/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.elaborationhighlight;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.editor.elaborationhighlight.ElaborationHighlightUtils;
import ro.amiq.dvt.ui.editor.elaborationhighlight.ElaborationHighlighter;
import ro.amiq.dvt.utils.Utils;

public class ElaborationHighlightJob
extends Job {
    private IRfFileDef file;
    private ElaborationHighlighter elaborationHighlighter;
    private IDocument document;
    private boolean cancel;

    public ElaborationHighlightJob(ElaborationHighlighter semanticHighlighter, IRfFileDef file, IDocument document) {
        super("Elaboration Highlight for '" + file.getParserPath() + "'");
        this.elaborationHighlighter = semanticHighlighter;
        this.document = document;
        this.file = file;
    }

    protected void canceling() {
        this.cancel = true;
        this.elaborationHighlighter.clean();
        this.elaborationHighlighter = null;
        this.document = null;
    }

    public boolean isCanceled() {
        return this.cancel;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            if (this.elaborationHighlighter == null) {
                return Status.OK_STATUS;
            }
            this.elaborationHighlighter.process(this.file, this);
            List<Position> elaborationHighlightPositions = this.elaborationHighlighter.getPositions();
            if (elaborationHighlightPositions == null) {
                return Status.OK_STATUS;
            }
            try {
                ElaborationHighlightUtils.addPositionsToDocument(this.document, elaborationHighlightPositions);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            Utils.notifyHighlightPositionsChange(this.document, "__dvt_inactive_generate_branch_position");
            ObjectionManager.getInstance().clear(Objection.ELABORATION_HIGHLIGHT);
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return Status.OK_STATUS;
        }
    }
}

