/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.elaborationhighlight;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.elaborationhighlight.ElaborationHighlightJob;
import ro.amiq.dvt.ui.editor.elaborationhighlight.ElaborationHighlightUtils;
import ro.amiq.dvt.ui.editor.elaborationhighlight.ElaborationHighlighter;
import ro.amiq.dvt.ui.editor.pathmanager.DPMNotification;
import ro.amiq.dvt.ui.editor.pathmanager.IDesignPathListener;

public class ElaborationHighlightListener
implements IDesignPathListener {
    protected DVTEditor editor;
    private ElaborationHighlightJob elaborationHighlightJob;

    public ElaborationHighlightListener(DVTEditor editor) {
        this.editor = editor;
    }

    @Override
    public void designPathNotification(DPMNotification notification) {
        if (this.editor == null) {
            ObjectionManager.getInstance().clear(Objection.ELABORATION_HIGHLIGHT);
            return;
        }
        IRfFileDef fileDef = this.computeFileDef();
        this.startElaborationHighlight(fileDef);
    }

    private IRfFileDef computeFileDef() {
        IProject project = this.editor.getProject();
        if (project == null) {
            return null;
        }
        IEditorInput editorInput = this.editor.getEditorInput();
        if (!(editorInput instanceof FileEditorInput)) {
            return null;
        }
        RfMixedLangProject rfMixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(project, false);
        if (rfMixedLangProject == null) {
            return null;
        }
        IFile file = ((FileEditorInput)editorInput).getFile();
        if (file == null) {
            return null;
        }
        IRfFileDef result = this.computeFileDef(rfMixedLangProject, file, "ro.amiq.vlogdt.VlogNature");
        if (result != null) {
            return result;
        }
        return this.computeFileDef(rfMixedLangProject, file, "ro.amiq.vhdldt.VhdlNature");
    }

    private IRfFileDef computeFileDef(RfMixedLangProject rfMixedLangProject, IFile file, String nature) {
        IRfSingleLangProject singleLangProject = rfMixedLangProject.getSingleLangProject(nature);
        if (singleLangProject == null) {
            return null;
        }
        return singleLangProject.getFile((IResource)file);
    }

    private void startElaborationHighlight(IRfFileDef fileDef) {
        try {
            if (fileDef == null || this.editor == null) {
                ObjectionManager.getInstance().clear(Objection.ELABORATION_HIGHLIGHT);
                return;
            }
            if (!this.editor.isVisible()) {
                ObjectionManager.getInstance().clear(Objection.ELABORATION_HIGHLIGHT);
                return;
            }
            if (this.elaborationHighlightJob != null) {
                this.elaborationHighlightJob.cancel();
                this.elaborationHighlightJob = null;
            }
            this.elaborationHighlightJob = new ElaborationHighlightJob(new ElaborationHighlighter(this.editor), fileDef, this.editor.getDocument());
            this.elaborationHighlightJob.setPriority(50);
            this.elaborationHighlightJob.setRule(ElaborationHighlightUtils.JOB_SCHED_RULE);
            this.elaborationHighlightJob.setSystem(true);
            this.elaborationHighlightJob.schedule(300L);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public DVTEditor getDVTEditor() {
        return this.editor;
    }
}

