/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.elaborationhighlight;

import java.util.List;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import ro.amiq.dvt.DVTSynchronizableDocument;
import ro.amiq.dvt.ui.editor.DVTPosition;
import ro.amiq.dvt.utils.DVTDocumentUtils;

public class ElaborationHighlightUtils {
    public static final ISchedulingRule JOB_SCHED_RULE = new ISchedulingRule(){

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }
    };

    public static void addPosition(IDocument document, int startLine, int endLine, List<Position> positions) throws Exception {
        if (document == null) {
            return;
        }
        if (startLine == -1 || endLine == -1) {
            return;
        }
        int startOffset = DVTDocumentUtils.documentLineOffset(document, startLine - 1);
        int endOffset = DVTDocumentUtils.documentLineOffset(document, endLine - 1) + document.getLineLength(endLine - 1);
        positions.add(new DVTPosition(startOffset, endOffset - startOffset));
    }

    public static void addPositionsToDocument(IDocument document, List<Position> positions) throws Exception {
        if (document == null || positions.isEmpty()) {
            return;
        }
        if (document instanceof DVTSynchronizableDocument) {
            ((DVTSynchronizableDocument)document).addPositions("__dvt_inactive_generate_branch_position", positions);
        } else {
            for (Position position : positions) {
                document.addPosition("__dvt_inactive_generate_branch_position", position);
            }
        }
    }
}

