/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.elaborationhighlight;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.elaborationhighlight.ElaborationHighlightJob;
import ro.amiq.dvt.ui.editor.elaborationhighlight.ElaborationHighlightUtils;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManager;

public class ElaborationHighlighter {
    private DVTEditor fEditor;
    private IDocument fDocument;
    private List<Position> fPositions;

    public ElaborationHighlighter(DVTEditor editor) {
        this.fEditor = editor;
        this.fDocument = editor.getDocument();
        this.fPositions = new ArrayList<Position>();
    }

    public DVTEditor getEditor() {
        return this.fEditor;
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    public List<Position> getPositions() {
        return this.fPositions;
    }

    public void clean() {
        this.fDocument = null;
        this.fPositions = null;
    }

    public void process(IRfFileDef file, ElaborationHighlightJob job) {
        if (this.fDocument == null) {
            return;
        }
        if (!this.fDocument.containsPositionCategory("__dvt_inactive_generate_branch_position")) {
            this.fDocument.addPositionCategory("__dvt_inactive_generate_branch_position");
        } else {
            try {
                this.fDocument.removePositionCategory("__dvt_inactive_generate_branch_position");
                this.fDocument.addPositionCategory("__dvt_inactive_generate_branch_position");
            }
            catch (BadPositionCategoryException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return;
            }
        }
        try {
            this.doHighlightRecursive((IRfDefElement)((Object)file), new HashSet<IRfDefElement>(), job);
        }
        catch (ConcurrentModificationException concurrentModificationException) {
        }
        catch (Exception e) {
            String fileName = file != null && file.getParserPath() != null ? file.getParserPath().path : "Could not determine the file path.";
            if ("Elaboration Highlight canceled".equals(e.getMessage())) {
                DVTLogger.INSTANCE.logError("Elaboration Highlight canceled for file:\n" + fileName);
            }
            DVTLogger.INSTANCE.logError("Exception during Elaboration Highlight in file:\n" + fileName, (Throwable)e);
        }
    }

    private IStatus doHighlightRecursive(IRfDefElement root, Set<IRfDefElement> visited, ElaborationHighlightJob job) throws BadLocationException, BadPositionCategoryException, Exception {
        if (job == null || job.isCanceled()) {
            throw new Exception("Elaboration Highlight canceled");
        }
        if (root == null) {
            return Status.OK_STATUS;
        }
        boolean inactive = this.doHighlight(root);
        visited.add(root);
        if (inactive) {
            return Status.OK_STATUS;
        }
        Collection<?> children = root.getChildren();
        if (children == null) {
            return Status.OK_STATUS;
        }
        for (Object child : children) {
            if (!(child instanceof IRfDefElement) || visited.contains(child)) continue;
            this.doHighlightRecursive((IRfDefElement)child, new HashSet<IRfDefElement>(visited), job);
        }
        return Status.OK_STATUS;
    }

    private boolean doHighlight(IRfDefElement defElement) throws Exception {
        if (defElement == null || defElement instanceof IRfFileDef) {
            return false;
        }
        IRfNamedElement element = defElement.getNamedElement();
        if (!DesignUtils.isBlock(element)) {
            return false;
        }
        ElementPath path = DesignPathManager.getInstance().getPathFor(this.getEditor(), element, true);
        if (path == null) {
            ElaborationHighlightUtils.addPosition(this.getDocument(), defElement.getStartLine(), defElement.getEndLine(), this.getPositions());
            return true;
        }
        return false;
    }
}

