/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.emulation;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.emulation.EditorEmulationMode;

public class EditorEmulationAction
extends Action
implements IMenuCreator {
    private final boolean updateText;
    private Menu menu;

    public EditorEmulationAction(boolean updateText) {
        super("Editor Emulation Mode", 4);
        this.setToolTipText("Switch Editor Emulation Mode (Ctrl + Alt + =)");
        this.setEnabled(true);
        this.setMenuCreator(this);
        this.setImageDescriptor(DVTImages.EDITOR_EMULATION);
        this.updateText = updateText;
    }

    public void run() {
        this.menu.setVisible(true);
    }

    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
        }
        this.menu = null;
    }

    public Menu getMenu(Control parent) {
        if (this.menu != null) {
            return this.menu;
        }
        this.menu = new Menu(parent);
        this.createMenu();
        return this.menu;
    }

    public Menu getMenu(Menu parent) {
        if (this.menu != null) {
            return this.menu;
        }
        this.menu = new Menu(parent);
        this.createMenu();
        return this.menu;
    }

    private void createMenu() {
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!((MenuItem)e.widget).getSelection()) {
                    return;
                }
                Object editorEmulationMode = e.widget.getData();
                if (editorEmulationMode == null || !(editorEmulationMode instanceof EditorEmulationMode)) {
                    return;
                }
                EditorEmulationMode emulationMode = (EditorEmulationMode)((Object)editorEmulationMode);
                DVTPlugin.getDefault().getPreferences().put("editor_emulation_mode", emulationMode.getName());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        List<EditorEmulationMode> availableEmulationsModes = EditorEmulationMode.getAvailableModes();
        for (EditorEmulationMode EditorEmulationMode2 : availableEmulationsModes) {
            MenuItem item = new MenuItem(this.menu, 16);
            item.setText(EditorEmulationMode2.getName());
            item.setData((Object)EditorEmulationMode2);
            item.addSelectionListener(selectionListener);
        }
    }

    private void setActionText(EditorEmulationMode EditorEmulationMode2, boolean refresh) {
        if (this.updateText) {
            this.setText(" " + EditorEmulationMode2.getName());
        }
        if (refresh) {
            DVTUiUtils.redrawToolbarInCoolbar((String)"ro.amiq.dvt.ui.editor.emulation.toolbar");
        }
    }

    public void setSelection(EditorEmulationMode editorEmulationMode, boolean refresh) {
        MenuItem[] items;
        if (this.menu == null) {
            return;
        }
        MenuItem[] menuItemArray = items = this.menu.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem item = menuItemArray[n2];
            Object data = item.getData();
            if (data != null && data instanceof EditorEmulationMode && data == editorEmulationMode) {
                item.setSelection(true);
                this.setActionText(editorEmulationMode, refresh);
            } else {
                item.setSelection(false);
            }
            ++n2;
        }
    }

    public void setDefaults() {
        String emulationModePreference = DVTPlugin.getDefault().getPreferenceStore().getString("editor_emulation_mode");
        EditorEmulationMode emulationMode = EditorEmulationMode.valueOfAvailable(emulationModePreference);
        if (emulationMode != null) {
            this.setSelection(emulationMode, false);
        }
    }
}

