/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.emulation;

import java.io.IOException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.bindings.Scheme;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.editor.emulation.EditorEmulationHelper;

public abstract class EditorEmulationHandler {
    public abstract boolean isAvailable();

    public abstract void activate();

    public abstract void deactivate();

    protected boolean bundleExists(String bundleID) {
        return Platform.getBundle((String)bundleID) != null;
    }

    protected void activateScheme(String schemeID) {
        if (schemeID == null) {
            return;
        }
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        if (bindingService == null) {
            return;
        }
        Scheme[] schemes = bindingService.getDefinedSchemes();
        try {
            Scheme[] schemeArray = schemes;
            int n = schemes.length;
            int n2 = 0;
            while (n2 < n) {
                Scheme scheme = schemeArray[n2];
                if (schemeID.equals(scheme.getId())) {
                    bindingService.savePreferences(scheme, EditorEmulationHelper.INSTANCE.getAllBindings());
                    break;
                }
                ++n2;
            }
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        IWorkbenchPart activePart = DVTUiUtils.getActivePart();
        if (activePart == null) {
            return;
        }
        activePart.setFocus();
    }
}

