/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.emulation;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.ui.bindings.internal.BindingTable;
import org.eclipse.e4.ui.bindings.internal.BindingTableManager;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.BindingManager;
import org.eclipse.jface.bindings.Scheme;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeyBinding;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.keys.BindingService;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.IDVTEditor;

public enum EditorEmulationHelper {
    INSTANCE;

    private static final String EMACS_PLUS_BUNDLE_ID = "com.mulgasoft.emacsplus";
    private static final String EMACS_PLUS_SCHEME_ID = "com.mulgasoft.emacsplusConfiguration";
    private static final String EMACS_SCHEME_ID = "org.eclipse.ui.emacsAcceleratorConfiguration";
    private static final String DEFAULT_SCHEME_ID = "org.eclipse.ui.defaultAcceleratorConfiguration";
    private static final String CONTENT_ASSIST = "Content Assist";
    private static final String INCREMENTAL_FIND = "Incremental Find";
    private Binding[] allBindings;
    private Binding[] activeBindings;
    private IPreferenceStore workbenchPreferences;
    private IPropertyChangeListener keysPrefPageListener;
    private IPropertyChangeListener contentAssistNotificationPrefListener;
    private IBindingService bindingService;
    private Binding emacsPlusContentAssist;
    private Binding defaultContentAssistCommand;
    private Binding defaultIncrementalFindCommand;

    public void initBindings() {
        if (this.bindingService != null) {
            return;
        }
        this.bindingService = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        if (this.bindingService == null) {
            return;
        }
        this.allBindings = this.bindingService.getBindings();
        if (this.allBindings == null) {
            return;
        }
        this.defaultContentAssistCommand = this.findCommandInScheme(this.allBindings, DEFAULT_SCHEME_ID, CONTENT_ASSIST, false);
        this.defaultIncrementalFindCommand = this.findCommandInScheme(this.allBindings, DEFAULT_SCHEME_ID, INCREMENTAL_FIND, false);
        if (Platform.getBundle((String)EMACS_PLUS_BUNDLE_ID) != null) {
            this.emacsPlusContentAssist = this.createContentAssistEmacsPlus();
            this.allBindings = (Binding[])ArrayUtils.add((Object[])this.allBindings, (Object)this.emacsPlusContentAssist);
            this.removeExtraIncrementalFindBinding();
        }
        this.activeBindings = this.getActiveBindings();
    }

    private Binding findCommandInScheme(Binding[] bindings, String scheme, String name, boolean isContentAssistInit) {
        block7: {
            block6: {
                if (bindings != null) break block6;
                return null;
            }
            if (scheme != null) break block7;
            return null;
        }
        try {
            Binding[] bindingArray = bindings;
            int n = bindings.length;
            int n2 = 0;
            while (n2 < n) {
                Command command;
                ParameterizedCommand parameterizedCommand;
                Binding binding = bindingArray[n2];
                if (binding != null && scheme.equals(binding.getSchemeId()) && (parameterizedCommand = binding.getParameterizedCommand()) != null && (command = parameterizedCommand.getCommand()).isDefined() && name.equals(command.getName()) && (!isContentAssistInit || !name.equals(CONTENT_ASSIST) || !binding.equals((Object)this.defaultContentAssistCommand))) {
                    return binding;
                }
                ++n2;
            }
            return null;
        }
        catch (NotDefinedException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    private Binding createContentAssistEmacsPlus() {
        Binding contentAssistEmacs = this.findCommandInScheme(this.allBindings, EMACS_SCHEME_ID, CONTENT_ASSIST, false);
        if (contentAssistEmacs == null) {
            return null;
        }
        return new KeyBinding(((KeyBinding)contentAssistEmacs).getKeySequence(), contentAssistEmacs.getParameterizedCommand(), EMACS_PLUS_SCHEME_ID, contentAssistEmacs.getContextId(), contentAssistEmacs.getLocale(), contentAssistEmacs.getPlatform(), "", contentAssistEmacs.getType());
    }

    public Binding[] getActiveBindings() {
        Collection values;
        block13: {
            HashMap declaredFieldValue;
            block12: {
                Field declaredField;
                BindingManager bindingManager;
                block11: {
                    block10: {
                        block9: {
                            try {
                                if (this.bindingService != null) break block9;
                                return null;
                            }
                            catch (Throwable e) {
                                DVTLogger.INSTANCE.logError(e);
                                return null;
                            }
                        }
                        bindingManager = ((BindingService)this.bindingService).getBindingManager();
                        if (bindingManager != null) break block10;
                        return null;
                    }
                    declaredField = BindingManager.class.getDeclaredField("activeBindings");
                    if (declaredField != null) break block11;
                    return null;
                }
                declaredField.setAccessible(true);
                declaredFieldValue = (HashMap)declaredField.get(bindingManager);
                if (declaredFieldValue != null) break block12;
                return null;
            }
            values = declaredFieldValue.values();
            if (values != null) break block13;
            return null;
        }
        Object[] activeBindings = values.toArray(new Binding[values.size()]);
        Scheme activeScheme = this.bindingService.getActiveScheme();
        if (activeScheme == null) {
            return activeBindings;
        }
        if (this.emacsPlusContentAssist != null && EMACS_PLUS_SCHEME_ID.equals(activeScheme.getId())) {
            return (Binding[])ArrayUtils.add((Object[])activeBindings, (Object)this.emacsPlusContentAssist);
        }
        return activeBindings;
    }

    public Binding[] getAllBindings() {
        if (this.bindingService == null) {
            return null;
        }
        this.allBindings = this.bindingService.getBindings();
        if (this.allBindings == null) {
            return null;
        }
        if (this.emacsPlusContentAssist != null) {
            this.allBindings = (Binding[])ArrayUtils.add((Object[])this.allBindings, (Object)this.emacsPlusContentAssist);
        }
        this.removeExtraIncrementalFindBinding();
        return this.allBindings;
    }

    public void emptyBindingsByPrefixTables() {
        try {
            if (this.bindingService == null) {
                return;
            }
            Field tableManagerField = BindingService.class.getDeclaredField("tableManager");
            if (tableManagerField == null) {
                return;
            }
            tableManagerField.setAccessible(true);
            BindingTableManager tableManagerValue = (BindingTableManager)tableManagerField.get(this.bindingService);
            if (tableManagerValue == null) {
                return;
            }
            for (String context : this.getContexts()) {
                Field bindingsByPrefixField;
                BindingTable table = tableManagerValue.getTable(context);
                if (table == null || (bindingsByPrefixField = BindingTable.class.getDeclaredField("bindingsByPrefix")) == null) continue;
                bindingsByPrefixField.setAccessible(true);
                HashMap bindingsByPrefixValue = (HashMap)bindingsByPrefixField.get(table);
                if (bindingsByPrefixValue == null) continue;
                this.removeKeysWithoutValues(bindingsByPrefixValue);
                bindingsByPrefixField.set(table, bindingsByPrefixValue);
            }
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    private void removeKeysWithoutValues(HashMap<TriggerSequence, ArrayList<Binding>> bindingsByPrefix) {
        Iterator<Map.Entry<TriggerSequence, ArrayList<Binding>>> it = bindingsByPrefix.entrySet().iterator();
        while (it.hasNext()) {
            ArrayList<Binding> value = it.next().getValue();
            if (value != null && !value.isEmpty()) continue;
            it.remove();
        }
    }

    private HashSet<String> getContexts() {
        if (this.allBindings == null) {
            return new HashSet<String>();
        }
        HashSet<String> contexts = new HashSet<String>();
        Binding[] bindingArray = this.allBindings;
        int n = this.allBindings.length;
        int n2 = 0;
        while (n2 < n) {
            Binding binding = bindingArray[n2];
            if (binding != null) {
                contexts.add(binding.getContextId());
            }
            ++n2;
        }
        return contexts;
    }

    private void removeExtraIncrementalFindBinding() {
        if (this.allBindings == null) {
            return;
        }
        if (this.defaultIncrementalFindCommand == null) {
            return;
        }
        Binding[] bindingArray = this.allBindings;
        int n = this.allBindings.length;
        int n2 = 0;
        while (n2 < n) {
            Binding binding = bindingArray[n2];
            if (binding != null && this.defaultIncrementalFindCommand.getTriggerSequence().equals((Object)binding.getTriggerSequence()) && binding.getParameterizedCommand() == null) {
                this.allBindings = (Binding[])ArrayUtils.removeElement((Object[])this.allBindings, (Object)binding);
            }
            ++n2;
        }
    }

    public void manageContentAssistNotifications(List<IEditorPart> visibleEditors) {
        if (this.bindingService == null) {
            return;
        }
        Scheme activeScheme = this.bindingService.getActiveScheme();
        if (activeScheme == null) {
            return;
        }
        Binding contentAssistBinding = this.findCommandInScheme(this.activeBindings, activeScheme.getId(), CONTENT_ASSIST, true);
        boolean showContentAssistNotification = this.isShowNotification();
        if (showContentAssistNotification && contentAssistBinding != null) {
            this.createContentAssistNotifications(visibleEditors, contentAssistBinding);
        } else {
            this.destroyContentAssistNotifications(visibleEditors);
        }
    }

    private boolean isShowNotification() {
        IEclipsePreferences preferences = DVTPlugin.getDefault().getPreferences();
        if (preferences == null) {
            return false;
        }
        return preferences.getBoolean("show.content.assist.notifications", true);
    }

    public void createContentAssistNotifications(List<IEditorPart> editorList, Binding contentAssistBinding) {
        if (contentAssistBinding == null) {
            return;
        }
        if (editorList == null) {
            return;
        }
        for (IEditorPart editor : editorList) {
            if (!(editor instanceof IDVTEditor)) continue;
            ((IDVTEditor)editor).createContentAssistNotification(contentAssistBinding);
        }
    }

    public void destroyContentAssistNotifications(List<IEditorPart> editorList) {
        if (editorList == null) {
            return;
        }
        for (IEditorPart editor : editorList) {
            if (!(editor instanceof IDVTEditor)) continue;
            ((IDVTEditor)editor).destroyContentAssistNotification();
        }
    }

    private IPropertyChangeListener createKeysPrefPageListener() {
        return new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (!"org.eclipse.ui.commands".equals(event.getProperty())) {
                    return;
                }
                EditorEmulationHelper.this.allBindings = EditorEmulationHelper.this.getAllBindings();
                EditorEmulationHelper.this.activeBindings = EditorEmulationHelper.this.getActiveBindings();
                EditorEmulationHelper.this.emptyBindingsByPrefixTables();
                EditorEmulationHelper.this.manageContentAssistNotifications(Utils.computeVisibleEditors());
            }
        };
    }

    private IPropertyChangeListener createContentAssistNotificationPrefListener() {
        return new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (!"show.content.assist.notifications".equals(event.getProperty())) {
                    return;
                }
                EditorEmulationHelper.this.manageContentAssistNotifications(Utils.computeVisibleEditors());
            }
        };
    }

    public void installListeners() {
        this.contentAssistNotificationPrefListener = this.createContentAssistNotificationPrefListener();
        IPreferenceStore preferenceStore = DVTPlugin.getDefault().getPreferenceStore();
        if (preferenceStore == null) {
            return;
        }
        preferenceStore.addPropertyChangeListener(this.contentAssistNotificationPrefListener);
        this.keysPrefPageListener = this.createKeysPrefPageListener();
        this.workbenchPreferences = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.ui.workbench");
        this.workbenchPreferences.addPropertyChangeListener(this.keysPrefPageListener);
    }

    public void uninstallListeners() {
        if (this.workbenchPreferences == null) {
            return;
        }
        this.workbenchPreferences.removePropertyChangeListener(this.keysPrefPageListener);
        IPreferenceStore preferenceStore = DVTPlugin.getDefault().getPreferenceStore();
        if (preferenceStore == null) {
            return;
        }
        preferenceStore.removePropertyChangeListener(this.contentAssistNotificationPrefListener);
    }
}

