/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.emulation;

import java.util.ArrayList;
import java.util.List;
import ro.amiq.dvt.ui.editor.emulation.DefaultEmulationHandler;
import ro.amiq.dvt.ui.editor.emulation.EditorEmulationHandler;
import ro.amiq.dvt.ui.editor.emulation.EditorEmulationHelper;
import ro.amiq.dvt.ui.editor.emulation.EmacsEmulationHandler;
import ro.amiq.dvt.ui.editor.emulation.ViEmulationHandler;

public enum EditorEmulationMode {
    ECLIPSE("eclipse", new DefaultEmulationHandler()),
    VI("vi", new ViEmulationHandler()),
    EMACS("emacs", new EmacsEmulationHandler());

    private final String name;
    private final EditorEmulationHandler handler;
    private boolean isEnabled;
    private static final List<EditorEmulationMode> AVAILABLE_MODES;

    static {
        AVAILABLE_MODES = new ArrayList<EditorEmulationMode>();
        EditorEmulationMode[] editorEmulationModeArray = EditorEmulationMode.values();
        int n = editorEmulationModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            EditorEmulationMode emulationMode = editorEmulationModeArray[n2];
            if (emulationMode.handler.isAvailable()) {
                AVAILABLE_MODES.add(emulationMode);
            }
            ++n2;
        }
    }

    private EditorEmulationMode(String name, EditorEmulationHandler handler) {
        this.name = name;
        this.handler = handler;
        EditorEmulationHelper.INSTANCE.initBindings();
    }

    public String getName() {
        return this.name;
    }

    public void activate() {
        List<EditorEmulationMode> availableModes = EditorEmulationMode.getAvailableModes();
        for (EditorEmulationMode availableMode : availableModes) {
            availableMode.deactivate();
        }
        this.handler.activate();
        this.isEnabled = true;
    }

    public void deactivate() {
        this.isEnabled = false;
        this.handler.deactivate();
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public static List<EditorEmulationMode> getAvailableModes() {
        return AVAILABLE_MODES;
    }

    public static boolean isAvailable() {
        return !AVAILABLE_MODES.isEmpty();
    }

    public static EditorEmulationMode valueOfAvailable(String value) {
        for (EditorEmulationMode availableMode : AVAILABLE_MODES) {
            if (!availableMode.getName().equals(value)) continue;
            return availableMode;
        }
        return ECLIPSE;
    }
}

