/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.emulation;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.ui.editor.emulation.EditorEmulationMode;

public class EditorEmulationSwitchCommand
extends AbstractHandler {
    public static final String COMMAND_ID = "ro.amiq.dvt.ui.editor.emulation.switch";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (!EditorEmulationMode.isAvailable()) {
            return null;
        }
        String emulationModePreference = DVTPlugin.getDefault().getPreferenceStore().getString("editor_emulation_mode");
        EditorEmulationMode nextEmulationMode = null;
        if (emulationModePreference != null) {
            List<EditorEmulationMode> availableModes = EditorEmulationMode.getAvailableModes();
            int i = 0;
            while (i < availableModes.size()) {
                if (availableModes.get(i).getName().equals(emulationModePreference)) {
                    nextEmulationMode = i == availableModes.size() - 1 ? availableModes.get(0) : availableModes.get(i + 1);
                }
                ++i;
            }
        }
        if (nextEmulationMode == null) {
            nextEmulationMode = EditorEmulationMode.ECLIPSE;
        }
        DVTPlugin.getDefault().getPreferences().put("editor_emulation_mode", nextEmulationMode.getName());
        return null;
    }
}

