/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.emulation;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.editor.emulation.EditorEmulationAction;
import ro.amiq.dvt.ui.editor.emulation.EditorEmulationContributionItem;
import ro.amiq.dvt.ui.editor.emulation.EditorEmulationMode;

public enum EditorEmulationToolbar implements IWindowListener,
IEclipsePreferences.IPreferenceChangeListener
{
    INSTANCE;

    public static final String TOOLBAR_ID = "ro.amiq.dvt.ui.editor.emulation.toolbar";
    public final Map<IWorkbenchWindow, EditorEmulationAction> windowActions = new HashMap<IWorkbenchWindow, EditorEmulationAction>();

    public void init() {
        if (!EditorEmulationMode.isAvailable()) {
            return;
        }
        this.populateExistingToolbars();
        this.activateEmulation();
        DVTPlugin.getDefault().getPreferences().addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        PlatformUI.getWorkbench().addWindowListener((IWindowListener)this);
    }

    private void populateExistingToolbars() {
        IWorkbenchWindow[] windows;
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            this.populateToolbar(window);
            ++n2;
        }
    }

    private void populateToolbar(IWorkbenchWindow window) {
        if (this.windowActions.containsKey(window)) {
            return;
        }
        IToolBarManager toolbarManager = DVTUiUtils.getToolbarManager((IWorkbenchWindow)window, (String)TOOLBAR_ID);
        if (toolbarManager == null) {
            return;
        }
        EditorEmulationAction changeEmulationAction = new EditorEmulationAction(true);
        toolbarManager.add((IContributionItem)new EditorEmulationContributionItem(changeEmulationAction));
        this.windowActions.put(window, changeEmulationAction);
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if ("editor_emulation_mode".equals(event.getKey())) {
            EditorEmulationMode emulationMode = EditorEmulationMode.valueOfAvailable((String)event.getNewValue());
            if (emulationMode == null) {
                return;
            }
            emulationMode.activate();
            for (Map.Entry<IWorkbenchWindow, EditorEmulationAction> entry : this.windowActions.entrySet()) {
                entry.getValue().setSelection(emulationMode, true);
            }
        }
    }

    private void activateEmulation() {
        String emulationModePreference = DVTPlugin.getDefault().getPreferenceStore().getString("editor_emulation_mode");
        EditorEmulationMode emulationMode = EditorEmulationMode.valueOfAvailable(emulationModePreference);
        if (emulationMode != null) {
            emulationMode.activate();
        }
    }

    public void windowOpened(IWorkbenchWindow window) {
        this.populateToolbar(window);
    }

    public void windowActivated(IWorkbenchWindow window) {
        DVTUiUtils.redrawToolbarInCoolbar((IWorkbenchWindow)window, (String)TOOLBAR_ID);
    }

    public void windowClosed(IWorkbenchWindow window) {
        this.windowActions.remove(window);
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }
}

