/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.emulation;

import java.util.HashMap;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.emulation.EditorEmulationHandler;

class ViEmulationHandler
extends EditorEmulationHandler {
    private static final String COMMAND_ID = "com.mbartl.viplugineclipse.LoadViAction";
    private static final String PARAM_ID = "com.mbartl.viplugineclipse.LoadViAction.activateParameter";
    private static final String BUNDLE_ID = "com.mbartl.eclipse.viplugin";
    private static final String SCHEME_ID = "ViPluginKeyConfiguration";

    ViEmulationHandler() {
    }

    @Override
    public boolean isAvailable() {
        return this.bundleExists(BUNDLE_ID);
    }

    @Override
    public void activate() {
        this.activateScheme(SCHEME_ID);
        this.setEnabled(true);
    }

    @Override
    public void deactivate() {
        this.setEnabled(false);
    }

    private void setEnabled(boolean enabled) {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        if (commandService == null) {
            return;
        }
        Command command = commandService.getCommand(COMMAND_ID);
        if (command == null) {
            return;
        }
        HashMap<String, String> parameters = new HashMap<String, String>(1);
        parameters.put(PARAM_ID, Boolean.toString(enabled));
        ParameterizedCommand paramCommand = ParameterizedCommand.generateCommand((Command)command, parameters);
        if (paramCommand == null) {
            return;
        }
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        if (handlerService == null) {
            return;
        }
        try {
            handlerService.executeCommand(paramCommand, null);
        }
        catch (ExecutionException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        catch (NotDefinedException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        catch (NotEnabledException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        catch (NotHandledException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

