/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.floatingwidgets;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.swt.custom.CaretEvent;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetFactory;
import ro.amiq.dvt.ui.editor.floatingwidgets.IFWidget;

public enum FCaretHandlerListener implements CaretListener,
ITextListener
{
    INSTANCE;

    private Set<StyledText> registeredStyledTexts = new HashSet<StyledText>();
    private Set<ITextViewer> registeredSourceViewers = new HashSet<ITextViewer>();

    public static void addAsCaretListener(StyledText styledText) {
        if (FCaretHandlerListener.INSTANCE.registeredStyledTexts.contains(styledText)) {
            return;
        }
        styledText.addCaretListener((CaretListener)INSTANCE);
        FCaretHandlerListener.INSTANCE.registeredStyledTexts.add(styledText);
    }

    public static void removeCaretListener(StyledText styledText) {
        if (!FCaretHandlerListener.INSTANCE.registeredStyledTexts.contains(styledText)) {
            return;
        }
        styledText.removeCaretListener((CaretListener)INSTANCE);
        FCaretHandlerListener.INSTANCE.registeredStyledTexts.remove(styledText);
    }

    public static void addAsTextChangeListener(ITextViewer sourceViewer) {
        if (FCaretHandlerListener.INSTANCE.registeredSourceViewers.contains(sourceViewer)) {
            return;
        }
        sourceViewer.addTextListener((ITextListener)INSTANCE);
        FCaretHandlerListener.INSTANCE.registeredSourceViewers.add(sourceViewer);
    }

    public static void removeTextChangeListener(ITextViewer sourceViewer) {
        if (!FCaretHandlerListener.INSTANCE.registeredSourceViewers.contains(sourceViewer)) {
            return;
        }
        sourceViewer.removeTextListener((ITextListener)INSTANCE);
        FCaretHandlerListener.INSTANCE.registeredSourceViewers.remove(sourceViewer);
    }

    public void textChanged(TextEvent event) {
        IWorkbenchPart part = DVTUiUtils.getActivePart();
        if (!(part instanceof DVTEditor)) {
            return;
        }
        Collection<IFWidget> widgets = FWidgetFactory.INSTANCE.getWidgets((DVTEditor)part);
        if (widgets == null || widgets.isEmpty()) {
            return;
        }
        IFWidget firstWidget = widgets.iterator().next();
        StyledText styledText = firstWidget.getStyledText();
        if (styledText == null) {
            return;
        }
        Rectangle clientArea = styledText.getClientArea();
        if (clientArea == null) {
            return;
        }
        Caret caret = styledText.getCaret();
        if (caret == null) {
            return;
        }
        Point caretLocation = caret.getLocation();
        if (caretLocation == null) {
            return;
        }
        boolean insideAnyNotification = this.isInsideAnyNotification(caretLocation, widgets, clientArea.width);
        styledText.getCaret().setVisible(!insideAnyNotification);
    }

    public void caretMoved(CaretEvent event) {
        Object source = event.getSource();
        if (!(source instanceof StyledText)) {
            return;
        }
        List<IEditorPart> visibleEditors = Utils.computeVisibleEditors();
        if (visibleEditors == null || visibleEditors.isEmpty()) {
            return;
        }
        for (IEditorPart visibleEditor : visibleEditors) {
            DVTEditor editor;
            StyledText styledText;
            if (!(visibleEditor instanceof DVTEditor) || (styledText = (editor = (DVTEditor)visibleEditor).getStyledText()) != source) continue;
            Rectangle clientArea = styledText.getClientArea();
            if (clientArea == null) {
                return;
            }
            styledText.setCaretOffset(event.caretOffset);
            Point caretLocation = styledText.getCaret().getLocation();
            Collection<IFWidget> widgets = FWidgetFactory.INSTANCE.getWidgets((Canvas)styledText);
            boolean insideAnyNotification = this.isInsideAnyNotification(caretLocation, widgets, clientArea.width);
            Display.getCurrent().timerExec(200, () -> {
                if (styledText == null || styledText.isDisposed()) {
                    return;
                }
                styledText.getCaret().setVisible(!insideAnyNotification);
            });
            return;
        }
    }

    boolean isInsideAnyNotification(Point caretLocation, Collection<IFWidget> widgets, int width) {
        for (IFWidget widget : widgets) {
            boolean insideNotificationAreaX;
            if (!widget.isVisible()) continue;
            Rectangle notificationArea = widget.getNotificationArea(width);
            boolean insideNotificationAreaY = caretLocation.y > notificationArea.y && caretLocation.y < notificationArea.y + notificationArea.height;
            boolean bl = insideNotificationAreaX = caretLocation.x > notificationArea.x && caretLocation.x < notificationArea.x + notificationArea.width;
            if (!insideNotificationAreaX || !insideNotificationAreaY) continue;
            return true;
        }
        return false;
    }
}

