/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.floatingwidgets;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalNotificationFixer;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalNotificationTracker;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.floatingwidgets.FIncrementalNotificationStateWrapper;
import ro.amiq.dvt.ui.editor.floatingwidgets.FIncrementalNotificationStylingUtils;
import ro.amiq.dvt.ui.editor.floatingwidgets.FNotification;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetFactory;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetType;
import ro.amiq.dvt.ui.editor.floatingwidgets.IFNotificationHost;

public class FIncrementalNotification
extends FNotification {
    private StyleRange[] linkStyles;

    public FIncrementalNotification(IFNotificationHost editor) {
        super(editor);
    }

    @Override
    protected void disposeNotification() {
        Display.getDefault().asyncExec(() -> FWidgetFactory.INSTANCE.disposeAll(this.getType(), this.project));
    }

    @Override
    public void onMouseClick(Event e) {
        if (!FIncrementalNotificationTracker.INSTANCE.isDirty(this.project)) {
            return;
        }
        if (FIncrementalNotificationTracker.INSTANCE.isUpdating(this.project)) {
            return;
        }
        super.onMouseClick(e);
    }

    @Override
    protected void handleFixButtonClick() {
        this.canvas.setCursor(null);
        this.state = null;
        if (FIncrementalNotificationTracker.INSTANCE.isAutoBuildDisabled() && FIncrementalNotificationTracker.INSTANCE.getDirtyResources(this.project).isEmpty()) {
            this.turnOnAutoBuild();
            super.disposeNotification();
            return;
        }
        FIncrementalNotificationFixer.INSTANCE.scheduleFixJob(this.project);
        this.disposeNotification();
    }

    private void turnOnAutoBuild() {
        IEclipsePreferences preferences = DVTPlugin.getDefault().getPreferences("org.eclipse.core.resources");
        if (preferences == null) {
            return;
        }
        preferences.putBoolean("description.autobuilding", true);
    }

    @Override
    protected String getNotificationText() {
        return FIncrementalNotificationTracker.INSTANCE.getNotificationText(this.project);
    }

    @Override
    protected void styleNotificationText(Rectangle notificationArea) {
        FIncrementalNotificationStateWrapper wrapper = FIncrementalNotificationStylingUtils.getStateWrapper(this.project);
        this.notificationTextWidget.setStyleRange(FIncrementalNotificationStylingUtils.getBoldStyle(wrapper));
        this.linkStyles = FIncrementalNotificationStylingUtils.getLinkStyle(wrapper);
        if (this.linkStyles[0] != null) {
            this.notificationTextWidget.setStyleRange(this.linkStyles[0]);
        }
        if (this.linkStyles[1] != null) {
            this.notificationTextWidget.setStyleRange(this.linkStyles[1]);
        }
        FIncrementalNotificationStylingUtils.setIndent(this.notificationTextWidget, FIncrementalNotificationStylingUtils.getBulletStartLine(wrapper), notificationArea.x);
        FIncrementalNotificationStylingUtils.setBullets(this.project, this.notificationTextWidget, FIncrementalNotificationStylingUtils.getBulletStartLine(wrapper), notificationArea.x);
    }

    private boolean isInsideLink(StyleRange linkStyleRange, StyleRange clickedStyleRange) {
        if (linkStyleRange == null || clickedStyleRange == null) {
            return false;
        }
        return clickedStyleRange.start > linkStyleRange.start && clickedStyleRange.start < linkStyleRange.start + linkStyleRange.length;
    }

    @Override
    protected void addNotificationTextListeners() {
        super.addNotificationTextListeners();
        this.detailsClickListener = event -> {
            try {
                int offset = this.notificationTextWidget.getOffsetAtLocation(new Point(event.x, event.y));
                if (offset == -1) {
                    return;
                }
                StyleRange style = this.notificationTextWidget.getStyleRangeAtOffset(offset);
                if (this.isInsideLink(this.linkStyles[0], style)) {
                    this.handleFixButtonClick();
                }
                if (this.isInsideLink(this.linkStyles[1], style)) {
                    this.turnOnAutoBuild();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        };
        this.notificationTextWidget.addListener(3, this.detailsClickListener);
    }

    @Override
    public void disposeDetails() {
        this.linkStyles = null;
        super.disposeDetails();
    }

    @Override
    protected String getButtonTooltipText() {
        return FIncrementalNotificationTracker.INSTANCE.isAutoBuildDisabled() && FIncrementalNotificationTracker.INSTANCE.getDirtyResources(this.project).isEmpty() ? "Turn on Automatic Build" : "Update Database Now";
    }

    @Override
    protected boolean isReady() {
        return FIncrementalNotificationTracker.INSTANCE.isDirty(this.project) && !FIncrementalNotificationTracker.INSTANCE.isUpdating(this.project);
    }

    @Override
    public FWidgetType getType() {
        return FWidgetType.DB_OUT_OF_SYNC;
    }

    @Override
    protected Image getFixButtonImage() {
        return DVTImages.imageCache.getImage(IS_DARK ? DVTImages.F_DB_OUT_OF_SYNC_NOTIFICATION_DARK : DVTImages.F_DB_OUT_OF_SYNC_NOTIFICATION_LIGHT);
    }
}

