/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.floatingwidgets;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.custom.Bullet;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalNotificationText;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalNotificationTracker;
import ro.amiq.dvt.ui.editor.floatingwidgets.FIncrementalNotificationStateWrapper;
import ro.amiq.dvt.ui.editor.floatingwidgets.FNotificationStylingUtils;

public class FIncrementalNotificationStylingUtils
extends FNotificationStylingUtils {
    private static final int START_BULLET_AUTO_BUILD_ENABLED = 2;
    private static final int START_BULLET_AUTO_BUILD_DISABLED = 3;

    public static void setBullets(IProject project, StyledText notificationTextWidget, int bulletStartLine, int notificationAreaWidth) {
        FIncrementalNotificationText fIncrementalNotificationText = FIncrementalNotificationTracker.INSTANCE.getIncrementalNotificationText(project);
        if (fIncrementalNotificationText == null) {
            return;
        }
        int indentValue = FIncrementalNotificationStylingUtils.getIndentValue(notificationAreaWidth);
        Bullet reasonBullet = FIncrementalNotificationStylingUtils.getReasonBullet(indentValue);
        Bullet fileNameBullet = FIncrementalNotificationStylingUtils.getResourceBullet(indentValue);
        FIncrementalNotificationStylingUtils.setBullets(fIncrementalNotificationText, notificationTextWidget, reasonBullet, fileNameBullet, bulletStartLine);
    }

    public static FIncrementalNotificationStateWrapper getStateWrapper(IProject project) {
        int noOfDirtyFiles = FIncrementalNotificationTracker.INSTANCE.getDirtyResources(project).size();
        boolean autoBuildDisabled = FIncrementalNotificationTracker.INSTANCE.isAutoBuildDisabled();
        boolean hasRenamedDirtyFile = FIncrementalNotificationTracker.INSTANCE.hasRenamedDirtyFile(project);
        boolean isActiveBuildConfigChanged = FIncrementalNotificationTracker.INSTANCE.isActiveBuildConfigChanged(project);
        boolean isFullBuildNeeded = FIncrementalNotificationTracker.INSTANCE.isFullBuildNeeded(project);
        return new FIncrementalNotificationStateWrapper(noOfDirtyFiles, autoBuildDisabled, hasRenamedDirtyFile, isActiveBuildConfigChanged, isFullBuildNeeded);
    }

    public static StyleRange getBoldStyle(FIncrementalNotificationStateWrapper wrapper) {
        boolean autoBuildDisabled;
        boolean fullBuildNeeded = wrapper.isFullBuildNeeded();
        int length = 0;
        if (fullBuildNeeded) {
            length += " Database is not up to date, update now".length();
            return new StyleRange(0, (length += FIncrementalNotificationStylingUtils.getSuggestionMessageLength(wrapper)) + 1, null, null, 1);
        }
        int noOfDirtyFiles = wrapper.getNoOfDirtyFiles();
        if (noOfDirtyFiles != 0) {
            length += " Database is not up to date, update now".length();
            length += FIncrementalNotificationStylingUtils.getSuggestionMessageLength(wrapper);
        }
        if (autoBuildDisabled = wrapper.isAutoBuildDisabled()) {
            length += " Automatic build is turned off. Turn it on?".length();
        }
        return new StyleRange(0, length + 1, null, null, 1);
    }

    public static StyleRange[] getLinkStyle(FIncrementalNotificationStateWrapper wrapper) {
        boolean autoBuildDisabled;
        StyleRange[] linkStyles = new StyleRange[2];
        int noOfDirtyFiles = wrapper.getNoOfDirtyFiles();
        boolean fullBuildNeeded = wrapper.isFullBuildNeeded();
        if (noOfDirtyFiles != 0 || fullBuildNeeded) {
            int length = "update now".length();
            linkStyles[0] = FIncrementalNotificationStylingUtils.getLinkStyle(" Database is not up to date, ".length(), length += FIncrementalNotificationStylingUtils.getSuggestionMessageLength(wrapper));
            if (fullBuildNeeded) {
                return linkStyles;
            }
        }
        if (autoBuildDisabled = wrapper.isAutoBuildDisabled()) {
            int start = noOfDirtyFiles != 0 ? " Database is not up to date, update now".length() : 0;
            start += " Automatic build is turned off.".length();
            if (noOfDirtyFiles != 0) {
                start += FIncrementalNotificationStylingUtils.getSuggestionMessageLength(wrapper);
            }
            linkStyles[1] = FIncrementalNotificationStylingUtils.getLinkStyle(start, " Turn it on?".length() + 1);
        }
        return linkStyles;
    }

    private static int getSuggestionMessageLength(FIncrementalNotificationStateWrapper wrapper) {
        if (wrapper.isFullBuildNeeded()) {
            return " (full build).".length();
        }
        boolean hasRenamedDirtyFile = wrapper.hasRenamedDirtyFile();
        boolean isActiveBuildConfigChanged = wrapper.isActiveBuildConfigChanged();
        int noOfDirtyFiles = wrapper.getNoOfDirtyFiles();
        return !isActiveBuildConfigChanged && !hasRenamedDirtyFile && noOfDirtyFiles < 50 ? " (analyse changed files).".length() : " (full build).".length();
    }

    public static int getBulletStartLine(FIncrementalNotificationStateWrapper wrapper) {
        int noOfDirtyFiles = wrapper.getNoOfDirtyFiles();
        boolean autoBuildDisabled = wrapper.isAutoBuildDisabled();
        if (noOfDirtyFiles != 0 || wrapper.isFullBuildNeeded()) {
            return autoBuildDisabled ? 3 : 2;
        }
        return -1;
    }

    public static void setBullets(FIncrementalNotificationText fIncrementalNotificationText, StyledText notificationTextWidget, Bullet reasonBullet, Bullet fileNameBullet, int bulletStartLine) {
        int currentLine = bulletStartLine;
        if (fIncrementalNotificationText.isActiveBuildConfigChanged()) {
            notificationTextWidget.setLineBullet(currentLine, 1, reasonBullet);
            currentLine += 2;
        }
        if (fIncrementalNotificationText.hasScriptingEditors()) {
            notificationTextWidget.setLineBullet(currentLine, 1, reasonBullet);
            currentLine += 2;
        }
        ArrayList<Integer> fileCategoriesSizes = fIncrementalNotificationText.getFileCategoriesSizes();
        FIncrementalNotificationStylingUtils.setLineBullets(notificationTextWidget, reasonBullet, fileNameBullet, currentLine, fileCategoriesSizes);
        if (fIncrementalNotificationText.areTooManyFilesChanged()) {
            notificationTextWidget.setLineBullet(currentLine, 1, reasonBullet);
        }
    }
}

