/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.floatingwidgets;

import org.eclipse.swt.custom.Bullet;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import ro.amiq.dvt.model.floatingwidgets.FLazyResourcesFixJob;
import ro.amiq.dvt.model.floatingwidgets.FLazyResourcesNotificationTracker;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.floatingwidgets.FNotification;
import ro.amiq.dvt.ui.editor.floatingwidgets.FNotificationStylingUtils;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetFactory;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetType;
import ro.amiq.dvt.ui.editor.floatingwidgets.IFNotificationHost;

public class FLazyResourcesNotification
extends FNotification {
    private StyleRange linkStyle;
    private StyleRange dissmissNotificationLink;

    protected FLazyResourcesNotification(IFNotificationHost editor) {
        super(editor);
    }

    @Override
    public FWidgetType getType() {
        return FWidgetType.LAZY_RESOURCES;
    }

    @Override
    protected String getButtonTooltipText() {
        return "Open config file";
    }

    @Override
    protected void disposeNotification() {
        Display.getDefault().asyncExec(() -> FWidgetFactory.INSTANCE.disposeAll(this.getType(), this.project));
    }

    @Override
    protected void handleFixButtonClick() {
        FLazyResourcesFixJob fixJob = new FLazyResourcesFixJob(this.project);
        fixJob.schedule();
        this.disposeNotification();
    }

    @Override
    protected String getNotificationText() {
        return FLazyResourcesNotificationTracker.INSTANCE.getNotificationText(this.project);
    }

    private boolean isInsideLink(int offset, StyleRange linkStyle, String text) {
        return offset >= linkStyle.start && offset < linkStyle.start + linkStyle.length && text.equals(this.notificationTextWidget.getText(linkStyle.start, linkStyle.start + linkStyle.length - 1));
    }

    @Override
    protected void addNotificationTextListeners() {
        super.addNotificationTextListeners();
        this.detailsClickListener = event -> {
            try {
                int offset = this.notificationTextWidget.getOffsetAtLocation(new Point(event.x, event.y));
                if (offset == -1) {
                    return;
                }
                if (this.isInsideLink(offset, this.linkStyle, " Check".trim())) {
                    this.handleFixButtonClick();
                    return;
                }
                if (this.isInsideLink(offset, this.dissmissNotificationLink, " Dismiss notification.".trim())) {
                    FLazyResourcesNotificationTracker.INSTANCE.disposeNotification(this.project);
                    return;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        };
        this.notificationTextWidget.addListener(3, this.detailsClickListener);
    }

    @Override
    protected void styleNotificationText(Rectangle notificationArea) {
        String projectName = this.project.getName();
        int projectNameLength = projectName.length();
        this.notificationTextWidget.setStyleRange(new StyleRange(0, " Resources added on top of the include first_level filtering for ".length() + projectNameLength + 1, null, null, 1));
        String checkConfigFileText = " Check".trim();
        this.linkStyle = FNotificationStylingUtils.getLinkStyle(this.notificationTextWidget.getText().indexOf(checkConfigFileText), checkConfigFileText.length());
        this.notificationTextWidget.setStyleRange(this.linkStyle);
        String dismissNotificationText = " Dismiss notification.".trim();
        this.dissmissNotificationLink = FNotificationStylingUtils.getLinkStyle(this.notificationTextWidget.getText().indexOf(dismissNotificationText), dismissNotificationText.length());
        this.notificationTextWidget.setStyleRange(this.dissmissNotificationLink);
        int indentValue = FNotificationStylingUtils.getIndentValue(notificationArea.x);
        FNotificationStylingUtils.setIndent(this.notificationTextWidget, 2, notificationArea.x);
        Bullet bulletList = FNotificationStylingUtils.getReasonBullet(indentValue);
        int numberOfBullets = FLazyResourcesNotificationTracker.INSTANCE.getDirtyRoots(this.project).size();
        if (numberOfBullets > 0) {
            this.notificationTextWidget.setLineBullet(2, numberOfBullets, bulletList);
        }
    }

    @Override
    protected boolean isReady() {
        return FLazyResourcesNotificationTracker.INSTANCE.isDirty(this.project);
    }

    @Override
    public void onMouseClick(Event e) {
        if (!FLazyResourcesNotificationTracker.INSTANCE.isDirty(this.project)) {
            return;
        }
        super.onMouseClick(e);
    }

    @Override
    protected int getDetailsHeight() {
        int minimumHeight = this.detailsComposite.computeSize((int)-1, (int)-1).y;
        return Math.min(minimumHeight, 216);
    }

    @Override
    protected Image getFixButtonImage() {
        return DVTImages.imageCache.getImage(IS_DARK ? DVTImages.F_LAZY_RESOURCES_NOTIFICATION_DARK : DVTImages.F_LAZY_RESOURCES_NOTIFICATION_LIGHT);
    }

    @Override
    public void disposeDetails() {
        this.linkStyle = null;
        this.dissmissNotificationLink = null;
        super.disposeDetails();
    }
}

