/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.floatingwidgets;

import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.model.floatingwidgets.FMissingPluginNotificationTracker;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.floatingwidgets.FNotification;
import ro.amiq.dvt.ui.editor.floatingwidgets.FNotificationState;
import ro.amiq.dvt.ui.editor.floatingwidgets.FNotificationStylingUtils;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetType;
import ro.amiq.dvt.ui.editor.floatingwidgets.IFNotificationHost;
import ro.amiq.dvt.utils.DVTStringUtil;

public class FMissingPluginNotification
extends FNotification {
    public static final String DISMISS_NOTIFICATION_MESSAGE = " Dismiss notification.";
    private static final String MISSING_PLUGIN_MESSAGE = " TCL plugin is not installed";
    private static final String KIT_INSTALLER_TCL_COMMAND = "$DVT_HOME/bin/dvt_kit_installer.sh -i TCL";
    private static final String MISSING_PLUGIN_EXTRA_DETAILS = "  To take advantage of functionalities such as syntax highlighting or completion suggestions, please run $DVT_HOME/bin/dvt_kit_installer.sh -i TCL and restart Eclipse";
    private StyleRange dissmissNotificationLink;

    protected FMissingPluginNotification(IFNotificationHost editor) {
        super(editor);
    }

    @Override
    public FWidgetType getType() {
        return FWidgetType.MISSING_PLUGIN;
    }

    @Override
    protected String getButtonTooltipText() {
        return MISSING_PLUGIN_MESSAGE;
    }

    @Override
    protected void handleFixButtonClick() {
    }

    @Override
    protected String getNotificationText() {
        return MISSING_PLUGIN_MESSAGE + DVTStringUtil.LINE_SEPARATOR + MISSING_PLUGIN_EXTRA_DETAILS + DVTStringUtil.LINE_SEPARATOR + DVTStringUtil.LINE_SEPARATOR + DISMISS_NOTIFICATION_MESSAGE + DVTStringUtil.LINE_SEPARATOR;
    }

    @Override
    protected void addNotificationTextListeners() {
        super.addNotificationTextListeners();
        this.detailsClickListener = event -> {
            try {
                int offset = this.notificationTextWidget.getOffsetAtLocation(new Point(event.x, event.y));
                if (offset == -1) {
                    return;
                }
                if (this.isInsideLink(offset, this.dissmissNotificationLink, DISMISS_NOTIFICATION_MESSAGE)) {
                    FMissingPluginNotificationTracker.INSTANCE.removeAllDirtyResources();
                    DVTPlugin.getDefault().getPreferenceStore().setValue("ro.amiq.dvt.EXTERNAL_PLUGIN_NOTIFICATION_ENABLED", false);
                    return;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        };
        this.notificationTextWidget.addListener(3, this.detailsClickListener);
    }

    private boolean isInsideLink(int offset, StyleRange linkStyle, String text) {
        text = text.trim();
        return offset >= linkStyle.start && offset < linkStyle.start + linkStyle.length && text.equals(this.notificationTextWidget.getText(linkStyle.start, linkStyle.start + linkStyle.length - 1));
    }

    @Override
    protected void styleNotificationText(Rectangle notificationArea) {
        this.boldMessage(MISSING_PLUGIN_MESSAGE);
        this.boldMessage(KIT_INSTALLER_TCL_COMMAND);
        String dismissMessage = DISMISS_NOTIFICATION_MESSAGE.trim();
        this.dissmissNotificationLink = FNotificationStylingUtils.getLinkStyle(this.notificationTextWidget.getText().indexOf(dismissMessage), dismissMessage.length());
        this.notificationTextWidget.setStyleRange(this.dissmissNotificationLink);
    }

    private void boldMessage(String message) {
        int startIndex = this.notificationTextWidget.getText().indexOf(message);
        if (startIndex != -1) {
            this.notificationTextWidget.setStyleRange(new StyleRange(startIndex, message.length() + 1, null, null, 1));
        }
    }

    @Override
    protected boolean isReady() {
        return FMissingPluginNotificationTracker.INSTANCE.isDirty(this.project);
    }

    @Override
    protected Image getFixButtonImage() {
        return DVTImages.imageCache.getImage(DVTImages.WARNING_ICON);
    }

    @Override
    protected void setButtonState() {
        this.state = FNotificationState.PAINTED_EFFECT;
    }
}

