/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.floatingwidgets;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.custom.Bullet;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.model.floatingwidgets.FMonitorDirtyResource;
import ro.amiq.dvt.model.floatingwidgets.FMonitorNotificationTracker;
import ro.amiq.dvt.model.floatingwidgets.FNotificationDirtyReason;
import ro.amiq.dvt.resourcefilters.NewProjectResourceFiltersWrapper;
import ro.amiq.dvt.resourcefilters.ResourceFilterMessageDialog;
import ro.amiq.dvt.resourcefilters.ResourceFilterUtils;
import ro.amiq.dvt.resourcemonitor.DVTResourceMonitor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.floatingwidgets.FMonitorNotificationConstants;
import ro.amiq.dvt.ui.editor.floatingwidgets.FNotification;
import ro.amiq.dvt.ui.editor.floatingwidgets.FNotificationStylingUtils;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetType;
import ro.amiq.dvt.ui.editor.floatingwidgets.IFNotificationHost;

public class FMonitorNotification
extends FNotification {
    private Map<StyleRange, IProject> linkRanges;
    private static final Map<FNotificationDirtyReason, String> reasonMessages = new EnumMap<FNotificationDirtyReason, String>(FNotificationDirtyReason.class);
    private static final Map<FNotificationDirtyReason, String> reasonMessagesSuffixes = new EnumMap<FNotificationDirtyReason, String>(FNotificationDirtyReason.class);
    private static final Map<FNotificationDirtyReason, String> reasonMessagesPreferencesIds = new EnumMap<FNotificationDirtyReason, String>(FNotificationDirtyReason.class);

    static {
        reasonMessages.put(FNotificationDirtyReason.DIRECTORY_TIMEOUT, " timed out while scanning for more than ");
        reasonMessages.put(FNotificationDirtyReason.DIRECTORY_CHILDREN_COUNT, " exceeds the file count threshold of ");
        reasonMessagesSuffixes.put(FNotificationDirtyReason.DIRECTORY_TIMEOUT, " seconds. (");
        reasonMessagesSuffixes.put(FNotificationDirtyReason.DIRECTORY_CHILDREN_COUNT, " files (");
        reasonMessagesPreferencesIds.put(FNotificationDirtyReason.DIRECTORY_TIMEOUT, "ro.amiq.dvt.RESOURCE_MONITOR_TIMEOUT");
        reasonMessagesPreferencesIds.put(FNotificationDirtyReason.DIRECTORY_CHILDREN_COUNT, "ro.amiq.dvt.RESOURCE_MONITOR_THRESHOLD");
    }

    protected FMonitorNotification(IFNotificationHost editor) {
        super(editor);
    }

    private void openResourceFiltersDialogLink(IProject project) {
        ResourceFilterMessageDialog dialog = new ResourceFilterMessageDialog("The project contains directories that may slow down the Eclipse platform.", project.getRawLocation().toOSString(), project, false, false);
        NewProjectResourceFiltersWrapper resourceFilterWrapper = dialog.openCustom();
        if (resourceFilterWrapper.getExcludedPaths() == null) {
            return;
        }
        ResourceFilterUtils.applyDvtFilters(project, resourceFilterWrapper.getExcludedPaths(), true);
    }

    @Override
    protected void handleFixButtonClick() {
        Job fixJob = new Job("Applying DVT Resource Filters for problematic directories found by the Resource Monitor"){

            protected IStatus run(IProgressMonitor monitor) {
                DVTResourceMonitor.stop(false, true);
                Map<IProject, Set<FMonitorDirtyResource>> dirtyResources = FMonitorNotificationTracker.INSTANCE.getAllDirtyResources();
                int count = 0;
                for (Map.Entry<IProject, Set<FMonitorDirtyResource>> entry : dirtyResources.entrySet()) {
                    try {
                        HashSet<String> pathsSet = new HashSet<String>();
                        entry.getValue().forEach(dr -> {
                            boolean bl = pathsSet.add(dr.getPathString());
                        });
                        ResourceFilterUtils.appendDvtFilters(entry.getKey(), pathsSet, count == dirtyResources.size() - 1);
                        ++count;
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        fixJob.setSystem(true);
        fixJob.schedule();
        this.disposeNotification();
    }

    @Override
    protected void addNotificationTextListeners() {
        super.addNotificationTextListeners();
        this.detailsClickListener = event -> {
            try {
                int offset = this.notificationTextWidget.getOffsetAtLocation(new Point(event.x, event.y));
                if (offset == -1) {
                    return;
                }
                for (Map.Entry<StyleRange, IProject> entry : this.linkRanges.entrySet()) {
                    StyleRange style = entry.getKey();
                    if (offset < style.start || offset >= style.start + style.length) continue;
                    IProject value = entry.getValue();
                    if (value != null) {
                        this.openResourceFiltersDialogLink(value);
                        this.disposeDetails();
                        return;
                    }
                    if (" Configure...".equals(this.notificationTextWidget.getText(style.start - 1, style.start + style.length - 1))) {
                        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"ro.amiq.dvt.ResourceMonitorPreferencePage", null, null);
                        if (dialog == null) continue;
                        dialog.open();
                        this.disposeDetails();
                        return;
                    }
                    if (!" Update the DVT Resource Filters now to fix.".equals(this.notificationTextWidget.getText(style.start, style.start + style.length))) continue;
                    this.handleFixButtonClick();
                    return;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        };
        this.notificationTextWidget.addListener(3, this.detailsClickListener);
        this.notificationTextWidget.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent e) {
                try {
                    int offset = FMonitorNotification.this.notificationTextWidget.getOffsetAtLocation(new Point(e.x, e.y));
                    if (offset < 0) {
                        DVTUiUtils.hideTooltipFloatingNotification((Control)FMonitorNotification.this.notificationTextWidget);
                        return;
                    }
                    int line = FMonitorNotification.this.notificationTextWidget.getLineAtOffset(offset);
                    if (line < 0) {
                        DVTUiUtils.hideTooltipFloatingNotification((Control)FMonitorNotification.this.notificationTextWidget);
                        return;
                    }
                    String lineString = FMonitorNotification.this.notificationTextWidget.getLine(line);
                    if (lineString == null) {
                        DVTUiUtils.hideTooltipFloatingNotification((Control)FMonitorNotification.this.notificationTextWidget);
                        return;
                    }
                    Point tooltipDestination = new Point(e.x + 5, e.y + 5);
                    FMonitorDirtyResource dirtyResource = FMonitorNotificationTracker.INSTANCE.getDirtyResource(lineString);
                    if (dirtyResource == null) {
                        String possibleProjectName = lineString.substring(0, lineString.length() - 1);
                        if (lineString.equals(" Configure...")) {
                            DVTUiUtils.installTooltipFloatingNotification((Control)FMonitorNotification.this.notificationTextWidget, (String)"Open the DVT Resource Monitor Preference Page", (Point)tooltipDestination);
                        } else if (lineString.equals(" Update the DVT Resource Filters now to fix.")) {
                            DVTUiUtils.installTooltipFloatingNotification((Control)FMonitorNotification.this.notificationTextWidget, (String)"Automatically create filters that exclude all problematic directories from the project directory tree", (Point)tooltipDestination);
                        } else if (FMonitorNotificationTracker.INSTANCE.isDirtyProject(possibleProjectName)) {
                            DVTUiUtils.installTooltipFloatingNotification((Control)FMonitorNotification.this.notificationTextWidget, (String)("Click to manually configure DVT Resource Filters for project '" + possibleProjectName + "'"), (Point)tooltipDestination);
                        } else {
                            DVTUiUtils.hideTooltipFloatingNotification((Control)FMonitorNotification.this.notificationTextWidget);
                        }
                        return;
                    }
                    StringBuilder sb = new StringBuilder(dirtyResource.getPath().getFileName().toString());
                    sb.append(reasonMessages.getOrDefault(dirtyResource.getReason(), "")).append(DVTPlugin.getDefault().getPreferenceStore().getInt(reasonMessagesPreferencesIds.get(dirtyResource.getReason()))).append(reasonMessagesSuffixes.getOrDefault(dirtyResource.getReason(), ""));
                    if (dirtyResource.getReason() == FNotificationDirtyReason.DIRECTORY_CHILDREN_COUNT) {
                        sb.append((int)dirtyResource.getValue());
                    } else {
                        sb.append(dirtyResource.getValue());
                    }
                    sb.append(')');
                    DVTUiUtils.installTooltipFloatingNotification((Control)FMonitorNotification.this.notificationTextWidget, (String)sb.toString(), (Point)tooltipDestination);
                }
                catch (Exception exception) {
                    DVTUiUtils.hideTooltipFloatingNotification((Control)FMonitorNotification.this.notificationTextWidget);
                }
            }
        });
    }

    @Override
    protected String getNotificationText() {
        return FMonitorNotificationTracker.INSTANCE.getNotificationText(null);
    }

    @Override
    protected void styleNotificationText(Rectangle notificationArea) {
        this.linkRanges = new HashMap<StyleRange, IProject>();
        this.notificationTextWidget.setStyleRange(new StyleRange(0, FMonitorNotificationConstants.BIG_DIRECTORIES.length() + 1, null, null, 1));
        String text = this.notificationTextWidget.getText();
        Map<IProject, Set<FMonitorDirtyResource>> dirtyResources = FMonitorNotificationTracker.INSTANCE.getAllDirtyResources();
        Set<IProject> dirtyProjects = dirtyResources.keySet();
        for (IProject project : dirtyProjects) {
            String projectName = project.getName();
            int start = text.indexOf(projectName);
            if (start < 0) continue;
            StyleRange style = FNotificationStylingUtils.getLinkStyle(start, projectName.length());
            this.notificationTextWidget.setStyleRange(style);
            this.linkRanges.put(style, project);
        }
        this.addNonProjectLinks(text);
        int indentValue = FNotificationStylingUtils.getIndentValue(notificationArea.x);
        int bulletStartLine = 4;
        FNotificationStylingUtils.setIndent(this.notificationTextWidget, bulletStartLine, notificationArea.x);
        Bullet reasonBullet = FNotificationStylingUtils.getReasonBullet(indentValue);
        Bullet resourceBullet = FNotificationStylingUtils.getResourceBullet(indentValue);
        int currentLine = bulletStartLine;
        int[] filesCounts = dirtyResources.entrySet().stream().filter(e -> ((IProject)e.getKey()).isOpen()).mapToInt(e -> ((Set)e.getValue()).size()).toArray();
        if (filesCounts == null || filesCounts.length == 0) {
            return;
        }
        FNotificationStylingUtils.setLineBullets(this.notificationTextWidget, reasonBullet, resourceBullet, currentLine, Arrays.stream(filesCounts).boxed().collect(Collectors.toList()));
    }

    private void addNonProjectLinks(String text) {
        int configureIndex = text.indexOf(" Configure...");
        StyleRange style = FNotificationStylingUtils.getLinkStyle(configureIndex + 1, " Configure...".length() - 1);
        this.notificationTextWidget.setStyleRange(style);
        this.linkRanges.put(style, null);
        int updateToFixIndex = text.indexOf(" Update the DVT Resource Filters now to fix.");
        style = FNotificationStylingUtils.getLinkStyle(updateToFixIndex, " Update the DVT Resource Filters now to fix.".length() - 1);
        this.notificationTextWidget.setStyleRange(style);
        this.linkRanges.put(style, null);
    }

    @Override
    public void onMouseClick(Event e) {
        if (!FMonitorNotificationTracker.INSTANCE.isDirty()) {
            return;
        }
        super.onMouseClick(e);
    }

    @Override
    protected String getButtonTooltipText() {
        return "Update the DVT Resource Filters now";
    }

    @Override
    protected boolean isReady() {
        return FMonitorNotificationTracker.INSTANCE.isDirty(this.project);
    }

    @Override
    public FWidgetType getType() {
        return FWidgetType.RESOURCE_MONITOR;
    }

    @Override
    public void disposeDetails() {
        this.linkRanges = null;
        DVTUiUtils.hideTooltipFloatingNotification((Control)this.notificationTextWidget);
        super.disposeDetails();
    }

    @Override
    protected int getDetailsHeight() {
        int minimumHeight = this.detailsComposite.computeSize((int)-1, (int)-1).y;
        return Math.min(minimumHeight, 216);
    }

    @Override
    protected Image getFixButtonImage() {
        return DVTImages.imageCache.getImage(IS_DARK ? DVTImages.F_RESOURCE_MONITOR_NOTIFICATION_DARK : DVTImages.F_RESOURCE_MONITOR_NOTIFICATION_LIGHT);
    }
}

