/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.floatingwidgets;

import java.util.Collection;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.floatingwidgets.FNotificationConstants;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetFactory;
import ro.amiq.dvt.ui.editor.floatingwidgets.IFWidget;

public enum FMouseDownFilterListener implements Listener
{
    INSTANCE;


    public void handleEvent(Event event) {
        if (!(event.widget instanceof Canvas)) {
            return;
        }
        Canvas currentHost = (Canvas)event.widget;
        if (currentHost.getData() == FNotificationConstants.NOTIFICATION_STYLED_TEXT_DATA) {
            return;
        }
        this.disposeOtherNotificationDetails(currentHost);
        Collection<IFWidget> widgets = FWidgetFactory.INSTANCE.getWidgets(currentHost);
        for (IFWidget widget : widgets) {
            widget.onMouseClick(event);
        }
    }

    private void disposeOtherNotificationDetails(Canvas currentHost) {
        IWorkbenchPage page = DVTUiUtils.getActivePage();
        if (page == null) {
            return;
        }
        IEditorReference[] editorReferences = page.getEditorReferences();
        if (editorReferences == null) {
            return;
        }
        IEditorReference[] iEditorReferenceArray = editorReferences;
        int n = editorReferences.length;
        int n2 = 0;
        while (n2 < n) {
            DVTEditor dvtEditor;
            IEditorPart editor;
            IEditorReference reference = iEditorReferenceArray[n2];
            IWorkbenchPart part = reference.getPart(false);
            if (part != null && page.isPartVisible(part) && (editor = reference.getEditor(false)) instanceof DVTEditor && (dvtEditor = (DVTEditor)editor).getFNotificationHostCanvas() != currentHost) {
                dvtEditor.disposeFloatingWidgetsDetails();
            }
            ++n2;
        }
    }

    public void addDisplayFilter(Canvas canvas) {
        if (canvas == null) {
            return;
        }
        canvas.getDisplay().addFilter(3, (Listener)this);
    }

    public void removeDisplayFilter(Canvas canvas) {
        if (canvas == null) {
            return;
        }
        canvas.getDisplay().removeListener(3, (Listener)this);
        canvas.getDisplay().removeFilter(3, (Listener)this);
    }
}

