/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.floatingwidgets;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import ro.amiq.dvt.draw.utils.GCFactory;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.editor.floatingwidgets.FCaretHandlerListener;
import ro.amiq.dvt.ui.editor.floatingwidgets.FNotificationConstants;
import ro.amiq.dvt.ui.editor.floatingwidgets.FNotificationState;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetFactory;
import ro.amiq.dvt.ui.editor.floatingwidgets.IFNotificationHost;
import ro.amiq.dvt.ui.editor.floatingwidgets.IFWidget;
import ro.amiq.dvt.ui.preferences.theme.DVTThemeUtils;
import ro.amiq.dvt.ui.utils.DVTColorUtil;

public abstract class FNotification
implements IFWidget {
    protected IProject project;
    private AtomicInteger index = new AtomicInteger();
    protected FNotificationState state;
    protected Canvas canvas;
    protected ITextViewer sourceViewer;
    protected StyledText notificationTextWidget;
    private AtomicBoolean resizeRemove = new AtomicBoolean();
    private AtomicBoolean forcePaint = new AtomicBoolean();
    protected Composite detailsComposite;
    private int arrowDirectionShifter = 1;
    private ToolTip tooltip;
    private FocusListener textFocusListener;
    private ControlListener resizeListener;
    private PaintListener paintListener;
    private MouseMoveListener mouseMoveListener;
    private Listener hScrollListener;
    protected Listener detailsClickListener;
    private Job resetJob;
    protected static final boolean IS_DARK = DVTThemeUtils.isDarkUI();

    protected FNotification(IFNotificationHost editor) {
        this.canvas = editor.getFNotificationHostCanvas();
        this.project = editor.getProject();
        this.sourceViewer = editor.getFNotificationHostTextViewer();
        this.createJobs();
        this.addListeners();
    }

    protected void createJobs() {
        this.resetJob = new Job("Resizing editor..."){

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (FNotification.this.canvas == null || FNotification.this.canvas.isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                FNotification.this.resizeRemove.set(false);
                Display.getDefault().syncExec(() -> {
                    if (FNotification.this.canvas != null) {
                        FNotification.this.canvas.redraw();
                    }
                });
                return Status.OK_STATUS;
            }
        };
        this.resetJob.setSystem(true);
    }

    protected void addListeners() {
        Display.getDefault().syncExec(() -> {
            this.addResizeListener();
            this.addFPaintListener();
            this.addHoverListener();
            this.addCaretListener();
            this.addTextChangeListener();
        });
    }

    private void addResizeListener() {
        if (this.canvas == null) {
            return;
        }
        this.resizeListener = new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                if (!FNotification.this.resizeRemove.get()) {
                    FNotification.this.canvas.redraw();
                }
                FNotification.this.resizeRemove.set(true);
                FNotification.this.disposeDetails();
                FNotification.this.resetJob.cancel();
                FNotification.this.resetJob.schedule(300L);
            }
        };
        ScrollBar horizontalBar = this.canvas.getHorizontalBar();
        if (horizontalBar != null) {
            this.hScrollListener = event -> {
                if (!this.resizeRemove.get()) {
                    this.canvas.redraw();
                }
                this.resizeRemove.set(true);
                this.disposeDetails();
                this.resetJob.cancel();
                this.resetJob.schedule(300L);
            };
            horizontalBar.addListener(13, this.hScrollListener);
        }
        this.canvas.addControlListener(this.resizeListener);
    }

    private void addFPaintListener() {
        if (this.canvas == null) {
            return;
        }
        this.paintListener = e -> this.internalPaint(e);
        this.canvas.addPaintListener(this.paintListener);
    }

    private void addCaretListener() {
        if (this.sourceViewer == null) {
            return;
        }
        FCaretHandlerListener.addAsCaretListener(this.getStyledText());
    }

    private void addTextChangeListener() {
        if (this.sourceViewer == null) {
            return;
        }
        FCaretHandlerListener.addAsTextChangeListener(this.sourceViewer);
    }

    @Override
    public void onMouseClick(Event e) {
        if (this.canvas == null) {
            return;
        }
        Rectangle clientArea = this.canvas.getClientArea();
        if (clientArea == null) {
            return;
        }
        Rectangle notificationArea = this.getNotificationArea(clientArea.width);
        if (this.isInsideNotificationDetails(e.widget)) {
            return;
        }
        if (!this.isInsideNotificationArea(e, notificationArea)) {
            this.disposeDetails();
            return;
        }
        e.type = 0;
        if (e.x > notificationArea.x + notificationArea.width / 2) {
            this.handleFixButtonClick();
            return;
        }
        if (e.x < notificationArea.x + notificationArea.width / 2) {
            this.handleArrowClick(clientArea.width);
        }
    }

    private boolean isInsideNotificationArea(Object event, Rectangle notificationArea) {
        if (notificationArea == null) {
            return false;
        }
        if (event instanceof Event) {
            Event e = (Event)event;
            return e.x >= notificationArea.x && e.x <= notificationArea.x + notificationArea.width && e.y >= notificationArea.y && e.y <= notificationArea.y + notificationArea.height;
        }
        if (event instanceof MouseEvent) {
            MouseEvent e = (MouseEvent)event;
            return e.x >= notificationArea.x && e.x <= notificationArea.x + notificationArea.width && e.y >= notificationArea.y && e.y <= notificationArea.y + notificationArea.height;
        }
        return false;
    }

    private boolean isInsideNotificationDetails(Widget widget) {
        if (this.detailsComposite == null || this.detailsComposite.isDisposed()) {
            return false;
        }
        return widget == this.notificationTextWidget;
    }

    protected void disposeNotification() {
        Display.getDefault().syncExec(() -> FWidgetFactory.INSTANCE.disposeAll(this.getType()));
    }

    protected void handleArrowClick(int clientAreaWidth) {
        if (this.arrowDirectionShifter == -1) {
            this.disposeDetails();
            return;
        }
        this.arrowDirectionShifter = -1;
        this.detailsComposite = new Composite((Composite)this.canvas, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, true).applyTo((Control)this.detailsComposite);
        GridLayoutFactory.fillDefaults().applyTo(this.detailsComposite);
        Rectangle notificationArea = this.getNotificationArea(clientAreaWidth);
        int detailsCompositeWidth = clientAreaWidth - 72 - 30;
        this.detailsComposite.setBounds(10, notificationArea.y, detailsCompositeWidth, 72);
        this.notificationTextWidget = new StyledText(this.detailsComposite, 584);
        this.notificationTextWidget.setData(FNotificationConstants.NOTIFICATION_STYLED_TEXT_DATA);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.notificationTextWidget);
        DVTColorUtil.INSTANCE.setBackground((Control)this.notificationTextWidget, JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.notification.backgroundColor"));
        this.notificationTextWidget.setText(this.getNotificationText());
        this.detailsComposite.setSize(detailsCompositeWidth, this.getDetailsHeight());
        this.styleNotificationText(notificationArea);
        this.addNotificationTextListeners();
        this.detailsComposite.layout();
        this.canvas.redraw(notificationArea.x, notificationArea.y, notificationArea.width / 2, notificationArea.height, false);
        ObjectionManager.getInstance().clear(Objection.FLOATING_NOTIFICATION_TEXT);
    }

    protected void addNotificationTextListeners() {
        this.textFocusListener = new FocusListener(){

            public void focusLost(FocusEvent e) {
                FNotification.this.disposeDetails();
            }

            public void focusGained(FocusEvent e) {
            }
        };
        this.notificationTextWidget.addFocusListener(this.textFocusListener);
    }

    private void addHoverListener() {
        if (this.canvas == null) {
            return;
        }
        this.mouseMoveListener = e -> this.onMouseMove(e);
        this.canvas.addMouseMoveListener(this.mouseMoveListener);
    }

    private void onMouseMove(MouseEvent e) {
        if (!this.isReady()) {
            return;
        }
        Rectangle clientArea = this.canvas.getClientArea();
        if (clientArea == null) {
            return;
        }
        Rectangle notificationArea = this.getNotificationArea(clientArea.width);
        if (!this.isInsideNotificationArea(e, notificationArea)) {
            if (this.state == FNotificationState.HOVER_ARROW || this.state == FNotificationState.HOVER_BUTTON) {
                this.canvas.setCursor(null);
                this.state = null;
                this.canvas.redraw(notificationArea.x, notificationArea.y, notificationArea.width, notificationArea.height, false);
            }
            this.disposeTooltips();
            return;
        }
        this.canvas.setCursor(FNotificationConstants.HOVER_CURSOR);
        if (e.x > notificationArea.x + notificationArea.width / 2 && this.state != FNotificationState.HOVER_BUTTON && this.state != FNotificationState.PAINTED_EFFECT) {
            this.setButtonState();
            this.disposeTooltips();
            this.createTooltips();
            if (this.state != FNotificationState.PAINTED_EFFECT) {
                this.canvas.redraw(notificationArea.x, notificationArea.y, notificationArea.width, notificationArea.height, false);
            }
        }
        if (e.x < notificationArea.x + notificationArea.width / 2 && this.state != FNotificationState.HOVER_ARROW) {
            this.state = FNotificationState.HOVER_ARROW;
            this.disposeTooltips();
            this.createTooltips();
            this.canvas.redraw(notificationArea.x, notificationArea.y, notificationArea.width, notificationArea.height, false);
        }
    }

    protected void setButtonState() {
        this.state = FNotificationState.HOVER_BUTTON;
    }

    private void createTooltips() {
        this.tooltip = new ToolTip((Control)this.canvas){
            private FormText tooltipFormText;
            private Form form;
            private FormToolkit toolkit;

            protected Composite createToolTipContentArea(Event event, Composite parent) {
                if (FNotification.this.state != FNotificationState.HOVER_ARROW && FNotification.this.state != FNotificationState.HOVER_BUTTON) {
                    return null;
                }
                this.tooltipFormText = this.createTooltipFormText(parent);
                if (FNotification.this.state == FNotificationState.HOVER_ARROW) {
                    this.tooltipFormText.setText("Toggle Details", false, false);
                } else if (FNotification.this.state == FNotificationState.HOVER_BUTTON) {
                    String buttonTooltip = FNotification.this.getButtonTooltipText();
                    this.tooltipFormText.setText(buttonTooltip, false, false);
                }
                this.tooltipFormText.layout();
                return parent;
            }

            private FormText createTooltipFormText(Composite parent) {
                this.toolkit = new FormToolkit(parent.getDisplay());
                this.form = this.toolkit.createForm(parent);
                GridLayoutFactory.fillDefaults().applyTo(this.form.getBody());
                return this.toolkit.createFormText(this.form.getBody(), false);
            }

            public void deactivate() {
                this.deactivateFormText();
                this.deactivateToolkit();
                this.deactivateForm();
                if (FNotification.this.canvas.isDisposed()) {
                    return;
                }
                super.deactivate();
            }

            private void deactivateFormText() {
                if (this.tooltipFormText == null) {
                    return;
                }
                if (this.tooltipFormText.isDisposed()) {
                    this.tooltipFormText = null;
                    return;
                }
                this.tooltipFormText.dispose();
                this.tooltipFormText = null;
            }

            private void deactivateToolkit() {
                if (this.toolkit == null) {
                    return;
                }
                this.toolkit.dispose();
                this.toolkit = null;
            }

            private void deactivateForm() {
                if (this.form == null) {
                    return;
                }
                if (this.form.isDisposed()) {
                    this.form = null;
                    return;
                }
                this.form.dispose();
                this.form = null;
            }
        };
        this.tooltip.setShift(FNotificationConstants.TOOLTIP_SHIFT);
    }

    protected abstract String getButtonTooltipText();

    @Override
    public void paint(boolean force) {
        Display.getDefault().asyncExec(() -> {
            if (this.canvas == null || this.canvas.isDisposed()) {
                return;
            }
            Rectangle clientArea = this.canvas.getClientArea();
            if (clientArea == null) {
                return;
            }
            Rectangle notificationArea = this.getNotificationArea(clientArea.width);
            this.forcePaint.set(force);
            this.canvas.redraw(notificationArea.x, notificationArea.y, notificationArea.width + 1, notificationArea.height + 1, false);
        });
    }

    private void internalPaint(PaintEvent e) {
        if (this.resizeRemove.get()) {
            return;
        }
        if (!this.forcePaint.get() && !this.isReady()) {
            return;
        }
        if (this.state == null) {
            this.state = FNotificationState.PAINTED;
        }
        this.paintNotification(e.gc);
    }

    private void paintNotification(GC gc) {
        Rectangle clientArea = this.canvas.getClientArea();
        if (clientArea == null) {
            return;
        }
        GCFactory.INSTANCE.setMaxQuality(gc);
        Rectangle notification = this.getNotificationArea(clientArea.width);
        this.drawBorder(gc, notification);
        this.drawSeparator(gc, notification);
        this.drawHover(gc, this.state, notification);
        this.drawExpandCollapse(gc, this.state, notification);
        this.drawFixButton(gc, this.state, notification);
        ObjectionManager.getInstance().clear(Objection.FLOATING_NOTIFICATION);
    }

    private void drawBorder(GC gc, Rectangle notificationArea) {
        gc.setBackground(this.canvas.getBackground());
        gc.fillRoundRectangle(notificationArea.x, notificationArea.y, notificationArea.width, notificationArea.height, 20, 20);
        gc.setBackground(FNotificationConstants.COLOR_HOVER_BG);
        gc.setForeground(FNotificationConstants.BORDER_COLOR);
        gc.drawRoundRectangle(notificationArea.x, notificationArea.y, notificationArea.width, notificationArea.height, 20, 20);
    }

    private void drawSeparator(GC gc, Rectangle notificationArea) {
        gc.setBackground(FNotificationConstants.SEPARATOR_COLOR);
        gc.drawLine(notificationArea.x + notificationArea.width / 2, notificationArea.y, notificationArea.x + notificationArea.width / 2, notificationArea.y + notificationArea.height);
    }

    private void drawHover(GC gc, FNotificationState hoverState, Rectangle notificationArea) {
        if (hoverState != FNotificationState.HOVER_ARROW && hoverState != FNotificationState.HOVER_BUTTON) {
            return;
        }
        gc.setBackground(FNotificationConstants.COLOR_HOVER_BG);
        int xClip = hoverState == FNotificationState.HOVER_ARROW ? notificationArea.x + 1 : notificationArea.x + notificationArea.width / 2;
        int y = notificationArea.y + 1;
        int width = notificationArea.width / 2;
        int height = notificationArea.height;
        gc.setClipping(xClip, y, width, height);
        gc.fillRoundRectangle(notificationArea.x, notificationArea.y, notificationArea.width, notificationArea.height, 20, 20);
        gc.drawRoundRectangle(notificationArea.x, notificationArea.y, notificationArea.width, notificationArea.height, 20, 20);
        Region resetClippingRegion = null;
        gc.setClipping(resetClippingRegion);
    }

    private void drawExpandCollapse(GC gc, FNotificationState state, Rectangle notificationArea) {
        int paddingX;
        int oldLineWidth = gc.getLineWidth();
        gc.setLineWidth(2);
        gc.setForeground(IS_DARK ? FNotificationConstants.EXPAND_COLLAPSE_COLOR_DARK_THEME : FNotificationConstants.EXPAND_COLLAPSE_COLOR);
        int paddingY = FNotificationState.HOVER_ARROW == state ? 10 : 11;
        int n = paddingX = FNotificationState.HOVER_ARROW == state ? 0 : 1;
        if (this.arrowDirectionShifter == 1) {
            this.drawExpand(gc, notificationArea, paddingY, paddingX);
        } else {
            this.drawCollapse(gc, notificationArea, paddingX);
        }
        gc.setLineWidth(oldLineWidth);
    }

    private void drawExpand(GC gc, Rectangle notificationArea, int paddingY, int paddingX) {
        this.drawCollapse(gc, notificationArea, paddingX);
        int x1 = notificationArea.x + notificationArea.width / 4;
        int y1 = notificationArea.y + paddingY;
        int x2 = x1;
        int y2 = notificationArea.y + notificationArea.height - paddingY;
        gc.drawLine(x1, y1, x2, y2);
    }

    private void drawCollapse(GC gc, Rectangle notificationArea, int paddingX) {
        int x1 = notificationArea.x + notificationArea.width / 8 + paddingX;
        int y1 = notificationArea.y + notificationArea.height / 2;
        int x2 = notificationArea.x + 3 * notificationArea.width / 8 - paddingX;
        int y2 = y1;
        gc.drawLine(x1, y1, x2, y2);
    }

    private void drawFixButton(GC gc, FNotificationState region, Rectangle notificationArea) {
        Transform tr = new Transform((Device)Display.getDefault());
        tr.translate((float)notificationArea.width / 8.0f, (float)notificationArea.height / 4.0f);
        gc.setTransform(tr);
        int x = notificationArea.x + notificationArea.width / 2;
        int y = notificationArea.y;
        int padding = FNotificationState.HOVER_BUTTON == region ? 1 : 0;
        gc.drawImage(this.getFixButtonImage(), x - padding, y - padding);
        tr.dispose();
        gc.setTransform(null);
    }

    @Override
    public Rectangle getNotificationArea(int clientAreaWidth) {
        int rectangleX = clientAreaWidth - 72 - 10;
        int rectangleY = 10 + this.index.get() * 46;
        Rectangle rectangle = new Rectangle(rectangleX, rectangleY, 72, 36);
        return rectangle;
    }

    @Override
    public void dispose() {
        if (this.resetJob != null) {
            this.resetJob.cancel();
            this.resetJob = null;
        }
        this.disposeDetails();
        this.disposeTooltips();
        this.removeListeners();
        if (this.canvas == null || this.canvas.isDisposed()) {
            return;
        }
        this.canvas.setCursor(null);
        Rectangle clientArea = this.canvas.getClientArea();
        if (clientArea == null) {
            return;
        }
        Rectangle notificationArea = this.getNotificationArea(clientArea.width);
        this.canvas.redraw(notificationArea.x, notificationArea.y, notificationArea.width + 1, notificationArea.height + 1, false);
        this.sourceViewer = null;
        this.canvas = null;
        this.project = null;
        this.resizeRemove = null;
        this.forcePaint = null;
        this.state = null;
        ObjectionManager.getInstance().clear(Objection.FLOATING_NOTIFICATION);
    }

    @Override
    public void disposeDetails() {
        if (this.notificationTextWidget != null && !this.notificationTextWidget.isDisposed()) {
            if (this.textFocusListener != null) {
                this.notificationTextWidget.removeFocusListener(this.textFocusListener);
            }
            if (this.detailsClickListener != null) {
                this.notificationTextWidget.removeListener(3, this.detailsClickListener);
            }
            this.notificationTextWidget.dispose();
        }
        this.textFocusListener = null;
        this.notificationTextWidget = null;
        if (this.detailsComposite != null) {
            this.detailsComposite.dispose();
            this.detailsComposite = null;
        }
        this.arrowDirectionShifter = 1;
    }

    private void disposeTooltips() {
        if (this.tooltip == null) {
            return;
        }
        this.tooltip.hide();
        this.tooltip.deactivate();
        this.tooltip = null;
    }

    protected void removeListeners() {
        if (this.canvas == null || this.canvas.isDisposed()) {
            return;
        }
        if (this.resizeListener != null) {
            this.canvas.removeControlListener(this.resizeListener);
            this.resizeListener = null;
        }
        if (this.paintListener != null) {
            this.canvas.removePaintListener(this.paintListener);
            this.paintListener = null;
        }
        if (this.mouseMoveListener != null) {
            this.canvas.removeMouseMoveListener(this.mouseMoveListener);
            this.mouseMoveListener = null;
        }
        this.removeHScrollListener();
        StyledText styledText = this.getStyledText();
        if (styledText == null) {
            return;
        }
        FCaretHandlerListener.removeCaretListener(styledText);
        FCaretHandlerListener.removeTextChangeListener(this.sourceViewer);
    }

    private void removeHScrollListener() {
        if (this.hScrollListener == null) {
            return;
        }
        ScrollBar horizontalBar = this.canvas.getHorizontalBar();
        if (horizontalBar == null) {
            return;
        }
        horizontalBar.removeListener(13, this.hScrollListener);
        this.hScrollListener = null;
    }

    @Override
    public void setIndex(int index) {
        this.index.set(index);
    }

    @Override
    public StyledText getStyledText() {
        if (this.sourceViewer == null) {
            return null;
        }
        return this.sourceViewer.getTextWidget();
    }

    @Override
    public boolean isVisible() {
        return this.state != null;
    }

    protected int getDetailsHeight() {
        return 72;
    }

    protected abstract void handleFixButtonClick();

    protected abstract String getNotificationText();

    protected abstract void styleNotificationText(Rectangle var1);

    protected abstract boolean isReady();

    protected abstract Image getFixButtonImage();

    @Override
    public void testOpenNotification() {
        if (this.canvas == null) {
            return;
        }
        Rectangle clientArea = this.canvas.getClientArea();
        if (clientArea == null) {
            return;
        }
        if (this.arrowDirectionShifter == -1) {
            ObjectionManager.getInstance().clear(Objection.FLOATING_NOTIFICATION_TEXT);
            return;
        }
        this.handleArrowClick(clientArea.width);
    }

    @Override
    public void testFixButtonClick() {
        if (this.canvas == null) {
            return;
        }
        Rectangle clientArea = this.canvas.getClientArea();
        if (clientArea == null) {
            return;
        }
        this.handleFixButtonClick();
    }

    @Override
    public String testGetNotificationText() {
        if (this.notificationTextWidget == null) {
            return "";
        }
        return this.notificationTextWidget.getText();
    }
}

