/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.floatingwidgets;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.buildconfig.splitinvocation.SplitInvocationUtils;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalDirtyPrecompiledLibraries;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalDirtySplitInvocation;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalNotificationTracker;
import ro.amiq.dvt.model.floatingwidgets.FNotificationDirtyReason;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetFactory;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetType;

public enum FNotificationFactory {
    INSTANCE;

    private Map<Integer, String> dirtyPrecompiledLibraryPaths = new HashMap<Integer, String>();
    private Map<SplitInvocationUtils.SplitInvocationLibraryElementsMessageType, List<String>> dirtySplitInvocationLibraryElements = new EnumMap<SplitInvocationUtils.SplitInvocationLibraryElementsMessageType, List<String>>(SplitInvocationUtils.SplitInvocationLibraryElementsMessageType.class);

    public void addDirtyPrecompiledLibrary(String precompiledDBPath, int invocationNumber) {
        this.dirtyPrecompiledLibraryPaths.put(invocationNumber, precompiledDBPath);
    }

    public void clear() {
        this.dirtyPrecompiledLibraryPaths.clear();
        this.dirtySplitInvocationLibraryElements.clear();
    }

    public Map<Integer, String> getDirtyPrecompiledLibraryPaths() {
        return this.dirtyPrecompiledLibraryPaths;
    }

    public void createPrecompiledFloatingNotification(IProject project) {
        if (this.dirtyPrecompiledLibraryPaths == null || this.dirtyPrecompiledLibraryPaths.isEmpty()) {
            return;
        }
        FIncrementalDirtyPrecompiledLibraries dirtyResource = new FIncrementalDirtyPrecompiledLibraries(FNotificationDirtyReason.PRECOMPILED_SOURCES_OUT_OF_SYNC, this.dirtyPrecompiledLibraryPaths);
        FIncrementalNotificationTracker.INSTANCE.addDirtyResource(project, dirtyResource);
        FWidgetFactory.INSTANCE.paint(true, FWidgetType.DB_OUT_OF_SYNC);
    }

    public void addDirtySplitInvocationLibraryElement(List<String> resolvedElements, SplitInvocationUtils.SplitInvocationLibraryElementsMessageType type) {
        if (this.dirtySplitInvocationLibraryElements.containsKey((Object)type)) {
            this.dirtySplitInvocationLibraryElements.get((Object)type).addAll(resolvedElements);
        } else {
            this.dirtySplitInvocationLibraryElements.put(type, resolvedElements);
        }
    }

    public void createSplitInvocationFloatingNotification(IProject project) {
        if (this.dirtySplitInvocationLibraryElements == null || this.dirtySplitInvocationLibraryElements.isEmpty() || !SplitInvocationUtils.isSplitConfigUsed(project)) {
            return;
        }
        FIncrementalDirtySplitInvocation dirtyResource = new FIncrementalDirtySplitInvocation(this.dirtySplitInvocationLibraryElements);
        FIncrementalNotificationTracker.INSTANCE.addDirtyResource(project, dirtyResource);
        FWidgetFactory.INSTANCE.paint(true, FWidgetType.DB_OUT_OF_SYNC);
    }
}

