/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.floatingwidgets;

import java.util.List;
import org.eclipse.swt.custom.Bullet;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.GlyphMetrics;

public class FNotificationStylingUtils {
    public static StyleRange getLinkStyle(int start, int length) {
        StyleRange styleRange = new StyleRange(start, length, null, null, 1);
        styleRange.underline = true;
        styleRange.underlineStyle = 4;
        return styleRange;
    }

    public static void setIndent(StyledText notificationTextWidget, int bulletStartLine, int notificationAreaWidth) {
        int lineCount = notificationTextWidget.getLineCount();
        int indentValue = FNotificationStylingUtils.getIndentValue(notificationAreaWidth);
        if (bulletStartLine == -1) {
            return;
        }
        notificationTextWidget.setLineWrapIndent(0, bulletStartLine, 5);
        notificationTextWidget.setLineWrapIndent(bulletStartLine, lineCount - bulletStartLine, indentValue);
    }

    public static int getIndentValue(int notificationAreaWidth) {
        if (notificationAreaWidth < 0) {
            return 0;
        }
        return Math.min(40, notificationAreaWidth / 10);
    }

    public static Bullet getResourceBullet(int indentValue) {
        StyleRange style2 = new StyleRange();
        style2.metrics = new GlyphMetrics(0, 0, indentValue + 20);
        Bullet fileNameBullet = new Bullet(16, style2);
        fileNameBullet.text = ">";
        return fileNameBullet;
    }

    public static Bullet getReasonBullet(int indentValue) {
        if (indentValue < 0) {
            return null;
        }
        StyleRange style1 = new StyleRange();
        style1.metrics = new GlyphMetrics(0, 0, indentValue);
        Bullet reasonBullet = new Bullet(style1);
        return reasonBullet;
    }

    public static void setLineBullets(StyledText notificationTextWidget, Bullet reasonBullet, Bullet fileNameBullet, int currentLine, List<Integer> fileCategoriesSizes) {
        if (currentLine == -1) {
            return;
        }
        for (Integer fileCount : fileCategoriesSizes) {
            if (fileCount == 0) continue;
            notificationTextWidget.setLineBullet(currentLine, 1, reasonBullet);
            notificationTextWidget.setLineBullet(currentLine + 1, fileCount.intValue(), fileNameBullet);
            currentLine += 2 + fileCount;
        }
    }
}

