/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.floatingwidgets;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.commands.ICommandService;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.model.floatingwidgets.FNotificationDirtyReason;
import ro.amiq.dvt.model.floatingwidgets.FReportIssueDirtyResource;
import ro.amiq.dvt.model.floatingwidgets.FReportIssueNotificationTracker;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.floatingwidgets.FNotification;
import ro.amiq.dvt.ui.editor.floatingwidgets.FNotificationStylingUtils;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetType;
import ro.amiq.dvt.ui.editor.floatingwidgets.IFNotificationHost;

public class FReportIssueNotification
extends FNotification {
    private static final String TOOLTIP_MESSAGE = "Report an issue";
    public static final String INCREMENTAL_NOTIFICATION_MESSAGE = " Incremental build took longer than expected.";
    public static final String PRECOMPILED_AUTO_INFINITE_LOOP_NOTIFICATION_MESSAGE = " Unable to precompile the following libraries so they were fully built: ";
    private static final String REPORT_ISSUE_LINK_TEXT = " Sending a DVT Issue Report";
    public static final String NOTIFICATION_PROPOSAL = " Sending a DVT Issue Report is recommended.";
    public static final String DISMISS_NOTIFICATION_MESSAGE = " Dismiss notification.";
    private static final String REPORT_ISSUE_COMMAND = "ro.amiq.dvt.ui.ReportIssueDelegate";
    private StyleRange linkStyle;
    private StyleRange dissmissNotificationLink;

    protected FReportIssueNotification(IFNotificationHost editor) {
        super(editor);
    }

    @Override
    public FWidgetType getType() {
        return FWidgetType.REPORT_ISSUE;
    }

    @Override
    protected void handleFixButtonClick() {
        try {
            ICommandService commandService = (ICommandService)Utils.getActiveWorkbenchWindow().getService(ICommandService.class);
            if (commandService == null) {
                return;
            }
            Command reportIssueCommand = commandService.getCommand(REPORT_ISSUE_COMMAND);
            if (reportIssueCommand == null) {
                return;
            }
            try {
                reportIssueCommand.executeWithChecks(new ExecutionEvent());
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        finally {
            this.disposeNotification();
        }
    }

    @Override
    protected String getNotificationText() {
        return FReportIssueNotificationTracker.INSTANCE.getNotificationText(this.project);
    }

    @Override
    protected String getButtonTooltipText() {
        return TOOLTIP_MESSAGE;
    }

    @Override
    protected void addNotificationTextListeners() {
        super.addNotificationTextListeners();
        this.detailsClickListener = event -> {
            try {
                int offset = this.notificationTextWidget.getOffsetAtLocation(new Point(event.x, event.y));
                if (offset == -1) {
                    return;
                }
                if (this.isInsideLink(offset, this.linkStyle, REPORT_ISSUE_LINK_TEXT)) {
                    this.handleFixButtonClick();
                    return;
                }
                if (this.isInsideLink(offset, this.dissmissNotificationLink, DISMISS_NOTIFICATION_MESSAGE)) {
                    FReportIssueNotificationTracker.INSTANCE.removeAllDirtyResources();
                    DVTPlugin.getDefault().getPreferenceStore().setValue("ro.amiq.dvt.REPORT_AN_ISSUE_NOTIFICATION_ENABLED", false);
                    return;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        };
        this.notificationTextWidget.addListener(3, this.detailsClickListener);
    }

    private boolean isInsideLink(int offset, StyleRange linkStyle, String text) {
        text = text.trim();
        return offset >= linkStyle.start && offset < linkStyle.start + linkStyle.length && text.equals(this.notificationTextWidget.getText(linkStyle.start, linkStyle.start + linkStyle.length - 1));
    }

    @Override
    protected void styleNotificationText(Rectangle notificationArea) {
        FReportIssueDirtyResource dirtyResource = (FReportIssueDirtyResource)FReportIssueNotificationTracker.INSTANCE.getDirtyResources(this.project).get(0);
        for (FNotificationDirtyReason reason : dirtyResource.getReasons().keySet()) {
            this.boldReasonMessage(FReportIssueNotificationTracker.INSTANCE.getMessageForReason(reason));
        }
        String linkText = REPORT_ISSUE_LINK_TEXT.trim();
        this.linkStyle = FNotificationStylingUtils.getLinkStyle(this.notificationTextWidget.getText().indexOf(linkText), linkText.length());
        this.notificationTextWidget.setStyleRange(this.linkStyle);
        String dismissMessage = DISMISS_NOTIFICATION_MESSAGE.trim();
        this.dissmissNotificationLink = FNotificationStylingUtils.getLinkStyle(this.notificationTextWidget.getText().indexOf(dismissMessage), dismissMessage.length());
        this.notificationTextWidget.setStyleRange(this.dissmissNotificationLink);
    }

    private void boldReasonMessage(String message) {
        int startIndex = this.notificationTextWidget.getText().indexOf(message);
        if (startIndex != -1) {
            this.notificationTextWidget.setStyleRange(new StyleRange(startIndex, message.length() + 1, null, null, 1));
        }
    }

    @Override
    protected int getDetailsHeight() {
        return this.detailsComposite.computeSize((int)-1, (int)-1).y;
    }

    @Override
    protected boolean isReady() {
        return FReportIssueNotificationTracker.INSTANCE.isDirty(this.project);
    }

    @Override
    protected Image getFixButtonImage() {
        return DVTImages.imageCache.getImage(DVTImages.REPORT_ISSUE_IMAGE);
    }
}

