/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.floatingwidgets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPart;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalNotificationTracker;
import ro.amiq.dvt.model.floatingwidgets.FLazyResourcesNotificationTracker;
import ro.amiq.dvt.model.floatingwidgets.FMissingPluginNotificationTracker;
import ro.amiq.dvt.model.floatingwidgets.FMonitorNotificationTracker;
import ro.amiq.dvt.model.floatingwidgets.FReportIssueNotificationTracker;
import ro.amiq.dvt.model.floatingwidgets.IFNotificationTracker;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTTclEditorDummy;
import ro.amiq.dvt.ui.editor.floatingwidgets.FIncrementalNotification;
import ro.amiq.dvt.ui.editor.floatingwidgets.FLazyResourcesNotification;
import ro.amiq.dvt.ui.editor.floatingwidgets.FMissingPluginNotification;
import ro.amiq.dvt.ui.editor.floatingwidgets.FMonitorNotification;
import ro.amiq.dvt.ui.editor.floatingwidgets.FReportIssueNotification;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetType;
import ro.amiq.dvt.ui.editor.floatingwidgets.IFNotificationHost;
import ro.amiq.dvt.ui.editor.floatingwidgets.IFWidget;

public enum FWidgetFactory {
    INSTANCE;

    private Map<IFNotificationHost, List<IFWidget>> widgetsMap = Collections.synchronizedMap(new HashMap());
    private static EnumMap<FWidgetType, IFNotificationTracker> trackersMap;

    static {
        trackersMap = new EnumMap(FWidgetType.class);
        trackersMap.put(FWidgetType.DB_OUT_OF_SYNC, FIncrementalNotificationTracker.INSTANCE);
        trackersMap.put(FWidgetType.RESOURCE_MONITOR, FMonitorNotificationTracker.INSTANCE);
        trackersMap.put(FWidgetType.LAZY_RESOURCES, FLazyResourcesNotificationTracker.INSTANCE);
        trackersMap.put(FWidgetType.REPORT_ISSUE, FReportIssueNotificationTracker.INSTANCE);
        trackersMap.put(FWidgetType.MISSING_PLUGIN, FMissingPluginNotificationTracker.INSTANCE);
    }

    public void createWidgets(IFNotificationHost editor) {
        if (this.testIsFWidgetDisabled()) {
            return;
        }
        if (editor == null) {
            return;
        }
        ArrayList<IFWidget> widgetsList = new ArrayList<IFWidget>();
        this.widgetsMap.put(editor, widgetsList);
        int index = 0;
        FWidgetType[] fWidgetTypeArray = FWidgetType.values();
        int n = fWidgetTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFWidget widget;
            FWidgetType type = fWidgetTypeArray[n2];
            if (trackersMap.get((Object)type).isDirty(editor.getProject()) && (widget = this.createWidget(type, editor)) != null) {
                widgetsList.add(widget);
                widget.setIndex(index++);
            }
            ++n2;
        }
    }

    public Collection<IFWidget> getWidgets(IFNotificationHost editor) {
        List<IFWidget> widgetsList = this.widgetsMap.get(editor);
        if (widgetsList == null) {
            return Collections.emptyList();
        }
        return new ArrayList<IFWidget>(widgetsList);
    }

    public IFWidget getWidget(IFNotificationHost editor, FWidgetType widgetType) {
        List<IFWidget> widgetsList = this.widgetsMap.get(editor);
        if (widgetsList == null) {
            return null;
        }
        for (IFWidget widget : widgetsList) {
            if (widget.getType() != widgetType) continue;
            return widget;
        }
        return null;
    }

    public Collection<IFWidget> getWidgets(Canvas host) {
        if (host == null) {
            return Collections.emptyList();
        }
        for (Map.Entry<IFNotificationHost, List<IFWidget>> entry : this.widgetsMap.entrySet()) {
            IFNotificationHost editor = entry.getKey();
            if (editor == null || host != editor.getFNotificationHostCanvas()) continue;
            List<IFWidget> editorWidgets = entry.getValue();
            if (editorWidgets == null) {
                return Collections.emptyList();
            }
            return new ArrayList<IFWidget>(editorWidgets);
        }
        return Collections.emptyList();
    }

    public void disposeAll(FWidgetType type) {
        for (IFNotificationHost editor : this.widgetsMap.keySet()) {
            this.disposeWidget(editor, type);
        }
    }

    public void disposeAll(FWidgetType type, IProject project) {
        for (IFNotificationHost editor : this.widgetsMap.keySet()) {
            if (!project.equals((Object)editor.getProject())) continue;
            this.disposeWidget(editor, type);
        }
    }

    public void disposeWidgets(IFNotificationHost editor) {
        if (editor == null) {
            return;
        }
        List<IFWidget> editorWidgets = this.widgetsMap.remove(editor);
        if (editorWidgets == null) {
            return;
        }
        for (IFWidget floatingWidget : editorWidgets) {
            if (floatingWidget == null) continue;
            floatingWidget.dispose();
        }
    }

    private void disposeWidget(IFNotificationHost editor, FWidgetType type) {
        if (editor == null) {
            return;
        }
        List<IFWidget> editorWidgets = this.widgetsMap.get(editor);
        if (editorWidgets == null) {
            return;
        }
        IFWidget floatingWidget = null;
        for (IFWidget fw : editorWidgets) {
            if (fw.getType() != type) continue;
            floatingWidget = fw;
            break;
        }
        if (floatingWidget == null) {
            return;
        }
        floatingWidget.dispose();
        editorWidgets.remove(floatingWidget);
        ArrayList<IFWidget> newWidgets = new ArrayList<IFWidget>();
        int currentIndex = 0;
        for (IFWidget remainingWidget : editorWidgets) {
            remainingWidget.dispose();
            IFWidget newWidget = this.createWidget(remainingWidget.getType(), editor);
            if (newWidget == null) continue;
            newWidgets.add(newWidget);
            newWidget.setIndex(currentIndex++);
            newWidget.paint(true);
        }
        this.widgetsMap.put(editor, newWidgets);
    }

    public void paint(IFNotificationHost editor, boolean force) {
        if (editor == null) {
            return;
        }
        List<IFWidget> editorWidgets = this.widgetsMap.get(editor);
        if (editorWidgets == null || editorWidgets.isEmpty()) {
            return;
        }
        for (IFWidget floatingWidget : editorWidgets) {
            floatingWidget.paint(force);
        }
    }

    public void paint(boolean force, FWidgetType type) {
        List<IEditorReference> editorReferences = Utils.getCurrentlyOpenEditorReferences();
        for (IEditorReference editorReference : editorReferences) {
            IWorkbenchPart editor = editorReference.getPart(false);
            if (!(editor instanceof IFNotificationHost)) continue;
            IFNotificationHost notificationHost = (IFNotificationHost)editor;
            if (!trackersMap.get((Object)type).isDirty(notificationHost.getProject())) continue;
            this.paint(notificationHost, force, type);
        }
    }

    private void paint(IFNotificationHost editor, boolean force, FWidgetType type) {
        if (editor == null) {
            return;
        }
        IProject project = editor.getProject();
        if (project == null) {
            return;
        }
        List<IFWidget> widgetsList = this.widgetsMap.get(editor);
        if (widgetsList == null) {
            return;
        }
        for (IFWidget widget : widgetsList) {
            if (widget.getType() != type) continue;
            widget.paint(force);
            return;
        }
        IFWidget newWidget = this.createWidget(type, editor);
        if (newWidget == null) {
            return;
        }
        newWidget.setIndex(widgetsList.size());
        widgetsList.add(newWidget);
        newWidget.paint(force);
    }

    private IFWidget createWidget(FWidgetType type, IFNotificationHost editor) {
        switch (type) {
            case DB_OUT_OF_SYNC: {
                return new FIncrementalNotification(editor);
            }
            case RESOURCE_MONITOR: {
                return editor instanceof DVTEditor ? new FMonitorNotification(editor) : null;
            }
            case LAZY_RESOURCES: {
                return editor instanceof DVTEditor ? new FLazyResourcesNotification(editor) : null;
            }
            case REPORT_ISSUE: {
                return editor instanceof DVTEditor ? new FReportIssueNotification(editor) : null;
            }
            case MISSING_PLUGIN: {
                return editor instanceof DVTTclEditorDummy ? new FMissingPluginNotification(editor) : null;
            }
        }
        return null;
    }

    private boolean testIsFWidgetDisabled() {
        return TestHelper.isFWidgetDisabled();
    }
}

