/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.floatingwidgets.preferences;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.ui.preferences.PreferenceUtils;

public class FloatingWidgetsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "ro.amiq.dvt.FloatingWidgetsPreferencePage";
    private Combo fDatabaseUpdateTimeout;
    private Button fDatabaseUpdateTimeoutButton;
    private Button fEnableReportIssueNotification;
    private Button fEnableExternalPluginNotification;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().hint(parent.computeSize(-1, -1)).applyTo((Control)composite);
        Group databaseUpdate = new Group(composite, 16);
        databaseUpdate.setFont(parent.getFont());
        databaseUpdate.setLayout((Layout)new GridLayout(3, false));
        GridDataFactory.fillDefaults().applyTo((Control)databaseUpdate);
        databaseUpdate.setText("Database Update from Editor Notification");
        this.fDatabaseUpdateTimeoutButton = new Button((Composite)databaseUpdate, 32);
        this.fDatabaseUpdateTimeoutButton.setFont(parent.getFont());
        this.fDatabaseUpdateTimeoutButton.setText("Timeout after ");
        this.fDatabaseUpdateTimeoutButton.setSelection(DVTPlugin.getDefault().getPreferenceStore().getBoolean("ro.amiq.dvt.DATABASE_UPDATE_ENABLE"));
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).applyTo((Control)this.fDatabaseUpdateTimeoutButton);
        this.fDatabaseUpdateTimeout = new Combo((Composite)databaseUpdate, 2048);
        this.fDatabaseUpdateTimeout.setFont(parent.getFont());
        this.fDatabaseUpdateTimeout.setEnabled(this.fDatabaseUpdateTimeoutButton.getSelection());
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).hint(65, -1).applyTo((Control)this.fDatabaseUpdateTimeout);
        this.fDatabaseUpdateTimeoutButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FloatingWidgetsPreferencePage.this.fDatabaseUpdateTimeout.setEnabled(FloatingWidgetsPreferencePage.this.fDatabaseUpdateTimeoutButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fDatabaseUpdateTimeout.setItems(new String[]{"10", "20", "30", "60", "120", "240", "300"});
        this.fDatabaseUpdateTimeout.setText(DVTPlugin.getDefault().getPreferenceStore().getString("ro.amiq.dvt.DATABASE_UPDATE"));
        this.fDatabaseUpdateTimeout.setTextLimit(3);
        this.fDatabaseUpdateTimeout.addModifyListener(e -> {
            this.setValid(true);
            this.setErrorMessage(null);
            String databaseUpdateTime = this.fDatabaseUpdateTimeout.getText();
            try {
                int value = Integer.parseInt(databaseUpdateTime);
                if (value < 1) {
                    this.setErrorMessage("Build automatic time must be valid, positive number!");
                    this.setValid(false);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage("'" + databaseUpdateTime + "' is not a valid number!");
                this.setValid(false);
            }
        });
        this.fEnableReportIssueNotification = new Button(composite, 32);
        this.fEnableReportIssueNotification.setFont(parent.getFont());
        this.fEnableReportIssueNotification.setToolTipText("Suggest sending an Issue Report when an incremental build takes longer than expected.");
        this.fEnableReportIssueNotification.setText("Report an Issue Editor Notification");
        this.fEnableReportIssueNotification.setSelection(PreferenceUtils.INSTANCE.getBoolean("ro.amiq.dvt.REPORT_AN_ISSUE_NOTIFICATION_ENABLED"));
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).applyTo((Control)this.fEnableReportIssueNotification);
        this.fEnableExternalPluginNotification = new Button(composite, 32);
        this.fEnableExternalPluginNotification.setFont(parent.getFont());
        this.fEnableExternalPluginNotification.setText("External Plugin Editor Notification");
        this.fEnableExternalPluginNotification.setSelection(PreferenceUtils.INSTANCE.getBoolean("ro.amiq.dvt.EXTERNAL_PLUGIN_NOTIFICATION_ENABLED"));
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).applyTo((Control)this.fEnableExternalPluginNotification);
        Label databaseUpdateLabel = new Label((Composite)databaseUpdate, 0);
        databaseUpdateLabel.setFont(parent.getFont());
        databaseUpdateLabel.setText("seconds.");
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(DVTPlugin.getDefault().getPreferenceStore());
        this.setDescription("General settings for all DVT Editor Notifications");
    }

    protected void performDefaults() {
        super.performDefaults();
        IPreferenceStore preferenceStore = DVTPlugin.getDefault().getPreferenceStore();
        this.fDatabaseUpdateTimeoutButton.setSelection(preferenceStore.getDefaultBoolean("ro.amiq.dvt.DATABASE_UPDATE_ENABLE"));
        this.fDatabaseUpdateTimeout.setEnabled(this.fDatabaseUpdateTimeoutButton.getSelection());
        this.fEnableReportIssueNotification.setSelection(preferenceStore.getDefaultBoolean("ro.amiq.dvt.REPORT_AN_ISSUE_NOTIFICATION_ENABLED"));
        this.fEnableExternalPluginNotification.setSelection(preferenceStore.getDefaultBoolean("ro.amiq.dvt.EXTERNAL_PLUGIN_NOTIFICATION_ENABLED"));
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("ro.amiq.dvt.DATABASE_UPDATE_ENABLE", this.fDatabaseUpdateTimeoutButton.getSelection());
        this.getPreferenceStore().setValue("ro.amiq.dvt.DATABASE_UPDATE", Integer.parseInt(this.fDatabaseUpdateTimeout.getText()));
        this.getPreferenceStore().setValue("ro.amiq.dvt.REPORT_AN_ISSUE_NOTIFICATION_ENABLED", this.fEnableReportIssueNotification.getSelection());
        this.getPreferenceStore().setValue("ro.amiq.dvt.EXTERNAL_PLUGIN_NOTIFICATION_ENABLED", this.fEnableExternalPluginNotification.getSelection());
        DVTPlugin.getDefault().savePreferences();
        return true;
    }

    public void dispose() {
        this.fDatabaseUpdateTimeout.dispose();
        this.fDatabaseUpdateTimeoutButton.dispose();
        this.fEnableReportIssueNotification.dispose();
        this.fEnableExternalPluginNotification.dispose();
        this.fDatabaseUpdateTimeout = null;
        this.fDatabaseUpdateTimeoutButton = null;
        this.fEnableReportIssueNotification = null;
        this.fEnableExternalPluginNotification = null;
        super.dispose();
    }
}

