/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.formatter;

import de.cau.cs.kieler.core.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.formatter.IContentFormatter;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.preproc.PreprocDiffManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.DVTPosition;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.ExternalCodeFormatJob;
import ro.amiq.dvt.ui.editor.TextUtils;
import ro.amiq.dvt.ui.editor.formatter.DVTPreprocFormattingUtils;
import ro.amiq.dvt.ui.editor.formatter.model.CFAction;
import ro.amiq.dvt.ui.editor.formatter.model.CFChunk;
import ro.amiq.dvt.ui.editor.formatter.model.CFLineInfo;
import ro.amiq.dvt.ui.editor.formatter.model.CFModel;
import ro.amiq.dvt.ui.editor.formatter.model.CFPartition;
import ro.amiq.dvt.ui.editor.formatter.model.CFPositionReference;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFPreferences;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFToken;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFTokenScanner;
import ro.amiq.dvt.ui.editor.formatter.scanner.ICFTokenScanner;
import ro.amiq.dvt.ui.editor.formatter.scanner.indent.ICFIndentScannerImpl;
import ro.amiq.dvt.ui.editor.formatter.scanner.vertical.ICFVParenTokenScannerImpl;
import ro.amiq.dvt.ui.editor.formatter.scanner.vertical.ICFVTokenScannerImpl;
import ro.amiq.dvt.ui.editor.formatter.scanner.vregex.CFVRegExBaseDefinition;
import ro.amiq.dvt.ui.editor.formatter.strategies.DVTBaseCodeFormattingStrategy;
import ro.amiq.dvt.ui.editor.formatter.strategies.DVTBaseFormattingStrategy;
import ro.amiq.dvt.ui.editor.formatter.strategies.IDVTFormattingStrategy;
import ro.amiq.dvt.ui.editor.formatter.util.CFSyso;
import ro.amiq.dvt.ui.editor.formatter.util.CFUtils;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.utils.DVTUtilsCommon;

public class DVTContentFormatter
implements IContentFormatter {
    private Map<String, IDVTFormattingStrategy> fStrategies;
    private List<CFPositionReference> fAffectedPositionReferences;
    private String fPartitioning;
    private IDocument fDocument;
    private DVTSourceViewerConfiguration fConfiguration;
    private boolean fIgnoreCase;
    private boolean fSlashSLComment;
    private boolean fDashSLComment;
    private boolean fSlashMLComment;
    private boolean fFormatFailed;
    private boolean fDoNotShowFormatFailedPopup;
    private boolean fFormatFromEditor;
    private int fCodeFormattingThreshold;
    private static final String DVT_CFSYSO_TAGS_VAL = "DVT_CFSYSO_TAGS";
    private static final Set<String> DVT_CFSYSO_TAGS_SET = DVTContentFormatter.getSetFromCFSysoTags(System.getenv("DVT_CFSYSO_TAGS"));
    private TypedPosition fFirstTypedPosition;
    public static final String CFVREGEX_VLOG_DEFINES = "VlogDefines";
    public static final String CFVREGEX_VLOG_BY_NAME_PORT_CONNECTIONS = "VlogByNamePortConnections";
    public static final String CFVREGEX_VLOG_XVM_FIELD_MACROS = "VlogXVMFieldMacros";
    public static final String CFVREGEX_VLOG_CLASS_DECLARATIONS_GROUP_DIMENSIONS = "VlogClassDeclarationsGroupDimensions";
    public static final String CFVREGEX_VLOG_CLASS_DECLARATIONS = "VlogClassDeclarations";
    public static final String CFVREGEX_VLOG_CLASS_VARIABLE_DECLARATIONS_GROUP_DIMENSIONS = "VlogClassVariableDeclarationsGroupDimensions";
    public static final String CFVREGEX_VLOG_CLASS_VARIABLE_DECLARATIONS = "VlogClassVariableDeclarations";
    public static final String CFVREGEX_VLOG_FUNCTION_DECLARATIONS_GROUP_DIMENSIONS = "VlogFunctionDeclarationsGroupDimensions";
    public static final String CFVREGEX_VLOG_FUNCTION_DECLARATIONS = "VlogFunctionDeclarations";
    public static final String CFVREGEX_VLOG_FUNCTION_VARIABLE_DECLARATIONS_GROUP_DIMENSIONS = "VlogFunctionVariableDeclarationsGroupDimensions";
    public static final String CFVREGEX_VLOG_FUNCTION_VARIABLE_DECLARATIONS = "VlogFunctionVariableDeclarations";
    public static final String CFVREGEX_VLOG_INTERFACE_PORT_DECLARATIONS_GROUP_DIMENSIONS = "VlogInterfacePortDeclarationsGroupDimensions";
    public static final String CFVREGEX_VLOG_INTERFACE_PORT_DECLARATIONS = "VlogInterfacePortDeclarations";
    public static final String CFVREGEX_VLOG_INTERFACE_SIGNAL_DECLARATIONS_GROUP_DIMENSIONS = "VlogInterfaceSignalDeclarationsGroupDimensions";
    public static final String CFVREGEX_VLOG_INTERFACE_SIGNAL_DECLARATIONS = "VlogInterfaceSignalDeclarations";
    public static final String CFVREGEX_VLOG_LIBRARY_PACKAGE_PARAMETER_DECLARATIONS_GROUP_DIMENSIONS = "VlogLibraryAndPackageParameterDeclarationsGroupDimensions";
    public static final String CFVREGEX_VLOG_LIBRARY_PACKAGE_PARAMETER_DECLARATIONS = "VlogLibraryAndPackageParameterDeclarations";
    public static final String CFVREGEX_VLOG_MODULE_PORT_DECLARATIONS_GROUP_DIMENSIONS = "VlogModulePortDeclarationsGroupDimensions";
    public static final String CFVREGEX_VLOG_MODULE_PORT_DECLARATIONS = "VlogModulePortDeclarations";
    public static final String CFVREGEX_VLOG_MODULE_SIGNAL_DECLARATIONS_GROUP_DIMENSIONS = "VlogModuleSignalDeclarationsGroupDimensions";
    public static final String CFVREGEX_VLOG_MODULE_SIGNAL_DECLARATIONS = "VlogModuleSignalDeclarations";
    public static final String CFVREGEX_GROUP_DIMENSIONS_PREFIX = "GroupDimensions";
    public static final List<Pair<String, String>> CFVREGEX_VLOG_PATTERNS_PAIRS = Arrays.asList(new Pair((Object)"VlogClassDeclarations", (Object)"VlogClassDeclarationsGroupDimensions"), new Pair((Object)"VlogClassVariableDeclarations", (Object)"VlogClassVariableDeclarationsGroupDimensions"), new Pair((Object)"VlogModulePortDeclarations", (Object)"VlogModulePortDeclarationsGroupDimensions"), new Pair((Object)"VlogModuleSignalDeclarations", (Object)"VlogModuleSignalDeclarationsGroupDimensions"), new Pair((Object)"VlogInterfacePortDeclarations", (Object)"VlogInterfacePortDeclarationsGroupDimensions"), new Pair((Object)"VlogInterfaceSignalDeclarations", (Object)"VlogInterfaceSignalDeclarationsGroupDimensions"), new Pair((Object)"VlogFunctionDeclarations", (Object)"VlogFunctionDeclarationsGroupDimensions"), new Pair((Object)"VlogFunctionVariableDeclarations", (Object)"VlogFunctionVariableDeclarationsGroupDimensions"), new Pair((Object)"VlogLibraryAndPackageParameterDeclarations", (Object)"VlogLibraryAndPackageParameterDeclarationsGroupDimensions"));
    public static final String CFVREGEX_VHDL_CONSTANT_DECLARATIONS = "VhdlConstantDeclarations";
    public static final String CFVREGEX_VHDL_PORT_DECLARATIONS = "VhdlPortDeclarations";
    public static final String CFVREGEX_VHDL_RECORD_DECLARATIONS = "VhdlRecordDeclarations";
    public static final String CFVREGEX_VHDL_SIGNAL_DECLARATIONS = "VhdlSignalDeclarations";
    public static final String CFVREGEX_VHDL_VARIABLE_DECLARATIONS = "VhdlVariableDeclarations";
    public static final String CFVREGEX_VHDL_SIGNAL_VARIABLE_CONSTANT_DECLARATIONS = "VhdlVariableSignalConstantDeclarations";
    private long fPerformanceDurationGetOriginalContent;
    private long fPerformanceDurationGetFormattedContent;
    private long fPerformanceDurationEquals;
    private long fPerformanceDurationReplace;
    private long fPerformanceNofOperationsReplace;
    private static List<String> fTransformTokens = new ArrayList<String>();
    private static final String PARTITIONING = "__formatter_partitioning";
    private IPositionUpdater fPartitioningUpdater;
    private String[] fExternalPartitonManagingCategories;
    private boolean fNeedsComputation = true;
    private String[] fPartitionManagingCategories;
    private IEclipsePreferences.IPreferenceChangeListener fFormatterMaxLinesPreferenceListener;

    public DVTContentFormatter(DVTSourceViewerConfiguration sourceViewerConfiguration, boolean ignoreCase, boolean slashSLComment, boolean dashSLComment, boolean slashMLComment) {
        this.fConfiguration = sourceViewerConfiguration;
        this.fIgnoreCase = ignoreCase;
        this.fSlashSLComment = slashSLComment;
        this.fDashSLComment = dashSLComment;
        this.fSlashMLComment = slashMLComment;
        this.fPartitioning = "__dftl_partitioning";
        this.addThresholdPreferenceChangeListener();
    }

    private static Set<String> getSetFromCFSysoTags(String cfSysoTags) {
        try {
            if (cfSysoTags == null || cfSysoTags.isEmpty()) {
                return Collections.emptySet();
            }
            String[] tags = cfSysoTags.split(",");
            if (tags == null || tags.length == 0) {
                return Collections.emptySet();
            }
            HashSet<String> result = new HashSet<String>();
            String[] stringArray = tags;
            int n = tags.length;
            int n2 = 0;
            while (n2 < n) {
                String tag = stringArray[n2];
                String trimmedTag = tag.trim();
                if (trimmedTag.equals("FLOW") || trimmedTag.equals("CREATE_ACTION") || trimmedTag.equals("APPLY_ACTION") || trimmedTag.equals("MISC") || trimmedTag.equals("VALIGN") || trimmedTag.equals("POSITIONS") || trimmedTag.equals("POSITIONS_AFFECTED") || trimmedTag.equals("PERFORMANCE") || trimmedTag.equals("TRANSFORM")) {
                    result.add(trimmedTag);
                }
                ++n2;
            }
            return result;
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
            return Collections.emptySet();
        }
    }

    public void setFormattingStrategy(IDVTFormattingStrategy strategy, String contentType) {
        Assert.isNotNull((Object)contentType);
        if (this.fStrategies == null) {
            this.fStrategies = new HashMap<String, IDVTFormattingStrategy>();
        }
        if (strategy == null) {
            this.fStrategies.remove(contentType);
        } else {
            this.fStrategies.put(contentType, strategy);
        }
    }

    public void setDocumentPartitioning(String partitioning) {
        this.fPartitioning = partitioning;
    }

    public IDVTFormattingStrategy getFormattingStrategy(String contentType) {
        Assert.isNotNull((Object)contentType);
        if (this.fStrategies == null) {
            return null;
        }
        return this.fStrategies.get(contentType);
    }

    public void format(IDocument document, Region region, IFile file) {
        DVTPreprocFormattingUtils.getInstance().setPVlogPrerequisites(file);
        this.format(document, (IRegion)region);
    }

    public void format(IDocument document, IRegion region) {
        CFPreferences formatPreferences;
        String tmpPositionCategory;
        block36: {
            boolean isValidPVerilogDocument;
            DVTBaseCodeFormattingStrategy cfs;
            if (this.abortFormat(document, region)) {
                return;
            }
            tmpPositionCategory = "TMP EXTERNAL CODE FORMAT";
            formatPreferences = null;
            if (this.fConfiguration != null && (cfs = this.fConfiguration.getCodeFormattingStrategy()) != null) {
                formatPreferences = cfs.getFormatPreferences();
            }
            if (formatPreferences != null && formatPreferences.isExternalPreFormatEnabled()) {
                String externalPreFormatCommand = formatPreferences.getExternalPreFormatCommand();
                if ((externalPreFormatCommand = DVTUtilsCommon.INSTANCE.replaceAllSystemVariables(externalPreFormatCommand, DVTUtilsCommon.ReplaceSysvarsPolicy.LEAVE_UNREPLACED, null)) != null && !externalPreFormatCommand.isEmpty()) {
                    try {
                        String textToFormat = document.get(region.getOffset(), region.getLength());
                        ExternalCodeFormatJob ecfJob = new ExternalCodeFormatJob("DVT - External Pre-Format Code", textToFormat, externalPreFormatCommand);
                        ecfJob.setUser(true);
                        ecfJob.schedule();
                        ecfJob.join();
                        String formattedText = ecfJob.getFormattedText();
                        if (formattedText != null) {
                            document.replace(region.getOffset(), region.getLength(), formattedText);
                            final int newOffset = region.getOffset();
                            final int newLength = formattedText.length();
                            region = new IRegion(){

                                public int getOffset() {
                                    return newOffset;
                                }

                                public int getLength() {
                                    return newLength;
                                }
                            };
                        }
                    }
                    catch (BadLocationException ecfBLE) {
                        DVTLogger.INSTANCE.logError((Throwable)ecfBLE);
                    }
                    catch (InterruptedException ecfIE) {
                        DVTLogger.INSTANCE.logError((Throwable)ecfIE);
                    }
                }
            }
            if (formatPreferences != null && formatPreferences.isExternalPostFormatEnabled()) {
                try {
                    if (document.containsPositionCategory(tmpPositionCategory)) {
                        document.removePositionCategory(tmpPositionCategory);
                    }
                    document.addPositionCategory(tmpPositionCategory);
                    DVTPosition position = new DVTPosition(region.getOffset(), region.getLength());
                    document.addPosition(tmpPositionCategory, (Position)position);
                }
                catch (BadPositionCategoryException ecfBPCE) {
                    DVTLogger.INSTANCE.logError((Throwable)ecfBPCE);
                }
                catch (BadLocationException ecfBLE) {
                    DVTLogger.INSTANCE.logError((Throwable)ecfBLE);
                }
            }
            boolean bl = isValidPVerilogDocument = !this.fConfiguration.isPreview() && DVTPreprocFormattingUtils.getInstance().isValidPVerilogDocument();
            if (isValidPVerilogDocument) {
                region = DVTPreprocFormattingUtils.getInstance().processDocumentBeforeFormatting(document, region);
            }
            try {
                try {
                    this.fNeedsComputation = true;
                    this.fDocument = document;
                    this.fConfiguration.setIncrementalReconciler(false);
                    this.fConfiguration.disableBracketMatcher(true);
                    String indentation = this.getLineStartWSChars(region.getOffset());
                    boolean indentFirstLine = true;
                    int firstLineIndent = 0;
                    if (region.getOffset() != 0) {
                        int lineNo = this.fDocument.getLineOfOffset(region.getOffset());
                        int lineLength = this.fDocument.getLineLength(lineNo);
                        int lineOffset = this.fDocument.getLineOffset(lineNo);
                        if (region.getOffset() != lineOffset) {
                            Region myRegion = new Region(lineOffset, region.getLength() + region.getOffset() - lineOffset);
                            indentation = this.getLineStartWSChars(myRegion.getOffset());
                            indentFirstLine = false;
                        }
                        if (lineNo > 0) {
                            String currentLineTrimmed;
                            String currentLine = this.fDocument.get(lineOffset, lineLength);
                            int currentLineIndent = currentLine.indexOf(currentLineTrimmed = currentLine.trim());
                            if (currentLineIndent != 0) {
                                firstLineIndent = TextUtils.replaceTabsWithSpaces(indentation, this.fConfiguration.getTabWidth()).length();
                            } else {
                                int prevLineOffset = this.fDocument.getLineOffset(lineNo - 1);
                                int prevLineLength = this.fDocument.getLineLength(lineNo - 1);
                                String prevLine = this.fDocument.get(prevLineOffset, prevLineLength);
                                String prevLineTrim = prevLine.trim();
                                while (prevLineTrim.isEmpty() && lineNo > 1) {
                                    prevLineOffset = this.fDocument.getLineOffset(--lineNo - 1);
                                    prevLineLength = this.fDocument.getLineLength(lineNo - 1);
                                    prevLine = this.fDocument.get(prevLineOffset, prevLineLength);
                                    prevLineTrim = prevLine.trim();
                                }
                                firstLineIndent = TextUtils.replaceTabsWithSpaces(this.getLineStartWSChars(prevLineOffset), this.fConfiguration.getTabWidth()).length();
                            }
                        }
                    }
                    this.formatPartitions(region, indentation, indentFirstLine, firstLineIndent, this.fConfiguration.getLanguageKind(), false);
                    if (isValidPVerilogDocument) {
                        DVTPreprocFormattingUtils.getInstance().processDocumentAfterFormatting(document);
                        IDocument originalDocument = DVTPreprocFormattingUtils.getInstance().getOriginalDocument();
                        if (originalDocument != null) {
                            this.validateFormattingResult(originalDocument.get(), this.shouldSort(formatPreferences), this.fConfiguration.getLanguageKind());
                            if (this.fFormatFailed) {
                                DVTPreprocFormattingUtils.getInstance().handleFormatFailed();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    this.fNeedsComputation = true;
                    this.fDocument = null;
                    this.fFirstTypedPosition = null;
                    this.fConfiguration.setIncrementalReconciler(true);
                    this.fConfiguration.disableBracketMatcher(false);
                    DVTPreprocFormattingUtils.getInstance().clearInternal();
                    break block36;
                }
            }
            catch (Throwable throwable) {
                this.fNeedsComputation = true;
                this.fDocument = null;
                this.fFirstTypedPosition = null;
                this.fConfiguration.setIncrementalReconciler(true);
                this.fConfiguration.disableBracketMatcher(false);
                DVTPreprocFormattingUtils.getInstance().clearInternal();
                throw throwable;
            }
            this.fNeedsComputation = true;
            this.fDocument = null;
            this.fFirstTypedPosition = null;
            this.fConfiguration.setIncrementalReconciler(true);
            this.fConfiguration.disableBracketMatcher(false);
            DVTPreprocFormattingUtils.getInstance().clearInternal();
        }
        if (formatPreferences != null && formatPreferences.isExternalPostFormatEnabled()) {
            String externalPostFormatCommand = formatPreferences.getExternalPostFormatCommand();
            if ((externalPostFormatCommand = DVTUtilsCommon.INSTANCE.replaceAllSystemVariables(externalPostFormatCommand, DVTUtilsCommon.ReplaceSysvarsPolicy.LEAVE_UNREPLACED, null)) != null && !externalPostFormatCommand.isEmpty()) {
                try {
                    Position[] ecfPositions = document.getPositions(tmpPositionCategory);
                    if (ecfPositions != null && ecfPositions.length != 0) {
                        Position ecfPosition = ecfPositions[0];
                        String textToFormat = document.get(ecfPosition.getOffset(), ecfPosition.getLength());
                        ExternalCodeFormatJob ecfJob = new ExternalCodeFormatJob("DVT - External Post-Format Code", textToFormat, externalPostFormatCommand);
                        ecfJob.setUser(true);
                        ecfJob.schedule();
                        ecfJob.join();
                        String formattedText = ecfJob.getFormattedText();
                        if (formattedText != null) {
                            document.replace(ecfPosition.getOffset(), ecfPosition.getLength(), formattedText);
                        }
                    }
                }
                catch (BadPositionCategoryException ecfBPCE) {
                    DVTLogger.INSTANCE.logError((Throwable)ecfBPCE);
                }
                catch (BadLocationException ecfBLE) {
                    DVTLogger.INSTANCE.logError((Throwable)ecfBLE);
                }
                catch (InterruptedException ecfIE) {
                    DVTLogger.INSTANCE.logError((Throwable)ecfIE);
                }
            }
        }
    }

    private boolean abortFormat(IDocument document, IRegion region) {
        block5: {
            block4: {
                try {
                    if (this.fFormatFromEditor) break block4;
                    return false;
                }
                catch (BadLocationException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return true;
                }
            }
            int startRegionLine = document.getLineOfOffset(region.getOffset());
            int endRegionLine = document.getLineOfOffset(region.getOffset() + region.getLength());
            if (this.fCodeFormattingThreshold != 0 && this.fCodeFormattingThreshold < endRegionLine - startRegionLine + 1) break block5;
            return false;
        }
        return Utils.forceFormatter(this.fCodeFormattingThreshold);
    }

    public void format(IDocument document, IRegion region, String indentation, boolean ignoreFirstLine, LanguageKind languageKind, boolean onlyIndent) {
        this.fNeedsComputation = true;
        this.fDocument = document;
        this.fConfiguration.setIncrementalReconciler(false);
        this.fConfiguration.disableBracketMatcher(true);
        try {
            this.formatPartitions(region, indentation, !ignoreFirstLine, indentation == null ? 0 : indentation.length(), languageKind, onlyIndent);
        }
        finally {
            this.fNeedsComputation = true;
            this.fDocument = null;
            this.fFirstTypedPosition = null;
            this.fConfiguration.setIncrementalReconciler(true);
            this.fConfiguration.disableBracketMatcher(false);
            DVTPreprocFormattingUtils.getInstance().clearInternal();
        }
    }

    private void formatPartitions(IRegion region, String indentation, boolean indentFirstLine, int firstLineIndent, LanguageKind languageKind, boolean onlyIndent) {
        this.addPartitioningUpdater();
        try {
            CFPreferences formatPreferences = null;
            TypedPosition[] typedPositions = this.getPartitioning(region);
            if (typedPositions != null) {
                if (typedPositions.length > 0 && typedPositions[0] != null) {
                    IDVTFormattingStrategy strategy = this.getFormattingStrategy(typedPositions[0].getType());
                    formatPreferences = strategy.getFormatPreferences();
                }
                long allStartTime = System.currentTimeMillis();
                if (this.fConfiguration != null) {
                    this.fConfiguration.refreshLineDelimiter();
                }
                this.formatterStarts(typedPositions, indentation);
                this.fAffectedPositionReferences = this.getAffectedPositionReferences();
                CFPartition[] partitions = this.createPartitions(typedPositions);
                if (onlyIndent) {
                    model = this.createModel(partitions, indentFirstLine, firstLineIndent);
                    this.replaceTabsWithSpaces(model, partitions);
                    this.applyActions(partitions);
                    if (formatPreferences != null && (formatPreferences.isAddNewLineAfterBeginAndBeforeEnd() || formatPreferences.isAddNewLineAfterEnd())) {
                        model = this.createModel(partitions, indentFirstLine, firstLineIndent);
                        this.addNLAfterToken(model, partitions);
                        this.applyActions(partitions);
                    }
                    if (formatPreferences != null && !formatPreferences.isBeginPrefLeaveAsIs()) {
                        model = this.createModel(partitions, indentFirstLine, firstLineIndent);
                        this.beginIndentation(model, partitions);
                        this.applyActions(partitions);
                    }
                    model = this.createModel(partitions, indentFirstLine, firstLineIndent);
                    this.indent(model, partitions);
                    this.applyActions(partitions);
                    model = this.createModel(partitions, indentFirstLine, firstLineIndent);
                    this.indentStandaloneComments(model, partitions);
                    this.applyActions(partitions);
                    if (CFUtils.getInstance().shouldUseTabs(this.fConfiguration, formatPreferences)) {
                        model = this.createModel(partitions, indentFirstLine, firstLineIndent);
                        this.indentUsingTabs(model, partitions);
                        this.applyActions(partitions);
                    }
                } else {
                    int n;
                    model = this.createModel(partitions, indentFirstLine, firstLineIndent);
                    this.replaceTabsWithSpaces(model, partitions);
                    this.applyActions(partitions);
                    if (formatPreferences != null && formatPreferences.getAddWSBefore() != null && !formatPreferences.getAddWSBefore().trim().isEmpty()) {
                        model = this.createModel(partitions, indentFirstLine, firstLineIndent);
                        this.addWhitespaceBefore(model, partitions);
                        this.applyActions(partitions);
                    }
                    if (formatPreferences != null && formatPreferences.getAddWSAfter() != null && !formatPreferences.getAddWSAfter().trim().isEmpty()) {
                        model = this.createModel(partitions, indentFirstLine, firstLineIndent);
                        this.addWhitespaceAfter(model, partitions);
                        this.applyActions(partitions);
                    }
                    if (formatPreferences != null && formatPreferences.isCompactConsecutiveEmptyLinesEnabled()) {
                        model = this.createModel(partitions, indentFirstLine, firstLineIndent);
                        this.compactConsecutiveEmptyLines(model, partitions);
                        this.applyActions(partitions);
                    }
                    if (formatPreferences != null && formatPreferences.isTrimWhitespaceLineEnabled()) {
                        model = this.createModel(partitions, indentFirstLine, firstLineIndent);
                        this.trimEmptyLines(model, partitions);
                        this.applyActions(partitions);
                    }
                    if (formatPreferences != null && formatPreferences.isTrimEndOfLineWSEnabled()) {
                        model = this.createModel(partitions, indentFirstLine, firstLineIndent);
                        this.trimEndOfLineWhitespace(model, partitions);
                        this.applyActions(partitions);
                    }
                    String removeNLBeforePrefsAsString = null;
                    if (formatPreferences != null) {
                        removeNLBeforePrefsAsString = formatPreferences.getRemoveNLBefore();
                    }
                    if (removeNLBeforePrefsAsString != null) {
                        removeNLBeforePrefsAsString = removeNLBeforePrefsAsString.trim();
                    }
                    if (formatPreferences != null && removeNLBeforePrefsAsString != null && !removeNLBeforePrefsAsString.isEmpty()) {
                        HashSet<String> removeNLprefs = new HashSet<String>();
                        String[] values = removeNLBeforePrefsAsString.split(" ");
                        if (values != null) {
                            String[] stringArray = values;
                            n = values.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String value = stringArray[n2];
                                if (value != null && !(value = value.trim()).isEmpty()) {
                                    removeNLprefs.add(value);
                                }
                                ++n2;
                            }
                        }
                        model = this.createModel(partitions, indentFirstLine, firstLineIndent);
                        this.removeNLBefore(model, partitions, removeNLprefs);
                        this.applyActions(partitions);
                    }
                    String removeNLAfterPrefsAsString = null;
                    if (formatPreferences != null) {
                        removeNLAfterPrefsAsString = formatPreferences.getRemoveNLAfter();
                    }
                    if (removeNLAfterPrefsAsString != null) {
                        removeNLAfterPrefsAsString = removeNLAfterPrefsAsString.trim();
                    }
                    if (formatPreferences != null && removeNLAfterPrefsAsString != null && !removeNLAfterPrefsAsString.isEmpty()) {
                        HashSet<String> removeNLprefs = new HashSet<String>();
                        String[] values = removeNLAfterPrefsAsString.split(" ");
                        if (values != null) {
                            String[] stringArray = values;
                            int n3 = values.length;
                            n = 0;
                            while (n < n3) {
                                String value = stringArray[n];
                                if (value != null && !(value = value.trim()).isEmpty()) {
                                    removeNLprefs.add(value);
                                }
                                ++n;
                            }
                        }
                        model = this.createModel(partitions, indentFirstLine, firstLineIndent);
                        this.removeNLAfter(model, partitions, removeNLprefs);
                        this.applyActions(partitions);
                    }
                    if (formatPreferences != null && formatPreferences.isCompactWSEnabled()) {
                        model = this.createModel(partitions, indentFirstLine, firstLineIndent);
                        this.compactWhitespace(model, partitions);
                        this.applyActions(partitions);
                    }
                    if (formatPreferences != null && formatPreferences.hasFixWhitespaceAfterCodeMarkerInExpansion()) {
                        model = this.createModel(partitions, indentFirstLine, firstLineIndent);
                        this.fixWhitespaceAfterCodeMarkerInExpansion(model, partitions);
                        this.applyActions(partitions);
                    }
                    if (formatPreferences != null && (formatPreferences.isAddNewLineAfterBeginAndBeforeEnd() || formatPreferences.isAddNewLineAfterEnd())) {
                        model = this.createModel(partitions, indentFirstLine, firstLineIndent);
                        this.addNLAfterToken(model, partitions);
                        this.applyActions(partitions);
                    }
                    if (formatPreferences != null && !formatPreferences.isBeginPrefLeaveAsIs()) {
                        model = this.createModel(partitions, indentFirstLine, firstLineIndent);
                        this.beginIndentation(model, partitions);
                        this.applyActions(partitions);
                    }
                    model = this.createModel(partitions, indentFirstLine, firstLineIndent);
                    this.indent(model, partitions);
                    this.applyActions(partitions);
                    if (formatPreferences != null && (formatPreferences.isVerticalAlignParenEnabled() || formatPreferences.isVerticalAlignCurlyEnabled())) {
                        model = this.createModel(partitions, indentFirstLine, firstLineIndent);
                        this.verticalAlignByParen(model, partitions);
                        this.applyActions(partitions);
                    }
                    if (formatPreferences != null && formatPreferences.isVerticalAlignEnabled()) {
                        model = this.createModel(partitions, indentFirstLine, firstLineIndent);
                        if (formatPreferences.isVerticalAlignByRegExEnabled()) {
                            if (!formatPreferences.isCompactWSEnabled() && formatPreferences.isVRegExCompactWSEnabled()) {
                                this.compactWSForVerticalAlignPatterns(model, partitions);
                            }
                            this.applyActions(partitions);
                            this.verticalAlignByRegEx(model, partitions);
                        }
                        this.verticalAlign(model, partitions);
                        this.applyActions(partitions);
                        if (formatPreferences.isVerticalAlignParenEnabled() || formatPreferences.isVerticalAlignCurlyEnabled()) {
                            this.verticalAlignByParen(model, partitions);
                            this.applyActions(partitions);
                        }
                    }
                    model = this.createModel(partitions, indentFirstLine, firstLineIndent);
                    this.indentStandaloneComments(model, partitions);
                    this.applyActions(partitions);
                    if (formatPreferences != null && formatPreferences.isTrimEndOfLineWSEnabled() && (formatPreferences.isBeginPrefNewLine() || formatPreferences.isBeginPrefNewLineAndIndent() || formatPreferences.isAddNewLineAfterBeginAndBeforeEnd() || formatPreferences.isAddNewLineAfterEnd() || formatPreferences.isElsePrefNewLine() || formatPreferences.isLineWrapEnabled() || formatPreferences.isParamsPrefNewLineOpenParenNextLine() || formatPreferences.isParamsPrefNewLineOpenParenSameLine())) {
                        model = this.createModel(partitions, indentFirstLine, firstLineIndent);
                        this.trimEndOfLineWhitespace(model, partitions);
                        this.applyActions(partitions);
                    }
                    if (!(!this.fIgnoreCase || formatPreferences == null || formatPreferences.isCapitalizationKeyworsLeaveAsIs() && formatPreferences.isCapitalizationDataTypesLeaveAsIs() && formatPreferences.isCapitalizationAttributesLeaveAsIs())) {
                        model = this.createModel(partitions, indentFirstLine, firstLineIndent);
                        this.capitalize(model, partitions);
                        this.applyActions(partitions);
                    }
                    if (CFUtils.getInstance().shouldUseTabs(this.fConfiguration, formatPreferences)) {
                        model = this.createModel(partitions, indentFirstLine, firstLineIndent);
                        this.indentUsingTabs(model, partitions);
                        this.applyActions(partitions);
                    }
                }
                long startTime = System.currentTimeMillis();
                long endTime = System.currentTimeMillis();
                String originalDocumentContent = this.fDocument.get();
                this.fFormatFailed = false;
                this.format(partitions);
                endTime = System.currentTimeMillis();
                CFSyso.println("PERFORMANCE", "format: " + (endTime - startTime) + " ms");
                startTime = endTime;
                if (typedPositions.length > 0) {
                    this.fFirstTypedPosition = typedPositions[0];
                }
                if (!DVTPreprocFormattingUtils.getInstance().isValidPVerilogDocument()) {
                    this.validateFormattingResult(originalDocumentContent, this.shouldSort(formatPreferences), languageKind);
                }
                this.formatterStops(typedPositions);
                CFSyso.println("PERFORMANCE", "TOTAL: " + (System.currentTimeMillis() - allStartTime) + " ms");
            }
        }
        catch (BadLocationException badLocationException) {}
        this.removePartitioningUpdater();
    }

    private void validateFormattingResult(String originalDocumentContent, boolean shouldSort, LanguageKind languageKind) {
        if (this.fConfiguration.isTesting() || this.fConfiguration.isPreview() || this.fFirstTypedPosition == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        CFSyso.println("FLOW", "DVTContentFormatter.CHECK");
        TRANSFORM_STATE initialState = this.getTransformInitialState(this.fFirstTypedPosition);
        String originalTransf = DVTContentFormatter.transform(initialState, originalDocumentContent, this.fSlashSLComment, this.fDashSLComment, this.fSlashMLComment, shouldSort, this.fIgnoreCase, languageKind, DVTPreprocFormattingUtils.getInstance().getOriginalPreprocMacros());
        CFSyso.println("TRANSFORM", "ORIGINAL TRANSFORM:");
        CFSyso.println("TRANSFORM", "'" + originalTransf + "'");
        long endTime = System.currentTimeMillis();
        CFSyso.println("PERFORMANCE", "transform Original: " + (endTime - startTime) + " ms");
        startTime = endTime;
        String formattedTransf = DVTContentFormatter.transform(initialState, this.fDocument.get(), this.fSlashSLComment, this.fDashSLComment, this.fSlashMLComment, shouldSort, this.fIgnoreCase, languageKind, DVTPreprocFormattingUtils.getInstance().getPreprocMacros());
        CFSyso.println("TRANSFORM", "FORMATTED TRANSFORM:");
        CFSyso.println("TRANSFORM", "'" + formattedTransf + "'");
        endTime = System.currentTimeMillis();
        CFSyso.println("PERFORMANCE", "transform Formatted: " + (endTime - startTime) + " ms");
        startTime = endTime;
        boolean noCodeLoss = originalTransf.equals(formattedTransf);
        endTime = System.currentTimeMillis();
        CFSyso.println("PERFORMANCE", "compare: " + (endTime - startTime) + " ms");
        startTime = endTime;
        if (!noCodeLoss) {
            this.fFormatFailed = true;
            if (!this.fDoNotShowFormatFailedPopup) {
                Utils.popFormatFailed("There was an error during formatting. The code has been reverted to its original value.");
            }
            this.fDocument.set(originalDocumentContent);
            IPositionUpdater[] positionUpdaters = this.fDocument.getPositionUpdaters();
            positionUpdaters[0].update(new DocumentEvent(this.fDocument, this.fCodeFormattingThreshold, this.fCodeFormattingThreshold, formattedTransf));
        }
    }

    private boolean shouldSort(CFPreferences formatPreferences) {
        if (formatPreferences == null) {
            return false;
        }
        if (formatPreferences.isLineWrapSLCommentsEnabled()) {
            return true;
        }
        return formatPreferences.isBeginPrefSameLine();
    }

    private TypedPosition[] getPartitioning(IRegion region) throws BadLocationException {
        this.fConfiguration.connectCFDocumentPartitioner(this.fDocument);
        ITypedRegion[] regions = TextUtilities.computePartitioning((IDocument)this.fDocument, (String)"__cf_partitioning", (int)region.getOffset(), (int)region.getLength(), (boolean)false);
        this.fConfiguration.disconnectCFDocumentPartitioner(this.fDocument);
        TypedPosition[] positions = new TypedPosition[regions.length];
        int i = 0;
        while (i < regions.length) {
            positions[i] = new TypedPosition(regions[i]);
            try {
                this.fDocument.addPosition(PARTITIONING, (Position)positions[i]);
            }
            catch (BadPositionCategoryException x) {
                DVTLogger.INSTANCE.logError((Throwable)x);
            }
            ++i;
        }
        return positions;
    }

    private void formatterStarts(TypedPosition[] typedPositions, String indentation) {
        HashSet<String> dbgTags = new HashSet<String>();
        dbgTags.addAll(DVT_CFSYSO_TAGS_SET);
        CFSyso.setTags(dbgTags);
        long startTime = System.currentTimeMillis();
        CFSyso.printlnIn("FLOW", "DVTContentFormatter.formatterStarts()", true);
        HashSet<IDVTFormattingStrategy> notifiedStrategies = new HashSet<IDVTFormattingStrategy>();
        TypedPosition[] typedPositionArray = typedPositions;
        int n = typedPositions.length;
        int n2 = 0;
        while (n2 < n) {
            IDVTFormattingStrategy strategy;
            TypedPosition typedPosition = typedPositionArray[n2];
            if (typedPosition != null && (strategy = this.getFormattingStrategy(typedPosition.getType())) != null && !notifiedStrategies.contains(strategy)) {
                strategy.formatterStarts(indentation);
                notifiedStrategies.add(strategy);
            }
            ++n2;
        }
        long endTime = System.currentTimeMillis();
        CFSyso.println("PERFORMANCE", "formatterStarts: " + (endTime - startTime) + " ms");
    }

    private void formatterStops(TypedPosition[] typedPositions) {
        long startTime = System.currentTimeMillis();
        CFSyso.printlnOut("FLOW", "DVTContentFormatter.formatterStops()");
        HashSet<IDVTFormattingStrategy> notifiedStrategies = new HashSet<IDVTFormattingStrategy>();
        TypedPosition[] typedPositionArray = typedPositions;
        int n = typedPositions.length;
        int n2 = 0;
        while (n2 < n) {
            IDVTFormattingStrategy strategy;
            TypedPosition typedPosition = typedPositionArray[n2];
            if (typedPosition != null && (strategy = this.getFormattingStrategy(typedPosition.getType())) != null && !notifiedStrategies.contains(strategy)) {
                strategy.formatterStops();
                notifiedStrategies.add(strategy);
            }
            ++n2;
        }
        long endTime = System.currentTimeMillis();
        CFSyso.println("PERFORMANCE", "formatterStops: " + (endTime - startTime) + " ms");
    }

    private CFPartition[] createPartitions(TypedPosition[] typedPositions) {
        long startTime = System.currentTimeMillis();
        CFSyso.println("FLOW", "DVTContentFormatter.createPartitions()");
        CFPartition[] partitions = new CFPartition[typedPositions.length];
        int i = 0;
        while (i < typedPositions.length) {
            IDVTFormattingStrategy strategy;
            TypedPosition typedPosition = typedPositions[i];
            if (typedPosition != null && (strategy = this.getFormattingStrategy(typedPosition.getType())) instanceof DVTBaseFormattingStrategy) {
                partitions[i] = this.createPartition((DVTBaseFormattingStrategy)strategy, typedPosition);
            }
            ++i;
        }
        long endTime = System.currentTimeMillis();
        CFSyso.println("PERFORMANCE", "createPartitions: " + (endTime - startTime) + " ms");
        return partitions;
    }

    private CFPartition createPartition(DVTBaseFormattingStrategy formattingStrategy, TypedPosition typedPosition) {
        try {
            int partitionOffset = typedPosition.getOffset();
            int partitionLength = typedPosition.getLength();
            String partitionContent = this.fDocument.get(partitionOffset, partitionLength);
            return new CFPartition(formattingStrategy, typedPosition, partitionContent);
        }
        catch (BadLocationException x) {
            DVTLogger.INSTANCE.logError((Throwable)x);
            return null;
        }
    }

    private CFModel createModel(CFPartition[] partitions, boolean indentFirstLine, int firstLineIndent) {
        if (partitions == null) {
            return null;
        }
        long startTime = System.currentTimeMillis();
        CFSyso.println("FLOW", "DVTContentFormatter.createModel()");
        CFModel model = this.createModel(indentFirstLine, firstLineIndent);
        int i = 0;
        while (i < partitions.length) {
            CFPartition partition = partitions[i];
            if (partition != null) {
                if (i == 0) {
                    model.setCurrentChunkOffsetInDocument(partition.getTypedPosition().getOffset());
                }
                partition.createChunks(model);
            }
            ++i;
        }
        long endTime = System.currentTimeMillis();
        CFSyso.println("PERFORMANCE", "createModel: " + (endTime - startTime) + " ms");
        return model;
    }

    protected CFModel createModel(boolean indentFirstLine, int firstLineIndent) {
        return new CFModel(this.fIgnoreCase, indentFirstLine, firstLineIndent);
    }

    private void replaceTabsWithSpaces(CFModel model, CFPartition[] partitions) {
        if (partitions == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        CFSyso.println("FLOW", "DVTContentFormatter.replaceTabsWithSpaces()");
        int currentOffset = 0;
        int i = 0;
        while (i < partitions.length) {
            CFPartition partition = partitions[i];
            if (partition != null) {
                currentOffset = partition.replaceTabsWithSpaces(currentOffset);
            }
            ++i;
        }
        long endTime = System.currentTimeMillis();
        CFSyso.println("PERFORMANCE", "replaceTabsWithSpaces: " + (endTime - startTime) + " ms");
    }

    private void trimEmptyLines(CFModel model, CFPartition[] partitions) {
        if (partitions == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        CFSyso.println("FLOW", "DVTContentFormatter.trimEmptyLines()");
        int i = 0;
        while (i < partitions.length) {
            CFPartition partition = partitions[i];
            if (partition != null) {
                partition.trimEmptyLines();
            }
            ++i;
        }
        long endTime = System.currentTimeMillis();
        CFSyso.println("PERFORMANCE", "trimEmptyLines: " + (endTime - startTime) + " ms");
        CFLineInfo lastLineInfo = model.getLastLineInfo();
        if (lastLineInfo == null) {
            return;
        }
        CFChunk lastChunk = lastLineInfo.getLastChunk();
        if (lastChunk == null) {
            return;
        }
        if (lastChunk.endsWithNL()) {
            return;
        }
        String trimmedChunksContent = lastLineInfo.getChunksContent().trim();
        if (!trimmedChunksContent.isEmpty()) {
            return;
        }
        int nofWS = lastLineInfo.getLineStartWSLength();
        if (nofWS != 0) {
            lastChunk.addAction(new CFAction(0, nofWS, "", "trim last no nl empty line"));
        }
    }

    private void trimEndOfLineWhitespace(CFModel model, CFPartition[] partitions) {
        if (partitions == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        CFSyso.println("FLOW", "DVTContentFormatter.trimEndOfLineWhitespace()");
        CFTokenScanner tokenScanner = new CFTokenScanner(model){

            @Override
            public void analyzeToken(CFToken token) {
                this.fStrategy.trimEndOfLineWhitespace(token);
            }
        };
        this.scanTokensInOrder(partitions, tokenScanner);
        long endTime = System.currentTimeMillis();
        CFSyso.println("PERFORMANCE", "trimEndOfLineWhitespace: " + (endTime - startTime) + " ms");
    }

    private void compactWhitespace(CFModel model, CFPartition[] partitions) {
        if (partitions == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        CFSyso.println("FLOW", "DVTContentFormatter.compactWhitespace()");
        CFTokenScanner tokenScanner = new CFTokenScanner(model){

            @Override
            public void analyzeToken(CFToken token) {
                this.fStrategy.compactWhitespace(token);
            }
        };
        this.scanTokensInOrder(partitions, tokenScanner);
        long endTime = System.currentTimeMillis();
        CFSyso.println("PERFORMANCE", "compactWhitespace: " + (endTime - startTime) + " ms");
    }

    private void compactWSForVerticalAlignPatterns(CFModel model, CFPartition[] partitions) {
        if (partitions == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        CFSyso.println("FLOW", "DVTContentFormatter.compactWSForVerticalAlignPatterns()");
        ICFVTokenScannerImpl vScanner = this.createVRegExScanner(model);
        if (vScanner != null) {
            this.scanTokensInOrder(partitions, vScanner);
        }
        long endTime = System.currentTimeMillis();
        CFSyso.println("PERFORMANCE", "compactWSForVerticalAlignPatterns: " + (endTime - startTime) + " ms");
    }

    private void compactConsecutiveEmptyLines(CFModel model, CFPartition[] partitions) {
        if (partitions == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        CFSyso.println("FLOW", "DVTContentFormatter.compactConsecutiveEmptyLines()");
        int i = 0;
        while (i < partitions.length) {
            CFPartition partition = partitions[i];
            if (partition != null) {
                if (i == partitions.length - 1) {
                    partition.compactConsecutiveEmptyLines(model, true);
                } else {
                    partition.compactConsecutiveEmptyLines(model, false);
                }
            }
            ++i;
        }
        long endTime = System.currentTimeMillis();
        CFSyso.println("PERFORMANCE", "compactConsecutiveEmptyLines: " + (endTime - startTime) + " ms");
    }

    private void addNLAfterToken(CFModel model, CFPartition[] partitions) {
        if (partitions == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        CFSyso.printlnIn("FLOW", "DVTContentFormatter.addNLAfterToken()");
        ICFIndentScannerImpl NLAfterTokenScanner = this.createNLAfterTokenScanner(model);
        if (NLAfterTokenScanner != null) {
            this.scanTokensInOrder(partitions, NLAfterTokenScanner);
        }
        CFSyso.printlnOut("FLOW", "DVTContentFormatter.addNLAfterToken()");
        long endTime = System.currentTimeMillis();
        CFSyso.println("PERFORMANCE", "addNLAfterToken: " + (endTime - startTime) + " ms");
    }

    protected ICFIndentScannerImpl createNLAfterTokenScanner(CFModel model) {
        return null;
    }

    private void beginIndentation(CFModel model, CFPartition[] partitions) {
        if (partitions == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        CFSyso.printlnIn("FLOW", "DVTContentFormatter.beginIndentation()");
        ICFTokenScanner NLAfterTokenScanner = this.createBeginIndentationTokenScanner(model);
        if (NLAfterTokenScanner != null) {
            this.scanTokensInOrder(partitions, NLAfterTokenScanner);
        }
        CFSyso.printlnOut("FLOW", "DVTContentFormatter.beginIndentation()");
        long endTime = System.currentTimeMillis();
        CFSyso.println("PERFORMANCE", "beginIndentation: " + (endTime - startTime) + " ms");
    }

    protected ICFTokenScanner createBeginIndentationTokenScanner(CFModel model) {
        return null;
    }

    private void removeNLBefore(CFModel model, CFPartition[] partitions, final Set<String> prefs) {
        if (partitions == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        CFSyso.println("FLOW", "DVTContentFormatter.removeNLBefore()");
        CFTokenScanner tokenScanner = new CFTokenScanner(model){
            List<CFRemoveNLBeforeInfo> adjustments;
            {
                super($anonymous0);
                this.adjustments = new ArrayList<CFRemoveNLBeforeInfo>();
            }

            @Override
            public void analyzeToken(CFToken token) {
                if (token == null) {
                    return;
                }
                CFChunk chunk = token.getEnclosingChunk();
                if (chunk == null) {
                    return;
                }
                if (3 != token.getTokenType()) {
                    if (1 == chunk.getType() && token.isFirstNWSTokenOnLine() && prefs.contains(token.getValue()) && !this.adjustments.isEmpty()) {
                        int i = 0;
                        while (i < this.adjustments.size()) {
                            this.adjustments.get((int)i).chunk.addAction(new CFAction(this.adjustments.get((int)i).offset, this.adjustments.get((int)i).delete, "", "remove nl before"));
                            ++i;
                        }
                        chunk.addAction(new CFAction(0, token.getStartOffsetInChunk(), " ", "remove nl before"));
                    }
                    this.adjustments.clear();
                } else if (1 == chunk.getType() && chunk.endsWithNL()) {
                    CFLineInfo lineInfo = chunk.getEnclosingLineInfo();
                    if (lineInfo == null) {
                        this.adjustments.clear();
                        return;
                    }
                    if (lineInfo.getNLOffsetInLine() >= token.getStartOffsetInLine() && lineInfo.getNLOffsetInLine() <= token.getEndOffsetInLine()) {
                        String chunkValue = chunk.getValue().trim();
                        if (!chunkValue.endsWith("\\")) {
                            this.adjustments.add(new CFRemoveNLBeforeInfo(chunk, token.getStartOffsetInChunk(), token.getValue().length()));
                        } else {
                            this.adjustments.clear();
                        }
                    } else {
                        this.adjustments.clear();
                    }
                } else {
                    this.adjustments.clear();
                }
            }
        };
        this.scanTokensInOrder(partitions, tokenScanner);
        long endTime = System.currentTimeMillis();
        CFSyso.println("PERFORMANCE", "removeNLBefore: " + (endTime - startTime) + " ms");
    }

    private void removeNLAfter(CFModel model, CFPartition[] partitions, final Set<String> prefs) {
        if (partitions == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        CFSyso.println("FLOW", "DVTContentFormatter.removeNLAfter()");
        CFTokenScanner tokenScanner = new CFTokenScanner(model){
            CFToken fAfterToken;

            @Override
            public void analyzeToken(CFToken token) {
                if (token == null) {
                    return;
                }
                CFChunk chunk = token.getEnclosingChunk();
                if (chunk == null) {
                    return;
                }
                if (!chunk.endsWithNL()) {
                    return;
                }
                CFLineInfo lineInfo = chunk.getEnclosingLineInfo();
                if (lineInfo == null) {
                    return;
                }
                if (token.getTokenType() == 3) {
                    int nofWSCharsToDelete;
                    if (this.fAfterToken != null && chunk.endsWithNL() && lineInfo.getNLOffsetInLine() >= token.getStartOffsetInLine() && lineInfo.getNLOffsetInLine() <= token.getEndOffsetInLine() && (nofWSCharsToDelete = token.getValue().length()) != 0) {
                        chunk.addAction(new CFAction(token.getStartOffsetInChunk(), nofWSCharsToDelete, "", "remove nl after"));
                    }
                } else if (1 != chunk.getType()) {
                    this.fAfterToken = null;
                } else {
                    String tokenValue = token.getValue();
                    if (prefs.contains(tokenValue)) {
                        this.fAfterToken = token;
                    } else {
                        if (this.fAfterToken != null && token.isFirstNWSTokenOnLine()) {
                            int nofWSCharsToDelete = token.getStartOffsetInLine();
                            chunk.addAction(new CFAction(0, nofWSCharsToDelete, " ", "remove nl after"));
                        }
                        this.fAfterToken = null;
                    }
                }
            }
        };
        this.scanTokensInOrder(partitions, tokenScanner);
        long endTime = System.currentTimeMillis();
        CFSyso.println("PERFORMANCE", "removeNLAfter: " + (endTime - startTime) + " ms");
    }

    private void addWhitespaceBefore(CFModel model, CFPartition[] partitions) {
        if (partitions == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        CFSyso.println("FLOW", "DVTContentFormatter.addWhitespaceBefore()");
        ICFTokenScanner addWSBeforeTokenScanner = this.createAddWhitespaceBeforeTokenScanner(model);
        if (addWSBeforeTokenScanner != null) {
            this.scanTokensInOrder(partitions, addWSBeforeTokenScanner);
        }
        long endTime = System.currentTimeMillis();
        CFSyso.println("PERFORMANCE", "addWhitespaceBefore: " + (endTime - startTime) + " ms");
    }

    protected ICFTokenScanner createAddWhitespaceBeforeTokenScanner(CFModel model) {
        return null;
    }

    private void addWhitespaceAfter(CFModel model, CFPartition[] partitions) {
        if (partitions == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        CFSyso.println("FLOW", "DVTContentFormatter.addWhitespaceAfter()");
        ICFTokenScanner addWSAfterTokenScanner = this.createAddWhitespaceAfterTokenScanner(model);
        if (addWSAfterTokenScanner != null) {
            this.scanTokensInOrder(partitions, addWSAfterTokenScanner);
        }
        long endTime = System.currentTimeMillis();
        CFSyso.println("PERFORMANCE", "addWhitespaceAfter: " + (endTime - startTime) + " ms");
    }

    protected ICFTokenScanner createAddWhitespaceAfterTokenScanner(CFModel model) {
        return null;
    }

    private void fixWhitespaceAfterCodeMarkerInExpansion(CFModel model, CFPartition[] partitions) {
        if (partitions == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        CFSyso.println("FLOW", "DVTContentFormatter.fixWhitespaceAfterCodeMarkerInExpansion()");
        CFTokenScanner tokenScanner = new CFTokenScanner(model){

            @Override
            public void analyzeToken(CFToken token) {
                this.fStrategy.fixWhitespaceAfterCodeMarkerInExpansion(token);
            }
        };
        this.scanTokensInOrder(partitions, tokenScanner);
        long endTime = System.currentTimeMillis();
        CFSyso.println("PERFORMANCE", "fixWhitespaceAfterCodeMarkerInExpansion: " + (endTime - startTime) + " ms");
    }

    private void indent(CFModel model, CFPartition[] partitions) {
        if (partitions == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        CFSyso.printlnIn("FLOW", "DVTContentFormatter.indent()");
        ICFIndentScannerImpl indentScanner = this.createIndentScanner(model);
        if (indentScanner != null) {
            this.scanTokensInOrder(partitions, indentScanner);
        }
        CFSyso.printlnOut("FLOW", "DVTContentFormatter.indent()");
        long endTime = System.currentTimeMillis();
        CFSyso.println("PERFORMANCE", "indent: " + (endTime - startTime) + " ms");
    }

    protected ICFIndentScannerImpl createIndentScanner(CFModel model) {
        return null;
    }

    private void indentStandaloneComments(CFModel model, CFPartition[] partitions) {
        if (partitions == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        CFSyso.printlnIn("FLOW", "DVTContentFormatter.indentStandaloneComments()");
        ICFTokenScanner preprocScanner = this.createPreprocScanner(model);
        if (preprocScanner != null) {
            this.scanTokensInOrder(partitions, preprocScanner);
        }
        int i = partitions.length - 1;
        while (i >= 0) {
            CFPartition partition = partitions[i];
            if (partition != null) {
                partition.indentStandaloneComments(model);
            }
            --i;
        }
        CFSyso.printlnOut("FLOW", "DVTContentFormatter.indentStandaloneComments()");
        long endTime = System.currentTimeMillis();
        CFSyso.println("PERFORMANCE", "indentStandaloneComments: " + (endTime - startTime) + " ms");
    }

    protected ICFTokenScanner createPreprocScanner(CFModel model) {
        return null;
    }

    private void verticalAlignByParen(CFModel model, CFPartition[] partitions) {
        if (partitions == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        CFSyso.printlnIn("FLOW", "DVTContentFormatter.verticalAlignByParen()");
        ICFVParenTokenScannerImpl vScanner = this.createVParenScanner(model);
        if (vScanner != null) {
            this.scanTokensInOrder(partitions, vScanner);
        }
        CFSyso.printlnOut("FLOW", "DVTContentFormatter.verticalAlignByParen()");
        long endTime = System.currentTimeMillis();
        CFSyso.println("PERFORMANCE", "verticalAlignByParen: " + (endTime - startTime) + " ms");
    }

    protected ICFVParenTokenScannerImpl createVParenScanner(CFModel model) {
        return null;
    }

    private void verticalAlign(CFModel model, CFPartition[] partitions) {
        if (partitions == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        CFSyso.printlnIn("FLOW", "DVTContentFormatter.verticalAlign()");
        ICFVTokenScannerImpl vScanner = this.createVScanner(model);
        if (vScanner != null) {
            this.scanTokensInOrder(partitions, vScanner);
            vScanner.verticalAlign();
        }
        CFSyso.printlnOut("FLOW", "DVTContentFormatter.verticalAlign()");
        long endTime = System.currentTimeMillis();
        CFSyso.println("PERFORMANCE", "verticalAlign: " + (endTime - startTime) + " ms");
    }

    protected ICFVTokenScannerImpl createVScanner(CFModel model) {
        return null;
    }

    private void verticalAlignByRegEx(CFModel model, CFPartition[] partitions) {
        if (partitions == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        CFSyso.printlnIn("FLOW", "DVTContentFormatter.verticalAlignByRegEx()");
        ICFVTokenScannerImpl vScanner = this.createVRegExScanner(model);
        this.resetVerticalAlignPatternsState();
        if (vScanner != null) {
            this.scanTokensInOrder(partitions, vScanner);
            vScanner.verticalAlign();
        }
        CFSyso.printlnOut("FLOW", "DVTContentFormatter.verticalAlignByRegEx()");
        long endTime = System.currentTimeMillis();
        CFSyso.println("PERFORMANCE", "verticalAlignByRegEx: " + (endTime - startTime) + " ms");
    }

    protected ICFVTokenScannerImpl createVRegExScanner(CFModel model) {
        return null;
    }

    private void resetVerticalAlignPatternsState() {
        if (this.fConfiguration == null) {
            return;
        }
        DVTBaseCodeFormattingStrategy strategy = this.fConfiguration.getCodeFormattingStrategy();
        if (strategy == null) {
            return;
        }
        List<CFVRegExBaseDefinition> vRegExDefs = strategy.getEnabledVRegExPref();
        if (vRegExDefs == null) {
            return;
        }
        for (CFVRegExBaseDefinition vRegExDef : vRegExDefs) {
            if (vRegExDef == null) continue;
            vRegExDef.resetState();
        }
    }

    private void indentUsingTabs(CFModel model, CFPartition[] partitions) {
        if (partitions == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        CFSyso.println("FLOW", "DVTContentFormatter.indentUsingTabs()");
        ICFTokenScanner tokenScanner = this.createIndentUsingTabsScanner(model);
        this.scanTokensInOrder(partitions, tokenScanner);
        long endTime = System.currentTimeMillis();
        CFSyso.println("PERFORMANCE", "indentUsingTabs: " + (endTime - startTime) + " ms");
    }

    protected ICFTokenScanner createIndentUsingTabsScanner(CFModel model) {
        return null;
    }

    private void capitalize(CFModel model, CFPartition[] partitions) {
        if (partitions == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        CFSyso.println("FLOW", "DVTContentFormatter.capitalize()");
        ICFTokenScanner tokenScanner = this.createCapitalizeScanner(model);
        if (tokenScanner != null) {
            this.scanTokensInOrder(partitions, tokenScanner);
        }
        long endTime = System.currentTimeMillis();
        CFSyso.println("PERFORMANCE", "capitalize: " + (endTime - startTime) + " ms");
    }

    protected ICFTokenScanner createCapitalizeScanner(CFModel model) {
        return null;
    }

    private void scanTokensInOrder(CFPartition[] partitions, ICFTokenScanner tokenScanner) {
        if (partitions == null) {
            return;
        }
        CFPartition[] cFPartitionArray = partitions;
        int n = partitions.length;
        int n2 = 0;
        while (n2 < n) {
            CFPartition partition = cFPartitionArray[n2];
            if (partition != null) {
                partition.scanTokensInOrder(tokenScanner);
            }
            ++n2;
        }
    }

    private void applyActions(CFPartition[] partitions) {
        if (partitions == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        CFSyso.println("FLOW", "DVTContentFormatter.applyActions()");
        int i = partitions.length - 1;
        while (i >= 0) {
            CFPartition partition = partitions[i];
            if (partition != null) {
                partition.applyFormattingActions(this.fAffectedPositionReferences);
            }
            --i;
        }
        if (this.fAffectedPositionReferences != null) {
            for (CFPositionReference pr : this.fAffectedPositionReferences) {
                pr.fNewOffset += pr.fNewOffsetDelta;
                pr.fNewLength += pr.fNewLengthDelta;
                pr.fNewOffsetDelta = 0;
                pr.fNewLengthDelta = 0;
            }
        }
        long endTime = System.currentTimeMillis();
        CFSyso.println("PERFORMANCE", "applyActions: " + (endTime - startTime) + " ms");
    }

    private void format(CFPartition[] partitions) {
        if (partitions == null) {
            return;
        }
        CFSyso.println("FLOW", "DVTContentFormatter.format()");
        this.fPerformanceDurationGetOriginalContent = 0L;
        this.fPerformanceDurationGetFormattedContent = 0L;
        this.fPerformanceDurationEquals = 0L;
        this.fPerformanceDurationReplace = 0L;
        this.fPerformanceNofOperationsReplace = 0L;
        ArrayList<CFPartition> formattedPartitions = new ArrayList<CFPartition>();
        ArrayList<String> formattedContentInPartitions = new ArrayList<String>();
        CFPartition[] cFPartitionArray = partitions;
        int n = partitions.length;
        int n2 = 0;
        while (n2 < n) {
            CFPartition partition = cFPartitionArray[n2];
            if (partition != null) {
                try {
                    int offset = partition.getTypedPosition().getOffset();
                    int length = partition.getTypedPosition().getLength();
                    long timestamp = System.currentTimeMillis();
                    String originalContent = this.fDocument.get(offset, length);
                    this.fPerformanceDurationGetOriginalContent += System.currentTimeMillis() - timestamp;
                    timestamp = System.currentTimeMillis();
                    String formattedContent = partition.getContent();
                    this.fPerformanceDurationGetFormattedContent += System.currentTimeMillis() - timestamp;
                    timestamp = System.currentTimeMillis();
                    if (formattedContent != null && !formattedContent.equals(originalContent)) {
                        formattedPartitions.add(partition);
                        formattedContentInPartitions.add(formattedContent);
                    }
                    this.fPerformanceDurationEquals += System.currentTimeMillis() - timestamp;
                }
                catch (BadLocationException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
            ++n2;
        }
        boolean isFirst = false;
        boolean isLast = false;
        if (!formattedPartitions.isEmpty()) {
            int i = formattedPartitions.size() - 1;
            while (i >= 0) {
                isFirst = i == formattedPartitions.size() - 1;
                isLast = i == 0;
                CFPartition partition = (CFPartition)formattedPartitions.get(i);
                String formattedContent = (String)formattedContentInPartitions.get(i);
                this.format(partition, formattedContent, isFirst, isLast);
                --i;
            }
        }
        CFSyso.println("PERFORMANCE", "format-getOriginalContent: " + this.fPerformanceDurationGetOriginalContent + " ms");
        CFSyso.println("PERFORMANCE", "format-getFormattedContent: " + this.fPerformanceDurationGetFormattedContent + " ms");
        CFSyso.println("PERFORMANCE", "format-equals: " + this.fPerformanceDurationEquals + " ms");
        CFSyso.println("PERFORMANCE", "format-replace: " + this.fPerformanceDurationReplace + " ms");
        CFSyso.println("PERFORMANCE", "format-replace: " + this.fPerformanceNofOperationsReplace + " ops");
    }

    private void format(CFPartition partition, String formattedContent, boolean isFirst, boolean isLast) {
        try {
            int offset = partition.getTypedPosition().getOffset();
            int length = partition.getTypedPosition().getLength();
            RemoveAffectedPositions firstPU = null;
            if (isFirst) {
                firstPU = new RemoveAffectedPositions();
                this.fDocument.insertPositionUpdater((IPositionUpdater)firstPU, 0);
            }
            UpdateAffectedPositions lastPU = null;
            if (isLast) {
                lastPU = new UpdateAffectedPositions();
                this.fDocument.addPositionUpdater((IPositionUpdater)lastPU);
            }
            long timestamp = System.currentTimeMillis();
            ++this.fPerformanceNofOperationsReplace;
            this.fDocument.replace(offset, length, formattedContent);
            this.fPerformanceDurationReplace += System.currentTimeMillis() - timestamp;
            if (firstPU != null) {
                this.fDocument.removePositionUpdater((IPositionUpdater)firstPU);
            }
            if (lastPU != null) {
                this.fDocument.removePositionUpdater((IPositionUpdater)lastPU);
            }
        }
        catch (BadLocationException x) {
            DVTLogger.INSTANCE.logError((Throwable)x);
        }
    }

    protected TRANSFORM_STATE getTransformInitialState(TypedPosition firstTypedPosition) {
        if (!this.fSlashMLComment) {
            return TRANSFORM_STATE.ML_COMMENT;
        }
        return TRANSFORM_STATE.CODE;
    }

    private static void addTransformToken(TRANSFORM_STATE state, String token, boolean ignoreCase) {
        if (ignoreCase) {
            fTransformTokens.add(token.toLowerCase());
        } else {
            fTransformTokens.add(token);
        }
    }

    public static String transform(TRANSFORM_STATE initialState, String value, boolean slashSLComment, boolean dashSLComment, boolean slashMLComment, boolean sort, LanguageKind languageKind) {
        return DVTContentFormatter.transform(initialState, value, slashSLComment, dashSLComment, slashMLComment, sort, false, languageKind);
    }

    public static String transform(TRANSFORM_STATE initialState, String value, boolean slashSLComment, boolean dashSLComment, boolean slashMLComment, boolean sort, boolean ignoreCase, LanguageKind languageKind) {
        return DVTContentFormatter.transform(initialState, value, slashSLComment, dashSLComment, slashMLComment, sort, ignoreCase, languageKind, null);
    }

    public static String transform(TRANSFORM_STATE initialState, String value, boolean slashSLComment, boolean dashSLComment, boolean slashMLComment, boolean sort, boolean ignoreCase, LanguageKind languageKind, List<PreprocDiffManager.PreprocMacro> preprocMacros) {
        value = value.replaceAll("[^\\p{ASCII}]", "");
        TRANSFORM_STATE state = initialState;
        if (state == null) {
            state = !slashMLComment ? TRANSFORM_STATE.ML_COMMENT : TRANSFORM_STATE.CODE;
        }
        boolean tripleDoubleQuotedLiteral = LanguageKind.PSS == languageKind;
        StringBuilder currWordToken = null;
        StringBuilder currStringToken = null;
        StringBuilder currEscapedIdToken = null;
        boolean backslash = false;
        boolean inChar = false;
        boolean continueToNL = false;
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            int preprocRegionLength = DVTPreprocFormattingUtils.getInstance().getPreprocRegionLengthFromOffset(i, preprocMacros);
            if (preprocRegionLength > 0) {
                DVTContentFormatter.addTransformToken(TRANSFORM_STATE.STRING, value.substring(i, i + preprocRegionLength), ignoreCase);
                i += preprocRegionLength - 1;
            } else {
                switch (state) {
                    case CODE: {
                        if (slashSLComment && '/' == c && i + 1 < value.length() && '/' == value.charAt(i + 1)) {
                            ++i;
                            if (currWordToken != null) {
                                DVTContentFormatter.addTransformToken(state, currWordToken.toString(), ignoreCase);
                                currWordToken = null;
                            }
                            state = TRANSFORM_STATE.SL_COMMENT;
                            break;
                        }
                        if (dashSLComment && '-' == c && i + 1 < value.length() && '-' == value.charAt(i + 1)) {
                            ++i;
                            if (currWordToken != null) {
                                DVTContentFormatter.addTransformToken(state, currWordToken.toString(), ignoreCase);
                                currWordToken = null;
                            }
                            state = TRANSFORM_STATE.SL_COMMENT;
                            break;
                        }
                        if (slashMLComment && '/' == c && i + 1 < value.length() && '*' == value.charAt(i + 1)) {
                            ++i;
                            if (currWordToken != null) {
                                DVTContentFormatter.addTransformToken(state, currWordToken.toString(), ignoreCase);
                                currWordToken = null;
                            }
                            state = TRANSFORM_STATE.ML_COMMENT;
                            break;
                        }
                        if (!slashMLComment && '\n' == c && i + 1 < value.length() && '\'' == value.charAt(i + 1) && i + 2 < value.length() && '>' == value.charAt(i + 2)) {
                            i += 2;
                            if (currWordToken != null) {
                                DVTContentFormatter.addTransformToken(state, currWordToken.toString(), ignoreCase);
                                currWordToken = null;
                            }
                            state = TRANSFORM_STATE.ML_COMMENT;
                            break;
                        }
                        if ('\\' == c) {
                            if (currWordToken != null) {
                                DVTContentFormatter.addTransformToken(state, currWordToken.toString(), ignoreCase);
                                currWordToken = null;
                            }
                            currEscapedIdToken = new StringBuilder();
                            currEscapedIdToken.append('\\');
                            state = TRANSFORM_STATE.ESCAPED_ID;
                            break;
                        }
                        if ('\"' == c && !backslash && !inChar) {
                            if (currWordToken != null) {
                                DVTContentFormatter.addTransformToken(state, currWordToken.toString(), ignoreCase);
                                currWordToken = null;
                            }
                            currStringToken = new StringBuilder();
                            currStringToken.append('\"');
                            state = TRANSFORM_STATE.STRING;
                            if (!tripleDoubleQuotedLiteral || i + 2 >= value.length() || value.charAt(i + 1) != '\"' || value.charAt(i + 2) != '\"') break;
                            i += 2;
                            state = TRANSFORM_STATE.TRIPLE_STRING;
                            break;
                        }
                        if (Character.isWhitespace(c)) {
                            if (currWordToken == null) break;
                            DVTContentFormatter.addTransformToken(state, currWordToken.toString(), ignoreCase);
                            currWordToken = null;
                            break;
                        }
                        if (Character.isJavaIdentifierPart(c)) {
                            if (currWordToken == null) {
                                currWordToken = new StringBuilder();
                            }
                            currWordToken.append(c);
                            break;
                        }
                        if (currWordToken != null) {
                            DVTContentFormatter.addTransformToken(state, currWordToken.toString(), ignoreCase);
                            currWordToken = null;
                        }
                        DVTContentFormatter.addTransformToken(state, "" + c, ignoreCase);
                        break;
                    }
                    case SL_COMMENT: {
                        if ('\r' == c || '\n' == c) {
                            if (currWordToken != null) {
                                DVTContentFormatter.addTransformToken(state, currWordToken.toString(), ignoreCase);
                                currWordToken = null;
                            }
                            state = TRANSFORM_STATE.CODE;
                            break;
                        }
                        if (Character.isWhitespace(c)) {
                            if (currWordToken == null) break;
                            DVTContentFormatter.addTransformToken(state, currWordToken.toString(), ignoreCase);
                            currWordToken = null;
                            break;
                        }
                        if (Character.isJavaIdentifierPart(c)) {
                            if (currWordToken == null) {
                                currWordToken = new StringBuilder();
                            }
                            currWordToken.append(c);
                            break;
                        }
                        if (currWordToken != null) {
                            DVTContentFormatter.addTransformToken(state, currWordToken.toString(), ignoreCase);
                            currWordToken = null;
                        }
                        DVTContentFormatter.addTransformToken(state, "" + c, ignoreCase);
                        break;
                    }
                    case ML_COMMENT: {
                        if (slashMLComment && '*' == c && i + 1 < value.length() && '/' == value.charAt(i + 1)) {
                            ++i;
                            if (currWordToken != null) {
                                DVTContentFormatter.addTransformToken(state, currWordToken.toString(), ignoreCase);
                                currWordToken = null;
                            }
                            state = TRANSFORM_STATE.CODE;
                            break;
                        }
                        if (!slashMLComment && ('\n' == c && i + 1 < value.length() && '<' == value.charAt(i + 1) && i + 2 < value.length() && '\'' == value.charAt(i + 2) || i == 0 && i < value.length() && '<' == value.charAt(i) && i + 1 < value.length() && '\'' == value.charAt(i + 1))) {
                            i = '\n' == c ? (i += 2) : ++i;
                            if (currWordToken != null) {
                                DVTContentFormatter.addTransformToken(state, currWordToken.toString(), ignoreCase);
                                currWordToken = null;
                            }
                            state = TRANSFORM_STATE.CODE;
                            break;
                        }
                        if (Character.isWhitespace(c)) {
                            if (currWordToken == null) break;
                            DVTContentFormatter.addTransformToken(state, currWordToken.toString(), ignoreCase);
                            currWordToken = null;
                            break;
                        }
                        if (Character.isJavaIdentifierPart(c)) {
                            if (currWordToken == null) {
                                currWordToken = new StringBuilder();
                            }
                            currWordToken.append(c);
                            break;
                        }
                        if (currWordToken != null) {
                            DVTContentFormatter.addTransformToken(state, currWordToken.toString(), ignoreCase);
                            currWordToken = null;
                        }
                        DVTContentFormatter.addTransformToken(state, "" + c, ignoreCase);
                        break;
                    }
                    case ESCAPED_ID: {
                        if (Character.isWhitespace(c) || languageKind == LanguageKind.VHDL && '\\' == c) {
                            if (currEscapedIdToken != null) {
                                DVTContentFormatter.addTransformToken(state, currEscapedIdToken.toString(), ignoreCase);
                                currEscapedIdToken = null;
                            }
                            state = TRANSFORM_STATE.CODE;
                            break;
                        }
                        if (currEscapedIdToken == null) break;
                        currEscapedIdToken.append(c);
                        break;
                    }
                    case STRING: {
                        if ('\"' == c && !backslash) {
                            if (currStringToken != null) {
                                DVTContentFormatter.addTransformToken(state, currStringToken.toString(), ignoreCase);
                                currStringToken = null;
                            }
                            state = TRANSFORM_STATE.CODE;
                            break;
                        }
                        if (currStringToken == null) break;
                        if (continueToNL && c == '\n' || c == '\r') {
                            continueToNL = false;
                            currStringToken.append(c);
                            break;
                        }
                        if (backslash && Character.isWhitespace(c) && c != '\n' && c != '\r' || continueToNL) {
                            continueToNL = true;
                            break;
                        }
                        currStringToken.append(c);
                        break;
                    }
                    case TRIPLE_STRING: {
                        if ('\"' == c && !backslash && i + 2 < value.length() && value.charAt(i + 1) == '\"' && value.charAt(i + 2) == '\"') {
                            if (currStringToken != null) {
                                DVTContentFormatter.addTransformToken(state, currStringToken.toString(), ignoreCase);
                                currStringToken = null;
                            }
                            i += 2;
                            state = TRANSFORM_STATE.CODE;
                            break;
                        }
                        if (currStringToken == null) break;
                        currStringToken.append(c);
                    }
                }
                boolean bl = c == '\\' ? !backslash : (backslash = false);
                if (state == TRANSFORM_STATE.CODE && c == '\'') {
                    if (!inChar) {
                        if (i + 2 < value.length() && '\'' == value.charAt(i + 2)) {
                            inChar = true;
                        }
                    } else {
                        inChar = false;
                    }
                }
            }
            ++i;
        }
        if (currWordToken != null) {
            DVTContentFormatter.addTransformToken(state, currWordToken.toString(), ignoreCase);
            currWordToken = null;
        }
        if (currEscapedIdToken != null) {
            DVTContentFormatter.addTransformToken(state, currEscapedIdToken.toString(), ignoreCase);
            currEscapedIdToken = null;
        }
        if (currStringToken != null) {
            DVTContentFormatter.addTransformToken(state, currStringToken.toString(), ignoreCase);
            currStringToken = null;
        }
        if (sort) {
            Collections.sort(fTransformTokens);
        }
        StringBuilder result = new StringBuilder();
        for (String token : fTransformTokens) {
            result.append(token);
        }
        fTransformTokens = new ArrayList<String>();
        return result.toString();
    }

    private void addPartitioningUpdater() {
        this.fPartitioningUpdater = new NonDeletingPositionUpdater(PARTITIONING);
        this.fDocument.addPositionCategory(PARTITIONING);
        this.fDocument.addPositionUpdater(this.fPartitioningUpdater);
    }

    private void removePartitioningUpdater() {
        try {
            this.fDocument.removePositionUpdater(this.fPartitioningUpdater);
            this.fDocument.removePositionCategory(PARTITIONING);
            this.fPartitioningUpdater = null;
        }
        catch (BadPositionCategoryException x) {
            DVTLogger.INSTANCE.logError((Throwable)x);
        }
    }

    @Deprecated
    public void setPartitionManagingPositionCategories(String[] categories) {
        this.fExternalPartitonManagingCategories = TextUtilities.copy((String[])categories);
    }

    private String[] getPartitionManagingCategories() {
        if (this.fNeedsComputation) {
            this.fNeedsComputation = false;
            this.fPartitionManagingCategories = TextUtilities.computePartitionManagingCategories((IDocument)this.fDocument);
            if (this.fPartitionManagingCategories == null) {
                this.fPartitionManagingCategories = this.fExternalPartitonManagingCategories;
            }
        }
        return this.fPartitionManagingCategories;
    }

    private boolean ignoreCategory(String category) {
        if (PARTITIONING.equals(category)) {
            return true;
        }
        if ("__dvt_folding_position".equals(category)) {
            return true;
        }
        if (category.startsWith("__fragmentsCategory")) {
            return true;
        }
        String[] categories = this.getPartitionManagingCategories();
        if (categories != null) {
            int i = 0;
            while (i < categories.length) {
                if (categories[i].equals(category)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private List<CFPositionReference> getAffectedPositionReferences() {
        ArrayList<CFPositionReference> result = new ArrayList<CFPositionReference>();
        String[] categories = this.fDocument.getPositionCategories();
        if (categories != null) {
            int i = 0;
            while (i < categories.length) {
                if (!this.ignoreCategory(categories[i])) {
                    try {
                        Position[] positions = this.fDocument.getPositions(categories[i]);
                        int j = 0;
                        while (j < positions.length) {
                            Position p = positions[j];
                            result.add(new CFPositionReference(p, categories[i]));
                            ++j;
                        }
                    }
                    catch (BadPositionCategoryException x) {
                        DVTLogger.INSTANCE.logError((Throwable)x);
                    }
                }
                ++i;
            }
        }
        return result;
    }

    private void removeAffectedPositions(IDocument document) {
        long timestamp = System.currentTimeMillis();
        for (CFPositionReference r : this.fAffectedPositionReferences) {
            try {
                document.removePosition(r.getCategory(), r.getPosition());
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
        }
        CFSyso.println("PERFORMANCE", "removeAffectedPositions: " + (System.currentTimeMillis() - timestamp) + " ms");
    }

    protected void updateAffectedPositions(IDocument document) {
        if (document != this.fDocument) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        for (CFPositionReference r : this.fAffectedPositionReferences) {
            Position p = r.getPosition();
            String category = r.getCategory();
            p.setOffset(Math.max(0, r.fNewOffset));
            p.setLength(Math.max(0, r.fNewLength));
            if (document.containsPosition(category, p.offset, p.length)) continue;
            try {
                if (!this.positionAboutToBeAdded(document, category, p)) continue;
                document.addPosition(category, p);
            }
            catch (BadPositionCategoryException x) {
                DVTLogger.INSTANCE.logError((Throwable)x);
            }
            catch (BadLocationException x) {
                DVTLogger.INSTANCE.logError((Throwable)x);
            }
        }
        CFSyso.println("PERFORMANCE", "updateAffectedPositions: " + (System.currentTimeMillis() - timestamp) + " ms");
    }

    private boolean positionAboutToBeAdded(IDocument document, String category, Position position) {
        return position.offset >= 0 && position.length >= 0 && position.offset + position.length <= document.getLength();
    }

    private String getLineStartWSChars(int offset) {
        try {
            int start = this.fDocument.getLineOfOffset(offset);
            int end = start = this.fDocument.getLineOffset(start);
            char c = this.fDocument.getChar(end);
            while ('\t' == c || ' ' == c) {
                c = this.fDocument.getChar(++end);
            }
            return this.fDocument.get(start, end - start);
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    public boolean isFormatFailed() {
        return this.fFormatFailed;
    }

    public void setDoNotShowFormatFailedPopup(boolean doNotShowPopup) {
        this.fDoNotShowFormatFailedPopup = doNotShowPopup;
    }

    public void setFormatFromEditor() {
        this.fFormatFromEditor = true;
    }

    private void addThresholdPreferenceChangeListener() {
        this.fFormatterMaxLinesPreferenceListener = new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                if (!"disable.codeformatting".equals(event.getKey())) {
                    return;
                }
                DVTContentFormatter.this.fCodeFormattingThreshold = PrefConst.getCodeFormattingMaxLines();
            }
        };
        DVTPlugin.getDefault().getPreferences().addPreferenceChangeListener(this.fFormatterMaxLinesPreferenceListener);
        this.setContentFormatterMaxLines(PrefConst.getCodeFormattingMaxLines());
    }

    public void setContentFormatterMaxLines(int formattingMaxLines) {
        this.fCodeFormattingThreshold = formattingMaxLines;
    }

    public void dispose() {
        if (this.fFormatterMaxLinesPreferenceListener != null) {
            DVTPlugin.getDefault().getPreferences().removePreferenceChangeListener(this.fFormatterMaxLinesPreferenceListener);
        }
    }

    static class CFRemoveNLBeforeInfo {
        CFChunk chunk;
        int offset;
        int delete;

        public CFRemoveNLBeforeInfo(CFChunk chunk, int offset, int delete) {
            this.chunk = chunk;
            this.offset = offset;
            this.delete = delete;
        }
    }

    static class NonDeletingPositionUpdater
    extends DefaultPositionUpdater {
        protected NonDeletingPositionUpdater(String category) {
            super(category);
        }

        protected boolean notDeleted() {
            return true;
        }
    }

    class RemoveAffectedPositions
    implements IPositionUpdater {
        RemoveAffectedPositions() {
        }

        public void update(DocumentEvent event) {
            DVTContentFormatter.this.removeAffectedPositions(event.getDocument());
        }
    }

    public static enum TRANSFORM_STATE {
        CODE,
        SL_COMMENT,
        ML_COMMENT,
        ESCAPED_ID,
        STRING,
        TRIPLE_STRING;

    }

    class UpdateAffectedPositions
    implements IPositionUpdater {
        public void update(DocumentEvent event) {
            DVTContentFormatter.this.updateAffectedPositions(event.getDocument());
        }
    }
}

