/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.formatter;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.core.DVTNature;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.resources.properties.PropertiesManager;
import ro.amiq.dvt.resources.properties.PropertyTypes;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.formatter.DVTContentFormatter;
import ro.amiq.dvt.ui.editor.formatter.FileListDialog;
import ro.amiq.dvt.ui.editor.formatter.MultipleFilesFormatTestHelper;
import ro.amiq.dvt.ui.editor.textchanges.DVTFileModificationValidator;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.TextFileBufferInfo;

public class DVTMultipleFilesFormatter {
    public static final String FORMAT_MULTIPLE_FILES = "Format Multiple Files";

    public static void formatResources(final List<IResource> roots, final boolean isTesting) {
        ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(DVTUiUtils.getActiveWorkbenchShell());
        try {
            progressDialog.run(false, true, (IRunnableWithProgress)new WorkspaceModifyOperation(){

                protected void execute(final IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    final HashMap filesToFormat = new HashMap();
                    final HashSet<IFile> dirtyFiles = new HashSet<IFile>();
                    HashSet<IFile> problematicFiles = new HashSet<IFile>();
                    final ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
                    if (roots == null || roots.isEmpty()) {
                        this.showNoFilesPopUp();
                        return;
                    }
                    MessageConsole formatFilesConsole = DVTMultipleFilesFormatter.getFormatFilesConsole(false);
                    if (formatFilesConsole != null) {
                        formatFilesConsole.clearConsole();
                    }
                    for (IResource root : roots) {
                        if (!(root instanceof IContainer) && !(root instanceof IFile)) {
                            return;
                        }
                        IResourceVisitor visitor = new IResourceVisitor(){

                            public boolean visit(IResource resource) throws CoreException {
                                LocationKind locationKind;
                                TextFileBufferInfo bufferedManagerInfo;
                                IPath path;
                                ITextFileBuffer textFileBuffer;
                                if (monitor.isCanceled()) {
                                    return false;
                                }
                                if (!(resource instanceof IFile)) {
                                    return true;
                                }
                                IFile file = (IFile)resource;
                                if (this.isFileCollected(file) && (textFileBuffer = bufferManager.getTextFileBuffer(path = (bufferedManagerInfo = DVTFileUtils.getInstance().getTextFileBufferInfo(file)).getPath(), locationKind = bufferedManagerInfo.getLocationKind())) != null && textFileBuffer.isDirty()) {
                                    dirtyFiles.add(file);
                                }
                                return true;
                            }

                            private boolean isFileCollected(IFile file) {
                                if (file.getLocation() == null || !file.isAccessible()) {
                                    return false;
                                }
                                IProject project = file.getProject();
                                if (project == null) {
                                    return false;
                                }
                                String editorIdOrLanguageSyntax = PropertiesManager.getSessionProperty((IResource)file, PropertyTypes.QN_IMPORTED_FILE);
                                IBuildConfigParserConstants.LanguageSyntax languageSyntax = IBuildConfigParserConstants.LanguageSyntax.from(editorIdOrLanguageSyntax);
                                String editorId = "";
                                if (languageSyntax == null) {
                                    editorId = editorIdOrLanguageSyntax;
                                } else if (IBuildConfigParserConstants.LanguageSyntax.VERILOG_AMS_23 == languageSyntax || IBuildConfigParserConstants.LanguageSyntax.SYSTEMVERILOG_AMS == languageSyntax) {
                                    editorId = "ro.amiq.vlogdt.ui.editor.VlogAmsEditor";
                                } else if (languageSyntax.languageKind == LanguageKind.VLOG) {
                                    editorId = "ro.amiq.vlogdt.ui.editor.VlogEditor";
                                } else if (languageSyntax.languageKind == LanguageKind.VHDL) {
                                    editorId = "ro.amiq.vhdldt.ui.editor.VhdlEditor";
                                }
                                String fileNature = this.getFileNatureForEditorId(editorId);
                                if (fileNature != null && DVTNature.hasNature(project, fileNature)) {
                                    filesToFormat.put(file, editorId);
                                    return true;
                                }
                                String editorIdBasedOnExtension = DVTFileUtils.getInstance().getEditorIDForFile(file);
                                fileNature = this.getFileNatureForEditorId(editorIdBasedOnExtension);
                                if (fileNature != null && DVTNature.hasNature(project, fileNature)) {
                                    filesToFormat.put(file, editorIdBasedOnExtension);
                                    return true;
                                }
                                return false;
                            }
                        };
                        String sectionText = "Start formatting multiple files";
                        if (root.getType() == 4) {
                            sectionText = String.valueOf(sectionText) + " from '" + root.getName() + "' project";
                        } else if (root.getType() == 2) {
                            sectionText = String.valueOf(sectionText) + " from '" + root.getName() + "' folder";
                        } else if (root.getType() == 1) {
                            sectionText = "Start formatting '" + root.getName() + "' file";
                        }
                        DVTMultipleFilesFormatter.consolePrintSection(sectionText);
                        DVTMultipleFilesFormatter.consolePrint("Refreshing resource tree...");
                        root.refreshLocal(2, null);
                        DVTMultipleFilesFormatter.consolePrint("Gathering information...");
                        root.accept(visitor, 2, false);
                        DVTMultipleFilesFormatter.consolePrint("Found " + filesToFormat.size() + " files to format.");
                    }
                    IWorkbenchWindow workbench = DVTUiUtils.getActiveWorkbenchWindow();
                    if (workbench == null) {
                        return;
                    }
                    if (!dirtyFiles.isEmpty()) {
                        FileListDialog dirtyFilesDialog = new FileListDialog(workbench.getShell(), "The following files are opened and modified but not saved, please save them and try again:", FileListDialog.Kind.ERROR, dirtyFiles);
                        dirtyFilesDialog.open();
                        return;
                    }
                    try {
                        DVTFileModificationValidator.validateEdit(null, filesToFormat.keySet().toArray(new IFile[filesToFormat.size()]), false);
                    }
                    catch (CoreException e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                    HashSet<IFile> stillReadOnlyFiles = new HashSet<IFile>();
                    HashSet<String> stillReadOnlyPaths = new HashSet<String>();
                    for (IFile fileToFormat : filesToFormat.keySet()) {
                        if (fileToFormat.getLocation().toFile().canWrite()) continue;
                        stillReadOnlyFiles.add(fileToFormat);
                        stillReadOnlyPaths.add(fileToFormat.getLocation().toOSString());
                    }
                    if (!stillReadOnlyFiles.isEmpty()) {
                        DVTMultipleFilesFormatter.consolePrint("Found " + stillReadOnlyFiles.size() + " read-only files that will be skipped:\n" + DVTStringUtil.join(stillReadOnlyPaths, "\n"));
                        filesToFormat.keySet().removeAll(stillReadOnlyFiles);
                        FileListDialog stillReadOnlyDialog = new FileListDialog(workbench.getShell(), "The following files are read only and will not be formatted. Continue?", FileListDialog.Kind.WARNING, stillReadOnlyFiles);
                        if (stillReadOnlyDialog.open() != 0) {
                            return;
                        }
                    }
                    if (monitor.isCanceled()) {
                        return;
                    }
                    int numFiles = filesToFormat.size();
                    if (numFiles == 0) {
                        this.showNoFilesPopUp();
                        return;
                    }
                    monitor.beginTask("Formatting files", numFiles);
                    int count = 0;
                    for (Map.Entry fileEntry : filesToFormat.entrySet()) {
                        if (monitor.isCanceled()) {
                            return;
                        }
                        IFile file = (IFile)fileEntry.getKey();
                        String editorId = (String)fileEntry.getValue();
                        monitor.subTask("(" + ++count + "/" + numFiles + ") " + file.getLocation().toOSString());
                        try {
                            LocationKind locationKind;
                            String fileNatureForEditorId = this.getFileNatureForEditorId(editorId);
                            DVTSourceViewerConfiguration config = RfMixedLangManager.getInstance().getSourceViewerConfigurationForFile(fileNatureForEditorId, file.getProject());
                            if (config == null) {
                                problematicFiles.add(file);
                                DVTMultipleFilesFormatter.consolePrint("Encountered problems while formatting: " + file.getFullPath().toOSString());
                                continue;
                            }
                            if (isTesting) {
                                config.setTesting();
                            }
                            IDocument document = null;
                            boolean shouldDisconnect = false;
                            TextFileBufferInfo bufferedManagerInfo = DVTFileUtils.getInstance().getTextFileBufferInfo(file);
                            IPath path = bufferedManagerInfo.getPath();
                            ITextFileBuffer textFileBuffer = bufferManager.getTextFileBuffer(path, locationKind = bufferedManagerInfo.getLocationKind());
                            if (textFileBuffer == null) {
                                shouldDisconnect = true;
                                bufferManager.connect(path, locationKind, null);
                            }
                            if (!((document = (textFileBuffer = bufferManager.getTextFileBuffer(path, locationKind)).getDocument()) instanceof IDocumentExtension4)) {
                                problematicFiles.add(file);
                                DVTMultipleFilesFormatter.consolePrint("Encountered problems while formatting: " + file.getFullPath().toOSString());
                                continue;
                            }
                            try {
                                IDocumentExtension4 extension = (IDocumentExtension4)document;
                                DocumentRewriteSession rewriteSession = extension.getActiveRewriteSession();
                                if (rewriteSession == null) {
                                    rewriteSession = extension.startRewriteSession(DocumentRewriteSessionType.SEQUENTIAL);
                                }
                                if (rewriteSession.getSessionType() != DocumentRewriteSessionType.SEQUENTIAL) {
                                    extension.stopRewriteSession(rewriteSession);
                                    rewriteSession = extension.startRewriteSession(DocumentRewriteSessionType.SEQUENTIAL);
                                }
                                config.setupDocumentPartitioner(document);
                                IContentFormatter formatter = config.getContentFormatter(null);
                                if (!(formatter instanceof DVTContentFormatter)) {
                                    problematicFiles.add(file);
                                    DVTMultipleFilesFormatter.consolePrint("Encountered problems while formatting: " + file.getFullPath().toOSString());
                                    continue;
                                }
                                config.detectIndentation(document);
                                DVTContentFormatter dvtFormatter = (DVTContentFormatter)formatter;
                                dvtFormatter.setDoNotShowFormatFailedPopup(true);
                                dvtFormatter.format(document, new Region(0, document.getLength()), file);
                                if (isTesting) {
                                    MultipleFilesFormatTestHelper.getInstance().compareToReference(document.get(), file);
                                } else {
                                    textFileBuffer.commit(null, false);
                                }
                                if (dvtFormatter.isFormatFailed()) {
                                    problematicFiles.add(file);
                                    DVTMultipleFilesFormatter.consolePrint("Encountered problems while formatting: " + file.getFullPath().toOSString());
                                }
                                extension.stopRewriteSession(rewriteSession);
                                config.setNormal();
                            }
                            catch (Exception e) {
                                problematicFiles.add(file);
                                DVTLogger.INSTANCE.logError((Throwable)e);
                            }
                            if (shouldDisconnect) {
                                bufferManager.disconnect(path, locationKind, null);
                            }
                        }
                        catch (CoreException e) {
                            problematicFiles.add(file);
                            DVTLogger.INSTANCE.logError((Throwable)e);
                        }
                        monitor.worked(1);
                    }
                    DVTMultipleFilesFormatter.consolePrint("Refreshing resource tree after changes...");
                    for (IResource root : roots) {
                        root.refreshLocal(2, null);
                    }
                    if (!problematicFiles.isEmpty()) {
                        FileListDialog problematicFilesDialog = new FileListDialog(workbench.getShell(), "Problems were encountered while formatting the following files, the code has been reverted to its original value:", FileListDialog.Kind.ERROR, problematicFiles);
                        problematicFilesDialog.open();
                    }
                    monitor.done();
                    DVTMultipleFilesFormatter.consolePrint("Done formatting.\n");
                }

                private void showNoFilesPopUp() {
                    ErrorDialog.openError((Shell)DVTUiUtils.getActiveWorkbenchShell(), null, (String)"Nothing to format!", (IStatus)new Status(2, "ro.amiq.dvt", "No valid source files were included in your selection."));
                }

                private String getFileNatureForEditorId(String editorId) {
                    if (editorId == null) {
                        return null;
                    }
                    if (editorId.equals("ro.amiq.vlogdt.ui.editor.VlogEditor")) {
                        return "ro.amiq.vlogdt.VlogNature";
                    }
                    if (editorId.equals("ro.amiq.vhdldt.ui.editor.VhdlEditor")) {
                        return "ro.amiq.vhdldt.VhdlNature";
                    }
                    if (editorId.equals("ro.amiq.edt.ui.editor.EEditor")) {
                        return "ro.amiq.edt.enature";
                    }
                    if (editorId.equals("ro.amiq.slndt.ui.editor.SLNEditor")) {
                        return "ro.amiq.slndt.slnnature";
                    }
                    if (editorId.equals("ro.amiq.msdldt.ui.editor.MSDLEditor")) {
                        return "ro.amiq.msdldt.msdlnature";
                    }
                    if (editorId.equals("ro.amiq.pssdt.ui.editor.PSSEditor")) {
                        return "ro.amiq.pssdt.pssnature";
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected static void consolePrintSection(String string) {
        DVTMultipleFilesFormatter.consolePrint("****\n" + string);
    }

    public static MessageConsole getFormatFilesConsole(boolean createIfNone) {
        IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        int i = 0;
        while (i < consoleManager.getConsoles().length) {
            if (FORMAT_MULTIPLE_FILES.equals(consoleManager.getConsoles()[i].getName())) {
                return (MessageConsole)consoleManager.getConsoles()[i];
            }
            ++i;
        }
        if (!createIfNone) {
            return null;
        }
        MessageConsole myConsole = new MessageConsole(FORMAT_MULTIPLE_FILES, null);
        consoleManager.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }

    protected static void consolePrint(String string) {
        MessageConsole myConsole = DVTMultipleFilesFormatter.getFormatFilesConsole(true);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (MessageConsoleStream newMessageStream = myConsole.newMessageStream();){
                newMessageStream.println(string);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

