/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.formatter;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.model.preproc.PreprocUtils;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.formatter.DVTPreprocFormattingUtilsCommon;
import ro.amiq.dvt.utils.DVTFileUtils;

public class DVTPreprocFormattingUtils
extends DVTPreprocFormattingUtilsCommon {
    private static DVTPreprocFormattingUtils INSTANCE;
    private static final Object SYNC_OBJECT;
    private IProject project;

    static {
        SYNC_OBJECT = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DVTPreprocFormattingUtils getInstance() {
        if (INSTANCE == null) {
            Object object = SYNC_OBJECT;
            synchronized (object) {
                INSTANCE = new DVTPreprocFormattingUtils();
            }
        }
        return INSTANCE;
    }

    private DVTPreprocFormattingUtils() {
    }

    @Override
    protected IProject getProject() {
        if (this.project != null) {
            return this.project;
        }
        IEditorPart activeEditor = DVTFileUtils.getInstance().getActiveEditor();
        if (!(activeEditor instanceof DVTEditor)) {
            return null;
        }
        this.project = ((DVTEditor)activeEditor).getProject();
        return this.project;
    }

    @Override
    protected ParserPath getParserPath() {
        if (super.getParserPath() != null) {
            return super.getParserPath();
        }
        IEditorPart activeEditor = DVTFileUtils.getInstance().getActiveEditor();
        if (!(activeEditor instanceof DVTEditor)) {
            return null;
        }
        ParserPath parserPath = ((DVTEditor)activeEditor).getParserPath();
        this.setParserPath(parserPath);
        return parserPath;
    }

    @Override
    protected void setPVlogPrerequisites(IFile file) {
        if (file == null || !PreprocUtils.getInstance().isPFile(file)) {
            return;
        }
        IPath path = file.getLocation();
        if (path == null) {
            return;
        }
        this.setParserPath(new ParserPath(path.toOSString()));
        this.project = file.getProject();
    }

    @Override
    protected void clearInternal() {
        super.clearInternal();
        this.project = null;
    }
}

