/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.formatter;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import ro.amiq.dvt.model.preproc.PreprocDiffManager;
import ro.amiq.dvt.model.preproc.PreprocUtils;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.dvt.utils.DVTPair;

public abstract class DVTPreprocFormattingUtilsCommon {
    private ParserPath parserPath;
    private List<PreprocDiffManager.PreprocMacro> preprocMacros;
    private IDocument originalDocument;
    private List<PreprocDiffManager.PreprocMacro> originalPreprocMacros;
    private List<String> originalPreprocCodeRegions;
    private int cachedPreprocMacroIndex;
    private List<PreprocDiffManager.PreprocMacro> cachedPreprocMacros;

    protected ParserPath getParserPath() {
        return this.parserPath;
    }

    protected void setParserPath(ParserPath parserPath) {
        this.parserPath = parserPath;
    }

    protected boolean isValidPVerilogDocument() {
        IProject project = this.getProject();
        if (project == null) {
            return false;
        }
        ParserPath parserPath = this.getParserPath();
        if (parserPath == null) {
            return false;
        }
        return PreprocUtils.getInstance().isPFile(project, parserPath);
    }

    protected List<PreprocDiffManager.PreprocMacro> getPreprocMacros() {
        if (this.parserPath == null) {
            return null;
        }
        return PreprocDiffManager.INSTANCE.getPreprocMacros(this.parserPath.path);
    }

    protected IDocument getOriginalDocument() {
        return this.originalDocument;
    }

    protected List<PreprocDiffManager.PreprocMacro> getOriginalPreprocMacros() {
        return this.originalPreprocMacros;
    }

    protected IRegion processDocumentBeforeFormatting(IDocument document, IRegion region) {
        this.originalDocument = new Document(document.get());
        this.updatePreprocMacros(this.originalDocument);
        this.parserPath = this.getParserPath();
        this.preprocMacros = this.getPreprocMacros();
        this.originalPreprocCodeRegions = new ArrayList<String>();
        this.originalPreprocMacros = new ArrayList<PreprocDiffManager.PreprocMacro>();
        for (PreprocDiffManager.PreprocMacro preprocMacro : this.preprocMacros) {
            this.originalPreprocMacros.add(new PreprocDiffManager.PreprocMacro(preprocMacro));
        }
        DVTPair<Integer, Integer> regionAdjustments = this.addPreprocMacrosGuards(document, region);
        return this.adjustRegion(region, regionAdjustments);
    }

    private IRegion adjustRegion(IRegion region, DVTPair<Integer, Integer> regionAdjustments) {
        if (regionAdjustments == null) {
            return region;
        }
        final int offset = region.getOffset();
        final int length = region.getLength();
        final Integer offsetAdjustment = regionAdjustments.getKey();
        final Integer lengthAdjustment = regionAdjustments.getValue();
        return new IRegion(){

            public int getOffset() {
                return offset + offsetAdjustment;
            }

            public int getLength() {
                return length + lengthAdjustment;
            }
        };
    }

    protected void processDocumentAfterFormatting(IDocument document) {
        this.updatePreprocMacros(document);
        this.removePreprocMacrosGuards(document);
    }

    private void updatePreprocMacros(IDocument document) {
        IProject project = this.getProject();
        if (project == null || this.parserPath == null || document == null) {
            return;
        }
        PreprocUtils.getInstance().onPChange(project, this.parserPath, document.get());
    }

    private String getPreprocMacrosStartGuard() {
        return "// @formatter:off" + DVTDocumentCommon.getLineDelimiterByProject(this.getProject());
    }

    private String getPreprocMacrosEndGuard() {
        return String.valueOf(DVTDocumentCommon.getLineDelimiterByProject(this.getProject())) + "// @formatter:on";
    }

    private String getPreprocMacroFormattingReplacement(PreprocDiffManager.PreprocMacro preprocMacro) {
        return String.valueOf(this.getPreprocMacrosStartGuard()) + preprocMacro.getReplacement() + this.getPreprocMacrosEndGuard();
    }

    private void updatePVlogDocument(IDocument document) {
        if (this.parserPath == null || document == null) {
            return;
        }
        PreprocDiffManager.INSTANCE.setPrevDocument(this.parserPath.path, (IDocument)new Document(document.get()));
    }

    private DVTPair<Integer, Integer> addPreprocMacrosGuards(IDocument document, IRegion region) {
        int regionLengthAdjustment;
        int regionOffsetAdjustment;
        block6: {
            regionOffsetAdjustment = 0;
            regionLengthAdjustment = 0;
            if (this.preprocMacros != null && !this.preprocMacros.isEmpty()) break block6;
            return null;
        }
        try {
            int regionStartOffset = region.getOffset();
            int regionEndOffset = regionStartOffset + region.getLength();
            int noCharsToShift = 0;
            for (PreprocDiffManager.PreprocMacro preprocMacro : this.preprocMacros) {
                if (preprocMacro == null) continue;
                preprocMacro.shift(noCharsToShift);
                int pStartOffset = preprocMacro.getPStartOffset();
                if (pStartOffset >= regionEndOffset) continue;
                int pEndOffset = preprocMacro.getPEndOffset();
                int pLength = pEndOffset - pStartOffset;
                this.originalPreprocCodeRegions.add(document.get(pStartOffset, pLength));
                String formattingReplacement = this.getPreprocMacroFormattingReplacement(preprocMacro);
                document.replace(pStartOffset, pLength, formattingReplacement);
                int crtCharsToShift = formattingReplacement.length() - pLength;
                preprocMacro.setPEndOffset(pEndOffset + crtCharsToShift);
                noCharsToShift += crtCharsToShift;
                if (regionStartOffset >= pEndOffset) {
                    regionOffsetAdjustment += crtCharsToShift;
                    regionStartOffset += crtCharsToShift;
                } else {
                    regionLengthAdjustment += crtCharsToShift;
                }
                regionEndOffset += crtCharsToShift;
            }
            this.updatePVlogDocument(document);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return new DVTPair<Integer, Integer>(regionOffsetAdjustment, regionLengthAdjustment);
    }

    private void removePreprocMacrosGuards(IDocument document) {
        try {
            this.preprocMacros = this.getPreprocMacros();
            if (this.preprocMacros == null || this.preprocMacros.isEmpty()) {
                return;
            }
            int noCharsToShift = 0;
            int i = 0;
            while (i < this.preprocMacros.size()) {
                PreprocDiffManager.PreprocMacro preprocMacro = this.preprocMacros.get(i);
                if (preprocMacro != null) {
                    preprocMacro.shift(noCharsToShift);
                    if (i < this.originalPreprocCodeRegions.size()) {
                        int pStartOffset = preprocMacro.getPStartOffset();
                        int pEndOffset = preprocMacro.getPEndOffset();
                        int pLength = pEndOffset - pStartOffset;
                        String originalPreprocRegion = this.originalPreprocCodeRegions.get(i);
                        document.replace(pStartOffset, pLength, originalPreprocRegion);
                        int crtCharsToShift = originalPreprocRegion.length() - pLength;
                        preprocMacro.setPEndOffset(pEndOffset + crtCharsToShift);
                        noCharsToShift += crtCharsToShift;
                    }
                }
                ++i;
            }
            this.updatePVlogDocument(document);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected int getPreprocRegionLengthFromOffset(int crtOffset, List<PreprocDiffManager.PreprocMacro> preprocMacros) {
        if (preprocMacros != this.cachedPreprocMacros) {
            this.cachedPreprocMacros = preprocMacros;
            this.cachedPreprocMacroIndex = 0;
        }
        if (this.cachedPreprocMacros == null) {
            return 0;
        }
        int i = this.cachedPreprocMacroIndex;
        while (i < this.cachedPreprocMacros.size()) {
            PreprocDiffManager.PreprocMacro preprocMacro = this.cachedPreprocMacros.get(i);
            int pStartOffset = preprocMacro.getPStartOffset();
            int pEndOffset = preprocMacro.getPEndOffset();
            this.cachedPreprocMacroIndex = i++;
            if (crtOffset < pStartOffset) {
                return 0;
            }
            if (crtOffset >= pEndOffset) continue;
            return pEndOffset - pStartOffset;
        }
        return 0;
    }

    protected void handleFormatFailed() {
        if (this.parserPath == null) {
            return;
        }
        PreprocDiffManager.INSTANCE.setPreprocMacros(this.parserPath.path, this.originalPreprocMacros);
    }

    protected void clearInternal() {
        this.parserPath = null;
        this.preprocMacros = null;
        this.originalDocument = null;
        this.originalPreprocMacros = null;
        this.originalPreprocCodeRegions = null;
        this.cachedPreprocMacros = null;
        this.cachedPreprocMacroIndex = 0;
    }

    protected abstract IProject getProject();

    protected abstract void setPVlogPrerequisites(IFile var1);
}

