/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.formatter;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;
import ro.amiq.dvt.ui.editor.formatter.FileListContentProvider;
import ro.amiq.dvt.ui.editor.formatter.FileListLabelProvider;

class FileListDialog
extends ListDialog {
    private static final String TITLE = "Problems Encountered";
    protected static final String MESSAGE_READ_ONLY_FILES = "The following files are read only and will not be formatted. Continue?";
    protected static final String MESSAGE_DIRTY_FILES = "The following files are opened and modified but not saved, please save them and try again:";
    protected static final String MESSAGE_PROBLEMS_FILES = "Problems were encountered while formatting the following files, the code has been reverted to its original value:";
    private String fMessage;
    private Kind fKind;

    public FileListDialog(Shell parent, String message, Kind kind, Set<IFile> input) {
        super(parent);
        super.setInput(input);
        super.setContentProvider((IStructuredContentProvider)new FileListContentProvider());
        super.setLabelProvider((ILabelProvider)new FileListLabelProvider());
        super.setTitle(TITLE);
        this.fMessage = message;
        this.fKind = kind;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        switch (this.fKind) {
            case ERROR: {
                shell.setImage(shell.getDisplay().getSystemImage(1));
                break;
            }
            case WARNING: {
                shell.setImage(shell.getDisplay().getSystemImage(8));
            }
        }
    }

    protected Control createDialogArea(Composite container) {
        super.setMessage(this.fMessage);
        if (this.fKind == Kind.ERROR) {
            super.setAddCancelButton(false);
        }
        return super.createDialogArea(container);
    }

    protected static enum Kind {
        ERROR,
        WARNING;

    }
}

