/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.formatter;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.utils.DVTColorUtil;

public class ForceFormatterDialog
extends MessageDialog {
    private static final String editorPreferencePageId = "ro.amiq.dvt.EditorsPreferencePage";

    public ForceFormatterDialog(int threshold) {
        super(Utils.getActiveShell(), "Formatter threshold exceeded!", null, "You are about to format a file with more than " + threshold + " lines. Do you want to continue?\n\n" + "You can change the threshold value from <a href=\"link\">Editor Preference Page</a>\n" + "Hint: To ignore the formatter threshold set the value to 0", 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
    }

    protected Control createMessageArea(Composite composite) {
        Image image = this.getQuestionImage();
        if (image == null) {
            return composite;
        }
        this.imageLabel = new Label(composite, 0);
        image.setBackground(this.imageLabel.getBackground());
        this.imageLabel.setImage(image);
        GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)this.imageLabel);
        Link linkToPref = new Link(composite, this.getMessageLabelStyle());
        linkToPref.setText(this.message);
        DVTUiUtils.setPlatformLinkColor((Link)linkToPref);
        DVTColorUtil.INSTANCE.setForeground((Control)linkToPref, JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.notification.foregroundColor"), true);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)linkToPref);
        GridData linkToPrefData = new GridData(1, 0x1000000, true, false);
        linkToPref.setLayoutData((Object)linkToPrefData);
        linkToPref.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)ForceFormatterDialog.this.getShell(), (String)ForceFormatterDialog.editorPreferencePageId, null, null).open();
                ForceFormatterDialog.this.close();
            }
        });
        return composite;
    }
}

