/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.formatter;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.TextConsole;
import ro.amiq.dvt.test.ForTestingOrDebuggingOnly;
import ro.amiq.dvt.utils.DVTFileUtils;

@ForTestingOrDebuggingOnly
public class MultipleFilesFormatTestHelper {
    private static MultipleFilesFormatTestHelper instance;
    public static final String REFERENCE_SUFFIX = "_format_reference";

    public static MultipleFilesFormatTestHelper getInstance() {
        if (instance == null) {
            instance = new MultipleFilesFormatTestHelper();
        }
        return instance;
    }

    public void compareToReference(String actualFileContent, IFile file) {
        IPath projectRelativeFilePath = file.getProjectRelativePath();
        IProject project = file.getProject();
        String projectLocation = project.getLocation().toOSString();
        String projectName = project.getName();
        IPath referenceFilePath = Path.fromOSString((String)projectLocation).append(String.valueOf(projectName) + REFERENCE_SUFFIX).append(projectRelativeFilePath);
        String referenceFileContent = DVTFileUtils.getInstance().readFileContent(referenceFilePath.toFile());
        Assert.isTrue((boolean)actualFileContent.equals(referenceFileContent), (String)("Differences found for " + file.getName()));
    }

    public TextConsole getFormatConsole() {
        IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        MessageConsole myConsole = null;
        int i = 0;
        while (i < consoleManager.getConsoles().length) {
            if ("Format Multiple Files".equals(consoleManager.getConsoles()[i].getName())) {
                myConsole = (MessageConsole)consoleManager.getConsoles()[i];
            }
            ++i;
        }
        return myConsole;
    }
}

