/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.formatter.detectindentation;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.formatter.detectindentation.DVTAutoIndentDetector;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.views.inspect.InspectView;
import ro.amiq.dvt.utils.DVTFileUtils;

public enum DVTAutoIndentDetectionManager implements IWorkbenchListener
{
    INSTANCE;

    private IPropertyChangeListener detectIndentationPreferenceListener;
    private Map<IDocument, DVTAutoIndentDetector.DetectedIndentation> detectedIndentationMap = new HashMap<IDocument, DVTAutoIndentDetector.DetectedIndentation>();

    public void init() {
        PlatformUI.getWorkbench().addWorkbenchListener((IWorkbenchListener)this);
        this.installDetectIndentationPreferenceListener();
    }

    private void installDetectIndentationPreferenceListener() {
        try {
            this.detectIndentationPreferenceListener = event -> {
                if (!"format.indent.auto_detect".equals(event.getProperty())) {
                    return;
                }
                this.detectedIndentationMap.clear();
                IEditorPart activeEditor = DVTFileUtils.getInstance().getActiveEditor();
                if (activeEditor instanceof DVTEditor) {
                    ((DVTEditor)activeEditor).detectIndentation();
                }
                InspectView.getInstance().updateOnDetectIndentationPref();
            };
            DVTPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.detectIndentationPreferenceListener);
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    public DVTAutoIndentDetector.DetectedIndentation getDetectedIndentationForDocument(IDocument document) {
        if (!PrefConst.isDetectIndentationEnabled()) {
            return null;
        }
        if (document == null) {
            return null;
        }
        if (!this.detectedIndentationMap.containsKey(document)) {
            return null;
        }
        return this.detectedIndentationMap.get(document);
    }

    public void setDetectedIndendationForDocument(IDocument document, DVTAutoIndentDetector.DetectedIndentation detectedIndentation) {
        if (!PrefConst.isDetectIndentationEnabled()) {
            return;
        }
        if (document == null || detectedIndentation == null) {
            return;
        }
        this.detectedIndentationMap.put(document, detectedIndentation);
    }

    public void removeDetectedIndendationDocument(IDocument document) {
        if (!PrefConst.isDetectIndentationEnabled()) {
            return;
        }
        if (document == null) {
            return;
        }
        this.detectedIndentationMap.remove(document);
    }

    public boolean preShutdown(IWorkbench workbench, boolean forced) {
        return true;
    }

    public void postShutdown(IWorkbench workbench) {
    }

    public void dispose() {
        this.detectedIndentationMap.clear();
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        workbench.removeWorkbenchListener((IWorkbenchListener)this);
        DVTPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.detectIndentationPreferenceListener);
    }
}

