/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.formatter.detectindentation;

import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import ro.amiq.dvt.utils.DVTDocumentUtilsCommon;

public enum DVTAutoIndentDetector {
    INSTANCE;

    private static final int[] ALLOWED_TAB_WIDTHS;
    private static final int MAX_ALLOWED_TAB_WIDTH = 8;
    private static final int MIN_ALLOWED_TAB_WIDTH = 2;
    private boolean preprocLine;
    private boolean insideMultilineDefine;
    private long nofUnmatchedParen;
    private boolean indentBasedOnPreprocLines;

    static {
        ALLOWED_TAB_WIDTHS = new int[]{2, 4, 6, 8, 3, 5, 7};
    }

    public DetectedIndentation detectIndentation(IDocument document, IPreferenceStore preferenceStore, Set<String> allPreprocs) throws BadLocationException {
        int defaultTabWidth = preferenceStore == null ? 4 : preferenceStore.getInt("tabWidth");
        boolean insertSpaces = preferenceStore != null && preferenceStore.getBoolean("spacesForTabs");
        int linesCount = Math.min(document.getNumberOfLines(), 10000);
        int nofLinesIndentedWithTabs = 0;
        int nofLinesIndentedWithSpaces = 0;
        String previousLineText = "";
        int previousLineIndentation = 0;
        int[] spacesDiffCount = new int[9];
        int nofPreprocLinesIndentedWithTabs = 0;
        int nofPreprocLinesIndentedWithSpaces = 0;
        int[] preprocLinesSpacesDiffCount = new int[9];
        this.preprocLine = false;
        this.insideMultilineDefine = false;
        this.nofUnmatchedParen = 0L;
        this.indentBasedOnPreprocLines = allPreprocs != null;
        int lineNumber = 0;
        while (lineNumber < linesCount) {
            IRegion lineRegion = document.getLineInformation(lineNumber);
            String currentLineText = DVTDocumentUtilsCommon.getTextAtRegion(document, lineRegion);
            if (currentLineText != null && currentLineText.trim().length() != 0) {
                boolean pairContainsPreprocLine = this.pairContainsPreprocLine(currentLineText, allPreprocs);
                int currentLineLength = currentLineText.length();
                int currentLineIndentation = 0;
                int currentLineNofSpaces = 0;
                int currentLineNofTabs = 0;
                int i = 0;
                while (i < currentLineLength) {
                    char currentChar = currentLineText.charAt(i);
                    if (currentChar == '\t') {
                        ++currentLineNofTabs;
                    } else if (currentChar == ' ') {
                        ++currentLineNofSpaces;
                    } else {
                        currentLineIndentation = i;
                        break;
                    }
                    ++i;
                }
                if (currentLineNofTabs > 0) {
                    if (pairContainsPreprocLine) {
                        ++nofPreprocLinesIndentedWithTabs;
                    } else {
                        ++nofLinesIndentedWithTabs;
                    }
                } else if (currentLineNofSpaces > 1) {
                    if (pairContainsPreprocLine) {
                        ++nofPreprocLinesIndentedWithSpaces;
                    } else {
                        ++nofLinesIndentedWithSpaces;
                    }
                }
                SpacesDiffResult spacesDiffRes = this.spacesDiff(previousLineText, previousLineIndentation, currentLineText, currentLineIndentation, !pairContainsPreprocLine);
                if (!spacesDiffRes.looksLikeAlignment || insertSpaces && defaultTabWidth == spacesDiffRes.spacesDiff) {
                    int currentSpacesDiff = spacesDiffRes.spacesDiff;
                    if (currentSpacesDiff <= 8) {
                        if (pairContainsPreprocLine) {
                            int n = currentSpacesDiff;
                            preprocLinesSpacesDiffCount[n] = preprocLinesSpacesDiffCount[n] + 1;
                        } else {
                            int n = currentSpacesDiff;
                            spacesDiffCount[n] = spacesDiffCount[n] + 1;
                        }
                    }
                    previousLineText = currentLineText;
                    previousLineIndentation = currentLineIndentation;
                }
            }
            ++lineNumber;
        }
        if (this.indentBasedOnPreprocLines) {
            return this.computeDetectedIndentation(insertSpaces, nofPreprocLinesIndentedWithTabs, nofPreprocLinesIndentedWithSpaces, defaultTabWidth, preprocLinesSpacesDiffCount);
        }
        return this.computeDetectedIndentation(insertSpaces, nofLinesIndentedWithTabs, nofLinesIndentedWithSpaces, defaultTabWidth, spacesDiffCount);
    }

    DetectedIndentation computeDetectedIndentation(boolean defaultInsertSpaces, int nofLinesIndentedWithTabs, int nofLinesIndentedWithSpaces, int defaultTabWidth, int[] spacesDiffCount) {
        boolean insertSpaces = defaultInsertSpaces;
        if (nofLinesIndentedWithTabs != nofLinesIndentedWithSpaces) {
            insertSpaces = nofLinesIndentedWithTabs < nofLinesIndentedWithSpaces;
        }
        int tabWidth = defaultTabWidth;
        if (insertSpaces) {
            int tabWidthScore = 0;
            int[] nArray = ALLOWED_TAB_WIDTHS;
            int n = ALLOWED_TAB_WIDTHS.length;
            int n2 = 0;
            while (n2 < n) {
                int possibleTabWidth = nArray[n2];
                int possibleTabWidthScore = spacesDiffCount[possibleTabWidth];
                if (possibleTabWidthScore > tabWidthScore) {
                    tabWidthScore = possibleTabWidthScore;
                    tabWidth = possibleTabWidth;
                }
                ++n2;
            }
        }
        return new DetectedIndentation(tabWidth, insertSpaces);
    }

    private SpacesDiffResult spacesDiff(String prevLine, int prevLineIndentation, String currLine, int currLineIndentation, boolean nonPreprocLines) {
        SpacesDiffResult result = new SpacesDiffResult();
        result.spacesDiff = 0;
        result.looksLikeAlignment = false;
        int nofCommonChars = 0;
        while (nofCommonChars < prevLineIndentation && nofCommonChars < currLineIndentation) {
            char currLineChar;
            char prevLineChar = prevLine.charAt(nofCommonChars);
            if (prevLineChar != (currLineChar = currLine.charAt(nofCommonChars))) break;
            ++nofCommonChars;
        }
        int prevLineSpacesCnt = 0;
        int prevLineTabsCnt = 0;
        int i = nofCommonChars;
        while (i < prevLineIndentation) {
            char previousLineChar = prevLine.charAt(i);
            if (previousLineChar == ' ') {
                ++prevLineSpacesCnt;
            } else {
                ++prevLineTabsCnt;
            }
            ++i;
        }
        int currLineSpacesCnt = 0;
        int currLineTabsCnt = 0;
        int i2 = nofCommonChars;
        while (i2 < currLineIndentation) {
            char currLineChar = currLine.charAt(i2);
            if (currLineChar == ' ') {
                ++currLineSpacesCnt;
            } else {
                ++currLineTabsCnt;
            }
            ++i2;
        }
        if (prevLineSpacesCnt > 0 && prevLineTabsCnt > 0) {
            return result;
        }
        if (currLineSpacesCnt > 0 && currLineTabsCnt > 0) {
            return result;
        }
        int tabsDiff = Math.abs(prevLineTabsCnt - currLineTabsCnt);
        int spacesDiff = Math.abs(prevLineSpacesCnt - currLineSpacesCnt);
        if (tabsDiff == 0) {
            result.spacesDiff = spacesDiff;
            if (spacesDiff > 0 && currLineSpacesCnt - 1 >= 0 && currLineSpacesCnt - 1 < prevLine.length() && currLineSpacesCnt < currLine.length() && currLine.charAt(currLineSpacesCnt) != ' ' && prevLine.charAt(currLineSpacesCnt - 1) == ' ' && prevLine.charAt(prevLine.length() - 1) == ',') {
                result.looksLikeAlignment = true;
            }
            if (spacesDiff >= 2 && nonPreprocLines) {
                this.indentBasedOnPreprocLines = false;
            }
            return result;
        }
        if (nonPreprocLines) {
            this.indentBasedOnPreprocLines = false;
        }
        if (spacesDiff % tabsDiff == 0) {
            result.spacesDiff = spacesDiff / tabsDiff;
            return result;
        }
        return result;
    }

    private boolean pairContainsPreprocLine(String currentLineText, Set<String> allPreprocs) {
        if (allPreprocs == null) {
            return false;
        }
        String trimmedCurrentLineText = currentLineText.trim();
        if (trimmedCurrentLineText.charAt(0) == '`') {
            if (this.lineStartsWithPreproc(trimmedCurrentLineText, allPreprocs)) {
                this.preprocLine = true;
            }
            if (trimmedCurrentLineText.startsWith("`define") && trimmedCurrentLineText.endsWith("\\")) {
                this.insideMultilineDefine = true;
            }
            this.updateNofUnmatchedParen(trimmedCurrentLineText);
            if (this.nofUnmatchedParen != 0L) {
                this.preprocLine = true;
            }
            return this.preprocLine;
        }
        if (this.preprocLine) {
            if (this.insideMultilineDefine) {
                if (!trimmedCurrentLineText.endsWith("\\")) {
                    this.insideMultilineDefine = false;
                }
                this.updateNofUnmatchedParen(trimmedCurrentLineText);
                return true;
            }
            if (this.nofUnmatchedParen == 0L) {
                this.preprocLine = false;
            } else {
                this.updateNofUnmatchedParen(trimmedCurrentLineText);
            }
            return true;
        }
        return false;
    }

    private boolean lineStartsWithPreproc(String currentLineText, Set<String> allPreprocs) {
        for (String preproc : allPreprocs) {
            if (!currentLineText.startsWith(preproc)) continue;
            return true;
        }
        return false;
    }

    private void updateNofUnmatchedParen(String currentLineText) {
        long nofOpenParen = currentLineText.chars().filter(c -> c == 40).count();
        long nofCloseParen = currentLineText.chars().filter(c -> c == 41).count();
        this.nofUnmatchedParen += nofOpenParen - nofCloseParen;
    }

    public class DetectedIndentation {
        private int tabWidth;
        private boolean insertSpaces;

        public DetectedIndentation(int tabWidth, boolean insertSpaces) {
            this.tabWidth = tabWidth;
            this.insertSpaces = insertSpaces;
        }

        public int getTabWidth() {
            return this.tabWidth;
        }

        public boolean getInsertSpaces() {
            return this.insertSpaces;
        }
    }

    private class SpacesDiffResult {
        int spacesDiff;
        boolean looksLikeAlignment;

        private SpacesDiffResult() {
        }
    }
}

