/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.formatter.model;

import java.util.List;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.IApplyActionListener;
import ro.amiq.dvt.ui.editor.formatter.model.CFPositionReference;
import ro.amiq.dvt.ui.editor.formatter.strategies.DVTBaseFormattingStrategy;
import ro.amiq.dvt.ui.editor.formatter.util.CFSyso;

public class CFAction
implements Comparable<CFAction> {
    private int fPriority;
    private int fOffsetInChunk;
    private int fNofCharsToDelete;
    private String fCharsToInsert;
    private int fLineNo;
    protected String fCausedBy;
    public static final String CFC_UNKNOWN = "unknown";
    public static final String CFC_CAPITALIZE = "capitalize";
    public static final String CFC_REPLACE_TABS_WITH_SPACES = "replace tabs with spaces";
    public static final String CFC_TRIM_EMPTY_LINE = "trim empty line";
    public static final String CFC_TRIM_LAST_EMPTY_LINE = "trim last no nl empty line";
    public static final String CFC_TRIM_END_OF_LINE = "trim end of line whitespace";
    public static final String CFC_COMPACT_WHITESPACE = "compact whitespace";
    public static final String CFC_COMPACT_CONSECUTIVE_EMPTY_LINES = "compact consecutive empty lines";
    public static final String CFC_ADD_WHITESPACE_BEFORE = "add whitespace before";
    public static final String CFC_ADD_WHITESPACE_AFTER = "add whitespace after";
    public static final String CFC_REMOVE_NL_BEFORE = "remove nl before";
    public static final String CFC_REMOVE_NL_AFTER = "remove nl after";
    public static final String CFC_INDENT = "indent";
    public static final String CFC_INDENT_SL_COMMENT = "indent sl comment";
    public static final String CFC_INDENT_ML_COMMENT = "ml comment indent";
    public static final String CFC_INDENT_USING_TABS = "indent using tabs";
    public static final String CFC_INDENT_PREPROC = "indent preproc";
    public static final String CFC_BEGIN_NEW_LINE = "begin new line";
    public static final String CFC_BEGIN_SAME_LINE = "begin same line";
    public static final String CFC_NEW_LINE_AFTER_BEGIN_AND_BEFORE_END = "add new line after begin and before end";
    public static final String CFC_NEW_LINE_AFTER_END = "add new line after end";
    public static final String CFC_ELSE_NEW_LINE = "else new line";
    public static final String CFC_ELSE_SAME_LINE = "else same line";
    public static final String CFC_PARAM_SAME_LINE = "param same line";
    public static final String CFC_PARAM_NEW_LINE_OPEN_PAREN_NEXT_LINE = "param new line open paren next line";
    public static final String CFC_PARAM_NEW_LINE_OPEN_PAREN_SAME_LINE = "param new line open paren same line";
    public static final String CFC_PARAM_MORE_PER_LINE_IF_LESS_THAN = "param more per line if less than";
    public static final String CFC_PARAM_NEW_LINE_OPEN_PAREN_SAME_LINE_EMPTY_PARAMS_LIST = "param new line open paren same line empty params list";
    public static final String CFC_PARAM_SAME_LINE_COMPACT_WHITESPACE = "param same line compact whitespace";
    public static final String CFC_WRAP_BREAK_LINE = "wrap line";
    public static final String CFC_WRAP_MERGE_LINE = "wrap merge line";
    public static final String CFC_WRAP_TRIM_END_OF_LINE = "wrap trim end of line";
    public static final String CFC_WRAP_PARAM_PAREN_OPEN = "wrap param (";
    public static final String CFC_WRAP_PARAM_PAREN_CLOSE = "wrap param )";
    public static final String CFC_WRAP_PARAM_COMMA = "wrap param ,";
    public static final String CFC_WRAP_PARAM_MERGE = "wrap param merge";
    public static final String CFC_WRAP_STANDALONE_SL_COMMENT = "standalone sl comment wrap";
    public static final String CFC_WRAP_SL_COMMENT_ABOVE = "sl comment wrap above";
    public static final String CFC_WRAP_STANDALONE_ML_COMMENT = "standalone ml comment wrap";
    public static final String CFC_WRAP_PRE_ML_COMMENT = "pre ml comment wrap";
    public static final String CFC_WRAP_POST_ML_COMMENT = "post ml comment wrap";
    public static final String CFC_VERTICAL_ALIGN = "vertical align";
    public static final String CFC_REGEX_VERTICAL_ALIGN = "regex vertical align";
    public static final String CFC_PAREN_VERTICAL_ALIGN = "paren vertical align";

    public CFAction(int priority, int offsetInChunk, int nofCharsToDelete, String charsToInsert, String causedBy) {
        this.fPriority = priority;
        this.fOffsetInChunk = offsetInChunk;
        this.fNofCharsToDelete = nofCharsToDelete;
        this.fCharsToInsert = charsToInsert;
        this.fCausedBy = causedBy;
        this.fLineNo = 0;
        StringBuilder sb = new StringBuilder();
        sb.append("new action [by: ").append(this.fCausedBy).append("]:").append(" line:").append(this.fLineNo);
        CFSyso.println("CREATE_ACTION", sb);
        sb = new StringBuilder();
        sb.append("offset:").append(this.fOffsetInChunk).append(" delete:").append(this.fNofCharsToDelete).append(" insert: '").append(charsToInsert).append("'");
        CFSyso.println("CREATE_ACTION", sb);
    }

    public CFAction(int offsetInChunk, int nofCharsToDelete, String charsToInsert, String causedBy) {
        this(-1, offsetInChunk, nofCharsToDelete, charsToInsert, causedBy);
    }

    public void apply(DVTBaseFormattingStrategy strategy, StringBuilder chunkBuffer, List<CFPositionReference> startPositionReferences, List<CFPositionReference> endPositionReferences, int chunkOffsetInDocument) {
        DVTSourceViewerConfiguration svc;
        IApplyActionListener acl = null;
        if (strategy != null && (svc = strategy.getSourceViewerConfiguration()) != null) {
            acl = svc.getApplyActionListener();
        }
        int changeOffsetInDocument = chunkOffsetInDocument + this.fOffsetInChunk;
        int changeDelta = this.fCharsToInsert.length() - this.fNofCharsToDelete;
        StringBuilder sb = new StringBuilder();
        sb.append("apply action [by: ").append(this.fCausedBy).append("]:").append(" line:").append(this.fLineNo).append(" offsetInChunk:").append(this.fOffsetInChunk).append(" offsetInDoc:").append(changeOffsetInDocument);
        CFSyso.println("APPLY_ACTION", sb);
        sb = new StringBuilder();
        sb.append("delete:").append(this.fNofCharsToDelete).append(" insert: '").append(this.fCharsToInsert).append("'").append("len:").append(this.fCharsToInsert.length());
        CFSyso.println("APPLY_ACTION", sb);
        try {
            chunkBuffer.replace(this.fOffsetInChunk, this.fOffsetInChunk + this.fNofCharsToDelete, this.fCharsToInsert);
            if (acl != null) {
                acl.replace(changeOffsetInDocument, changeDelta);
            }
            for (CFPositionReference pr : startPositionReferences) {
                if (pr.fNewOffset + (pr.getLength() == 0 ? 0 : 1) <= changeOffsetInDocument) continue;
                pr.fNewOffsetDelta += changeDelta;
            }
            for (CFPositionReference pr : endPositionReferences) {
                if (pr.fNewOffset + (pr.getLength() == 0 ? 0 : 1) > changeOffsetInDocument || pr.fNewOffset + pr.fNewLength <= changeOffsetInDocument) continue;
                pr.fNewLengthDelta += changeDelta;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public int compareTo(CFAction other) {
        if (other.fOffsetInChunk == this.fOffsetInChunk) {
            if (other.fPriority == this.fPriority) {
                return 0;
            }
            if (other.fPriority < this.fPriority) {
                return 1;
            }
            return -1;
        }
        if (other.fOffsetInChunk < this.fOffsetInChunk) {
            return 1;
        }
        return -1;
    }

    public void setLineNo(int lineNo) {
        this.fLineNo = lineNo;
    }

    public String getCausedBy() {
        return this.fCausedBy;
    }
}

