/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.formatter.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.ui.editor.formatter.model.CFAction;
import ro.amiq.dvt.ui.editor.formatter.model.CFLineInfo;
import ro.amiq.dvt.ui.editor.formatter.model.CFPartition;
import ro.amiq.dvt.ui.editor.formatter.model.CFPositionReference;
import ro.amiq.dvt.ui.editor.formatter.strategies.DVTBaseFormattingStrategy;

public class CFChunk {
    public static final int CODE_CHUNK = 1;
    public static final int LITERAL_CHUNK = 2;
    public static final int SL_COMMENT_CHUNK = 3;
    public static final int ML_COMMENT_CHUNK = 4;
    public static final String CODE_MARKER_IN_EXPANSION = "codeMarkerInExpansion";
    private int fType;
    private CFPartition fEnclosingPartition;
    private final CFLineInfo fEnclosingLineInfo;
    private final boolean fIsFirstOnLine;
    private int fOffsetInDocument;
    private String fValue;
    private int fNLLength;
    private List<CFAction> fActions;
    private boolean fLiteralFragment;
    private Set<String> fInfos;

    public CFChunk(CFPartition enclosingPartition, CFLineInfo enclosingLineInfo, int offsetInDocument, int type, String value, boolean isFirstOnLine, String nlContent) {
        this.fType = type;
        this.fEnclosingPartition = enclosingPartition;
        this.fEnclosingLineInfo = enclosingLineInfo;
        this.fIsFirstOnLine = isFirstOnLine;
        this.fValue = value;
        this.fNLLength = nlContent != null ? nlContent.length() : 0;
        this.fOffsetInDocument = offsetInDocument;
        this.fActions = new ArrayList<CFAction>();
    }

    public String toString() {
        return this.fValue;
    }

    public int getType() {
        return this.fType;
    }

    public void setType(int type) {
        this.fType = type;
    }

    public CFPartition getEnclosingPartition() {
        return this.fEnclosingPartition;
    }

    public CFLineInfo getEnclosingLineInfo() {
        return this.fEnclosingLineInfo;
    }

    public int getLineNo() {
        return this.fEnclosingLineInfo.getLineNo();
    }

    public int getStartOffsetInLine() {
        return this.fEnclosingLineInfo.getPrevChunksLength(this);
    }

    public int getStartOffsetInLineAfterWS() {
        return this.getStartOffsetInLine() - this.fEnclosingLineInfo.getLineStartWSLength();
    }

    public boolean isFirstOnLine() {
        return this.fIsFirstOnLine;
    }

    public int getOffsetInDocument() {
        return this.fOffsetInDocument;
    }

    public String getValue() {
        return this.fValue;
    }

    public int getLength() {
        return this.fValue.length();
    }

    public boolean endsWithNL() {
        return this.fNLLength != 0;
    }

    public int getNLLength() {
        return this.fNLLength;
    }

    public int getNLOffset() {
        return this.fValue.length() - this.fNLLength;
    }

    public boolean isLiteralFragment() {
        return this.fLiteralFragment;
    }

    public void setLiteralFragment() {
        this.fLiteralFragment = true;
    }

    public int getNofActions() {
        if (this.fActions == null) {
            return 0;
        }
        return this.fActions.size();
    }

    public void addAction(CFAction action) {
        action.setLineNo(this.getLineNo());
        this.fActions.add(action);
    }

    public void applyActions(List<CFPositionReference> startPositionReferences, List<CFPositionReference> endPositionReferences) {
        DVTBaseFormattingStrategy strategy = this.fEnclosingPartition.getFormattingStrategy();
        ArrayList<CFAction> sortedActions = new ArrayList<CFAction>(this.fActions);
        Collections.sort(sortedActions, Collections.reverseOrder());
        StringBuilder chunkBuffer = new StringBuilder(this.fValue);
        int i = 0;
        while (i < sortedActions.size()) {
            CFAction action = (CFAction)sortedActions.get(i);
            if (this.fEnclosingLineInfo != null && (this.fEnclosingLineInfo.isFormatterOn() || "indent using tabs".equals(action.getCausedBy()) || "replace tabs with spaces".equals(action.getCausedBy()))) {
                action.apply(strategy, chunkBuffer, startPositionReferences, endPositionReferences, this.fOffsetInDocument);
            }
            ++i;
        }
        this.fActions.clear();
        this.fValue = chunkBuffer.toString();
    }

    public void setInfo(String info) {
        if (this.fInfos == null) {
            this.fInfos = new HashSet<String>();
        }
        this.fInfos.add(info);
    }

    public boolean hasInfo(String info) {
        if (this.fInfos == null) {
            return false;
        }
        return this.fInfos.contains(info);
    }
}

