/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.formatter.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.ui.editor.formatter.model.CFAction;
import ro.amiq.dvt.ui.editor.formatter.model.CFChunk;
import ro.amiq.dvt.ui.editor.formatter.scanner.vertical.CFVToken;

public class CFLineInfo {
    private final int fLineNo;
    private final int fLineStartWSLength;
    private List<CFChunk> fChunks;
    private int fIndent;
    private boolean fContainsPreproc;
    private boolean fContainsComplexPreproc;
    private boolean fFormatterOn;
    private boolean fIgnoreLine;
    private boolean canBeMergedWith = true;
    public boolean fForceSLCommentWrap = false;
    public boolean fInsertLineBreakBeforeToken = false;
    public int fCurrWrapIndentAfterLineBreakOrMerge = -1;
    private boolean fHasLineBreak = false;
    private int fLineBreakOffsetAdjustment = 0;
    private int fLineMergeOffsetAdjustment;
    private int fParamsCompactWSOffsetAdjustment;
    private CFChunk fSLCommentWrapChunk;
    private List<CFVToken> fVTokens;
    private boolean fIsVerticalAlignedByRegEx;
    private int fVParenDelta;
    private int fVParenDelDelta;

    public CFLineInfo(int lineNo, int lineStartWSLength) {
        this.fLineNo = lineNo;
        this.fLineStartWSLength = lineStartWSLength;
        this.fChunks = new ArrayList<CFChunk>();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CFLineInfo)) {
            return false;
        }
        CFLineInfo lineInfo = (CFLineInfo)obj;
        return this.fLineNo == lineInfo.fLineNo;
    }

    public int hashCode() {
        return this.fLineNo;
    }

    public String toString() {
        return this.getChunksContent();
    }

    public int getLineNo() {
        return this.fLineNo;
    }

    public int getLineStartWSLength() {
        return this.fLineStartWSLength;
    }

    public CFChunk getFirstChunk() {
        if (this.fChunks == null || this.fChunks.isEmpty()) {
            return null;
        }
        return this.fChunks.get(0);
    }

    public CFChunk getLastChunk() {
        if (this.fChunks == null || this.fChunks.isEmpty()) {
            return null;
        }
        return this.fChunks.get(this.fChunks.size() - 1);
    }

    public CFChunk getLastNonEmptyChunk() {
        if (this.fChunks == null || this.fChunks.isEmpty()) {
            return null;
        }
        int i = this.fChunks.size() - 1;
        while (i >= 0) {
            String chunkValue;
            CFChunk chunk = this.fChunks.get(i);
            if (chunk != null && (chunkValue = chunk.getValue()) != null && !chunkValue.trim().isEmpty()) {
                return chunk;
            }
            --i;
        }
        return null;
    }

    public CFChunk getLastNonEmptyNotCommentChunk() {
        if (this.fChunks == null || this.fChunks.isEmpty()) {
            return null;
        }
        int i = this.fChunks.size() - 1;
        while (i >= 0) {
            String value;
            CFChunk chunk = this.fChunks.get(i);
            if (chunk != null && chunk.getType() != 3 && chunk.getType() != 4 && (value = chunk.getValue()) != null && !value.trim().isEmpty()) {
                return chunk;
            }
            --i;
        }
        return null;
    }

    public boolean isPrecededByMLComment(CFChunk chunk) {
        CFChunk prevChunk = this.getChunkBefore(chunk);
        if (prevChunk == null) {
            return false;
        }
        return prevChunk.getType() == 4;
    }

    public CFChunk getChunkBefore(CFChunk refChunk) {
        CFChunk result = null;
        if (this.fChunks == null) {
            return result;
        }
        for (CFChunk chunk : this.fChunks) {
            if (chunk == null || chunk == refChunk) break;
            result = chunk;
        }
        return result;
    }

    public CFChunk getChunkAfter(CFChunk refChunk) {
        CFChunk result = null;
        if (this.fChunks == null) {
            return result;
        }
        int i = this.fChunks.size() - 1;
        while (i >= 0) {
            CFChunk chunk = this.fChunks.get(i);
            if (chunk == null || chunk == refChunk) break;
            result = chunk;
            --i;
        }
        return result;
    }

    public CFChunk getIndentableChunk() {
        CFChunk firstChunk = this.getFirstChunk();
        if (firstChunk != null && firstChunk.getType() == 2 && firstChunk.isLiteralFragment()) {
            if (firstChunk.hasInfo("codeMarkerInExpansion")) {
                return firstChunk;
            }
            return null;
        }
        return firstChunk;
    }

    public boolean startsWithLiteralFragment() {
        CFChunk firstChunk = this.getFirstChunk();
        return firstChunk != null && firstChunk.isLiteralFragment();
    }

    public boolean containsPreproc() {
        return this.fContainsPreproc;
    }

    public void setContainsPreproc() {
        this.fContainsPreproc = true;
    }

    public boolean containsComplexPreproc() {
        return this.fContainsComplexPreproc;
    }

    public void setContainsComplexPreproc() {
        this.fContainsComplexPreproc = true;
    }

    public void putChunk(CFChunk chunk) {
        this.fChunks.add(chunk);
    }

    public void setIndent(int indent) {
        this.fIndent = indent;
    }

    public String getChunksContent() {
        String result = "";
        if (this.fChunks == null) {
            return result;
        }
        for (CFChunk chunk : this.fChunks) {
            result = String.valueOf(result) + chunk.getValue();
        }
        return result;
    }

    public int getNLOffsetInLine() {
        CFChunk lastChunk = this.getLastChunk();
        if (lastChunk != null && lastChunk.endsWithNL()) {
            String lineContent = this.getChunksContent();
            return lineContent.length() - lastChunk.getNLLength();
        }
        return -1;
    }

    public int getNLOffsetInLineAfterWS() {
        CFChunk lastChunk = this.getLastChunk();
        if (lastChunk != null && lastChunk.endsWithNL()) {
            String lineContent = this.getChunksContent();
            return lineContent.length() - lastChunk.getNLLength() - this.getLineStartWSLength();
        }
        return -1;
    }

    public boolean hasCode() {
        if (this.fChunks == null) {
            return false;
        }
        for (CFChunk chunk : this.fChunks) {
            if (chunk.getType() == 3 || chunk.getType() == 4 || chunk.getValue().trim().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public int getNofTailWSChars() {
        int result = 0;
        String lineContent = this.getChunksContent();
        int i = this.getNLOffsetInLine() - 1 - this.getSLCommentWrapAdjustment();
        while (i >= 0) {
            if (' ' != lineContent.charAt(i)) break;
            ++result;
            --i;
        }
        return result;
    }

    public int hasClosingCurly(int startOffsetInChunk, CFChunk startChunk) {
        if (this.fChunks == null) {
            return -1;
        }
        int nofOpenCurly = 0;
        boolean startLooking = false;
        for (CFChunk chunk : this.fChunks) {
            String chunkValue;
            if (chunk == null) continue;
            if (!startLooking && startChunk == chunk) {
                startLooking = true;
            }
            if (!startLooking || chunk.getType() != 1 || (chunkValue = chunk.getValue()) == null) continue;
            int i = startOffsetInChunk;
            while (i < chunkValue.length()) {
                char c = chunkValue.charAt(i);
                if ('{' == c) {
                    ++nofOpenCurly;
                } else if ('}' == c && --nofOpenCurly == -1) {
                    return chunk.getStartOffsetInLineAfterWS() + i + 1;
                }
                ++i;
            }
            startOffsetInChunk = 0;
        }
        return -1;
    }

    public void createActionsToDeleteTailWS() {
        if (this.fChunks == null) {
            return;
        }
        boolean foundNWS = false;
        int i = this.fChunks.size() - 1;
        while (i >= 0) {
            CFChunk chunk = this.fChunks.get(i);
            if (chunk != null && (this.fSLCommentWrapChunk == null || this.fSLCommentWrapChunk != chunk)) {
                int nofCharsToDelete = 0;
                String chunkValue = chunk.getValue();
                int offsetInChunk = chunk.getLength() - chunk.getNLLength() - 1;
                while (offsetInChunk >= 0) {
                    if (' ' != chunkValue.charAt(offsetInChunk)) {
                        foundNWS = true;
                        break;
                    }
                    ++nofCharsToDelete;
                    --offsetInChunk;
                }
                if (nofCharsToDelete != 0) {
                    chunk.addAction(new CFAction(offsetInChunk + 1, nofCharsToDelete, "", "wrap trim end of line"));
                }
                if (foundNWS) break;
            }
            --i;
        }
    }

    public boolean areAllPrevChunksWS(CFChunk refChunk) {
        if (this.fChunks == null) {
            return true;
        }
        for (CFChunk chunk : this.fChunks) {
            if (chunk == null || chunk == refChunk) break;
            if (chunk.getValue().trim().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean areAllPrevChunksWSExtended(CFChunk refChunk) {
        if (this.fChunks == null) {
            return true;
        }
        for (CFChunk chunk : this.fChunks) {
            if (chunk == null || chunk == refChunk) break;
            if (chunk.hasInfo("codeMarkerInExpansion") || chunk.getValue().trim().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public int getPrevChunksLength(CFChunk refChunk) {
        int result = 0;
        if (this.fChunks == null) {
            return result;
        }
        for (CFChunk chunk : this.fChunks) {
            if (chunk == null || chunk == refChunk) break;
            result += chunk.getLength();
        }
        return result;
    }

    public boolean startsWithChar(char ch) {
        String line = this.getChunksContent().trim();
        return line != null && !line.isEmpty() && line.charAt(0) == ch;
    }

    public boolean endsWithChar(char ch) {
        String line = this.getChunksContent().trim();
        return line != null && !line.isEmpty() && line.charAt(line.length() - 1) == ch;
    }

    public boolean endsWithChars(Set<Character> chars) {
        if (chars == null) {
            return false;
        }
        String line = this.getChunksContent().trim();
        return line != null && !line.isEmpty() && chars.contains(Character.valueOf(line.charAt(line.length() - 1)));
    }

    public boolean canBeMergedWith() {
        return this.canBeMergedWith;
    }

    public void setCanBeMergedWith(boolean canBeMergedWith) {
        this.canBeMergedWith = canBeMergedWith;
    }

    public void setForceSLCommentWrap() {
        this.fForceSLCommentWrap = true;
    }

    public boolean isForceSLCommentWrap() {
        return this.fForceSLCommentWrap;
    }

    public boolean insertLineBreakBeforeToken() {
        return this.fInsertLineBreakBeforeToken;
    }

    public void setInsertLineBreakBeforeToken() {
        this.fInsertLineBreakBeforeToken = true;
    }

    public void resetInsertLineBreakBeforeToken() {
        this.fInsertLineBreakBeforeToken = false;
    }

    public int getCurrWrapIndent(int currLineIndent) {
        if (this.startsWithLiteralFragment() && !this.hasLineBreak()) {
            return 0;
        }
        if (this.fCurrWrapIndentAfterLineBreakOrMerge != -1) {
            return this.fCurrWrapIndentAfterLineBreakOrMerge;
        }
        return Math.max(currLineIndent, 0);
    }

    public int getCurrMergeIndent() {
        if (this.fCurrWrapIndentAfterLineBreakOrMerge != -1) {
            return this.fCurrWrapIndentAfterLineBreakOrMerge;
        }
        return this.fIndent;
    }

    public boolean hasLineBreak() {
        return this.fHasLineBreak;
    }

    public int getLineBreakOffsetAdjustment() {
        return this.fLineBreakOffsetAdjustment;
    }

    public void updateOnLineBreak(int nlOffsetOnTrimmedLine, int nlIndent) {
        this.fHasLineBreak = true;
        this.fLineBreakOffsetAdjustment = nlOffsetOnTrimmedLine;
        this.fLineMergeOffsetAdjustment = 0;
        this.fParamsCompactWSOffsetAdjustment = 0;
        this.fCurrWrapIndentAfterLineBreakOrMerge = nlIndent;
    }

    public int getLineMergeOffsetAdjustment() {
        return this.fLineMergeOffsetAdjustment - this.fParamsCompactWSOffsetAdjustment - this.getSLCommentWrapAdjustment();
    }

    public void updateOnLineMerge(int offsetAdjustment, int indent) {
        this.fLineMergeOffsetAdjustment = offsetAdjustment;
        this.fCurrWrapIndentAfterLineBreakOrMerge = indent;
    }

    public void updateOnParamsCompactWS(int offsetAdjustment) {
        this.fParamsCompactWSOffsetAdjustment += offsetAdjustment;
    }

    public void updateOnSLCommentWrap(CFChunk slChunk) {
        this.fSLCommentWrapChunk = slChunk;
    }

    public int getSLCommentWrapAdjustment() {
        if (this.fSLCommentWrapChunk != null) {
            return this.fSLCommentWrapChunk.getLength() - this.fSLCommentWrapChunk.getNLLength();
        }
        return 0;
    }

    public void addVToken(CFVToken aVToken) {
        if (this.fVTokens == null) {
            this.fVTokens = new ArrayList<CFVToken>();
        }
        this.fVTokens.add(aVToken);
    }

    public int getNofVTokens() {
        if (this.fVTokens == null) {
            return 0;
        }
        return this.fVTokens.size();
    }

    public void updateVDeltaInLine(int afterVDepth, int delta) {
        if (this.fVTokens == null) {
            return;
        }
        int i = afterVDepth + 1;
        while (i < this.fVTokens.size()) {
            CFVToken vToken = this.fVTokens.get(i);
            if (vToken != null) {
                vToken.updateVDeltaInLine(delta);
            }
            ++i;
        }
    }

    public List<CFVToken> getVTokensBefore(int afterVDepth) {
        ArrayList<CFVToken> result = new ArrayList<CFVToken>();
        if (this.fVTokens != null) {
            int i = 0;
            while (i < Math.min(afterVDepth, this.fVTokens.size())) {
                result.add(this.fVTokens.get(i));
                ++i;
            }
        }
        return result;
    }

    public boolean isVerticalAlignedByRegex() {
        return this.fIsVerticalAlignedByRegEx;
    }

    public void setIsVerticalAlignedByRegex() {
        this.fIsVerticalAlignedByRegEx = true;
    }

    public CFChunk getChunkAtOffset(int offsetInLine) {
        if (this.fChunks == null) {
            return null;
        }
        CFChunk prevChunk = null;
        for (CFChunk chunk : this.fChunks) {
            if (chunk == null) continue;
            if (chunk.getStartOffsetInLine() > offsetInLine) break;
            prevChunk = chunk;
        }
        return prevChunk;
    }

    public void setIgnoreLine(boolean ignoreLine) {
        this.fIgnoreLine = ignoreLine;
    }

    public boolean isIgnoreLine() {
        return this.fIgnoreLine;
    }

    public void setFormatterOn(boolean formatterOn) {
        this.fFormatterOn = formatterOn;
    }

    public boolean isFormatterOn() {
        return this.fFormatterOn;
    }

    public void setVParenDelta(int delta) {
        this.fVParenDelta = delta;
    }

    public int getVParenDelta() {
        return this.fVParenDelta;
    }

    public void addVParenDelDelta(int delta) {
        this.fVParenDelDelta += delta;
    }

    public int getVParenDelDelta() {
        return this.fVParenDelDelta;
    }
}

