/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.formatter.model;

import java.util.HashMap;
import java.util.Map;
import ro.amiq.dvt.ui.editor.formatter.model.CFLineInfo;

public class CFModel {
    private boolean fIgnoreCase;
    private boolean fIndentFirstLine;
    private int fFirstLineIndent;
    int fCurrLineNo;
    private int fLastLineNo;
    private Map<Integer, CFLineInfo> fLines;
    private int fNofOpenBracks;
    private int fNofOpenParens;
    private boolean fFormatterOn;
    private int fFormatterOnFromLineNo;
    private int fFormatterSkipLineNo;
    private int fCurrChunkOffsetInDocument;
    private boolean fIgnoreEncryptedCode;
    private int fIgnoreEncryptedCodeFromLineNo;

    public CFModel(boolean ignoreCase, boolean indentFirstLine, int firstLineIndent) {
        this.fIgnoreCase = ignoreCase;
        this.fIndentFirstLine = indentFirstLine;
        this.fFirstLineIndent = firstLineIndent;
        this.fCurrLineNo = 1;
        this.fLastLineNo = -1;
        this.fLines = new HashMap<Integer, CFLineInfo>();
        this.fNofOpenParens = 0;
        this.fNofOpenBracks = 0;
        this.fFormatterOn = true;
        this.fFormatterOnFromLineNo = 0;
        this.fFormatterSkipLineNo = -1;
    }

    public boolean indentFirstLine() {
        return this.fIndentFirstLine;
    }

    public int getFirstLineIndent() {
        return this.fFirstLineIndent;
    }

    public boolean ignoreCase() {
        return this.fIgnoreCase;
    }

    public int getCurrentLineNo() {
        return this.fCurrLineNo;
    }

    public void setCurrentLineNo(int lineNo) {
        this.fCurrLineNo = lineNo;
    }

    public CFLineInfo getLineInfo(int lineNo) {
        return this.fLines.get(lineNo);
    }

    public void setLineInfo(CFLineInfo line) {
        if (line == null) {
            return;
        }
        int lineNo = line.getLineNo();
        if (lineNo > this.fLastLineNo) {
            this.fLastLineNo = lineNo;
        }
        this.fLines.put(lineNo, line);
    }

    public int getLastLineNo() {
        return this.fLastLineNo;
    }

    public CFLineInfo getLastLineInfo() {
        if (this.fLastLineNo == -1) {
            return null;
        }
        return this.fLines.get(this.fLastLineNo);
    }

    public int getNofOpenParens() {
        return this.fNofOpenParens;
    }

    public void incrNofOpenParens() {
        ++this.fNofOpenParens;
    }

    public void decrNofOpenParens() {
        if (this.fNofOpenParens == 0 && this.fNofOpenBracks > 0) {
            --this.fNofOpenBracks;
        } else {
            --this.fNofOpenParens;
        }
    }

    public int getNofOpenBracks() {
        return this.fNofOpenBracks;
    }

    public void incrNofOpenBracks() {
        ++this.fNofOpenBracks;
    }

    public void decrNofOpenBracks() {
        if (this.fNofOpenBracks == 0 && this.fNofOpenParens > 0) {
            --this.fNofOpenParens;
        } else {
            --this.fNofOpenBracks;
        }
    }

    public CFLineInfo getLastNonWhitespaceLineUntilRefLine(int refLineNo) {
        CFLineInfo result = null;
        int lineNo = refLineNo;
        while (lineNo > 0) {
            String lineContent;
            result = this.getLineInfo(lineNo);
            if (result != null && (lineContent = result.getChunksContent()).trim().length() != 0) break;
            --lineNo;
        }
        return result;
    }

    public CFLineInfo getPrevNonWhitespaceLine(int lineNo) {
        return this.getLastNonWhitespaceLineUntilRefLine(lineNo - 1);
    }

    public CFLineInfo getLastNonWhitespaceLine() {
        return this.getLastNonWhitespaceLineUntilRefLine(this.fLastLineNo);
    }

    public CFLineInfo getPrevLineWithCode(int lineNo) {
        CFLineInfo result = null;
        int prevLineNo = lineNo - 1;
        while (prevLineNo > 0) {
            CFLineInfo lineInfo = this.getLineInfo(prevLineNo);
            if (lineInfo != null && lineInfo.hasCode()) {
                result = lineInfo;
                break;
            }
            --prevLineNo;
        }
        return result;
    }

    public CFLineInfo getNextLineWithCode(int lineNo) {
        CFLineInfo result = null;
        int lastLine = this.getLastLineNo();
        int nextLineNo = lineNo;
        while (nextLineNo <= lastLine) {
            CFLineInfo lineInfo = this.getLineInfo(nextLineNo);
            if (lineInfo != null && lineInfo.hasCode()) {
                result = lineInfo;
                break;
            }
            ++nextLineNo;
        }
        return result;
    }

    public void setFormatterOn(boolean formatterOn, int fromLineNo) {
        if (formatterOn != this.fFormatterOn) {
            this.fFormatterOn = formatterOn;
            this.fFormatterOnFromLineNo = fromLineNo;
        }
    }

    public void setFormatterSkip(int skipLineNo) {
        this.fFormatterSkipLineNo = skipLineNo;
    }

    public boolean isFormatterOn(int lineNo) {
        if (lineNo == this.fFormatterSkipLineNo) {
            return false;
        }
        if (this.fFormatterOn && lineNo >= this.fFormatterOnFromLineNo) {
            return true;
        }
        if (!this.fFormatterOn && lineNo >= this.fFormatterOnFromLineNo) {
            return false;
        }
        return false;
    }

    public int getCurrentChunkOffsetInDocument() {
        return this.fCurrChunkOffsetInDocument;
    }

    public void setCurrentChunkOffsetInDocument(int chunkOffsetInDocument) {
        this.fCurrChunkOffsetInDocument = chunkOffsetInDocument;
    }

    public void setIgnoreEncryptedCode(boolean shouldIgnore, int lineNo) {
        this.fIgnoreEncryptedCode = shouldIgnore;
        this.fIgnoreEncryptedCodeFromLineNo = lineNo;
    }

    public boolean ignoreLine(int lineNo) {
        if (this.fIgnoreEncryptedCode && lineNo >= this.fIgnoreEncryptedCodeFromLineNo) {
            return true;
        }
        if (!this.fIgnoreEncryptedCode && lineNo == this.fIgnoreEncryptedCodeFromLineNo - 1) {
            return true;
        }
        if (!this.fIgnoreEncryptedCode && lineNo >= this.fIgnoreEncryptedCodeFromLineNo) {
            return false;
        }
        return false;
    }
}

