/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.formatter.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.TypedPosition;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.formatter.model.CFAction;
import ro.amiq.dvt.ui.editor.formatter.model.CFChunk;
import ro.amiq.dvt.ui.editor.formatter.model.CFLineInfo;
import ro.amiq.dvt.ui.editor.formatter.model.CFModel;
import ro.amiq.dvt.ui.editor.formatter.model.CFPositionReference;
import ro.amiq.dvt.ui.editor.formatter.scanner.ICFTokenScanner;
import ro.amiq.dvt.ui.editor.formatter.strategies.DVTBaseCodeFormattingStrategy;
import ro.amiq.dvt.ui.editor.formatter.strategies.DVTBaseFormattingStrategy;
import ro.amiq.dvt.ui.editor.formatter.util.CFNLSplitter;
import ro.amiq.dvt.ui.editor.formatter.util.CFSyso;
import ro.amiq.dvt.ui.editor.formatter.util.CFUtils;

public class CFPartition {
    private static final String FORMATTER_OFF_PRAGMA = "@formatter:off";
    private static final String FORMATTER_ON_PRAGMA = "@formatter:on";
    private static final String FORMATTER_SKIP_PRAGMA = "@formatter:skip";
    private static final String BEGIN_ENCRYPTED_PRAGMA = "pragma protect begin_protected";
    private static final String END_ENCRYPTED_PRAGMA = "pragma protect end_protected";
    private static final String OPEN_PROTECTED_ENCRYPTED_PRAGMA = "`protected";
    private static final String CLOSE_PROTECTED_ENCRYPTED_PRAGMA = "`endprotected";
    private static final String BEGIN_PROTECTED_ENCRYPTED_PRAGMA = "`pragma protect begin_protected";
    private static final String END_PROTECTED_ENCRYPTED_PRAGMA = "`pragma protect end_protected";
    private TypedPosition fTypedPosition;
    private DVTBaseFormattingStrategy fFormattingStrategy;
    private String fInitialContent;
    private List<CFChunk> fChunks;
    private List<CFPartition> fSubPartitions;

    public CFPartition(DVTBaseFormattingStrategy formattingStrategy, TypedPosition typedPosition, String initialContent) {
        this.fFormattingStrategy = formattingStrategy;
        this.fTypedPosition = typedPosition;
        this.fInitialContent = initialContent;
        this.fChunks = new ArrayList<CFChunk>();
    }

    public TypedPosition getTypedPosition() {
        return this.fTypedPosition;
    }

    public DVTBaseFormattingStrategy getFormattingStrategy() {
        return this.fFormattingStrategy;
    }

    public void addChunk(CFChunk chunk) {
        if (this.fChunks != null) {
            this.fChunks.add(chunk);
        }
    }

    public boolean isFirstChunk(CFChunk chunk) {
        if (this.fChunks == null || this.fChunks.isEmpty()) {
            return false;
        }
        return chunk == this.fChunks.get(0);
    }

    public boolean isLastChunk(CFChunk chunk) {
        if (this.fChunks == null || this.fChunks.isEmpty()) {
            return false;
        }
        return chunk == this.fChunks.get(this.fChunks.size() - 1);
    }

    public void createChunks(CFModel model) {
        if (this.fSubPartitions != null) {
            for (CFPartition partition : this.fSubPartitions) {
                if (partition == null) continue;
                partition.createChunks(model);
            }
        } else if (this.fInitialContent != null) {
            this.fChunks.clear();
            String filteredContent = this.fFormattingStrategy.filterInitialPartitionContent(this.fInitialContent);
            this.createChunks(filteredContent, model);
        } else {
            String currentContent = this.getContent();
            this.fChunks.clear();
            this.createChunks(currentContent, model);
        }
        this.fInitialContent = null;
    }

    private void createChunks(String partitionContent, CFModel model) {
        if (model == null) {
            return;
        }
        if (partitionContent == null || partitionContent.isEmpty()) {
            return;
        }
        if (this.fFormattingStrategy == null) {
            return;
        }
        int currentLineNo = model.getCurrentLineNo();
        int cursor = 0;
        CFNLSplitter nlSplitter = new CFNLSplitter(partitionContent);
        int nlStart = partitionContent.length();
        int nlEnd = 0;
        String nlContent = "";
        boolean endsWithNL = false;
        boolean isFirstChunkInPartition = true;
        do {
            boolean isCodeMarkerInExpansion;
            boolean isFirstChunkOnLine;
            if (endsWithNL = nlSplitter.find()) {
                nlStart = nlSplitter.getNLStartOffset();
                nlEnd = nlSplitter.getNLEndOffset();
                nlContent = nlSplitter.getNLGroup();
            } else {
                nlStart = partitionContent.length();
                nlEnd = partitionContent.length();
                nlContent = "";
            }
            String chunkValue = String.valueOf(partitionContent.substring(cursor, nlStart)) + nlContent;
            if (chunkValue.isEmpty()) continue;
            CFLineInfo lineInfo = model.getLineInfo(currentLineNo);
            if (lineInfo == null) {
                int lineStartWSLength;
                isFirstChunkOnLine = true;
                isCodeMarkerInExpansion = this.fFormattingStrategy.isCodeMarkerInExpansion(chunkValue);
                if (!isCodeMarkerInExpansion && this.fFormattingStrategy.getChunkType() == 2 && !isFirstChunkInPartition) {
                    lineStartWSLength = 0;
                } else {
                    int nofWS = 0;
                    int wsIndex = cursor;
                    while (wsIndex < partitionContent.length() && partitionContent.charAt(wsIndex) == ' ') {
                        ++nofWS;
                        ++wsIndex;
                    }
                    lineStartWSLength = nofWS;
                }
                lineInfo = new CFLineInfo(currentLineNo, lineStartWSLength);
                model.setLineInfo(lineInfo);
            } else {
                isFirstChunkOnLine = false;
                isCodeMarkerInExpansion = false;
            }
            CFChunk chunk = new CFChunk(this, lineInfo, model.getCurrentChunkOffsetInDocument(), this.fFormattingStrategy.getChunkType(), chunkValue, isFirstChunkOnLine, nlContent);
            if (isCodeMarkerInExpansion) {
                chunk.setInfo("codeMarkerInExpansion");
            }
            lineInfo.putChunk(chunk);
            this.addChunk(chunk);
            model.setCurrentChunkOffsetInDocument(model.getCurrentChunkOffsetInDocument() + chunkValue.length());
            if (this.fFormattingStrategy.getChunkType() == 2 && !isFirstChunkInPartition) {
                chunk.setLiteralFragment();
            }
            if (chunk.getType() == 1) {
                this.ignoreEncryptedPragmas(model, chunkValue, currentLineNo, OPEN_PROTECTED_ENCRYPTED_PRAGMA, CLOSE_PROTECTED_ENCRYPTED_PRAGMA);
                this.ignoreEncryptedPragmas(model, chunkValue, currentLineNo, BEGIN_PROTECTED_ENCRYPTED_PRAGMA, END_PROTECTED_ENCRYPTED_PRAGMA);
            }
            if (chunk.getType() == 3) {
                this.ignoreEncryptedPragmas(model, chunkValue, currentLineNo, BEGIN_ENCRYPTED_PRAGMA, END_ENCRYPTED_PRAGMA);
            }
            if (chunk.getType() == 3 || chunk.getType() == 4) {
                this.disableFormattingForFormatPragmas(model, chunkValue, currentLineNo);
            }
            if (isFirstChunkOnLine) {
                lineInfo.setIgnoreLine(this.fFormattingStrategy.ignoreLine(chunkValue) || model.ignoreLine(currentLineNo));
            }
            lineInfo.setFormatterOn(model.isFormatterOn(currentLineNo));
            if (model.getLineInfo(currentLineNo) == null || model.getLineInfo(currentLineNo).getLastChunk().endsWithNL()) {
                ++currentLineNo;
            }
            isFirstChunkInPartition = false;
            cursor = nlEnd;
        } while (endsWithNL);
        model.setCurrentLineNo(currentLineNo);
    }

    private void disableFormattingForFormatPragmas(CFModel model, String chunkValue, int currentLineNo) {
        int onIndex = -1;
        int offIndex = -1;
        int startFrom = 0;
        do {
            onIndex = chunkValue.indexOf(FORMATTER_ON_PRAGMA, startFrom);
            offIndex = chunkValue.indexOf(FORMATTER_OFF_PRAGMA, startFrom);
            if (onIndex != -1 && (offIndex == -1 || onIndex < offIndex)) {
                model.setFormatterOn(true, currentLineNo + 1);
                startFrom = onIndex + FORMATTER_ON_PRAGMA.length();
                continue;
            }
            if (offIndex == -1 || onIndex != -1 && offIndex >= onIndex) continue;
            model.setFormatterOn(false, currentLineNo);
            startFrom = offIndex + FORMATTER_OFF_PRAGMA.length();
        } while (onIndex != -1 || offIndex != -1);
        if (chunkValue.contains(FORMATTER_SKIP_PRAGMA)) {
            model.setFormatterSkip(currentLineNo);
        }
    }

    private void ignoreEncryptedPragmas(CFModel model, String chunkValue, int currentLineNo, String startKeyword, String endKeyword) {
        int onIndex = -1;
        int offIndex = -1;
        int startFrom = 0;
        do {
            onIndex = chunkValue.indexOf(endKeyword, startFrom);
            offIndex = chunkValue.indexOf(startKeyword, startFrom);
            if (onIndex != -1 && (offIndex == -1 || onIndex < offIndex)) {
                model.setIgnoreEncryptedCode(false, currentLineNo + 1);
                startFrom = onIndex + endKeyword.length();
                continue;
            }
            if (offIndex == -1 || onIndex != -1 && offIndex >= onIndex) continue;
            model.setIgnoreEncryptedCode(true, currentLineNo);
            startFrom = offIndex + startKeyword.length();
        } while (onIndex != -1 || offIndex != -1);
    }

    public void scanTokensInOrder(ICFTokenScanner tokenScanner) {
        if (this.fSubPartitions != null) {
            for (CFPartition partition : this.fSubPartitions) {
                if (partition == null) continue;
                partition.scanTokensInOrder(tokenScanner);
            }
        } else {
            if (this.fChunks == null || this.fFormattingStrategy == null || tokenScanner == null) {
                return;
            }
            tokenScanner.startPartition(this.fFormattingStrategy);
            for (CFChunk chunk : this.fChunks) {
                if (chunk == null) continue;
                this.fFormattingStrategy.scanTokensInOrder(tokenScanner, chunk);
            }
        }
    }

    public int replaceTabsWithSpaces(int offset) {
        if (this.fSubPartitions != null) {
            for (CFPartition partition : this.fSubPartitions) {
                if (partition == null) continue;
                return partition.replaceTabsWithSpaces(offset);
            }
        }
        if (this.fChunks == null || this.fFormattingStrategy == null) {
            return 0;
        }
        for (CFChunk chunk : this.fChunks) {
            if (chunk == null) continue;
            offset = this.fFormattingStrategy.replaceTabsWithSpaces(chunk, offset);
        }
        return offset;
    }

    public void trimEmptyLines() {
        if (this.fSubPartitions != null) {
            for (CFPartition partition : this.fSubPartitions) {
                if (partition == null) continue;
                partition.trimEmptyLines();
            }
        } else {
            if (this.fChunks == null || this.fFormattingStrategy == null) {
                return;
            }
            for (CFChunk chunk : this.fChunks) {
                if (chunk == null) continue;
                this.fFormattingStrategy.trimEmptyLines(chunk);
            }
        }
    }

    public void compactConsecutiveEmptyLines(CFModel model, boolean isLastPartition) {
        CFLineInfo lastNWLine = model.getLastNonWhitespaceLine();
        if (lastNWLine == null) {
            return;
        }
        if (this.fSubPartitions != null) {
            for (CFPartition partition : this.fSubPartitions) {
                if (partition == null) continue;
                partition.compactConsecutiveEmptyLines(model, isLastPartition);
            }
        } else {
            if (this.fChunks == null || this.fFormattingStrategy == null) {
                return;
            }
            for (CFChunk chunk : this.fChunks) {
                CFLineInfo lineInfo;
                if (chunk == null || (lineInfo = chunk.getEnclosingLineInfo()) == null) continue;
                if (isLastPartition && lineInfo.getLineNo() >= lastNWLine.getLineNo()) {
                    this.fFormattingStrategy.compactConsecutiveEmptyLines(chunk, model, true);
                    break;
                }
                this.fFormattingStrategy.compactConsecutiveEmptyLines(chunk, model, false);
            }
        }
        this.fFormattingStrategy.resetNofConsecutiveEmptyLines();
    }

    public void indentStandaloneComments(CFModel model) {
        if (this.fSubPartitions != null) {
            int i = this.fSubPartitions.size() - 1;
            while (i >= 0) {
                CFPartition partition = this.fSubPartitions.get(i);
                if (partition != null) {
                    partition.indentStandaloneComments(model);
                }
                --i;
            }
        } else {
            if (this.fChunks == null || this.fFormattingStrategy == null) {
                return;
            }
            int i = this.fChunks.size() - 1;
            while (i >= 0) {
                CFChunk chunk = this.fChunks.get(i);
                if (chunk != null) {
                    this.fFormattingStrategy.indentStandaloneComments(model, chunk);
                }
                --i;
            }
        }
    }

    public void applyFormattingActions(List<CFPositionReference> positionReferences) {
        if (this.fSubPartitions != null) {
            int i = this.fSubPartitions.size() - 1;
            while (i >= 0) {
                CFPartition partition = this.fSubPartitions.get(i);
                if (partition != null) {
                    partition.applyFormattingActions(positionReferences);
                }
                --i;
            }
        } else {
            if (this.fChunks == null || this.fChunks.isEmpty()) {
                return;
            }
            int nofActionsToApply = 0;
            for (CFChunk chunk : this.fChunks) {
                if (chunk == null) continue;
                nofActionsToApply += chunk.getNofActions();
            }
            if (nofActionsToApply > 0) {
                long timestamp = System.currentTimeMillis();
                ArrayList<CFPositionReference> affectedStartPositionReferences = new ArrayList<CFPositionReference>();
                ArrayList<CFPositionReference> affectedEndPositionReferences = new ArrayList<CFPositionReference>();
                CFChunk firstChunk = this.fChunks.get(0);
                CFChunk lastChunk = this.fChunks.get(this.fChunks.size() - 1);
                int startPartitionOffset = firstChunk.getOffsetInDocument();
                int endPartitionOffset = lastChunk.getOffsetInDocument() + lastChunk.getLength();
                CFSyso.println("POSITIONS_AFFECTED", "PARTITION START: " + startPartitionOffset);
                CFSyso.println("POSITIONS_AFFECTED", "PARTITION END: " + endPartitionOffset);
                CFSyso.println("POSITIONS_AFFECTED", "ACTIONS: " + nofActionsToApply);
                for (CFPositionReference pr : positionReferences) {
                    if (pr.fNewOffset >= startPartitionOffset) {
                        affectedStartPositionReferences.add(pr);
                    }
                    if (pr.fNewOffset + pr.fNewLength < startPartitionOffset || pr.fNewOffset > endPartitionOffset || pr.fNewLength == 1 && "REFLECTION".equals(pr.getCategory())) continue;
                    affectedEndPositionReferences.add(pr);
                }
                CFSyso.println("POSITIONS_AFFECTED", "AFFECTED POSITIONS START: " + affectedStartPositionReferences.size() + "/" + positionReferences.size());
                CFSyso.println("POSITIONS_AFFECTED", "AFFECTED POSITIONS END: " + affectedEndPositionReferences.size() + "/" + positionReferences.size());
                int i = this.fChunks.size() - 1;
                while (i >= 0) {
                    CFChunk chunk = this.fChunks.get(i);
                    if (chunk != null) {
                        chunk.applyActions(affectedStartPositionReferences, affectedEndPositionReferences);
                    }
                    --i;
                }
                CFSyso.println("POSITIONS_AFFECTED", "DURATION: " + (System.currentTimeMillis() - timestamp) + " ms");
            }
        }
    }

    public String getContent() {
        if (this.fInitialContent != null) {
            return this.fInitialContent;
        }
        StringBuilder result = new StringBuilder();
        if (this.fSubPartitions != null) {
            for (CFPartition partition : this.fSubPartitions) {
                if (partition == null) continue;
                result.append(partition.getContent());
            }
        } else {
            if (this.fChunks == null) {
                return result.toString();
            }
            for (CFChunk chunk : this.fChunks) {
                if (chunk == null) continue;
                result.append(chunk.getValue());
            }
        }
        return result.toString();
    }

    public void createSLCommentAboveSubPartitions(List<String> slCommentWrapStrings, String slCommentPrefix, int indent, CFChunk beforeChunk) {
        if (slCommentWrapStrings == null) {
            return;
        }
        DVTSourceViewerConfiguration sourceViewerConfiguration = this.fFormattingStrategy.getSourceViewerConfiguration();
        if (sourceViewerConfiguration == null) {
            return;
        }
        DVTBaseFormattingStrategy slCommentFormattingStrategy = sourceViewerConfiguration.getSLCommentFormattingStrategy();
        if (slCommentFormattingStrategy == null) {
            return;
        }
        this.fSubPartitions = new ArrayList<CFPartition>();
        CFPartition prevCodePartition = new CFPartition(this.fFormattingStrategy, null, null);
        this.fSubPartitions.add(prevCodePartition);
        int i = 0;
        while (i < slCommentWrapStrings.size()) {
            CFPartition newCodePartition = new CFPartition(this.fFormattingStrategy, null, null);
            this.fSubPartitions.add(newCodePartition);
            CFChunk newCodeChunk = new CFChunk(this, beforeChunk.getEnclosingLineInfo(), beforeChunk.getOffsetInDocument(), 1, "", true, "");
            newCodePartition.addChunk(newCodeChunk);
            newCodeChunk.addAction(new CFAction(0, 0, CFUtils.getInstance().getWhitespace(indent), "sl comment wrap above"));
            CFPartition newCommentPartition = new CFPartition(slCommentFormattingStrategy, null, null);
            this.fSubPartitions.add(newCommentPartition);
            StringBuilder slCommentPartitionContent = new StringBuilder();
            if (i != 0) {
                slCommentPartitionContent.append(slCommentPrefix);
            }
            slCommentPartitionContent.append(slCommentWrapStrings.get(i));
            slCommentPartitionContent.append(sourceViewerConfiguration.getLineDelimiter());
            CFChunk newCommentChunk = new CFChunk(this, beforeChunk.getEnclosingLineInfo(), beforeChunk.getOffsetInDocument(), 3, "", false, "");
            newCommentPartition.addChunk(newCommentChunk);
            newCommentChunk.addAction(new CFAction(0, 0, slCommentPartitionContent.toString(), "sl comment wrap above"));
            ++i;
        }
        CFPartition nextCodePartition = new CFPartition(this.fFormattingStrategy, null, null);
        this.fSubPartitions.add(nextCodePartition);
        boolean foundBeforeChunk = false;
        for (CFChunk chunk : this.fChunks) {
            if (chunk == beforeChunk) {
                foundBeforeChunk = true;
            }
            if (!foundBeforeChunk) {
                prevCodePartition.addChunk(chunk);
                continue;
            }
            nextCodePartition.addChunk(chunk);
        }
    }

    public CFChunk createCodeChunkBeforeSubPartitions() {
        DVTSourceViewerConfiguration sourceViewerConfiguration = this.fFormattingStrategy.getSourceViewerConfiguration();
        if (sourceViewerConfiguration == null) {
            return null;
        }
        DVTBaseCodeFormattingStrategy codeFormattingStrategy = sourceViewerConfiguration.getCodeFormattingStrategy();
        if (codeFormattingStrategy == null) {
            return null;
        }
        this.fSubPartitions = new ArrayList<CFPartition>();
        if (this.fChunks == null || this.fChunks.isEmpty()) {
            return null;
        }
        CFChunk firstChunk = this.fChunks.get(0);
        if (firstChunk == null) {
            return null;
        }
        CFLineInfo firstChunkLineInfo = firstChunk.getEnclosingLineInfo();
        if (firstChunkLineInfo == null) {
            return null;
        }
        CFChunk codeChunk = new CFChunk(this, firstChunkLineInfo, firstChunk.getOffsetInDocument(), 1, "", firstChunk.isFirstOnLine(), "");
        CFPartition prevCodePartition = new CFPartition(codeFormattingStrategy, null, null);
        prevCodePartition.addChunk(codeChunk);
        this.fSubPartitions.add(prevCodePartition);
        CFPartition currPartition = new CFPartition(this.fFormattingStrategy, null, null);
        currPartition.fChunks = this.fChunks;
        this.fSubPartitions.add(currPartition);
        return codeChunk;
    }
}

