/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.formatter.preferences;

import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.MarginPainter;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFPreferences;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFPreferencesPage;
import ro.amiq.dvt.ui.preferences.BooleanFieldEditor2;
import ro.amiq.dvt.ui.preferences.DVTPreviewSourceViewer;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.utils.IntegerFieldEditor;

public abstract class CFBasePrefTabPage
extends FieldEditorPreferencePage {
    protected static final String LEAVE_AS_IS = "Leave as is";
    protected CFPreferences fPreferences;
    protected CFPreferencesPage fPreferencesPage;
    protected Composite fPreviewContainer;
    protected Composite fPreviewerShowInvisibleCharsContainer;
    protected BooleanFieldEditor2 fPreviewerShowInvisibleChars;
    protected Composite fPreviewerLineWrapWidthContainer;
    protected IntegerFieldEditor fPreviewerLineWrapWidth;
    protected DVTPreviewSourceViewer fPreviewViewer;
    protected IDocumentSetupParticipant fDocSetup;
    protected DVTSourceViewerConfiguration fConfiguration;
    protected MarginPainter fMarginPainter;
    protected PixelConverter fPixelConverter;
    private Link fTextEditorsLink;

    protected void createFieldEditors() {
    }

    public CFBasePrefTabPage(CFPreferences preferences, CFPreferencesPage preferencesPage) {
        super(1);
        this.fPreferences = preferences;
        this.fPreferencesPage = preferencesPage;
        this.fDocSetup = this.fPreferencesPage.createPreviewDocumentSetupParticipant();
        this.fConfiguration = this.fPreferencesPage.createPreviewSourceViewerconfiguration();
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        if (this.fPixelConverter == null) {
            this.fPixelConverter = new PixelConverter((Control)parent);
        }
        SashForm sashForm = new SashForm(parent, 256);
        sashForm.setFont(parent.getFont());
        Composite scrollContainer = new Composite((Composite)sashForm, 0);
        GridData gridData = new GridData(4, 4, true, true);
        scrollContainer.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        scrollContainer.setLayout((Layout)layout);
        ScrolledComposite scroll = new ScrolledComposite(scrollContainer, 768);
        scroll.setLayoutData((Object)new GridData(4, 4, true, true));
        scroll.setExpandHorizontal(true);
        scroll.setExpandVertical(true);
        int settingswidth = this.fPixelConverter.convertWidthInCharsToPixels(80);
        scroll.setMinWidth(settingswidth);
        Composite settingsContainer = new Composite((Composite)scroll, 0);
        settingsContainer.setFont(sashForm.getFont());
        scroll.setContent((Control)settingsContainer);
        layout = new GridLayout(1, false);
        settingsContainer.setLayout((Layout)layout);
        gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = settingswidth;
        settingsContainer.setLayoutData((Object)gridData);
        this.doCreatePreferences(settingsContainer);
        Composite previewPane = new Composite((Composite)sashForm, 0);
        previewPane.setLayout((Layout)this.createGridLayout(1, false));
        previewPane.setFont(sashForm.getFont());
        this.doCreatePreviewPane(previewPane);
        this.initialize();
        sashForm.setWeights(new int[]{3, 4});
        return sashForm;
    }

    protected void addTextEditorsLink(Composite parent) {
        this.fTextEditorsLink = new Link(parent, 64);
        GridData gd = new GridData(4, 0x1000000, true, false, 2, 1);
        gd.widthHint = 100;
        this.fTextEditorsLink.setLayoutData((Object)gd);
        this.fTextEditorsLink.setText("Insert Spaces for Tabs and Tab Width can be configured on the <a href=\"org.eclipse.ui.preferencePages.GeneralTextEditor\">Text Editors</a> preference page. <a href=\"ro.amiq.dvt.EditorsPreferencePage\">\nAuto-detect indentation</a> overrides these values.");
        this.fTextEditorsLink.setFont(parent.getFont());
        DVTUiUtils.setPlatformLinkColor((Link)this.fTextEditorsLink);
        this.fTextEditorsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)CFBasePrefTabPage.this.fTextEditorsLink.getShell(), (String)e.text, null, null);
            }
        });
        String linktooltip = "Go To Target Preference Page";
        this.fTextEditorsLink.setToolTipText(linktooltip);
    }

    protected void setEnabled(boolean enabled) {
        this.fPreviewerShowInvisibleChars.setEnabled(enabled, this.fPreviewerShowInvisibleCharsContainer);
        this.fPreviewerLineWrapWidth.setEnabled(enabled, this.fPreviewerLineWrapWidthContainer);
        this.fPreviewViewer.getTextWidget().setEnabled(enabled);
        if (this.fTextEditorsLink != null) {
            this.fTextEditorsLink.setEnabled(enabled);
        }
    }

    private GridLayout createGridLayout(int numColumns, boolean margins) {
        GridLayout layout = new GridLayout(numColumns, false);
        layout.verticalSpacing = this.fPixelConverter.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.fPixelConverter.convertHorizontalDLUsToPixels(4);
        if (margins) {
            layout.marginHeight = this.fPixelConverter.convertVerticalDLUsToPixels(7);
            layout.marginWidth = this.fPixelConverter.convertHorizontalDLUsToPixels(7);
        } else {
            layout.marginHeight = 0;
            layout.marginWidth = 0;
        }
        return layout;
    }

    protected abstract void doCreatePreferences(Composite var1);

    public IPreferenceStore getPreferenceStore() {
        return this.fPreferencesPage.getPreferenceStore();
    }

    public void doRestoreDefaults() {
        this.performDefaults();
        this.fPreferencesPage.refreshEnable();
        this.updatePreviewerContent();
    }

    protected void performDefaults() {
        super.performDefaults();
        this.fPreferencesPage.setPreviewShowInvisibleCharsEnabled(false);
        this.fPreferences.restoreDefaultInt("format.preview.line_wrap_threshold");
    }

    protected Composite createContainer(Composite parent, int horizontalIndent) {
        Composite result = new Composite(parent, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        result.setLayout((Layout)gl);
        GridData gd = new GridData(4, 4, false, false, 2, 1);
        gd.horizontalIndent = horizontalIndent;
        gd.grabExcessHorizontalSpace = true;
        result.setLayoutData((Object)gd);
        result.setFont(parent.getFont());
        return result;
    }

    protected BooleanFieldEditor2 createBooleanFieldEditor(Composite parent, final String prefName, String prefText) {
        BooleanFieldEditor2 result = new BooleanFieldEditor2(prefName, prefText, 0, parent);
        result.getChangeControl(parent).addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CFBasePrefTabPage.this.processPreferenceChanged(prefName);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        return result;
    }

    protected IntegerFieldEditor createIntegerFieldEditor(Composite parent, final String prefName, String prefText, int width) {
        IntegerFieldEditor result = new IntegerFieldEditor(prefName, prefText, width, parent);
        result.getTextControl(parent).addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CFBasePrefTabPage.this.processPreferenceChanged(prefName);
            }
        });
        return result;
    }

    protected StringFieldEditor createStringFieldEditor(Composite parent, final String prefName, String prefText) {
        StringFieldEditor result = new StringFieldEditor(prefName, prefText, StringFieldEditor.UNLIMITED, parent);
        result.getTextControl(parent).addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CFBasePrefTabPage.this.processPreferenceChanged(prefName);
            }
        });
        return result;
    }

    protected Label createPreListLabel(Composite parent, String text) {
        Label result = new Label(parent, 0);
        GridData gd = new GridData(4, 0x1000000, true, false, 2, 1);
        gd.horizontalIndent = 0;
        result.setLayoutData((Object)gd);
        result.setText(text);
        result.setFont(parent.getFont());
        return result;
    }

    protected Label createPreComboLabel(Composite parent, String text) {
        Label result = new Label(parent, 0);
        result.setText(text);
        GridData labelLayoutData = new GridData(4, 0x1000000, false, false);
        result.setLayoutData((Object)labelLayoutData);
        result.setFont(parent.getFont());
        return result;
    }

    protected Combo createCombo(Composite parent) {
        Combo result = new Combo(parent, 12);
        result.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        result.setFont(parent.getFont());
        return result;
    }

    protected Composite doCreatePreviewPane(Composite parent) {
        this.fPreviewContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.fPreviewContainer.setLayout((Layout)layout);
        this.fPreviewContainer.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.fPreviewContainer.setFont(parent.getFont());
        this.fPreviewerLineWrapWidthContainer = new Composite(this.fPreviewContainer, 0);
        layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.fPreviewerLineWrapWidthContainer.setLayout((Layout)layout);
        this.fPreviewerLineWrapWidthContainer.setLayoutData((Object)new GridData(16384, 4, true, false, 1, 1));
        this.fPreviewerLineWrapWidthContainer.setFont(parent.getFont());
        this.fPreviewerLineWrapWidth = new IntegerFieldEditor("format.preview.line_wrap_threshold", "Line width for preview:", 3, this.fPreviewerLineWrapWidthContainer);
        this.fPreviewerLineWrapWidth.getTextControl(this.fPreviewerLineWrapWidthContainer).addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int posVal = CFBasePrefTabPage.this.getPreviewLineWrapWidthFromFieldEditor();
                if (posVal != CFBasePrefTabPage.this.fPreferencesPage.getPreviewLineWrapThreshold()) {
                    CFBasePrefTabPage.this.fPreferencesPage.setPreviewLineWrapThreshold(CFBasePrefTabPage.this.getPreviewLineWrapWidthFromFieldEditor());
                    CFBasePrefTabPage.this.processPreferenceChanged("format.preview.line_wrap_threshold");
                }
            }
        });
        this.addField((FieldEditor)this.fPreviewerLineWrapWidth);
        this.fPreviewerShowInvisibleCharsContainer = new Composite(this.fPreviewContainer, 0);
        layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.fPreviewerShowInvisibleCharsContainer.setLayout((Layout)layout);
        this.fPreviewerShowInvisibleCharsContainer.setLayoutData((Object)new GridData(131072, 4, true, false, 1, 1));
        this.fPreviewerShowInvisibleCharsContainer.setFont(parent.getFont());
        this.fPreviewerShowInvisibleChars = new BooleanFieldEditor2("format.preview.show_invisible_characters", "Show invisible characters", 0, this.fPreviewerShowInvisibleCharsContainer);
        this.fPreviewerShowInvisibleChars.getChangeControl(this.fPreviewerShowInvisibleCharsContainer).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CFBasePrefTabPage.this.fPreviewViewer.showInvisibleCharacters(CFBasePrefTabPage.this.fPreviewerShowInvisibleChars.getBooleanValue());
                CFBasePrefTabPage.this.fPreferencesPage.setPreviewShowInvisibleCharsEnabled(CFBasePrefTabPage.this.fPreviewerShowInvisibleChars.getBooleanValue());
            }
        });
        Control previewer = this.createPreviewer(this.fPreviewContainer);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        previewer.setLayoutData((Object)gd);
        this.fMarginPainter = new MarginPainter((ITextViewer)this.fPreviewViewer);
        this.fMarginPainter.setMarginRulerColor(DVTColorUtil.INSTANCE.getColor(this.fConfiguration.getLineMarginColor()));
        this.fPreviewViewer.addPainter((IPainter)this.fMarginPainter);
        int previewLineWidth = this.getPreviewLineWrapWidthFromPreferenceStore();
        this.fMarginPainter.setMarginRulerColumn(previewLineWidth);
        return parent;
    }

    protected Control createPreviewer(Composite parent) {
        this.fPreviewViewer = new DVTPreviewSourceViewer(parent, 2816);
        this.fPreviewViewer.setPreferenceStore(DVTPlugin.getDefault().getCombinedPreferenceStore());
        this.fPreviewViewer.configure((SourceViewerConfiguration)this.fConfiguration);
        this.fPreviewViewer.getTextWidget().setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont"));
        this.fPreviewViewer.setEditable(false);
        String content = "";
        int i = 0;
        while (i < 40) {
            content = String.valueOf(content) + "\n";
            ++i;
        }
        Document document = new Document(content);
        this.fConfiguration.setupDocumentPartitioner((IDocument)document);
        this.fPreviewViewer.setDocument((IDocument)document);
        return this.fPreviewViewer.getControl();
    }

    public void updatePreviewerContent() {
        if (this.fPreferencesPage == null || this.fPreviewViewer == null || this.fMarginPainter == null) {
            return;
        }
        if (this.fPreviewerShowInvisibleChars.getBooleanValue() != this.fPreferencesPage.isPreviewShowInvisibleCharsEnabled()) {
            Button button = this.fPreviewerShowInvisibleChars.getChangeControl(this.fPreviewerShowInvisibleCharsContainer);
            button.setSelection(this.fPreferencesPage.isPreviewShowInvisibleCharsEnabled());
        }
        if (this.getPreviewLineWrapWidthFromFieldEditor() != this.fPreferencesPage.getPreviewLineWrapThreshold()) {
            Text text = this.fPreviewerLineWrapWidth.getTextControl(this.fPreviewerLineWrapWidthContainer);
            text.setText("" + this.fPreferencesPage.getPreviewLineWrapThreshold());
        }
        this.fPreviewViewer.showInvisibleCharacters(this.fPreferencesPage.isPreviewShowInvisibleCharsEnabled());
        this.fMarginPainter.setMarginRulerColumn(this.fPreferencesPage.getPreviewLineWrapThreshold());
        StyledText widget = (StyledText)this.fPreviewViewer.getControl();
        int height = widget.getClientArea().height;
        int top0 = widget.getTopPixel();
        int totalPixels0 = this.getHeightOfAllLines(widget);
        int topPixelRange0 = totalPixels0 > height ? totalPixels0 - height : 0;
        widget.setRedraw(false);
        this.doFormatPreview();
        this.fPreviewViewer.setSelection(null);
        int totalPixels1 = this.getHeightOfAllLines(widget);
        int topPixelRange1 = totalPixels1 > height ? totalPixels1 - height : 0;
        int top1 = topPixelRange0 > 0 ? (int)((double)(topPixelRange1 * top0) / (double)topPixelRange0) : 0;
        widget.setTopPixel(top1);
        widget.setRedraw(true);
    }

    private void doFormatPreview() {
        if (!this.fPreferencesPage.isExternalFormatEnabled()) {
            String content = this.fPreferencesPage.loadPreviewContentFromFile(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + this.fPreferences.getPreviewFileNameExtension());
            if (content == null || content.isEmpty()) {
                content = this.fPreferencesPage.loadPreviewContentFromFile(this.fPreferences.getPreviewFileName());
            }
            Document document = new Document(content);
            this.fConfiguration.setPreview();
            this.fDocSetup.setup((IDocument)document);
            this.fPreviewViewer.getTextWidget().setVisible(true);
            this.fPreviewViewer.setDocument((IDocument)document);
            this.fPreviewViewer.doOperation(15);
            this.fConfiguration.setNormal();
            this.fPreviewViewer.setDocument((IDocument)document);
        } else {
            this.fPreviewViewer.getTextWidget().setText("Preview is not available for external formatting.");
        }
    }

    private int getHeightOfAllLines(StyledText styledText) {
        int height = 0;
        int lineCount = styledText.getLineCount();
        int i = 0;
        while (i < lineCount) {
            height += styledText.getLineHeight(styledText.getOffsetAtLine(i));
            ++i;
        }
        return height;
    }

    public void processPreferenceChanged(String preferenceName) {
        if (preferenceName.equals("format.preview.line_wrap_threshold")) {
            int posVal = this.getPreviewLineWrapWidthFromFieldEditor();
            this.fPreferences.changePreference(preferenceName, posVal);
            this.fMarginPainter.setMarginRulerColumn(posVal);
        }
        this.fPreferencesPage.refreshEnable();
        this.updatePreviewerContent();
    }

    private int getPreviewLineWrapWidthFromFieldEditor() {
        try {
            String str = String.valueOf(this.fPreviewerLineWrapWidth.getIntValue());
            int i = Integer.parseInt(str);
            if (i >= 0) {
                return i;
            }
        }
        catch (Exception exception) {
            return 0;
        }
        return 0;
    }

    private int getPreviewLineWrapWidthFromPreferenceStore() {
        String pref = String.valueOf(this.getPreferenceStore().getInt("format.preview.line_wrap_threshold"));
        try {
            int i = Integer.parseInt(pref);
            if (i >= 0) {
                return i;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return 50;
    }

    public void setErrorMessage(String newMessage) {
        this.fPreferencesPage.setErrorMessage(newMessage);
    }
}

