/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.formatter.preferences;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFBasePrefTabPage;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFPreferences;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFPreferencesPage;

public class CFCapitalizationPrefTabPage
extends CFBasePrefTabPage {
    private static String CAPITALIZATION_UPPER_TEXT = "All upper case";
    private static String CAPITALIZATION_LOWER_TEXT = "All lower case";
    private Composite fComboContainer;
    private Label fCapitalizationKeywordsLabel;
    private Combo fCapitalizationKeywordsCombo;
    private Label fCapitalizationDataTypesLabel;
    private Combo fCapitalizationDataTypesCombo;
    private Label fCapitalizationAttributesLabel;
    private Combo fCapitalizationAttributesCombo;

    public CFCapitalizationPrefTabPage(CFPreferences preferences, CFPreferencesPage preferencesPage) {
        super(preferences, preferencesPage);
    }

    @Override
    protected void doCreatePreferences(Composite parent) {
        this.fComboContainer = this.createContainer(parent, 2);
        this.fComboContainer.setFont(parent.getFont());
        this.createCapitalizationKeywordsPrefs(this.fComboContainer);
        this.createCapitalizationDataTypesPrefs(this.fComboContainer);
        this.createCapitalizationAttributesPrefs(this.fComboContainer);
    }

    private void createCapitalizationKeywordsPrefs(Composite parent) {
        this.fCapitalizationKeywordsLabel = this.createPreComboLabel(parent, "Keywords");
        this.fCapitalizationKeywordsCombo = this.createCombo(parent);
        this.fCapitalizationKeywordsCombo.add("Leave as is");
        this.fCapitalizationKeywordsCombo.setData("Leave as is", null);
        this.fCapitalizationKeywordsCombo.add(CAPITALIZATION_UPPER_TEXT);
        this.fCapitalizationKeywordsCombo.setData(CAPITALIZATION_UPPER_TEXT, null);
        this.fCapitalizationKeywordsCombo.add(CAPITALIZATION_LOWER_TEXT);
        this.fCapitalizationKeywordsCombo.setData(CAPITALIZATION_LOWER_TEXT, null);
        int pref = this.getPreferenceStore().getInt("format.capitalization.keywords");
        switch (pref) {
            case 1: {
                this.fCapitalizationKeywordsCombo.select(0);
                break;
            }
            case 2: {
                this.fCapitalizationKeywordsCombo.select(1);
                break;
            }
            case 3: {
                this.fCapitalizationKeywordsCombo.select(2);
                break;
            }
            default: {
                this.fCapitalizationKeywordsCombo.select(0);
            }
        }
        this.fCapitalizationKeywordsCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CFCapitalizationPrefTabPage.this.processPreferenceChanged("format.capitalization.keywords");
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void createCapitalizationDataTypesPrefs(Composite parent) {
        this.fCapitalizationDataTypesLabel = this.createPreComboLabel(parent, "Data Types");
        this.fCapitalizationDataTypesCombo = this.createCombo(parent);
        this.fCapitalizationDataTypesCombo.add("Leave as is");
        this.fCapitalizationDataTypesCombo.setData("Leave as is", null);
        this.fCapitalizationDataTypesCombo.add(CAPITALIZATION_UPPER_TEXT);
        this.fCapitalizationDataTypesCombo.setData(CAPITALIZATION_UPPER_TEXT, null);
        this.fCapitalizationDataTypesCombo.add(CAPITALIZATION_LOWER_TEXT);
        this.fCapitalizationDataTypesCombo.setData(CAPITALIZATION_LOWER_TEXT, null);
        int pref = this.getPreferenceStore().getInt("format.capitalization.data_types");
        switch (pref) {
            case 1: {
                this.fCapitalizationDataTypesCombo.select(0);
                break;
            }
            case 2: {
                this.fCapitalizationDataTypesCombo.select(1);
                break;
            }
            case 3: {
                this.fCapitalizationDataTypesCombo.select(2);
                break;
            }
            default: {
                this.fCapitalizationDataTypesCombo.select(0);
            }
        }
        this.fCapitalizationDataTypesCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CFCapitalizationPrefTabPage.this.processPreferenceChanged("format.capitalization.data_types");
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void createCapitalizationAttributesPrefs(Composite parent) {
        this.fCapitalizationAttributesLabel = this.createPreComboLabel(parent, "Attributes");
        this.fCapitalizationAttributesCombo = this.createCombo(parent);
        this.fCapitalizationAttributesCombo.add("Leave as is");
        this.fCapitalizationAttributesCombo.setData("Leave as is", null);
        this.fCapitalizationAttributesCombo.add(CAPITALIZATION_UPPER_TEXT);
        this.fCapitalizationAttributesCombo.setData(CAPITALIZATION_UPPER_TEXT, null);
        this.fCapitalizationAttributesCombo.add(CAPITALIZATION_LOWER_TEXT);
        this.fCapitalizationAttributesCombo.setData(CAPITALIZATION_LOWER_TEXT, null);
        int pref = this.getPreferenceStore().getInt("format.capitalization.attributes");
        switch (pref) {
            case 1: {
                this.fCapitalizationAttributesCombo.select(0);
                break;
            }
            case 2: {
                this.fCapitalizationAttributesCombo.select(1);
                break;
            }
            case 3: {
                this.fCapitalizationAttributesCombo.select(2);
                break;
            }
            default: {
                this.fCapitalizationAttributesCombo.select(0);
            }
        }
        this.fCapitalizationAttributesCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CFCapitalizationPrefTabPage.this.processPreferenceChanged("format.capitalization.attributes");
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    @Override
    protected void performDefaults() {
        super.performDefaults();
        this.fPreferences.restoreDefaultInt("format.capitalization.keywords");
        this.fCapitalizationKeywordsCombo.select(0);
        this.fPreferences.restoreDefaultInt("format.capitalization.data_types");
        this.fCapitalizationDataTypesCombo.select(0);
        this.fPreferences.restoreDefaultInt("format.capitalization.attributes");
        this.fCapitalizationAttributesCombo.select(0);
    }

    @Override
    protected void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.fComboContainer.setEnabled(enabled);
        this.fCapitalizationKeywordsLabel.setEnabled(enabled);
        this.fCapitalizationKeywordsCombo.setEnabled(enabled);
        this.fCapitalizationDataTypesLabel.setEnabled(enabled);
        this.fCapitalizationDataTypesCombo.setEnabled(enabled);
        this.fCapitalizationAttributesLabel.setEnabled(enabled);
        this.fCapitalizationAttributesCombo.setEnabled(enabled);
    }

    @Override
    public void processPreferenceChanged(String preferenceName) {
        if (preferenceName.equals("format.capitalization.keywords")) {
            int index = this.fCapitalizationKeywordsCombo.getSelectionIndex();
            String selection = this.fCapitalizationKeywordsCombo.getItem(index);
            int capitalizationKeywordsPref = 0;
            if (selection.equals("Leave as is")) {
                capitalizationKeywordsPref = 1;
            } else if (selection.equals(CAPITALIZATION_UPPER_TEXT)) {
                capitalizationKeywordsPref = 2;
            } else if (selection.equals(CAPITALIZATION_LOWER_TEXT)) {
                capitalizationKeywordsPref = 3;
            }
            this.fPreferences.changePreference(preferenceName, capitalizationKeywordsPref);
        } else if (preferenceName.equals("format.capitalization.data_types")) {
            int index = this.fCapitalizationDataTypesCombo.getSelectionIndex();
            String selection = this.fCapitalizationDataTypesCombo.getItem(index);
            int capitalizationDataTypesPref = 0;
            if (selection.equals("Leave as is")) {
                capitalizationDataTypesPref = 1;
            } else if (selection.equals(CAPITALIZATION_UPPER_TEXT)) {
                capitalizationDataTypesPref = 2;
            } else if (selection.equals(CAPITALIZATION_LOWER_TEXT)) {
                capitalizationDataTypesPref = 3;
            }
            this.fPreferences.changePreference(preferenceName, capitalizationDataTypesPref);
        } else if (preferenceName.equals("format.capitalization.attributes")) {
            int index = this.fCapitalizationAttributesCombo.getSelectionIndex();
            String selection = this.fCapitalizationAttributesCombo.getItem(index);
            int capitalizationAttributesPref = 0;
            if (selection.equals("Leave as is")) {
                capitalizationAttributesPref = 1;
            } else if (selection.equals(CAPITALIZATION_UPPER_TEXT)) {
                capitalizationAttributesPref = 2;
            } else if (selection.equals(CAPITALIZATION_LOWER_TEXT)) {
                capitalizationAttributesPref = 3;
            }
            this.fPreferences.changePreference(preferenceName, capitalizationAttributesPref);
        }
        super.processPreferenceChanged(preferenceName);
    }
}

