/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.formatter.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFBasePrefTabPage;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFNoIndentDefinition;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFPreferences;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFPreferencesPage;
import ro.amiq.dvt.ui.preferences.BooleanFieldEditor2;
import ro.amiq.dvt.utils.IntegerFieldEditor;

public class CFIndentPrefTabPage
extends CFBasePrefTabPage {
    private static String BEGIN_NEW_LINE_TEXT = "On a new line";
    private static String BEGIN_SAME_LINE_TEXT = "On the same line";
    private static String BEGIN_NEW_LINE_AND_INDENT_TEXT = "On a new line and indent";
    private static String ELSE_NEW_LINE_TEXT = "On a new line";
    private static String ELSE_SAME_LINE_TEXT = "On the same line";
    private static final String PARAMS_IN_LINE = "More per line";
    private static final String PARAMS_NEW_LINE_OPEN_PAREN_NEXT_LINE = "One per line (open parenthesis on the next line)";
    private static final String PARAMS_NEW_LINE_OPEN_PAREN_SAME_LINE = "One per line (open parenthesis on the same line)";
    private Composite fMorePerLineIfLessThanContainer;
    private Composite fMorePerLineIfLessThanCheckboxContainer;
    private BooleanFieldEditor2 fMorePerLineIfLessThanCheckbox;
    private Composite fMorePerLineIfLessThanThresholdContainer;
    private IntegerFieldEditor fMorePerLineIfLessThanThreshold;
    private static final String PREPROC_INDENT = "Indent";
    private static final String PREPROC_INDENT_CONTENT = "Indent and increase indentation level";
    private static final String PREPROC_INDENT_CONTENT_EXCEPT_FIRST = "Indent and increase indentation level - except first";
    private static final String PREPROC_RESET_INDENT = "Move at first column";
    private Composite fComboContainer;
    private Label fLabelBegin;
    private Combo fComboBegin;
    private Label fLabelElse;
    private Combo fComboElse;
    private Label fLabelParam;
    private Combo fComboParam;
    private Label fLabelPreproc;
    private Combo fComboPreproc;
    private Composite fPreserveSLCommentAtLineZeroEnableContainer;
    private BooleanFieldEditor2 fPreserveSLCommentAtLineZeroEnable;
    private Composite fIndentMLCommentsEnableContainer;
    private BooleanFieldEditor2 fIndentMLCommentsEnable;
    private Composite fIndentSkipAssignsEnableContainer;
    private BooleanFieldEditor2 fIndentSkipAssignsEnable;
    private Composite fIndentSkipMLMacroDefsEnableContainer;
    private BooleanFieldEditor2 fIndentSkipMLMacroDefsEnable;
    private Composite fAddNewLineAfterBeginAndBeforeEndContainer;
    private BooleanFieldEditor2 fAddNewLineAfterBeginAndBeforeEndEnable;
    private Composite fAddNewLineAfterEndContainer;
    private BooleanFieldEditor2 fAddNewLineAfterEndEnable;
    private Composite fIgnoreLinesStartingWithTokensContainer;
    private StringFieldEditor fIgnoreLinesStartingWithTokens;
    private Composite fSkipIndentationContainer;
    private Label fSkipIndentationLabel;
    private Table fNoIndentationTable;
    private Text fTmpMacrosNewMacroText;
    private org.eclipse.swt.widgets.List fTmpMacrosList;
    private Composite fImplicitSemiMacrosContainer;
    private Label fImplicitSemiMacrosLabel;
    private Text fImplicitSemiMacrosNewMacroText;
    private org.eclipse.swt.widgets.List fImplicitSemiMacrosList;
    private Composite fOpenScopeMacrosContainer;
    private Label fOpenScopeMacrosLabel;
    private Text fOpenScopeMacrosNewMacroText;
    private org.eclipse.swt.widgets.List fOpenScopeMacrosList;
    private Composite fCloseScopeMacrosContainer;
    private Label fCloseScopeMacrosLabel;
    private Text fCloseScopeMacrosNewMacroText;
    private org.eclipse.swt.widgets.List fCloseScopeMacrosList;

    public CFIndentPrefTabPage(CFPreferences preferences, CFPreferencesPage preferencesPage) {
        super(preferences, preferencesPage);
    }

    @Override
    protected void doCreatePreferences(Composite parent) {
        this.addTextEditorsLink(parent);
        this.fComboContainer = this.createContainer(parent, 2);
        this.createBeginPrefs(this.fComboContainer);
        this.createElsePrefs(this.fComboContainer);
        this.createParametersPrefs(this.fComboContainer);
        this.createMorePerLineIfLessThanPrefs(this.fComboContainer);
        this.cretePreprocessingPrefs(this.fComboContainer);
        this.createIndentSkipMLMacroDefsPrefs(parent);
        this.createPreserveSLCommentsAtColumnZeroPrefs(parent);
        this.createIndentMLCommentsPrefs(parent);
        this.createIndentSkipAssignsPrefs(parent);
        this.createAddNewLineAfterBeginAndBeforeEnd(parent);
        this.createAddNewLineAfterEnd(parent);
        this.createIngoreLinesStartingWithPrefs(parent);
        this.createSkipIndentationPrefs(parent);
        this.createImplicitSemiMacrosPrefs(parent);
        this.createOpenScopeMacrosPrefs(parent);
        this.createCloseScopeMacrosPrefs(parent);
    }

    private void createBeginPrefs(Composite parent) {
        this.fLabelBegin = this.createPreComboLabel(this.fComboContainer, this.fPreferences.getBeginKeywordText());
        this.fComboBegin = this.createCombo(this.fComboContainer);
        this.fComboBegin.add("Leave as is");
        this.fComboBegin.setData("Leave as is", null);
        this.fComboBegin.add(BEGIN_NEW_LINE_TEXT);
        this.fComboBegin.setData(BEGIN_NEW_LINE_TEXT, null);
        this.fComboBegin.add(BEGIN_SAME_LINE_TEXT);
        this.fComboBegin.setData(BEGIN_SAME_LINE_TEXT, null);
        if (this.fPreferences.hasBeginPrefNewLineAndIndent()) {
            this.fComboBegin.add(BEGIN_NEW_LINE_AND_INDENT_TEXT);
            this.fComboBegin.setData(BEGIN_NEW_LINE_AND_INDENT_TEXT, null);
        }
        int pref = this.getPreferenceStore().getInt("format.indent.begin");
        switch (pref) {
            case 1: {
                this.fComboBegin.select(0);
                break;
            }
            case 2: {
                this.fComboBegin.select(1);
                break;
            }
            case 3: {
                this.fComboBegin.select(2);
                break;
            }
            case 4: {
                if (this.fPreferences.hasBeginPrefNewLineAndIndent()) {
                    this.fComboBegin.select(3);
                    break;
                }
                this.fComboBegin.select(0);
                break;
            }
            default: {
                this.fComboBegin.select(0);
            }
        }
        this.fComboBegin.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CFIndentPrefTabPage.this.processPreferenceChanged("format.indent.begin");
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void createElsePrefs(Composite parent) {
        if (!this.fPreferences.hasElseOptions()) {
            return;
        }
        this.fLabelElse = this.createPreComboLabel(this.fComboContainer, "\"else\"");
        this.fComboElse = this.createCombo(this.fComboContainer);
        this.fComboElse.add("Leave as is");
        this.fComboElse.setData("Leave as is", null);
        this.fComboElse.add(ELSE_NEW_LINE_TEXT);
        this.fComboElse.setData(ELSE_NEW_LINE_TEXT, null);
        this.fComboElse.add(ELSE_SAME_LINE_TEXT);
        this.fComboElse.setData(ELSE_SAME_LINE_TEXT, null);
        int pref = this.getPreferenceStore().getInt("format.indent.else");
        switch (pref) {
            case 1: {
                this.fComboElse.select(0);
                break;
            }
            case 2: {
                this.fComboElse.select(1);
                break;
            }
            case 3: {
                this.fComboElse.select(2);
                break;
            }
            default: {
                this.fComboElse.select(0);
            }
        }
        this.fComboElse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CFIndentPrefTabPage.this.processPreferenceChanged("format.indent.else");
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void createParametersPrefs(Composite parent) {
        if (!this.fPreferences.hasParametersOptions()) {
            return;
        }
        this.fLabelParam = this.createPreComboLabel(parent, "Parameters");
        this.fComboParam = this.createCombo(parent);
        this.fComboParam.add("Leave as is");
        this.fComboParam.setData("Leave as is", null);
        this.fComboParam.add(PARAMS_NEW_LINE_OPEN_PAREN_SAME_LINE);
        this.fComboParam.setData(PARAMS_NEW_LINE_OPEN_PAREN_SAME_LINE, null);
        this.fComboParam.add(PARAMS_NEW_LINE_OPEN_PAREN_NEXT_LINE);
        this.fComboParam.setData(PARAMS_NEW_LINE_OPEN_PAREN_NEXT_LINE, null);
        this.fComboParam.add(PARAMS_IN_LINE);
        this.fComboParam.setData(PARAMS_IN_LINE, null);
        int pref = this.getPreferenceStore().getInt("format.indent.params");
        switch (pref) {
            case 1: {
                this.fComboParam.select(0);
                break;
            }
            case 2: {
                this.fComboParam.select(1);
                break;
            }
            case 3: {
                this.fComboParam.select(2);
                break;
            }
            case 4: {
                this.fComboParam.select(3);
                break;
            }
            default: {
                this.fComboParam.select(0);
            }
        }
        this.fComboParam.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CFIndentPrefTabPage.this.processPreferenceChanged("format.indent.params");
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void createMorePerLineIfLessThanPrefs(Composite parent) {
        if (!this.fPreferences.hasParametersOptions()) {
            return;
        }
        this.fMorePerLineIfLessThanContainer = this.createContainer(parent, 0);
        this.fMorePerLineIfLessThanCheckboxContainer = new Composite(this.fMorePerLineIfLessThanContainer, 0);
        this.fMorePerLineIfLessThanCheckbox = this.createBooleanFieldEditor(this.fMorePerLineIfLessThanCheckboxContainer, "format.indent.more_per_line_if_less_than_enable", "More per line if less than:");
        this.addField((FieldEditor)this.fMorePerLineIfLessThanCheckbox);
        this.fMorePerLineIfLessThanThresholdContainer = new Composite(this.fMorePerLineIfLessThanContainer, 0);
        this.fMorePerLineIfLessThanThreshold = this.createIntegerFieldEditor(this.fMorePerLineIfLessThanThresholdContainer, "format.indent.more_per_line_if_less_than_threshold", "", 3);
        this.fMorePerLineIfLessThanThreshold.setValidRange(0, 100);
        this.addField((FieldEditor)this.fMorePerLineIfLessThanThreshold);
    }

    private void cretePreprocessingPrefs(Composite parent) {
        if (!this.fPreferences.hasPreprocessingOptions()) {
            return;
        }
        this.fLabelPreproc = this.createPreComboLabel(parent, "Preprocessing");
        this.fComboPreproc = this.createCombo(parent);
        this.fComboPreproc.add("Leave as is");
        this.fComboPreproc.setData("Leave as is", null);
        this.fComboPreproc.add(PREPROC_INDENT);
        this.fComboPreproc.setData(PREPROC_INDENT, null);
        this.fComboPreproc.add(PREPROC_INDENT_CONTENT);
        this.fComboPreproc.setData(PREPROC_INDENT_CONTENT, null);
        this.fComboPreproc.add(PREPROC_INDENT_CONTENT_EXCEPT_FIRST);
        this.fComboPreproc.setData(PREPROC_INDENT_CONTENT_EXCEPT_FIRST, null);
        this.fComboPreproc.add(PREPROC_RESET_INDENT);
        this.fComboPreproc.setData(PREPROC_RESET_INDENT, null);
        int pref = this.getPreferenceStore().getInt("format.indent.preproc");
        switch (pref) {
            case 1: {
                this.fComboPreproc.select(0);
                break;
            }
            case 2: {
                this.fComboPreproc.select(1);
                break;
            }
            case 3: {
                this.fComboPreproc.select(2);
                break;
            }
            case 5: {
                this.fComboPreproc.select(3);
                break;
            }
            case 4: {
                this.fComboPreproc.select(4);
                break;
            }
            default: {
                this.fComboPreproc.select(0);
            }
        }
        this.fComboPreproc.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CFIndentPrefTabPage.this.processPreferenceChanged("format.indent.preproc");
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void createPreserveSLCommentsAtColumnZeroPrefs(Composite parent) {
        this.fPreserveSLCommentAtLineZeroEnableContainer = this.createContainer(parent, 0);
        this.fPreserveSLCommentAtLineZeroEnable = this.createBooleanFieldEditor(this.fPreserveSLCommentAtLineZeroEnableContainer, "format.indent.preserve_sl_comment_column_zero", "Don't indent single line comments at first column");
        this.addField((FieldEditor)this.fPreserveSLCommentAtLineZeroEnable);
    }

    private void createIndentMLCommentsPrefs(Composite parent) {
        if (!this.fPreferences.hasIndentMLCommentsOptions()) {
            return;
        }
        this.fIndentMLCommentsEnableContainer = this.createContainer(parent, 0);
        this.fIndentMLCommentsEnable = this.createBooleanFieldEditor(this.fIndentMLCommentsEnableContainer, "format.indent.multiline_comments", "Indent multi line comments");
        this.addField((FieldEditor)this.fIndentMLCommentsEnable);
    }

    private void createIndentSkipAssignsPrefs(Composite parent) {
        if (!this.fPreferences.hasIndentSkipAssignsOptions()) {
            return;
        }
        this.fIndentSkipAssignsEnableContainer = this.createContainer(parent, 0);
        this.fIndentSkipAssignsEnable = this.createBooleanFieldEditor(this.fIndentSkipAssignsEnableContainer, "format.indent.skip_assigns", "Do not indent multi line content of assigns");
        this.addField((FieldEditor)this.fIndentSkipAssignsEnable);
    }

    private void createIndentSkipMLMacroDefsPrefs(Composite parent) {
        if (!this.fPreferences.hasIndentSkipMLMacroDefsOptions()) {
            return;
        }
        this.fIndentSkipMLMacroDefsEnableContainer = this.createContainer(parent, 0);
        this.fIndentSkipMLMacroDefsEnable = this.createBooleanFieldEditor(this.fIndentSkipMLMacroDefsEnableContainer, "format.indent.skip.ml.macro.definitions", "Do not indent multi line macro definitions");
        this.addField((FieldEditor)this.fIndentSkipMLMacroDefsEnable);
    }

    private void createAddNewLineAfterBeginAndBeforeEnd(Composite parent) {
        if (!this.fPreferences.hasAddNewLineAfterBeginAndBeforeEnd()) {
            return;
        }
        this.fAddNewLineAfterBeginAndBeforeEndContainer = this.createContainer(parent, 0);
        this.fAddNewLineAfterBeginAndBeforeEndEnable = this.createBooleanFieldEditor(this.fAddNewLineAfterBeginAndBeforeEndContainer, "format.indent.add_new_line_after_begin_and_before_end", "Add new line after \"begin\" and before \"end\"");
        this.addField((FieldEditor)this.fAddNewLineAfterBeginAndBeforeEndEnable);
    }

    private void createAddNewLineAfterEnd(Composite parent) {
        if (!this.fPreferences.hasAddNewLineAfterEnd()) {
            return;
        }
        this.fAddNewLineAfterEndContainer = this.createContainer(parent, 0);
        this.fAddNewLineAfterEndEnable = this.createBooleanFieldEditor(this.fAddNewLineAfterEndContainer, "format.indent.add_new_line_after_end", "Add new line after \"end\"");
        this.addField((FieldEditor)this.fAddNewLineAfterEndEnable);
    }

    private void createIngoreLinesStartingWithPrefs(Composite parent) {
        this.fIgnoreLinesStartingWithTokensContainer = this.createContainer(parent, 2);
        this.fIgnoreLinesStartingWithTokens = this.createStringFieldEditor(this.fIgnoreLinesStartingWithTokensContainer, "format.indent.ignore_lines", "Ignore lines starting with:");
        this.addField((FieldEditor)this.fIgnoreLinesStartingWithTokens);
    }

    private void createSkipIndentationPrefs(Composite parent) {
        if (!this.fPreferences.hasNoIndentKeywordsOptions()) {
            return;
        }
        this.fSkipIndentationContainer = this.createContainer(parent, 2);
        this.fSkipIndentationLabel = this.createPreListLabel(this.fSkipIndentationContainer, "Don't increase the indent level on:");
        this.fNoIndentationTable = new Table(this.fSkipIndentationContainer, 2084);
        GridData gd = new GridData(4, 0x1000000, true, false, 2, 1);
        gd.grabExcessHorizontalSpace = true;
        gd.minimumHeight = this.convertHeightInCharsToPixels(5);
        gd.heightHint = this.convertHeightInCharsToPixels(10);
        this.fNoIndentationTable.setLayoutData((Object)gd);
        TableLayout layout = new TableLayout();
        this.fNoIndentationTable.setLayout((Layout)layout);
        this.fNoIndentationTable.setFont(this.fSkipIndentationContainer.getFont());
        this.fNoIndentationTable.setHeaderVisible(false);
        this.fNoIndentationTable.setLinesVisible(true);
        List<CFNoIndentDefinition> defs = this.fPreferences.getNoIndentPref();
        for (CFNoIndentDefinition def : defs) {
            if (def == null) continue;
            TableItem item = new TableItem(this.fNoIndentationTable, 0);
            item.setText(def.getName());
            item.setChecked(def.isEnabled());
            item.setData((Object)def);
        }
        this.fNoIndentationTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 32 && e.item != null && e.item instanceof TableItem) {
                    TableItem tableItem = (TableItem)e.item;
                    CFNoIndentDefinition data = (CFNoIndentDefinition)tableItem.getData();
                    CFIndentPrefTabPage.this.fPreferences.enableNoIndentPref(data.getName(), tableItem.getChecked());
                    CFIndentPrefTabPage.this.processPreferenceChanged("format.indent.no_indent_keywords");
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void createImplicitSemiMacrosPrefs(Composite parent) {
        if (!this.fPreferences.hasImplicitSemiOptions()) {
            return;
        }
        this.fImplicitSemiMacrosContainer = this.createContainer(parent, 2);
        this.fImplicitSemiMacrosLabel = this.createPreListLabel(this.fImplicitSemiMacrosContainer, "Implicit semi macros:");
        this.createMacrosPrefs(this.fImplicitSemiMacrosContainer, "format.indent.implicit_semi_macros");
        this.fImplicitSemiMacrosNewMacroText = this.fTmpMacrosNewMacroText;
        this.fImplicitSemiMacrosList = this.fTmpMacrosList;
    }

    private void createOpenScopeMacrosPrefs(Composite parent) {
        if (!this.fPreferences.hasScopeMacrosOptions()) {
            return;
        }
        this.fOpenScopeMacrosContainer = this.createContainer(parent, 2);
        this.fOpenScopeMacrosLabel = this.createPreListLabel(this.fOpenScopeMacrosContainer, "Open scope macros:");
        this.createMacrosPrefs(this.fOpenScopeMacrosContainer, "format.indent.open_scope_macros");
        this.fOpenScopeMacrosNewMacroText = this.fTmpMacrosNewMacroText;
        this.fOpenScopeMacrosList = this.fTmpMacrosList;
    }

    private void createCloseScopeMacrosPrefs(Composite parent) {
        if (!this.fPreferences.hasScopeMacrosOptions()) {
            return;
        }
        this.fCloseScopeMacrosContainer = this.createContainer(parent, 2);
        this.fCloseScopeMacrosLabel = this.createPreListLabel(this.fCloseScopeMacrosContainer, "Close scope macros:");
        this.createMacrosPrefs(this.fCloseScopeMacrosContainer, "format.indent.close_scope_macros");
        this.fCloseScopeMacrosNewMacroText = this.fTmpMacrosNewMacroText;
        this.fCloseScopeMacrosList = this.fTmpMacrosList;
    }

    private void createMacrosPrefs(Composite macrosContainer, final String prefConst) {
        Composite tableComposite = new Composite(macrosContainer, 0);
        GridLayout tableLayout = new GridLayout();
        tableLayout.numColumns = 2;
        tableLayout.marginWidth = 0;
        tableComposite.setLayout((Layout)tableLayout);
        GridData tableGridData = new GridData(1808);
        tableGridData.minimumHeight = this.convertHeightInCharsToPixels(5);
        tableComposite.setLayoutData((Object)tableGridData);
        tableComposite.setFont(macrosContainer.getFont());
        Composite textsComposite = new Composite(tableComposite, 0);
        GridLayout textsGL = new GridLayout();
        textsGL.marginWidth = 0;
        textsComposite.setLayout((Layout)textsGL);
        GridData textsCompositeLayoutData = new GridData(768);
        textsCompositeLayoutData.verticalAlignment = 0x1000000;
        textsComposite.setLayoutData((Object)textsCompositeLayoutData);
        this.fTmpMacrosNewMacroText = new Text(textsComposite, 2048);
        GridData newMacroGridData = new GridData(768);
        newMacroGridData.grabExcessHorizontalSpace = true;
        this.fTmpMacrosNewMacroText.setLayoutData((Object)newMacroGridData);
        this.fTmpMacrosNewMacroText.setFont(tableComposite.getFont());
        this.fTmpMacrosList = new org.eclipse.swt.widgets.List(textsComposite, 2564);
        GridData macrosListGridData = new GridData(768);
        macrosListGridData.grabExcessHorizontalSpace = true;
        macrosListGridData.minimumHeight = this.convertHeightInCharsToPixels(5);
        macrosListGridData.heightHint = this.convertHeightInCharsToPixels(10);
        this.fTmpMacrosList.setLayoutData((Object)macrosListGridData);
        this.fTmpMacrosList.setFont(tableComposite.getFont());
        ArrayList<String> isml = this.fPreferences.getSortedCommaSeparatedProperty(prefConst, false);
        String[] ismv = isml.toArray(new String[isml.size()]);
        this.fTmpMacrosList.setItems(ismv);
        Composite buttons = new Composite(tableComposite, 0);
        buttons.setLayout((Layout)new GridLayout());
        GridData layoutData = new GridData(1040);
        layoutData.verticalAlignment = 0x1000000;
        buttons.setLayoutData((Object)layoutData);
        Button newBtn = new Button(buttons, 8);
        newBtn.setLayoutData((Object)new GridData(768));
        newBtn.setText("Add");
        newBtn.addSelectionListener((SelectionListener)new MacrosSelectionAdapter(this.fTmpMacrosNewMacroText, this.fTmpMacrosList){

            public void widgetSelected(SelectionEvent e) {
                String text = this.newMacroText.getText().trim();
                this.newMacroText.setText("");
                if (text != null && !text.isEmpty()) {
                    this.macrosList.add(text);
                    String[] values = this.macrosList.getItems();
                    Arrays.sort(values, String.CASE_INSENSITIVE_ORDER);
                    this.macrosList.setItems(values);
                    CFIndentPrefTabPage.this.processPreferenceChanged(prefConst);
                }
            }
        });
        Button deleteBtn = new Button(buttons, 8);
        deleteBtn.setLayoutData((Object)new GridData(768));
        deleteBtn.setText("Remove");
        deleteBtn.addSelectionListener((SelectionListener)new MacrosSelectionAdapter(this.fTmpMacrosNewMacroText, this.fTmpMacrosList){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = this.macrosList.getSelectionIndex();
                if (selectionIndex >= 0 && selectionIndex < this.macrosList.getItems().length) {
                    this.macrosList.remove(this.macrosList.getSelectionIndex());
                    CFIndentPrefTabPage.this.processPreferenceChanged(prefConst);
                }
            }
        });
    }

    @Override
    protected void performDefaults() {
        super.performDefaults();
        this.fPreferences.restoreDefaultInt("format.indent.begin");
        this.fComboBegin.select(0);
        if (this.fPreferences.hasElseOptions()) {
            this.fPreferences.restoreDefaultInt("format.indent.else");
            this.fComboElse.select(0);
        }
        if (this.fPreferences.hasParametersOptions()) {
            this.fPreferences.restoreDefaultInt("format.indent.params");
            this.fPreferences.restoreDefaultBoolean("format.indent.more_per_line_if_less_than_enable");
            this.fPreferences.restoreDefaultInt("format.indent.more_per_line_if_less_than_threshold");
            this.fComboParam.select(0);
        }
        if (this.fPreferences.hasPreprocessingOptions()) {
            this.fPreferences.restoreDefaultInt("format.indent.preproc");
            this.fComboPreproc.select(0);
        }
        this.fPreferences.restoreDefaultBoolean("format.indent.preserve_sl_comment_column_zero");
        if (this.fPreferences.hasIndentMLCommentsOptions()) {
            this.fPreferences.restoreDefaultBoolean("format.indent.multiline_comments");
        }
        if (this.fPreferences.hasIndentSkipAssignsOptions()) {
            this.fPreferences.restoreDefaultBoolean("format.indent.skip_assigns");
        }
        if (this.fPreferences.hasIndentSkipMLMacroDefsOptions()) {
            this.fPreferences.restoreDefaultBoolean("format.indent.skip.ml.macro.definitions");
        }
        if (this.fPreferences.hasNoIndentKeywordsOptions()) {
            this.fPreferences.restoreDefaultString("format.indent.no_indent_keywords");
            int nofItems = this.fNoIndentationTable.getItemCount();
            int i = 0;
            while (i < nofItems) {
                this.fNoIndentationTable.getItem(i).setChecked(false);
                ++i;
            }
        }
        if (this.fPreferences.hasImplicitSemiOptions()) {
            this.fPreferences.restoreDefaultString("format.indent.implicit_semi_macros");
            this.fImplicitSemiMacrosNewMacroText.setText("");
            ArrayList<String> isml = this.fPreferences.getSortedCommaSeparatedProperty("format.indent.implicit_semi_macros", true);
            String[] ismv = isml.toArray(new String[isml.size()]);
            this.fImplicitSemiMacrosList.setItems(ismv);
        }
        if (this.fPreferences.hasScopeMacrosOptions()) {
            this.fPreferences.restoreDefaultString("format.indent.open_scope_macros");
            this.fOpenScopeMacrosNewMacroText.setText("");
            ArrayList<String> isml = this.fPreferences.getSortedCommaSeparatedProperty("format.indent.open_scope_macros", true);
            String[] ismv = isml.toArray(new String[isml.size()]);
            this.fOpenScopeMacrosList.setItems(ismv);
            this.fPreferences.restoreDefaultString("format.indent.close_scope_macros");
            this.fCloseScopeMacrosNewMacroText.setText("");
            isml = this.fPreferences.getSortedCommaSeparatedProperty("format.indent.close_scope_macros", true);
            ismv = isml.toArray(new String[isml.size()]);
            this.fCloseScopeMacrosList.setItems(ismv);
        }
        this.fPreferences.restoreDefaultString("format.indent.ignore_lines");
        this.fPreferences.restoreDefaultBoolean("format.indent.add_new_line_after_begin_and_before_end");
        this.fPreferences.restoreDefaultBoolean("format.indent.add_new_line_after_end");
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.fComboContainer.setEnabled(enabled);
        this.fLabelBegin.setEnabled(enabled);
        this.fComboBegin.setEnabled(enabled);
        if (this.fPreferences.hasElseOptions()) {
            this.fLabelElse.setEnabled(enabled);
            this.fComboElse.setEnabled(enabled);
        }
        if (this.fPreferences.hasParametersOptions()) {
            this.fLabelParam.setEnabled(enabled);
            this.fComboParam.setEnabled(enabled);
            boolean enableMorePerLineIfLessThan = enabled && this.fPreferences.isParamsPrefNewLine();
            this.fMorePerLineIfLessThanContainer.setEnabled(enableMorePerLineIfLessThan);
            this.fMorePerLineIfLessThanCheckboxContainer.setEnabled(enableMorePerLineIfLessThan);
            this.fMorePerLineIfLessThanCheckbox.setEnabled(enableMorePerLineIfLessThan, this.fMorePerLineIfLessThanCheckboxContainer);
            this.fMorePerLineIfLessThanThresholdContainer.setEnabled(enableMorePerLineIfLessThan);
            this.fMorePerLineIfLessThanThreshold.setEnabled(enableMorePerLineIfLessThan && this.fMorePerLineIfLessThanCheckbox.getBooleanValue(), this.fMorePerLineIfLessThanThresholdContainer);
        }
        if (this.fPreferences.hasPreprocessingOptions()) {
            this.fLabelPreproc.setEnabled(enabled);
            this.fComboPreproc.setEnabled(enabled);
        }
        this.fPreserveSLCommentAtLineZeroEnableContainer.setEnabled(enabled);
        this.fPreserveSLCommentAtLineZeroEnable.setEnabled(enabled, this.fPreserveSLCommentAtLineZeroEnableContainer);
        if (this.fPreferences.hasIndentMLCommentsOptions()) {
            this.fIndentMLCommentsEnableContainer.setEnabled(enabled);
            this.fIndentMLCommentsEnable.setEnabled(enabled, this.fIndentMLCommentsEnableContainer);
        }
        if (this.fPreferences.hasIndentSkipAssignsOptions()) {
            this.fIndentSkipAssignsEnableContainer.setEnabled(enabled);
            this.fIndentSkipAssignsEnable.setEnabled(enabled, this.fIndentSkipAssignsEnableContainer);
        }
        if (this.fPreferences.hasIndentSkipMLMacroDefsOptions()) {
            boolean enableSkipMLMacroDefs = enabled && !this.fPreferences.isPreprocPrefLeaveAsIs();
            this.fIndentSkipMLMacroDefsEnableContainer.setEnabled(enableSkipMLMacroDefs);
            this.fIndentSkipMLMacroDefsEnable.setEnabled(enableSkipMLMacroDefs, this.fIndentSkipMLMacroDefsEnableContainer);
        }
        if (this.fPreferences.hasNoIndentKeywordsOptions()) {
            this.fSkipIndentationLabel.setEnabled(enabled);
            this.fNoIndentationTable.setEnabled(enabled);
            this.fSkipIndentationContainer.setEnabled(enabled);
        }
        if (this.fPreferences.hasImplicitSemiOptions()) {
            this.fImplicitSemiMacrosLabel.setEnabled(enabled);
            this.fImplicitSemiMacrosNewMacroText.setEnabled(enabled);
            this.fImplicitSemiMacrosList.setEnabled(enabled);
            this.fImplicitSemiMacrosContainer.setEnabled(enabled);
        }
        if (this.fPreferences.hasScopeMacrosOptions()) {
            this.fOpenScopeMacrosLabel.setEnabled(enabled);
            this.fOpenScopeMacrosNewMacroText.setEnabled(enabled);
            this.fOpenScopeMacrosList.setEnabled(enabled);
            this.fOpenScopeMacrosContainer.setEnabled(enabled);
            this.fCloseScopeMacrosLabel.setEnabled(enabled);
            this.fCloseScopeMacrosNewMacroText.setEnabled(enabled);
            this.fCloseScopeMacrosList.setEnabled(enabled);
            this.fCloseScopeMacrosContainer.setEnabled(enabled);
        }
        this.fIgnoreLinesStartingWithTokensContainer.setEnabled(enabled);
        this.fIgnoreLinesStartingWithTokens.setEnabled(enabled, this.fIgnoreLinesStartingWithTokensContainer);
        if (this.fPreferences.hasAddNewLineAfterBeginAndBeforeEnd()) {
            this.fAddNewLineAfterBeginAndBeforeEndContainer.setEnabled(enabled);
            this.fAddNewLineAfterBeginAndBeforeEndEnable.setEnabled(enabled, this.fAddNewLineAfterBeginAndBeforeEndContainer);
        }
        if (this.fPreferences.hasAddNewLineAfterEnd()) {
            this.fAddNewLineAfterEndContainer.setEnabled(enabled);
            this.fAddNewLineAfterEndEnable.setEnabled(enabled, this.fAddNewLineAfterEndContainer);
        }
    }

    @Override
    public void processPreferenceChanged(String preferenceName) {
        block69: {
            block75: {
                block74: {
                    block73: {
                        block71: {
                            block70: {
                                block68: {
                                    if (!preferenceName.equals("format.indent.begin")) break block68;
                                    int index = this.fComboBegin.getSelectionIndex();
                                    String selection = this.fComboBegin.getItem(index);
                                    int beginPref = 0;
                                    if (selection.equals("Leave as is")) {
                                        beginPref = 1;
                                    } else if (selection.equals(BEGIN_NEW_LINE_TEXT)) {
                                        beginPref = 2;
                                    } else if (selection.equals(BEGIN_SAME_LINE_TEXT)) {
                                        beginPref = 3;
                                    } else if (this.fPreferences.hasBeginPrefNewLineAndIndent() && selection.equals(BEGIN_NEW_LINE_AND_INDENT_TEXT)) {
                                        beginPref = 4;
                                    }
                                    this.fPreferences.changePreference(preferenceName, beginPref);
                                    break block69;
                                }
                                if (!preferenceName.equals("format.indent.else")) break block70;
                                int index = this.fComboElse.getSelectionIndex();
                                String selection = this.fComboElse.getItem(index);
                                int elsePref = 0;
                                if (selection.equals("Leave as is")) {
                                    elsePref = 1;
                                } else if (selection.equals(ELSE_NEW_LINE_TEXT)) {
                                    elsePref = 2;
                                } else if (selection.equals(ELSE_SAME_LINE_TEXT)) {
                                    elsePref = 3;
                                }
                                this.fPreferences.changePreference(preferenceName, elsePref);
                                break block69;
                            }
                            if (!preferenceName.equals("format.indent.params")) break block71;
                            int index = this.fComboParam.getSelectionIndex();
                            String selection = this.fComboParam.getItem(index);
                            int paramPref = 0;
                            switch (selection) {
                                case "Leave as is": {
                                    paramPref = 1;
                                    this.fMorePerLineIfLessThanCheckbox.loadDefault();
                                    this.fMorePerLineIfLessThanThreshold.loadDefault();
                                    this.fPreferences.restoreDefaultBoolean("format.indent.more_per_line_if_less_than_enable");
                                    this.fPreferences.restoreDefaultInt("format.indent.more_per_line_if_less_than_threshold");
                                    break;
                                }
                                case "One per line (open parenthesis on the same line)": {
                                    paramPref = 2;
                                    break;
                                }
                                case "One per line (open parenthesis on the next line)": {
                                    paramPref = 3;
                                    break;
                                }
                                case "More per line": {
                                    paramPref = 4;
                                    this.fMorePerLineIfLessThanCheckbox.loadDefault();
                                    this.fMorePerLineIfLessThanThreshold.loadDefault();
                                    this.fPreferences.restoreDefaultBoolean("format.indent.more_per_line_if_less_than_enable");
                                    this.fPreferences.restoreDefaultInt("format.indent.more_per_line_if_less_than_threshold");
                                    break;
                                }
                            }
                            this.fPreferences.changePreference(preferenceName, paramPref);
                            break block69;
                        }
                        if (!preferenceName.equals("format.indent.more_per_line_if_less_than_enable")) break block73;
                        this.fPreferences.changePreference(preferenceName, this.fMorePerLineIfLessThanCheckbox.getBooleanValue());
                        break block69;
                    }
                    if (!preferenceName.equals("format.indent.more_per_line_if_less_than_threshold")) break block74;
                    this.fPreferences.changePreference(preferenceName, this.fMorePerLineIfLessThanThreshold.getIntValue());
                    break block69;
                }
                if (!preferenceName.equals("format.indent.preproc")) break block75;
                int index = this.fComboPreproc.getSelectionIndex();
                String selection = this.fComboPreproc.getItem(index);
                int preprocPref = 0;
                switch (selection) {
                    case "Leave as is": {
                        preprocPref = 1;
                        this.fPreferences.restoreDefaultBoolean("format.indent.skip.ml.macro.definitions");
                        break;
                    }
                    case "Indent": {
                        preprocPref = 2;
                        break;
                    }
                    case "Indent and increase indentation level": {
                        preprocPref = 3;
                        break;
                    }
                    case "Indent and increase indentation level - except first": {
                        preprocPref = 5;
                        break;
                    }
                    case "Move at first column": {
                        preprocPref = 4;
                        break;
                    }
                }
                this.fPreferences.changePreference(preferenceName, preprocPref);
                break block69;
            }
            if (preferenceName.equals("format.indent.no_indent_keywords")) {
                this.fPreferences.changePreference(preferenceName, this.fPreferences.getNoIndentPrefString());
            } else if (preferenceName.equals("format.indent.implicit_semi_macros")) {
                this.fPreferences.changePreference(preferenceName, this.fPreferences.createCommaSeparatedPropertyValue(this.fImplicitSemiMacrosList.getItems()));
            } else if (preferenceName.equals("format.indent.open_scope_macros")) {
                this.fPreferences.changePreference(preferenceName, this.fPreferences.createCommaSeparatedPropertyValue(this.fOpenScopeMacrosList.getItems()));
            } else if (preferenceName.equals("format.indent.close_scope_macros")) {
                this.fPreferences.changePreference(preferenceName, this.fPreferences.createCommaSeparatedPropertyValue(this.fCloseScopeMacrosList.getItems()));
            } else if (preferenceName.equals("format.indent.preserve_sl_comment_column_zero")) {
                this.fPreferences.changePreference(preferenceName, this.fPreserveSLCommentAtLineZeroEnable.getBooleanValue());
            } else if (preferenceName.equals("format.indent.multiline_comments")) {
                this.fPreferences.changePreference(preferenceName, this.fIndentMLCommentsEnable.getBooleanValue());
            } else if (preferenceName.equals("format.indent.skip_assigns")) {
                this.fPreferences.changePreference(preferenceName, this.fIndentSkipAssignsEnable.getBooleanValue());
            } else if (preferenceName.equals("format.indent.skip.ml.macro.definitions")) {
                this.fPreferences.changePreference(preferenceName, this.fIndentSkipMLMacroDefsEnable.getBooleanValue());
            } else if (preferenceName.equals("format.indent.ignore_lines")) {
                this.fPreferences.changePreference(preferenceName, this.fIgnoreLinesStartingWithTokens.getStringValue());
            } else if (preferenceName.equals("format.indent.add_new_line_after_begin_and_before_end")) {
                this.fPreferences.changePreference(preferenceName, this.fAddNewLineAfterBeginAndBeforeEndEnable.getBooleanValue());
            } else if (preferenceName.equals("format.indent.add_new_line_after_end")) {
                this.fPreferences.changePreference(preferenceName, this.fAddNewLineAfterEndEnable.getBooleanValue());
            }
        }
        super.processPreferenceChanged(preferenceName);
    }

    static abstract class MacrosSelectionAdapter
    extends SelectionAdapter {
        public Text newMacroText;
        public org.eclipse.swt.widgets.List macrosList;

        MacrosSelectionAdapter(Text newMacroText, org.eclipse.swt.widgets.List macrosList) {
            this.newMacroText = newMacroText;
            this.macrosList = macrosList;
        }
    }
}

