/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.formatter.preferences;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.widgets.Composite;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFBasePrefTabPage;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFPreferences;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFPreferencesPage;
import ro.amiq.dvt.ui.preferences.BooleanFieldEditor2;
import ro.amiq.dvt.utils.IntegerFieldEditor;

public class CFLineWrapPrefTabPage
extends CFBasePrefTabPage {
    private Composite fLineWrapEnableContainer;
    private BooleanFieldEditor2 fLineWrapEnable;
    private Composite fLineWrapThresholdContainer;
    private IntegerFieldEditor fLineWrapThreshold;
    private Composite fLineWrapSLCommentsEnableContainer;
    private BooleanFieldEditor2 fLineWrapSLCommentsEnable;
    private Composite fLineWrapMLCommentsEnableContainer;
    private BooleanFieldEditor2 fLineWrapMLCommentsEnable;

    public CFLineWrapPrefTabPage(CFPreferences preferences, CFPreferencesPage preferencesPage) {
        super(preferences, preferencesPage);
    }

    @Override
    protected void doCreatePreferences(Composite parent) {
        this.createLineWrapEnablePrefs(parent);
        this.createLineWrapThresholdPrefs(parent);
        this.createLineWrapSLCommentsPrefs(parent);
        this.createLineWrapMLCommentsPrefs(parent);
    }

    private void createLineWrapEnablePrefs(Composite parent) {
        this.fLineWrapEnableContainer = this.createContainer(parent, 0);
        this.fLineWrapEnable = this.createBooleanFieldEditor(this.fLineWrapEnableContainer, "format.line_wrap", "Enable line wrapping");
        this.addField((FieldEditor)this.fLineWrapEnable);
    }

    private void createLineWrapThresholdPrefs(Composite parent) {
        this.fLineWrapThresholdContainer = this.createContainer(parent, 2);
        this.fLineWrapThreshold = this.createIntegerFieldEditor(this.fLineWrapThresholdContainer, "format.line_wrap.threshold", "Line width:", 3);
        this.addField((FieldEditor)this.fLineWrapThreshold);
    }

    private void createLineWrapSLCommentsPrefs(Composite parent) {
        this.fLineWrapSLCommentsEnableContainer = this.createContainer(parent, 0);
        this.fLineWrapSLCommentsEnable = this.createBooleanFieldEditor(this.fLineWrapSLCommentsEnableContainer, "format.line_wrap.sl_comments", "Wrap single line comments and move above code when needed");
        this.addField((FieldEditor)this.fLineWrapSLCommentsEnable);
    }

    private void createLineWrapMLCommentsPrefs(Composite parent) {
        this.fLineWrapMLCommentsEnableContainer = this.createContainer(parent, 0);
        this.fLineWrapMLCommentsEnable = this.createBooleanFieldEditor(this.fLineWrapMLCommentsEnableContainer, "format.line_wrap.ml_comments", "Wrap multi line comments");
        this.addField((FieldEditor)this.fLineWrapMLCommentsEnable);
    }

    @Override
    protected void performDefaults() {
        super.performDefaults();
        this.fPreferences.restoreDefaultBoolean("format.line_wrap");
        this.fPreferences.restoreDefaultInt("format.line_wrap.threshold");
        this.fPreferences.restoreDefaultBoolean("format.line_wrap.sl_comments");
        this.fPreferences.restoreDefaultBoolean("format.line_wrap.ml_comments");
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.fLineWrapEnableContainer.setEnabled(enabled);
        this.fLineWrapEnable.setEnabled(enabled, this.fLineWrapEnableContainer);
        this.fLineWrapThreshold.setEnabled(enabled && this.fLineWrapEnable.getBooleanValue(), this.fLineWrapThresholdContainer);
        this.fLineWrapSLCommentsEnableContainer.setEnabled(enabled && this.fLineWrapEnable.getBooleanValue());
        this.fLineWrapSLCommentsEnable.setEnabled(enabled && this.fLineWrapEnable.getBooleanValue(), this.fLineWrapSLCommentsEnableContainer);
        this.fLineWrapMLCommentsEnableContainer.setEnabled(enabled && this.fLineWrapEnable.getBooleanValue());
        this.fLineWrapMLCommentsEnable.setEnabled(enabled && this.fLineWrapEnable.getBooleanValue(), this.fLineWrapMLCommentsEnableContainer);
    }

    @Override
    public void processPreferenceChanged(String preferenceName) {
        if (preferenceName.equals("format.line_wrap")) {
            this.fPreferences.changePreference(preferenceName, this.fLineWrapEnable.getBooleanValue());
        }
        if (preferenceName.equals("format.line_wrap.threshold")) {
            this.fPreferences.changePreference(preferenceName, this.fLineWrapThreshold.getIntValue());
        } else if (preferenceName.equals("format.line_wrap.sl_comments")) {
            this.fPreferences.changePreference(preferenceName, this.fLineWrapSLCommentsEnable.getBooleanValue());
        } else if (preferenceName.equals("format.line_wrap.ml_comments")) {
            this.fPreferences.changePreference(preferenceName, this.fLineWrapMLCommentsEnable.getBooleanValue());
        }
        super.processPreferenceChanged(preferenceName);
    }
}

