/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.formatter.preferences;

import de.cau.cs.kieler.core.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.TextUtils;
import ro.amiq.dvt.ui.editor.formatter.DVTContentFormatter;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFNoIndentDefinition;
import ro.amiq.dvt.ui.editor.formatter.scanner.vregex.CFVRegExBaseDefinition;

public abstract class CFPreferences {
    protected Set<String> addWSBeforePref;
    protected Set<String> addWSAfterPref;
    protected Set<String> ignoreLinesStartingWithPref;
    protected Set<String> noIndentKeywordsPref;
    protected List<String> verticalAlignTokensPref;
    protected LinkedHashMap<String, CFNoIndentDefinition> fAllNoIndentKeywordsPref;
    protected LinkedHashMap<String, CFVRegExBaseDefinition> fAllVRegExPref;

    protected CFPreferences() {
        this.initAllNoIndentKeywordsPref();
        this.readNoIndentPref();
        this.initAllVRegExPref();
        this.readVRegExPref();
        this.addWSBeforePref = new HashSet<String>();
        this.addWSAfterPref = new HashSet<String>();
        this.ignoreLinesStartingWithPref = new HashSet<String>();
        this.noIndentKeywordsPref = new HashSet<String>();
        this.verticalAlignTokensPref = new ArrayList<String>();
    }

    public abstract String getPreviewFileName();

    public abstract String getPreviewFileNameExtension();

    public boolean hasIndentOptions() {
        return true;
    }

    public boolean hasLineWrappingOptions() {
        return true;
    }

    public abstract boolean hasAddWhitespaceOptions();

    public abstract boolean hasRemoveNLOptions();

    public abstract boolean hasCapitalizationOptions();

    public abstract String getBeginKeywordText();

    public abstract boolean hasBeginPrefNewLineAndIndent();

    public abstract boolean hasElseOptions();

    public abstract boolean hasParametersOptions();

    public abstract boolean hasPreprocessingOptions();

    public abstract boolean hasIndentMLCommentsOptions();

    public abstract boolean hasIndentSkipAssignsOptions();

    public abstract boolean hasIndentSkipMLMacroDefsOptions();

    public abstract boolean hasIndentAssumeImplicitSemiMacrosOptions();

    public boolean hasNoIndentKeywordsOptions() {
        return this.fAllNoIndentKeywordsPref != null && this.fAllNoIndentKeywordsPref.size() > 0;
    }

    public LinkedHashMap<String, CFNoIndentDefinition> getAllNoIndentKeywordsPref() {
        return this.fAllNoIndentKeywordsPref;
    }

    public abstract boolean hasImplicitSemiOptions();

    public abstract boolean hasScopeMacrosOptions();

    public abstract boolean hasAddNewLineAfterBeginAndBeforeEnd();

    public abstract boolean hasAddNewLineAfterEnd();

    public boolean hasVRegExOptions() {
        return this.fAllVRegExPref != null && this.fAllVRegExPref.size() > 0;
    }

    public abstract boolean hasVIndependentIfdefs();

    public abstract boolean hasVParenOptions();

    public abstract boolean hasVCurlyOptions();

    public abstract boolean hasVRegExCompactWSOptions();

    public abstract boolean hasFixWhitespaceAfterCodeMarkerInExpansion();

    protected abstract AbstractUIPlugin getDefaultPlugin();

    protected abstract IPreferenceStore getPluginCombinedPreferenceStore();

    protected IPreferenceStore getPreferenceStore() {
        return this.getDefaultPlugin().getPreferenceStore();
    }

    public boolean getBooleanProperty(String propertyID) {
        return this.getPreferenceStore().getBoolean(propertyID);
    }

    public int getIntegerProperty(String propertyID) {
        return this.getPreferenceStore().getInt(propertyID);
    }

    public String getStringProperty(String propertyID) {
        return this.getPreferenceStore().getString(propertyID);
    }

    public boolean isCapitalizationKeyworsLeaveAsIs() {
        if (!this.hasCapitalizationOptions()) {
            return true;
        }
        return this.getIntegerProperty("format.capitalization.keywords") == 1;
    }

    public boolean isCapitalizationKeyworsUpper() {
        return this.hasCapitalizationOptions() && this.getIntegerProperty("format.capitalization.keywords") == 2;
    }

    public boolean isCapitalizationKeyworsLower() {
        return this.hasCapitalizationOptions() && this.getIntegerProperty("format.capitalization.keywords") == 3;
    }

    public boolean isCapitalizationDataTypesLeaveAsIs() {
        if (!this.hasCapitalizationOptions()) {
            return true;
        }
        return this.getIntegerProperty("format.capitalization.data_types") == 1;
    }

    public boolean isCapitalizationDataTypesUpper() {
        return this.hasCapitalizationOptions() && this.getIntegerProperty("format.capitalization.data_types") == 2;
    }

    public boolean isCapitalizationDataTypesLower() {
        return this.hasCapitalizationOptions() && this.getIntegerProperty("format.capitalization.data_types") == 3;
    }

    public boolean isCapitalizationAttributesLeaveAsIs() {
        if (!this.hasCapitalizationOptions()) {
            return true;
        }
        return this.getIntegerProperty("format.capitalization.attributes") == 1;
    }

    public boolean isCapitalizationAttributesUpper() {
        return this.hasCapitalizationOptions() && this.getIntegerProperty("format.capitalization.attributes") == 2;
    }

    public boolean isCapitalizationAttributesLower() {
        return this.hasCapitalizationOptions() && this.getIntegerProperty("format.capitalization.attributes") == 3;
    }

    public boolean isUseSpacesForTabsEnabled() {
        return TextUtils.getEditorSpacesForTabs(this.getPluginCombinedPreferenceStore());
    }

    public boolean isTrimEndOfLineWSEnabled() {
        return this.getBooleanProperty("format.whitespace.trim_end_of_line");
    }

    public boolean isTrimWhitespaceLineEnabled() {
        return this.getBooleanProperty("format.whitespace.trim_whitespace_line");
    }

    public boolean isCompactWSEnabled() {
        return this.getBooleanProperty("format.whitespace.compact");
    }

    public boolean isCompactConsecutiveEmptyLinesEnabled() {
        return this.getBooleanProperty("format.whitespace.compact_consecutive_empty_lines");
    }

    public int getMaximumNofConsecutiveEmptyLines() {
        return this.getIntegerProperty("format.whitespace.maximum_nof_consecutive_empty_lines");
    }

    public int getTabWidth() {
        return Utils.getTabWidth(this.getPluginCombinedPreferenceStore());
    }

    public String getAddWSBefore() {
        if (!this.hasAddWhitespaceOptions()) {
            return "";
        }
        return this.getStringProperty("format.whitespace.add_before");
    }

    public String getAddWSAfter() {
        return this.getStringProperty("format.whitespace.add_after");
    }

    public String getRemoveNLAfter() {
        if (!this.hasRemoveNLOptions()) {
            return "";
        }
        return this.getStringProperty("format.whitespace.remove_nl_after");
    }

    public String getRemoveNLBefore() {
        if (!this.hasRemoveNLOptions()) {
            return "";
        }
        return this.getStringProperty("format.whitespace.remove_nl_before");
    }

    public boolean isAddNewLineAfterBeginAndBeforeEnd() {
        return this.getBooleanProperty("format.indent.add_new_line_after_begin_and_before_end");
    }

    public boolean isAddNewLineAfterEnd() {
        return this.getBooleanProperty("format.indent.add_new_line_after_end");
    }

    public boolean isBeginPrefLeaveAsIs() {
        return this.getIntegerProperty("format.indent.begin") == 1;
    }

    public boolean isBeginPrefNewLine() {
        return this.getIntegerProperty("format.indent.begin") == 2;
    }

    public boolean isBeginPrefSameLine() {
        return this.getIntegerProperty("format.indent.begin") == 3;
    }

    public boolean isBeginPrefNewLineAndIndent() {
        return this.hasBeginPrefNewLineAndIndent() && this.getIntegerProperty("format.indent.begin") == 4;
    }

    public boolean isElsePrefLeaveAsIs() {
        return this.getIntegerProperty("format.indent.else") == 1;
    }

    public boolean isElsePrefNewLine() {
        return this.getIntegerProperty("format.indent.else") == 2;
    }

    public boolean isElsePrefSameLine() {
        return this.getIntegerProperty("format.indent.else") == 3;
    }

    public boolean isParamsPrefLeaveAsIs() {
        if (!this.hasParametersOptions()) {
            return true;
        }
        return this.getIntegerProperty("format.indent.params") == 1;
    }

    public boolean isParamsPrefNewLineOpenParenNextLine() {
        return this.hasParametersOptions() && this.getIntegerProperty("format.indent.params") == 3;
    }

    public boolean isParamsPrefNewLineOpenParenSameLine() {
        return this.hasParametersOptions() && this.getIntegerProperty("format.indent.params") == 2;
    }

    public boolean isParamsPrefNewLine() {
        return this.isParamsPrefNewLineOpenParenNextLine() || this.isParamsPrefNewLineOpenParenSameLine();
    }

    public boolean isParamsPrefSameLine() {
        return this.hasParametersOptions() && this.getIntegerProperty("format.indent.params") == 4;
    }

    public boolean isMorePerLineIfLessThan() {
        if (this.isParamsPrefNewLineOpenParenNextLine() || this.isParamsPrefNewLineOpenParenSameLine()) {
            return this.getBooleanProperty("format.indent.more_per_line_if_less_than_enable");
        }
        return false;
    }

    public int getMorePerLineIfLessThanThreshold() {
        if (this.isParamsPrefNewLineOpenParenNextLine() || this.isParamsPrefNewLineOpenParenSameLine()) {
            return this.getIntegerProperty("format.indent.more_per_line_if_less_than_threshold");
        }
        return -1;
    }

    public boolean isPreprocPrefLeaveAsIs() {
        if (!this.hasPreprocessingOptions()) {
            return true;
        }
        return this.getIntegerProperty("format.indent.preproc") == 1;
    }

    public boolean isPreprocPrefResetIndent() {
        return this.hasPreprocessingOptions() && this.getIntegerProperty("format.indent.preproc") == 4;
    }

    public boolean isPreprocPrefIndent() {
        return this.hasPreprocessingOptions() && this.getIntegerProperty("format.indent.preproc") == 2;
    }

    public boolean isPreprocPrefIndentContent() {
        return this.hasPreprocessingOptions() && this.getIntegerProperty("format.indent.preproc") == 3;
    }

    public boolean isPreprocPrefIndentContentExceptFirst() {
        return this.hasPreprocessingOptions() && this.getIntegerProperty("format.indent.preproc") == 5;
    }

    public boolean isPreserveSLCommentAtColumnZeroEnabled() {
        return this.getBooleanProperty("format.indent.preserve_sl_comment_column_zero");
    }

    public boolean isIndentMLCommentsEnabled() {
        return this.hasIndentMLCommentsOptions() && this.getBooleanProperty("format.indent.multiline_comments");
    }

    public boolean isIndentSkipAssignsEnabled() {
        return this.hasIndentSkipAssignsOptions() && this.getBooleanProperty("format.indent.skip_assigns");
    }

    public boolean isIndentSkipMLMacroDefsEnabled() {
        return this.hasIndentSkipMLMacroDefsOptions() && this.getBooleanProperty("format.indent.skip.ml.macro.definitions");
    }

    public boolean isIndentAssumeImplicitSemiMacrosEnabled() {
        return this.hasIndentAssumeImplicitSemiMacrosOptions() && this.getBooleanProperty("format.indent.assume_implicit_semi_macros");
    }

    public String getIgnoreLinesStartingWith() {
        return this.getStringProperty("format.indent.ignore_lines");
    }

    protected void initAllNoIndentKeywordsPref() {
        this.fAllNoIndentKeywordsPref = new LinkedHashMap();
    }

    protected void readNoIndentPref() {
        if (this.fAllNoIndentKeywordsPref == null || this.fAllNoIndentKeywordsPref.isEmpty()) {
            return;
        }
        for (CFNoIndentDefinition def : this.fAllNoIndentKeywordsPref.values()) {
            if (def == null) continue;
            def.setEnabled(false);
        }
        String rawPrefs = this.getStringProperty("format.indent.no_indent_keywords");
        if (rawPrefs == null) {
            return;
        }
        String[] prefs = rawPrefs.split(",");
        if (prefs == null) {
            return;
        }
        String[] stringArray = prefs;
        int n = prefs.length;
        int n2 = 0;
        while (n2 < n) {
            CFNoIndentDefinition def;
            String pref = stringArray[n2];
            if (pref != null && (def = this.fAllNoIndentKeywordsPref.get(pref = pref.trim())) != null) {
                def.setEnabled(true);
            }
            ++n2;
        }
    }

    public List<CFNoIndentDefinition> getNoIndentPref() {
        this.readNoIndentPref();
        ArrayList<CFNoIndentDefinition> result = new ArrayList<CFNoIndentDefinition>();
        for (CFNoIndentDefinition def : this.fAllNoIndentKeywordsPref.values()) {
            result.add(def);
        }
        return result;
    }

    public void enableNoIndentPref(String name, boolean enable) {
        CFNoIndentDefinition def = this.fAllNoIndentKeywordsPref.get(name);
        if (def != null) {
            def.setEnabled(enable);
        }
    }

    public String getNoIndentPrefString() {
        StringBuilder result = new StringBuilder();
        boolean needComma = false;
        for (CFNoIndentDefinition def : this.fAllNoIndentKeywordsPref.values()) {
            if (def == null || !def.isEnabled()) continue;
            if (needComma) {
                result.append(",");
            }
            result.append(def.getName());
            needComma = true;
        }
        return result.toString();
    }

    public String getImplicitSemiMacros() {
        if (!this.hasImplicitSemiOptions()) {
            return null;
        }
        return this.getStringProperty("format.indent.implicit_semi_macros");
    }

    public String getOpenScopeMacros() {
        if (!this.hasScopeMacrosOptions()) {
            return null;
        }
        return this.getStringProperty("format.indent.open_scope_macros");
    }

    public String getCloseScopeMacros() {
        if (!this.hasScopeMacrosOptions()) {
            return null;
        }
        return this.getStringProperty("format.indent.close_scope_macros");
    }

    public boolean isLineWrapEnabled() {
        return this.getBooleanProperty("format.line_wrap");
    }

    public boolean isLineWrapSLCommentsEnabled() {
        return this.getBooleanProperty("format.line_wrap.sl_comments");
    }

    public boolean isLineWrapMLCommentsEnabled() {
        return this.getBooleanProperty("format.line_wrap.ml_comments");
    }

    public int getLineWrapThreshold(boolean isPreview) {
        if (isPreview) {
            return this.getIntegerProperty("format.preview.line_wrap_threshold");
        }
        return this.getIntegerProperty("format.line_wrap.threshold");
    }

    public boolean isVerticalAlignEnabled() {
        return this.getBooleanProperty("format.vertical_align");
    }

    public boolean isVerticalAlignIndependentIfdefs() {
        return this.getBooleanProperty("format.vertical_align.independent_ifdefs");
    }

    public boolean isVerticalAlignConsecutiveLines() {
        return this.getBooleanProperty("format.vertical_align.consecutive_lines");
    }

    public boolean isVerticalAlignSLCommentsEnabled() {
        return this.getBooleanProperty("format.vertical_align.sl_comments");
    }

    public boolean isVerticalAlignParenEnabled() {
        if (!this.isVerticalAlignEnabled()) {
            return false;
        }
        if (!this.hasVParenOptions()) {
            return false;
        }
        return this.getBooleanProperty("format.vertical_align.paren");
    }

    public boolean isVerticalAlignCurlyEnabled() {
        if (!this.isVerticalAlignEnabled()) {
            return false;
        }
        if (!this.hasVCurlyOptions()) {
            return false;
        }
        return this.getBooleanProperty("format.vertical_align.curly");
    }

    protected void initAllVRegExPref() {
        this.fAllVRegExPref = new LinkedHashMap();
    }

    protected void readVRegExPref() {
        for (CFVRegExBaseDefinition def : this.fAllVRegExPref.values()) {
            if (def == null) continue;
            def.setEnabled(false);
        }
        String rawPrefs = this.getStringProperty("format.vertical_align.vregex");
        if (rawPrefs == null) {
            return;
        }
        String[] prefs = rawPrefs.split(",");
        if (prefs == null) {
            return;
        }
        String[] stringArray = prefs;
        int n = prefs.length;
        int n2 = 0;
        while (n2 < n) {
            boolean isGroupDimensionsPattern;
            CFVRegExBaseDefinition def;
            String pref = stringArray[n2];
            if (!(pref == null || (def = this.fAllVRegExPref.get(pref = pref.trim())) == null || (isGroupDimensionsPattern = def.getName().endsWith("GroupDimensions")) && this.isSplitDimensionsPatternEnabled(pref, prefs))) {
                def.setEnabled(true);
            }
            ++n2;
        }
    }

    private boolean isSplitDimensionsPatternEnabled(String patternName, String[] prefs) {
        String pairPattern = null;
        for (Pair<String, String> verticalAlignPatternsPair : DVTContentFormatter.CFVREGEX_VLOG_PATTERNS_PAIRS) {
            if (verticalAlignPatternsPair == null) continue;
            String firstPattern = (String)verticalAlignPatternsPair.getFirst();
            String secondPattern = (String)verticalAlignPatternsPair.getSecond();
            if (firstPattern.equals(patternName)) {
                pairPattern = secondPattern;
                break;
            }
            if (!secondPattern.equals(patternName)) continue;
            pairPattern = firstPattern;
            break;
        }
        if (pairPattern == null) {
            return false;
        }
        String[] stringArray = prefs;
        int n = prefs.length;
        int n2 = 0;
        while (n2 < n) {
            String pref = stringArray[n2];
            if (pref != null && pairPattern.equals(pref.trim())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public List<CFVRegExBaseDefinition> getVRegExPref() {
        this.readVRegExPref();
        ArrayList<CFVRegExBaseDefinition> result = new ArrayList<CFVRegExBaseDefinition>();
        for (CFVRegExBaseDefinition def : this.fAllVRegExPref.values()) {
            result.add(def);
        }
        return result;
    }

    public void enableVRegExPref(String vRegExName, boolean enable) {
        CFVRegExBaseDefinition def = this.fAllVRegExPref.get(vRegExName);
        if (def != null) {
            def.setEnabled(enable);
        }
    }

    public boolean isVerticalAlignByRegExEnabled() {
        if (!this.isVerticalAlignEnabled()) {
            return false;
        }
        List<CFVRegExBaseDefinition> defs = this.getVRegExPref();
        if (defs == null) {
            return false;
        }
        for (CFVRegExBaseDefinition def : defs) {
            if (!def.isEnabled()) continue;
            return true;
        }
        return false;
    }

    public boolean isVRegExCompactWSEnabled() {
        if (!this.hasVRegExCompactWSOptions()) {
            return false;
        }
        return this.getBooleanProperty("format.vertical.align.vregex.compact.whitespace");
    }

    public String getVRegExPrefString() {
        StringBuilder result = new StringBuilder();
        boolean needComma = false;
        for (CFVRegExBaseDefinition def : this.fAllVRegExPref.values()) {
            if (def == null || !def.isEnabled()) continue;
            if (needComma) {
                result.append(",");
            }
            result.append(def.getName());
            needComma = true;
        }
        return result.toString();
    }

    public boolean isExternalPreFormatEnabled() {
        return this.getBooleanProperty("format.pre_external");
    }

    public String getExternalPreFormatCommand() {
        return this.getStringProperty("format.pre_external.command");
    }

    public boolean isExternalPostFormatEnabled() {
        return this.getBooleanProperty("format.post_external");
    }

    public String getExternalPostFormatCommand() {
        return this.getStringProperty("format.post_external.command");
    }

    public void restoreDefaultBoolean(String preferenceName) {
        IPreferenceStore store = this.getPreferenceStore();
        if (store.getBoolean(preferenceName) != store.getDefaultBoolean(preferenceName)) {
            store.setValue(preferenceName, store.getDefaultBoolean(preferenceName));
        }
    }

    public boolean changePreference(String preferenceName, boolean booleanValue) {
        IPreferenceStore store = this.getPreferenceStore();
        if (booleanValue == store.getBoolean(preferenceName)) {
            return false;
        }
        store.setValue(preferenceName, booleanValue);
        return true;
    }

    public void restoreDefaultInt(String preferenceName) {
        IPreferenceStore store = this.getPreferenceStore();
        if (store.getInt(preferenceName) != store.getDefaultInt(preferenceName)) {
            store.setValue(preferenceName, store.getDefaultInt(preferenceName));
        }
    }

    public boolean changePreference(String preferenceName, int intValue) {
        IPreferenceStore store = this.getPreferenceStore();
        if (intValue == store.getInt(preferenceName)) {
            return false;
        }
        store.setValue(preferenceName, intValue);
        return true;
    }

    public void restoreDefaultString(String preferenceName) {
        IPreferenceStore store = this.getPreferenceStore();
        if (!store.getString(preferenceName).equals(store.getDefaultString(preferenceName))) {
            store.setValue(preferenceName, store.getDefaultString(preferenceName));
        }
    }

    public boolean changePreference(String preferenceName, String stringValue) {
        IPreferenceStore store = this.getPreferenceStore();
        if (stringValue.equals(store.getString(preferenceName))) {
            return false;
        }
        store.setValue(preferenceName, stringValue);
        return true;
    }

    public String createCommaSeparatedPropertyValue(String[] values) {
        Arrays.sort(values);
        StringBuilder result = new StringBuilder();
        boolean needComma = false;
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (needComma) {
                result.append(",");
            }
            result.append(value);
            needComma = true;
            ++n2;
        }
        return result.toString();
    }

    public ArrayList<String> getSortedCommaSeparatedProperty(String prefConst, boolean useDefaults) {
        IPreferenceStore prefStore = this.getPreferenceStore();
        String prefVal = useDefaults ? prefStore.getDefaultString(prefConst) : this.getStringProperty(prefConst);
        ArrayList<String> result = new ArrayList<String>();
        if (prefVal == null || prefVal.isEmpty()) {
            return result;
        }
        String[] splittedPrefVal = prefVal.trim().split(",");
        if (splittedPrefVal == null) {
            return result;
        }
        String[] stringArray = splittedPrefVal;
        int n = splittedPrefVal.length;
        int n2 = 0;
        while (n2 < n) {
            String trimmedVal;
            String aPrefVal = stringArray[n2];
            if (aPrefVal != null && !(trimmedVal = aPrefVal.trim()).isEmpty()) {
                result.add(trimmedVal);
            }
            ++n2;
        }
        Collections.sort(result);
        return result;
    }

    public Set<String> getAddWSBeforePref() {
        return this.addWSBeforePref;
    }

    public Set<String> getAddWSAfterPref() {
        return this.addWSAfterPref;
    }

    public Set<String> getIgnoreLinesStartingWithPref() {
        return this.ignoreLinesStartingWithPref;
    }

    public Set<String> getNoIndentKeywordsPref() {
        return this.noIndentKeywordsPref;
    }

    public List<String> getVerticalAlignTokensPref() {
        return this.verticalAlignTokensPref;
    }

    public String getVerticalAlignTokens() {
        return this.getStringProperty("format.vertical_align.tokens");
    }

    public void refreshAddWSBefore() {
        this.refreshWSSeparatedPref(this.addWSBeforePref, this.getAddWSBefore());
    }

    public void refreshAddWSAfter() {
        this.refreshWSSeparatedPref(this.addWSAfterPref, this.getAddWSAfter());
    }

    public void refreshIgnoreLinesPref() {
        this.refreshWSSeparatedPref(this.ignoreLinesStartingWithPref, this.getIgnoreLinesStartingWith());
    }

    protected void refreshWSSeparatedPref(Set<String> into, String from) {
        into.clear();
        if (from == null) {
            return;
        }
        String[] values = (from = from.trim()).split(" ");
        if (values != null) {
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                if (value != null && !(value = value.trim()).isEmpty()) {
                    into.add(value);
                }
                ++n2;
            }
        }
    }

    public void refreshNoIndentKeywordsPref() {
        if (!this.hasNoIndentKeywordsOptions()) {
            return;
        }
        this.noIndentKeywordsPref.clear();
        List<CFNoIndentDefinition> noIndentPref = this.getNoIndentPref();
        if (noIndentPref == null || noIndentPref.isEmpty()) {
            return;
        }
        for (CFNoIndentDefinition def : noIndentPref) {
            if (def == null || !def.isEnabled()) continue;
            this.noIndentKeywordsPref.add(def.getName());
        }
    }

    public void refreshVAlignTokensPref() {
        this.verticalAlignTokensPref.clear();
        String tokensString = this.getVerticalAlignTokens();
        if (tokensString == null) {
            return;
        }
        StringBuilder tok = new StringBuilder();
        HashSet<String> result = new HashSet<String>();
        boolean backSlash = false;
        int i = 0;
        while (i < tokensString.length()) {
            char ch = tokensString.charAt(i);
            if (ch == ',' && backSlash) {
                tok.append(ch);
                backSlash = false;
            } else if (ch == '\\' && backSlash) {
                tok.append(ch);
            } else if (ch == '\\') {
                backSlash = !backSlash;
            } else if (ch == ',' && tok.length() != 0) {
                result.add(tok.toString());
                tok.delete(0, tok.length());
            } else if (!Character.isWhitespace(ch)) {
                tok.append(ch);
            }
            ++i;
        }
        if (!tok.toString().isEmpty()) {
            result.add(tok.toString().trim());
        }
        for (String vTokenString : result) {
            boolean valid = true;
            if (vTokenString == null || (vTokenString = vTokenString.trim()).isEmpty()) continue;
            int i2 = 0;
            while (i2 < vTokenString.length()) {
                if (Character.isJavaIdentifierPart(vTokenString.charAt(i2))) {
                    valid = false;
                    break;
                }
                ++i2;
            }
            if (!valid) continue;
            this.verticalAlignTokensPref.add(vTokenString);
        }
        Collections.sort(this.verticalAlignTokensPref, (s, t) -> {
            if (s.length() != t.length()) {
                return s.length() - t.length();
            }
            return s.compareTo((String)t);
        });
    }
}

