/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.formatter.preferences;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFBasePrefTabPage;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFCapitalizationPrefTabPage;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFExternalPrefTabPage;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFIndentPrefTabPage;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFLineWrapPrefTabPage;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFPreferences;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFVerticalAlignPrefTabPage;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFWhitespacePrefTabPage;
import ro.amiq.dvt.utils.DVTDocumentCommon;

public abstract class CFPreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    protected CFPreferences fPreferences;
    private boolean fPreviewShowInvisibleCharsEnabled;
    private int fPreviewLineWrapThreshold;
    private TabFolder fTabFolder;
    private List<CFBasePrefTabPage> fTabPages;

    public CFPreferencesPage() {
        super(1);
        this.setDescription(null);
    }

    protected abstract DVTSourceViewerConfiguration createPreviewSourceViewerconfiguration();

    protected abstract IDocumentSetupParticipant createPreviewDocumentSetupParticipant();

    protected Control createContents(Composite parent) {
        this.fTabFolder = new TabFolder(parent, 0);
        this.fTabFolder.setFont(parent.getFont());
        this.fTabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fTabPages = new ArrayList<CFBasePrefTabPage>();
        this.fTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TabItem tabItem = CFPreferencesPage.this.fTabFolder.getSelection()[0];
                Object data = tabItem.getData();
                if (data instanceof CFBasePrefTabPage) {
                    ((CFBasePrefTabPage)((Object)data)).updatePreviewerContent();
                }
            }
        });
        if (this.fPreferences.hasCapitalizationOptions()) {
            this.addTabPage("Capitalization", new CFCapitalizationPrefTabPage(this.fPreferences, this));
        }
        this.addTabPage("Whitespace", new CFWhitespacePrefTabPage(this.fPreferences, this));
        if (this.fPreferences.hasIndentOptions()) {
            this.addTabPage("Indentation", new CFIndentPrefTabPage(this.fPreferences, this));
        }
        this.addTabPage("Vertical Alignment", new CFVerticalAlignPrefTabPage(this.fPreferences, this));
        if (this.fPreferences.hasLineWrappingOptions()) {
            this.addTabPage("Line Wrapping", new CFLineWrapPrefTabPage(this.fPreferences, this));
        }
        this.addTabPage("External", new CFExternalPrefTabPage(this.fPreferences, this));
        return this.fTabFolder;
    }

    protected final void addTabPage(String title, CFBasePrefTabPage tabPage) {
        this.fTabPages.add(tabPage);
        TabItem tabItem = new TabItem(this.fTabFolder, 0);
        tabItem.setText(title);
        tabItem.setData((Object)tabPage);
        tabItem.setControl(tabPage.createContents((Composite)this.fTabFolder));
    }

    public boolean isExternalFormatEnabled() {
        return this.getPreferenceStore().getBoolean("format.external");
    }

    public boolean isPreviewShowInvisibleCharsEnabled() {
        return this.fPreviewShowInvisibleCharsEnabled;
    }

    public void setPreviewShowInvisibleCharsEnabled(boolean enabled) {
        this.fPreviewShowInvisibleCharsEnabled = enabled;
    }

    public int getPreviewLineWrapThreshold() {
        return this.fPreviewLineWrapThreshold;
    }

    public void setPreviewLineWrapThreshold(int threshold) {
        this.fPreviewLineWrapThreshold = threshold;
    }

    protected void performDefaults() {
        super.performDefaults();
        for (CFBasePrefTabPage tp : this.fTabPages) {
            tp.doRestoreDefaults();
        }
    }

    public void refreshEnable() {
        for (CFBasePrefTabPage tp : this.fTabPages) {
            if (this.isExternalFormatEnabled()) {
                tp.setEnabled(false);
                continue;
            }
            tp.setEnabled(true);
        }
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String loadPreviewContentFromFile(String filename) {
        BufferedReader reader;
        StringBuilder buffer;
        block14: {
            buffer = new StringBuilder(512);
            reader = null;
            if (((Object)((Object)this)).getClass().getResource(filename) != null) break block14;
            if (reader == null) return "";
            try {
                reader.close();
                return "";
            }
            catch (IOException iOException) {}
            return "";
        }
        try {
            try {
                String line;
                reader = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(filename)));
                String separator = DVTDocumentCommon.getLineDelimiter(null);
                while ((line = reader.readLine()) != null) {
                    buffer.append(line);
                    buffer.append(separator);
                }
            }
            catch (IOException io) {
                DVTLogger.INSTANCE.logError((Throwable)io);
                if (reader == null) return buffer.toString();
                try {
                    reader.close();
                    return buffer.toString();
                }
                catch (IOException iOException) {}
                return buffer.toString();
            }
        }
        catch (Throwable throwable) {
            if (reader == null) throw throwable;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        if (reader == null) return buffer.toString();
        try {
            reader.close();
            return buffer.toString();
        }
        catch (IOException iOException) {}
        return buffer.toString();
    }
}

