/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.formatter.preferences;

import de.cau.cs.kieler.core.util.Pair;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import ro.amiq.dvt.ui.editor.formatter.DVTContentFormatter;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFBasePrefTabPage;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFPreferences;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFPreferencesPage;
import ro.amiq.dvt.ui.editor.formatter.scanner.vregex.CFVRegExBaseDefinition;
import ro.amiq.dvt.ui.preferences.BooleanFieldEditor2;
import ro.amiq.dvt.ui.utils.DVTColorUtil;

public class CFVerticalAlignPrefTabPage
extends CFBasePrefTabPage {
    private Composite fVerticalAlignEnableContainer;
    private BooleanFieldEditor2 fVerticalAlignEnable;
    private Composite fVerticalAlignIndependentIfdefsContainer;
    private BooleanFieldEditor2 fVerticalAlignIndependentIfdefs;
    private Composite fVerticalAlignConsecutiveLinesContainer;
    private BooleanFieldEditor2 fVerticalAlignConsecutiveLines;
    private Composite fVerticalAlignTokensContainer;
    private StringFieldEditor fVerticalAlignTokens;
    private Composite fVerticalAlignParenEnableContainer;
    private BooleanFieldEditor2 fVerticalAlignParenEnable;
    private Composite fVerticalAlignCurlyEnableContainer;
    private BooleanFieldEditor2 fVerticalAlignCurlyEnable;
    private Composite fVerticalAlignSLCommentsEnableContainer;
    private BooleanFieldEditor2 fVerticalAlignSLCommentsEnable;
    private Composite fVerticalAlignVRegExCompactWSEnableContainer;
    private BooleanFieldEditor2 fVerticalAlignVRegExCompactWSEnable;
    private Composite fVerticalAlignVRegexContainer;
    private Label fVerticalAlignVRegexLabel;
    private CheckboxTableViewer fVerticalAlignVRegexTable;

    public CFVerticalAlignPrefTabPage(CFPreferences preferences, CFPreferencesPage preferencesPage) {
        super(preferences, preferencesPage);
    }

    @Override
    protected void doCreatePreferences(Composite parent) {
        this.createVerticalAlignEnablePrefs(parent);
        this.createVerticalIndependentIfdefsPrefs(parent);
        this.createVerticalAlignTokensPrefs(parent);
        this.createVerticalAlignConsecutiveLines(parent);
        this.createVerticalAlignParenPrefs(parent);
        this.createVerticalAlignCurlyPrefs(parent);
        this.createVerticalAlignSLCommentsPrefs(parent);
        this.createVerticalAlignVRegExCompactWSPrefs(parent);
        this.createVerticalAlignVRegExPrefs(parent);
    }

    private void createVerticalAlignEnablePrefs(Composite parent) {
        this.fVerticalAlignEnableContainer = this.createContainer(parent, 0);
        this.fVerticalAlignEnable = this.createBooleanFieldEditor(this.fVerticalAlignEnableContainer, "format.vertical_align", "Enable vertical alignment");
        this.addField((FieldEditor)this.fVerticalAlignEnable);
    }

    private void createVerticalIndependentIfdefsPrefs(Composite parent) {
        if (!this.fPreferences.hasVIndependentIfdefs()) {
            return;
        }
        this.fVerticalAlignIndependentIfdefsContainer = this.createContainer(parent, 0);
        this.fVerticalAlignIndependentIfdefs = this.createBooleanFieldEditor(this.fVerticalAlignIndependentIfdefsContainer, "format.vertical_align.independent_ifdefs", "Independent `ifdefs");
        this.addField((FieldEditor)this.fVerticalAlignIndependentIfdefs);
    }

    private void createVerticalAlignTokensPrefs(Composite parent) {
        this.fVerticalAlignTokensContainer = this.createContainer(parent, 2);
        this.fVerticalAlignTokens = this.createStringFieldEditor(this.fVerticalAlignTokensContainer, "format.vertical_align.tokens", "Vertical align tokens:");
        this.addField((FieldEditor)this.fVerticalAlignTokens);
    }

    private void createVerticalAlignConsecutiveLines(Composite parent) {
        this.fVerticalAlignConsecutiveLinesContainer = this.createContainer(parent, 0);
        this.fVerticalAlignConsecutiveLines = this.createBooleanFieldEditor(this.fVerticalAlignConsecutiveLinesContainer, "format.vertical_align.consecutive_lines", "Only consecutive lines");
        this.addField((FieldEditor)this.fVerticalAlignConsecutiveLines);
    }

    private void createVerticalAlignParenPrefs(Composite parent) {
        if (!this.fPreferences.hasVParenOptions()) {
            return;
        }
        this.fVerticalAlignParenEnableContainer = this.createContainer(parent, 0);
        this.fVerticalAlignParenEnable = this.createBooleanFieldEditor(this.fVerticalAlignParenEnableContainer, "format.vertical_align.paren", "Vertical align to open parenthesis");
        this.addField((FieldEditor)this.fVerticalAlignParenEnable);
    }

    private void createVerticalAlignCurlyPrefs(Composite parent) {
        if (!this.fPreferences.hasVCurlyOptions()) {
            return;
        }
        this.fVerticalAlignCurlyEnableContainer = this.createContainer(parent, 0);
        this.fVerticalAlignCurlyEnable = this.createBooleanFieldEditor(this.fVerticalAlignCurlyEnableContainer, "format.vertical_align.curly", "Vertical align to open curly");
        this.addField((FieldEditor)this.fVerticalAlignCurlyEnable);
    }

    private void createVerticalAlignSLCommentsPrefs(Composite parent) {
        this.fVerticalAlignSLCommentsEnableContainer = this.createContainer(parent, 0);
        this.fVerticalAlignSLCommentsEnable = this.createBooleanFieldEditor(this.fVerticalAlignSLCommentsEnableContainer, "format.vertical_align.sl_comments", "Vertical align single line comments");
        this.addField((FieldEditor)this.fVerticalAlignSLCommentsEnable);
    }

    private void createVerticalAlignVRegExCompactWSPrefs(Composite parent) {
        if (!this.fPreferences.hasVRegExCompactWSOptions()) {
            return;
        }
        this.fVerticalAlignVRegExCompactWSEnableContainer = this.createContainer(parent, 0);
        this.fVerticalAlignVRegExCompactWSEnable = this.createBooleanFieldEditor(this.fVerticalAlignVRegExCompactWSEnableContainer, "format.vertical.align.vregex.compact.whitespace", "Compact whitespace for vertical align patterns");
        this.addField((FieldEditor)this.fVerticalAlignVRegExCompactWSEnable);
    }

    private void createVerticalAlignVRegExPrefs(Composite parent) {
        if (!this.fPreferences.hasVRegExOptions()) {
            return;
        }
        this.fVerticalAlignVRegexContainer = this.createContainer(parent, 2);
        this.fVerticalAlignVRegexLabel = this.createPreListLabel(this.fVerticalAlignVRegexContainer, "Vertical align patterns:");
        TableViewer fVerticalAlignVRegexTV = new TableViewer(this.fVerticalAlignVRegexContainer, 2084);
        this.fVerticalAlignVRegexTable = new CheckboxTableViewer(fVerticalAlignVRegexTV.getTable());
        GridData gd = new GridData(4, 0x1000000, true, false, 2, 1);
        gd.grabExcessHorizontalSpace = true;
        gd.minimumHeight = this.convertHeightInCharsToPixels(5);
        gd.heightHint = this.convertHeightInCharsToPixels(10);
        this.fVerticalAlignVRegexTable.getTable().setLayoutData((Object)gd);
        TableLayout layout = new TableLayout();
        this.fVerticalAlignVRegexTable.getTable().setLayout((Layout)layout);
        this.fVerticalAlignVRegexTable.setContentProvider((IContentProvider)new CFVRegexTableContentProvider());
        this.fVerticalAlignVRegexTable.setCheckStateProvider((ICheckStateProvider)new CFVRegexTableStateProvider());
        this.fVerticalAlignVRegexTable.addCheckStateListener((ICheckStateListener)new CFVRegexTableStateListener());
        this.fVerticalAlignVRegexTable.setLabelProvider((IBaseLabelProvider)new CFVRegexTableLabelProvider());
        List<CFVRegExBaseDefinition> vRegExPrefs = this.fPreferences.getVRegExPref();
        Collections.sort(vRegExPrefs, (o1, o2) -> {
            if (o1 == null || o2 == null) {
                return 0;
            }
            String o1Name = o1.getName();
            String o2Name = o2.getName();
            if (o1Name == null || o2Name == null) {
                return 0;
            }
            return o1Name.compareTo(o2Name);
        });
        this.fVerticalAlignVRegexTable.setInput(vRegExPrefs);
    }

    private String getPairPatternName(String patternName) {
        for (Pair<String, String> verticalAlignPatternsPair : DVTContentFormatter.CFVREGEX_VLOG_PATTERNS_PAIRS) {
            if (verticalAlignPatternsPair == null) continue;
            String firstPattern = (String)verticalAlignPatternsPair.getFirst();
            String secondPattern = (String)verticalAlignPatternsPair.getSecond();
            if (firstPattern.equals(patternName)) {
                return secondPattern;
            }
            if (!secondPattern.equals(patternName)) continue;
            return firstPattern;
        }
        return null;
    }

    private Object getPairedPatternTableItem(String patternName) {
        if (!this.fPreferences.hasVRegExOptions()) {
            return null;
        }
        String pairPatternName = this.getPairPatternName(patternName);
        if (pairPatternName == null) {
            return null;
        }
        Object patternsTableInput = this.fVerticalAlignVRegexTable.getInput();
        if (!(patternsTableInput instanceof List)) {
            return null;
        }
        for (Object pattern : (List)patternsTableInput) {
            String name;
            if (!(pattern instanceof CFVRegExBaseDefinition) || !pairPatternName.equals(name = ((CFVRegExBaseDefinition)pattern).getName())) continue;
            return pattern;
        }
        return null;
    }

    private boolean isVerticalAlignPatternPrefEnabled(String refPatternName) {
        if (refPatternName == null) {
            return false;
        }
        List<CFVRegExBaseDefinition> patterns = this.fPreferences.getVRegExPref();
        for (CFVRegExBaseDefinition pattern : patterns) {
            if (pattern == null || !refPatternName.equals(pattern.getName()) || !pattern.isEnabled()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void performDefaults() {
        super.performDefaults();
        this.fPreferences.restoreDefaultBoolean("format.vertical_align");
        if (this.fPreferences.hasVIndependentIfdefs()) {
            this.fPreferences.restoreDefaultBoolean("format.vertical_align.independent_ifdefs");
        }
        this.fPreferences.restoreDefaultString("format.vertical_align.tokens");
        this.fPreferences.restoreDefaultBoolean("format.vertical_align.consecutive_lines");
        if (this.fPreferences.hasVParenOptions()) {
            this.fPreferences.restoreDefaultBoolean("format.vertical_align.paren");
        }
        if (this.fPreferences.hasVCurlyOptions()) {
            this.fPreferences.restoreDefaultBoolean("format.vertical_align.curly");
        }
        this.fPreferences.restoreDefaultBoolean("format.vertical_align.sl_comments");
        if (this.fPreferences.hasVRegExOptions()) {
            this.fPreferences.restoreDefaultString("format.vertical_align.vregex");
            Object patterns = this.fVerticalAlignVRegexTable.getInput();
            if (!(patterns instanceof List)) {
                return;
            }
            for (Object pattern : (List)patterns) {
                this.fVerticalAlignVRegexTable.setChecked(pattern, false);
            }
        }
        if (this.fPreferences.hasVRegExCompactWSOptions()) {
            this.fPreferences.restoreDefaultBoolean("format.vertical.align.vregex.compact.whitespace");
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.fVerticalAlignEnableContainer.setEnabled(enabled);
        this.fVerticalAlignEnable.setEnabled(enabled, this.fVerticalAlignEnableContainer);
        if (this.fPreferences.hasVIndependentIfdefs()) {
            this.fVerticalAlignIndependentIfdefsContainer.setEnabled(enabled && this.fVerticalAlignEnable.getBooleanValue());
            this.fVerticalAlignIndependentIfdefs.setEnabled(enabled && this.fVerticalAlignEnable.getBooleanValue(), this.fVerticalAlignIndependentIfdefsContainer);
        }
        this.fVerticalAlignTokensContainer.setEnabled(enabled && this.fVerticalAlignEnable.getBooleanValue());
        this.fVerticalAlignTokens.setEnabled(enabled && this.fVerticalAlignEnable.getBooleanValue(), this.fVerticalAlignTokensContainer);
        this.fVerticalAlignConsecutiveLinesContainer.setEnabled(enabled && this.fVerticalAlignEnable.getBooleanValue());
        this.fVerticalAlignConsecutiveLines.setEnabled(enabled && this.fVerticalAlignEnable.getBooleanValue(), this.fVerticalAlignConsecutiveLinesContainer);
        if (this.fPreferences.hasVParenOptions()) {
            this.fVerticalAlignParenEnableContainer.setEnabled(enabled && this.fVerticalAlignEnable.getBooleanValue());
            this.fVerticalAlignParenEnable.setEnabled(enabled && this.fVerticalAlignEnable.getBooleanValue(), this.fVerticalAlignParenEnableContainer);
        }
        if (this.fPreferences.hasVCurlyOptions()) {
            this.fVerticalAlignCurlyEnableContainer.setEnabled(enabled && this.fVerticalAlignEnable.getBooleanValue());
            this.fVerticalAlignCurlyEnable.setEnabled(enabled && this.fVerticalAlignEnable.getBooleanValue(), this.fVerticalAlignCurlyEnableContainer);
        }
        this.fVerticalAlignSLCommentsEnableContainer.setEnabled(enabled && this.fVerticalAlignEnable.getBooleanValue());
        this.fVerticalAlignSLCommentsEnable.setEnabled(enabled && this.fVerticalAlignEnable.getBooleanValue(), this.fVerticalAlignSLCommentsEnableContainer);
        if (this.fPreferences.hasVRegExOptions()) {
            this.fVerticalAlignVRegexLabel.setEnabled(enabled && this.fVerticalAlignEnable.getBooleanValue());
            this.fVerticalAlignVRegexTable.getTable().setEnabled(enabled && this.fVerticalAlignEnable.getBooleanValue());
        }
        if (this.fPreferences.hasVRegExCompactWSOptions()) {
            this.fVerticalAlignVRegExCompactWSEnableContainer.setEnabled(enabled && this.fVerticalAlignEnable.getBooleanValue());
            this.fVerticalAlignVRegExCompactWSEnable.setEnabled(enabled && this.fVerticalAlignEnable.getBooleanValue(), this.fVerticalAlignVRegExCompactWSEnableContainer);
        }
    }

    @Override
    public void processPreferenceChanged(String preferenceName) {
        if (preferenceName.equals("format.vertical_align")) {
            this.fPreferences.changePreference(preferenceName, this.fVerticalAlignEnable.getBooleanValue());
            if (this.fPreferences.hasVRegExOptions()) {
                this.fVerticalAlignVRegexTable.refresh();
            }
        } else if (preferenceName.equals("format.vertical_align.independent_ifdefs")) {
            this.fPreferences.changePreference(preferenceName, this.fVerticalAlignIndependentIfdefs.getBooleanValue());
        } else if (preferenceName.equals("format.vertical_align.tokens")) {
            this.fPreferences.changePreference(preferenceName, this.fVerticalAlignTokens.getStringValue());
        } else if (preferenceName.equals("format.vertical_align.consecutive_lines")) {
            this.fPreferences.changePreference(preferenceName, this.fVerticalAlignConsecutiveLines.getBooleanValue());
        } else if (preferenceName.equals("format.vertical_align.paren")) {
            this.fPreferences.changePreference(preferenceName, this.fVerticalAlignParenEnable.getBooleanValue());
        } else if (preferenceName.equals("format.vertical_align.curly")) {
            this.fPreferences.changePreference(preferenceName, this.fVerticalAlignCurlyEnable.getBooleanValue());
        } else if (preferenceName.equals("format.vertical_align.sl_comments")) {
            this.fPreferences.changePreference(preferenceName, this.fVerticalAlignSLCommentsEnable.getBooleanValue());
        } else if (preferenceName.equals("format.vertical_align.vregex")) {
            this.fPreferences.changePreference(preferenceName, this.fPreferences.getVRegExPrefString());
        } else if (preferenceName.equals("format.vertical.align.vregex.compact.whitespace")) {
            this.fPreferences.changePreference(preferenceName, this.fVerticalAlignVRegExCompactWSEnable.getBooleanValue());
        }
        super.processPreferenceChanged(preferenceName);
    }

    private static class CFVRegexTableContentProvider
    implements IStructuredContentProvider {
        private CFVRegexTableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            List v = (List)inputElement;
            return v.toArray();
        }
    }

    private class CFVRegexTableLabelProvider
    implements ILabelProvider,
    IColorProvider {
        private CFVRegexTableLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Color getForeground(Object element) {
            if (!(element instanceof CFVRegExBaseDefinition)) {
                return null;
            }
            String pairPatternName = CFVerticalAlignPrefTabPage.this.getPairPatternName(((CFVRegExBaseDefinition)element).getName());
            if (!CFVerticalAlignPrefTabPage.this.fPreferences.isVerticalAlignEnabled() || CFVerticalAlignPrefTabPage.this.isVerticalAlignPatternPrefEnabled(pairPatternName)) {
                return DVTColorUtil.INSTANCE.getSystemColor(18);
            }
            return DVTColorUtil.INSTANCE.getDefaultForeground((Control)CFVerticalAlignPrefTabPage.this.fVerticalAlignVRegexLabel);
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            String result = "";
            if (element != null && element instanceof CFVRegExBaseDefinition) {
                CFVRegExBaseDefinition tmpElement = (CFVRegExBaseDefinition)element;
                result = String.valueOf(result) + tmpElement.getDescription();
            }
            return result;
        }
    }

    private class CFVRegexTableStateListener
    implements ICheckStateListener {
        private CFVRegexTableStateListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            Object element = event.getElement();
            if (element != null && element instanceof CFVRegExBaseDefinition) {
                CFVRegExBaseDefinition data = (CFVRegExBaseDefinition)element;
                String selectedPatternName = data.getName();
                Object pairedPatternTableItem = CFVerticalAlignPrefTabPage.this.getPairedPatternTableItem(selectedPatternName);
                if (pairedPatternTableItem == null) {
                    CFVerticalAlignPrefTabPage.this.fPreferences.enableVRegExPref(selectedPatternName, event.getChecked());
                    CFVerticalAlignPrefTabPage.this.processPreferenceChanged("format.vertical_align.vregex");
                    return;
                }
                if (CFVerticalAlignPrefTabPage.this.fVerticalAlignVRegexTable.getChecked(pairedPatternTableItem)) {
                    CFVerticalAlignPrefTabPage.this.fVerticalAlignVRegexTable.setChecked(element, false);
                    return;
                }
                CFVerticalAlignPrefTabPage.this.fPreferences.enableVRegExPref(selectedPatternName, CFVerticalAlignPrefTabPage.this.fVerticalAlignVRegexTable.getChecked(element));
                CFVerticalAlignPrefTabPage.this.processPreferenceChanged("format.vertical_align.vregex");
                CFVerticalAlignPrefTabPage.this.fVerticalAlignVRegexTable.refresh();
            }
        }
    }

    private static class CFVRegexTableStateProvider
    implements ICheckStateProvider {
        private CFVRegexTableStateProvider() {
        }

        public boolean isGrayed(Object element) {
            return false;
        }

        public boolean isChecked(Object element) {
            CFVRegExBaseDefinition vRegExDef = (CFVRegExBaseDefinition)element;
            return vRegExDef.isEnabled();
        }
    }
}

