/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.formatter.preferences;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.widgets.Composite;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFBasePrefTabPage;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFPreferences;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFPreferencesPage;
import ro.amiq.dvt.ui.preferences.BooleanFieldEditor2;
import ro.amiq.dvt.utils.IntegerFieldEditor;

public class CFWhitespacePrefTabPage
extends CFBasePrefTabPage {
    private Composite fTextEditorsContainer;
    private Composite fTrimEndOfLineWSEnableContainer;
    private BooleanFieldEditor2 fTrimEndOfLineWSEnable;
    private Composite fTrimWhitespaceLineEnableContainer;
    private BooleanFieldEditor2 fTrimWhitespaceLineEnable;
    private Composite fCompactWSEnableContainer;
    private BooleanFieldEditor2 fCompactWSEnable;
    private Composite fCompactConsecutiveEmptyLinesEnableContainer;
    private BooleanFieldEditor2 fCompactConsecutiveEmptyLinesEnable;
    private Composite fMaximumNofConsecutiveEmptyLinesContainer;
    private IntegerFieldEditor fMaximumNofConsecutiveEmptyLines;
    private Composite fAddWhitespaceBeforeTokensContainer;
    private StringFieldEditor fAddWhitespaceBeforeTokens;
    private Composite fAddWhitespaceAfterTokensContainer;
    private StringFieldEditor fAddWhitespaceAfterTokens;
    private Composite fRemoveNLBeforeTokensContainer;
    private StringFieldEditor fRemoveNLBeforeTokens;
    private Composite fRemoveNLAfterTokensContainer;
    private StringFieldEditor fRemoveNLAfterTokens;

    public CFWhitespacePrefTabPage(CFPreferences preferences, CFPreferencesPage preferencesPage) {
        super(preferences, preferencesPage);
    }

    @Override
    protected void doCreatePreferences(Composite parent) {
        this.fTextEditorsContainer = this.createContainer(parent, 2);
        this.fTextEditorsContainer.setFont(parent.getFont());
        if (!this.fPreferences.hasIndentOptions()) {
            this.addTextEditorsLink(this.fTextEditorsContainer);
        }
        this.createTrimEndOfLineWSPrefs(parent);
        this.createTrimWhitespaceLinePrefs(parent);
        this.createCompactWSPrefs(parent);
        this.createCompactConsecutiveEmptyLinesPrefs(parent);
        this.createMaximumNofConsecutiveEmptyLinesPrefs(parent);
        this.createAddWhitespaceBeforePrefs(parent);
        this.createAddWhitespaceAfterPrefs(parent);
        this.createRemoveNLBeforePrefs(parent);
        this.createRemoveNLAfterPrefs(parent);
    }

    private void createTrimEndOfLineWSPrefs(Composite parent) {
        this.fTrimEndOfLineWSEnableContainer = this.createContainer(parent, 0);
        this.fTrimEndOfLineWSEnable = this.createBooleanFieldEditor(this.fTrimEndOfLineWSEnableContainer, "format.whitespace.trim_end_of_line", "Trim end of line whitespace");
        this.addField((FieldEditor)this.fTrimEndOfLineWSEnable);
    }

    private void createTrimWhitespaceLinePrefs(Composite parent) {
        this.fTrimWhitespaceLineEnableContainer = this.createContainer(parent, 0);
        this.fTrimWhitespaceLineEnable = this.createBooleanFieldEditor(this.fTrimWhitespaceLineEnableContainer, "format.whitespace.trim_whitespace_line", "Trim whitespace lines");
        this.addField((FieldEditor)this.fTrimWhitespaceLineEnable);
    }

    private void createCompactWSPrefs(Composite parent) {
        this.fCompactWSEnableContainer = this.createContainer(parent, 0);
        this.fCompactWSEnable = this.createBooleanFieldEditor(this.fCompactWSEnableContainer, "format.whitespace.compact", "Compact whitespace groups");
        this.addField((FieldEditor)this.fCompactWSEnable);
    }

    private void createCompactConsecutiveEmptyLinesPrefs(Composite parent) {
        this.fCompactConsecutiveEmptyLinesEnableContainer = this.createContainer(parent, 0);
        this.fCompactConsecutiveEmptyLinesEnable = this.createBooleanFieldEditor(this.fCompactConsecutiveEmptyLinesEnableContainer, "format.whitespace.compact_consecutive_empty_lines", "Compact consecutive empty lines");
        this.addField((FieldEditor)this.fCompactConsecutiveEmptyLinesEnable);
    }

    private void createMaximumNofConsecutiveEmptyLinesPrefs(Composite parent) {
        this.fMaximumNofConsecutiveEmptyLinesContainer = this.createContainer(parent, 2);
        this.fMaximumNofConsecutiveEmptyLines = this.createIntegerFieldEditor(this.fMaximumNofConsecutiveEmptyLinesContainer, "format.whitespace.maximum_nof_consecutive_empty_lines", "Maximum number of consecutive empty lines:", 3);
        this.fMaximumNofConsecutiveEmptyLines.setValidRange(0, 100);
        this.addField((FieldEditor)this.fMaximumNofConsecutiveEmptyLines);
    }

    private void createAddWhitespaceBeforePrefs(Composite parent) {
        if (!this.fPreferences.hasAddWhitespaceOptions()) {
            return;
        }
        this.fAddWhitespaceBeforeTokensContainer = this.createContainer(parent, 2);
        this.fAddWhitespaceBeforeTokens = this.createStringFieldEditor(this.fAddWhitespaceBeforeTokensContainer, "format.whitespace.add_before", "Add whitespace before:");
        this.addField((FieldEditor)this.fAddWhitespaceBeforeTokens);
    }

    private void createAddWhitespaceAfterPrefs(Composite parent) {
        if (!this.fPreferences.hasAddWhitespaceOptions()) {
            return;
        }
        this.fAddWhitespaceAfterTokensContainer = this.createContainer(parent, 2);
        this.fAddWhitespaceAfterTokens = this.createStringFieldEditor(this.fAddWhitespaceAfterTokensContainer, "format.whitespace.add_after", "Add whitespace after: ");
        this.addField((FieldEditor)this.fAddWhitespaceAfterTokens);
    }

    private void createRemoveNLBeforePrefs(Composite parent) {
        if (!this.fPreferences.hasRemoveNLOptions()) {
            return;
        }
        this.fRemoveNLBeforeTokensContainer = this.createContainer(parent, 2);
        this.fRemoveNLBeforeTokens = this.createStringFieldEditor(this.fRemoveNLBeforeTokensContainer, "format.whitespace.remove_nl_before", "Remove new line before: ");
        this.addField((FieldEditor)this.fRemoveNLBeforeTokens);
    }

    private void createRemoveNLAfterPrefs(Composite parent) {
        if (!this.fPreferences.hasRemoveNLOptions()) {
            return;
        }
        this.fRemoveNLAfterTokensContainer = this.createContainer(parent, 2);
        this.fRemoveNLAfterTokens = this.createStringFieldEditor(this.fRemoveNLAfterTokensContainer, "format.whitespace.remove_nl_after", "Remove new line after: ");
        this.addField((FieldEditor)this.fRemoveNLAfterTokens);
    }

    @Override
    protected void performDefaults() {
        super.performDefaults();
        this.fPreferences.restoreDefaultBoolean("format.whitespace.trim_end_of_line");
        this.fPreferences.restoreDefaultBoolean("format.whitespace.trim_whitespace_line");
        this.fPreferences.restoreDefaultBoolean("format.whitespace.compact");
        this.fPreferences.restoreDefaultBoolean("format.whitespace.compact_consecutive_empty_lines");
        this.fPreferences.restoreDefaultInt("format.whitespace.maximum_nof_consecutive_empty_lines");
        if (this.fPreferences.hasAddWhitespaceOptions()) {
            this.fPreferences.restoreDefaultString("format.whitespace.add_before");
            this.fPreferences.restoreDefaultString("format.whitespace.add_after");
        }
        if (this.fPreferences.hasRemoveNLOptions()) {
            this.fPreferences.restoreDefaultString("format.whitespace.remove_nl_before");
            this.fPreferences.restoreDefaultString("format.whitespace.remove_nl_after");
        }
    }

    @Override
    protected void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.fTextEditorsContainer.setEnabled(enabled);
        this.fTrimEndOfLineWSEnableContainer.setEnabled(enabled);
        this.fTrimEndOfLineWSEnable.setEnabled(enabled, this.fTrimEndOfLineWSEnableContainer);
        this.fTrimWhitespaceLineEnableContainer.setEnabled(enabled);
        this.fTrimWhitespaceLineEnable.setEnabled(enabled, this.fTrimWhitespaceLineEnableContainer);
        this.fCompactWSEnableContainer.setEnabled(enabled);
        this.fCompactWSEnable.setEnabled(enabled, this.fCompactWSEnableContainer);
        this.fCompactConsecutiveEmptyLinesEnableContainer.setEnabled(enabled);
        this.fCompactConsecutiveEmptyLinesEnable.setEnabled(enabled, this.fCompactConsecutiveEmptyLinesEnableContainer);
        this.fMaximumNofConsecutiveEmptyLines.setEnabled(enabled && this.fCompactConsecutiveEmptyLinesEnable.getBooleanValue(), this.fMaximumNofConsecutiveEmptyLinesContainer);
        if (this.fPreferences.hasAddWhitespaceOptions()) {
            this.fAddWhitespaceBeforeTokensContainer.setEnabled(enabled);
            this.fAddWhitespaceBeforeTokens.setEnabled(enabled, this.fAddWhitespaceBeforeTokensContainer);
            this.fAddWhitespaceAfterTokensContainer.setEnabled(enabled);
            this.fAddWhitespaceAfterTokens.setEnabled(enabled, this.fAddWhitespaceAfterTokensContainer);
        }
        if (this.fPreferences.hasRemoveNLOptions()) {
            this.fRemoveNLBeforeTokensContainer.setEnabled(enabled);
            this.fRemoveNLBeforeTokens.setEnabled(enabled, this.fRemoveNLBeforeTokensContainer);
            this.fRemoveNLAfterTokensContainer.setEnabled(enabled);
            this.fRemoveNLAfterTokens.setEnabled(enabled, this.fRemoveNLAfterTokensContainer);
        }
    }

    @Override
    public void processPreferenceChanged(String preferenceName) {
        if (preferenceName.equals("format.whitespace.trim_end_of_line")) {
            this.fPreferences.changePreference(preferenceName, this.fTrimEndOfLineWSEnable.getBooleanValue());
        } else if (preferenceName.equals("format.whitespace.trim_whitespace_line")) {
            this.fPreferences.changePreference(preferenceName, this.fTrimWhitespaceLineEnable.getBooleanValue());
        } else if (preferenceName.equals("format.whitespace.compact")) {
            this.fPreferences.changePreference(preferenceName, this.fCompactWSEnable.getBooleanValue());
        } else if (preferenceName.equals("format.whitespace.compact_consecutive_empty_lines")) {
            this.fPreferences.changePreference(preferenceName, this.fCompactConsecutiveEmptyLinesEnable.getBooleanValue());
        } else if (preferenceName.equals("format.whitespace.maximum_nof_consecutive_empty_lines")) {
            this.fPreferences.changePreference(preferenceName, this.fMaximumNofConsecutiveEmptyLines.getIntValue());
        } else if (preferenceName.equals("format.whitespace.add_before")) {
            this.fPreferences.changePreference(preferenceName, this.fAddWhitespaceBeforeTokens.getStringValue());
        } else if (preferenceName.equals("format.whitespace.add_after")) {
            this.fPreferences.changePreference(preferenceName, this.fAddWhitespaceAfterTokens.getStringValue());
        } else if (preferenceName.equals("format.whitespace.remove_nl_before")) {
            this.fPreferences.changePreference(preferenceName, this.fRemoveNLBeforeTokens.getStringValue());
        } else if (preferenceName.equals("format.whitespace.remove_nl_after")) {
            this.fPreferences.changePreference(preferenceName, this.fRemoveNLAfterTokens.getStringValue());
        }
        super.processPreferenceChanged(preferenceName);
    }
}

