/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.formatter.scanner;

import ro.amiq.dvt.ui.editor.formatter.scanner.CFToken;

public class CFScope {
    private CFToken fToken;
    private String fScopeName;
    private int fIndentKind;
    public static int NO_INDENT = 0;
    public static int INDENT = 1;
    public static int GLUE_INDENT = 2;
    public static int INDENT_CURRENT_LINE = 3;
    private boolean fIsShortScope;
    public static boolean BLOCK_SCOPE = false;
    public static boolean SHORT_SCOPE = true;
    private boolean fIsMultiConstructScope;
    private boolean fShouldClose;
    private boolean fIsImplicitSemiParamMacro;

    public CFScope(CFToken token, String state, boolean isShortScope, int indentKind) {
        this.fToken = token;
        this.fScopeName = state;
        this.fIndentKind = indentKind;
        this.fIsShortScope = isShortScope;
        this.fIsMultiConstructScope = !isShortScope;
        this.fIsImplicitSemiParamMacro = false;
    }

    public String toString() {
        return "name:" + this.fScopeName + ", line:" + this.getLineNo() + ", indent:" + this.fIndentKind;
    }

    public CFToken getToken() {
        return this.fToken;
    }

    public String getScopeName() {
        return this.fScopeName;
    }

    public void setScopeName(String scopeName) {
        this.fScopeName = scopeName;
    }

    public boolean isShortScope() {
        return this.fIsShortScope;
    }

    public int getLineNo() {
        if (this.fToken != null) {
            return this.fToken.getLineNo();
        }
        return 0;
    }

    public boolean addsIndent() {
        if (this.fIndentKind == INDENT) {
            return true;
        }
        return this.fIndentKind == INDENT_CURRENT_LINE;
    }

    public boolean isMultiConstructScope() {
        return this.fIsMultiConstructScope;
    }

    public void setMultiConstructScope() {
        this.fIsMultiConstructScope = true;
    }

    public boolean shouldClose() {
        return this.fShouldClose;
    }

    public void setShouldClose() {
        this.fShouldClose = true;
    }

    public boolean isImplicitSemiParamMacro() {
        return this.fIsImplicitSemiParamMacro;
    }

    public void setIsImplicitSemiParamMacro() {
        this.fIsImplicitSemiParamMacro = true;
    }

    public int getIndentKind() {
        return this.fIndentKind;
    }
}

