/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.formatter.scanner;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Set;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.formatter.model.CFChunk;
import ro.amiq.dvt.ui.editor.formatter.model.CFLineInfo;
import ro.amiq.dvt.ui.editor.formatter.model.CFModel;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFPreferences;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFScope;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFToken;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFTokenScanner;
import ro.amiq.dvt.ui.editor.formatter.scanner.ICFScopeScannerImpl;
import ro.amiq.dvt.ui.editor.formatter.strategies.DVTBaseCodeFormattingStrategy;
import ro.amiq.dvt.ui.editor.formatter.strategies.DVTBaseFormattingStrategy;

public class CFScopeScanner
extends CFTokenScanner {
    protected CFPreferences fFormatPreferences;
    protected int fCurrLineIndentLevel = 0;
    protected int fNextLineIndentLevel = 0;
    private Deque<CFScope> fScopeStack = new ArrayDeque<CFScope>();
    private DVTBaseCodeFormattingStrategy fCodeFormattingStragety;

    public CFScopeScanner(CFModel model, ICFScopeScannerImpl scopeScannerImpl) {
        super(model);
    }

    @Override
    public void startPartition(DVTBaseFormattingStrategy strategy) {
        super.startPartition(strategy);
        this.fFormatPreferences = strategy.getFormatPreferences();
    }

    public void incrCurrLineIndentLevel(boolean isFirstOnLine) {
        if (isFirstOnLine) {
            ++this.fCurrLineIndentLevel;
        }
    }

    public void decrCurrLineIndentLevel(boolean isFirstOnLine) {
        if (isFirstOnLine) {
            --this.fCurrLineIndentLevel;
        }
    }

    public int getNextLineIndentLevel() {
        return this.fNextLineIndentLevel;
    }

    public void incrNextLineIndentLevel() {
        ++this.fNextLineIndentLevel;
    }

    public void decrNextLineIndentLevel(boolean isFirstOnLine) {
        this.decrCurrLineIndentLevel(isFirstOnLine);
        --this.fNextLineIndentLevel;
    }

    protected CFScope createScope(CFToken token, String scopeName, boolean isShortScope, int indentKind) {
        if (token == null) {
            return null;
        }
        return new CFScope(token, scopeName, isShortScope, indentKind);
    }

    public boolean hasScopes() {
        return !this.fScopeStack.isEmpty();
    }

    public CFScope getPeekScope() {
        if (this.fScopeStack.isEmpty()) {
            return null;
        }
        return this.fScopeStack.peek();
    }

    public CFScope getPrePeekScope() {
        if (this.fScopeStack.size() < 2) {
            return null;
        }
        CFScope head = this.fScopeStack.pop();
        CFScope peek = this.fScopeStack.peek();
        this.fScopeStack.push(head);
        return peek;
    }

    public boolean hasScope(String word) {
        if (this.fScopeStack.isEmpty()) {
            return false;
        }
        Iterator<CFScope> it = this.fScopeStack.iterator();
        while (it.hasNext()) {
            if (!it.next().getScopeName().equals(word)) continue;
            return true;
        }
        return false;
    }

    public boolean hasOperatorsOnStack() {
        if (this.fScopeStack.isEmpty()) {
            return false;
        }
        for (CFScope next : this.fScopeStack) {
            String tokenValue;
            CFToken token;
            if (next == null || (token = next.getToken()) == null || (tokenValue = token.getValue()) == null) continue;
            if (this.isAssignmentOperator(token)) {
                return true;
            }
            if (this.fStrategy.isRelationalOperatorKeyword(tokenValue) && this.hasScope("constraint") && this.hasScope("{")) {
                return true;
            }
            if (!this.fStrategy.isEqualityOperatorKeyword(tokenValue) || !this.hasScope("constraint") || !this.hasScope("{")) continue;
            return true;
        }
        return false;
    }

    public CFScope getScope(String word) {
        if (this.fScopeStack.isEmpty()) {
            return null;
        }
        for (CFScope nextScope : this.fScopeStack) {
            if (!nextScope.getScopeName().equals(word)) continue;
            return nextScope;
        }
        return null;
    }

    public int getNofOpenParensUntilScope(Set<String> scopes, String paren) {
        if (this.fScopeStack.isEmpty()) {
            return 0;
        }
        int result = 0;
        for (CFScope scope : this.fScopeStack) {
            if (scope == null) continue;
            String scopeName = scope.getScopeName();
            if (paren.equals(scopeName)) {
                ++result;
            }
            if (!scopes.contains(scopeName)) continue;
            return result;
        }
        return result;
    }

    public CFScope getPeekScopeIgnoreAssignmentOperators() {
        DVTBaseCodeFormattingStrategy cfs = this.getCodeFormattingStrategy();
        if (cfs == null) {
            return null;
        }
        CFScope peekScope = null;
        for (CFScope scope : this.fScopeStack) {
            CFToken token;
            if (scope == null || (token = scope.getToken()) == null) break;
            if (this.isAssignmentOperator(token)) continue;
            peekScope = scope;
            break;
        }
        return peekScope;
    }

    public CFScope getPrePeekScopeIgnoreAssignmentOperators() {
        DVTBaseCodeFormattingStrategy cfs = this.getCodeFormattingStrategy();
        if (cfs == null) {
            return this.getPrePeekScope();
        }
        CFScope peekScope = null;
        CFScope prePeekScope = null;
        for (CFScope scope : this.fScopeStack) {
            CFToken token;
            if (scope == null || (token = scope.getToken()) == null) break;
            if (this.isAssignmentOperator(token)) continue;
            if (peekScope == null) {
                peekScope = scope;
                continue;
            }
            prePeekScope = scope;
            break;
        }
        return prePeekScope;
    }

    public CFScope getPeekScopeIgnorePreproc() {
        return this.getPeekScopeIgnorePreproc(null);
    }

    public CFScope getPeekScopeIgnorePreproc(Set<String> ignoreScopes) {
        if (!this.fFormatPreferences.isVerticalAlignIndependentIfdefs()) {
            return ignoreScopes == null ? this.getPeekScope() : this.getPeekScope(ignoreScopes);
        }
        DVTBaseCodeFormattingStrategy cfs = this.getCodeFormattingStrategy();
        if (cfs == null) {
            return ignoreScopes == null ? this.getPeekScope() : this.getPeekScope(ignoreScopes);
        }
        CFScope peekScope = null;
        for (CFScope iPeekScope : this.fScopeStack) {
            int iPreprocType;
            String iPeekTokenValue;
            CFToken iPeekToken;
            if (iPeekScope == null || (iPeekToken = iPeekScope.getToken()) == null || (iPeekTokenValue = iPeekToken.getValue()) == null) break;
            if (ignoreScopes != null && ignoreScopes.contains(iPeekTokenValue) || (iPreprocType = cfs.getPreprocType(iPeekTokenValue)) == 1) continue;
            peekScope = iPeekScope;
            break;
        }
        return peekScope;
    }

    public CFScope getPeekScope(Set<String> ignoreScopes) {
        if (ignoreScopes == null) {
            return this.getPeekScope();
        }
        if (this.fScopeStack.isEmpty()) {
            return null;
        }
        CFScope peekScope = null;
        for (CFScope iPeekScope : this.fScopeStack) {
            String iPeekTokenValue;
            CFToken iPeekToken;
            if (iPeekScope == null || (iPeekToken = iPeekScope.getToken()) == null || (iPeekTokenValue = iPeekToken.getValue()) == null) break;
            if (ignoreScopes.contains(iPeekTokenValue)) continue;
            peekScope = iPeekScope;
            break;
        }
        return peekScope;
    }

    public CFScope getPrePeekScopeIgnorePreproc() {
        if (!this.fFormatPreferences.isVerticalAlignIndependentIfdefs()) {
            return this.getPrePeekScope();
        }
        DVTBaseCodeFormattingStrategy cfs = this.getCodeFormattingStrategy();
        if (cfs == null) {
            return this.getPrePeekScope();
        }
        CFScope peekScope = null;
        CFScope prePeekScope = null;
        for (CFScope iPeekScope : this.fScopeStack) {
            String iPeekTokenValue;
            CFToken iPeekToken;
            if (iPeekScope == null || (iPeekToken = iPeekScope.getToken()) == null || (iPeekTokenValue = iPeekToken.getValue()) == null) break;
            int iPreprocType = cfs.getPreprocType(iPeekTokenValue);
            if (iPreprocType == 1) continue;
            if (peekScope == null) {
                peekScope = iPeekScope;
                continue;
            }
            prePeekScope = iPeekScope;
            break;
        }
        return prePeekScope;
    }

    public CFScope getPeekScopeIgnoreOperatorsAndPreproc() {
        DVTBaseCodeFormattingStrategy cfs = this.getCodeFormattingStrategy();
        if (cfs == null) {
            return null;
        }
        CFScope peekScope = null;
        for (CFScope scope : this.fScopeStack) {
            String tokenValue;
            CFToken token;
            if (scope == null || (token = scope.getToken()) == null || (tokenValue = token.getValue()) == null) break;
            int preprocType = cfs.getPreprocType(tokenValue);
            if (this.isAssignmentOperator(token) || preprocType == 1) continue;
            peekScope = scope;
            break;
        }
        return peekScope;
    }

    public CFScope getPrePeekScopeIgnoreOperatorsAndPreproc() {
        DVTBaseCodeFormattingStrategy cfs = this.getCodeFormattingStrategy();
        if (cfs == null) {
            return this.getPrePeekScope();
        }
        CFScope peekScope = null;
        CFScope prePeekScope = null;
        for (CFScope scope : this.fScopeStack) {
            String tokenValue;
            CFToken token;
            if (scope == null || (token = scope.getToken()) == null || (tokenValue = token.getValue()) == null) break;
            int preprocType = cfs.getPreprocType(tokenValue);
            if (this.isAssignmentOperator(token) || preprocType == 1) continue;
            if (peekScope == null) {
                peekScope = scope;
                continue;
            }
            prePeekScope = scope;
            break;
        }
        return prePeekScope;
    }

    public DVTBaseCodeFormattingStrategy getCodeFormattingStrategy() {
        if (this.fCodeFormattingStragety == null) {
            if (this.fStrategy instanceof DVTBaseCodeFormattingStrategy) {
                this.fCodeFormattingStragety = (DVTBaseCodeFormattingStrategy)this.fStrategy;
            } else {
                DVTSourceViewerConfiguration svc = this.fStrategy.getSourceViewerConfiguration();
                if (svc != null) {
                    this.fCodeFormattingStragety = svc.getCodeFormattingStrategy();
                }
            }
        }
        return this.fCodeFormattingStragety;
    }

    @Override
    public void endChunk(CFChunk chunk) {
        if (chunk == null) {
            return;
        }
        if (chunk.endsWithNL()) {
            this.updateOnEndOfLine(chunk.getLineNo());
        }
    }

    protected void updateOnEndOfLine(int lineNo) {
        this.fCurrLineIndentLevel = 0;
        this.fNextLineIndentLevel = 0;
    }

    public void pushScope(CFToken token, String scopeName, boolean isShortScope, int indentKind) {
        CFScope newScope;
        if (token == null) {
            return;
        }
        if (CFScope.INDENT == indentKind) {
            this.incrNextLineIndentLevel();
        }
        if (CFScope.GLUE_INDENT == indentKind) {
            this.decrCurrLineIndentLevel(token.isFirstNWSTokenOnLine());
        }
        if (CFScope.INDENT_CURRENT_LINE == indentKind) {
            this.incrNextLineIndentLevel();
            this.incrCurrLineIndentLevel(token.isFirstNWSTokenOnLine());
        }
        if ((newScope = this.createScope(token, scopeName, isShortScope, indentKind)) != null) {
            this.fScopeStack.push(newScope);
        }
    }

    public void popScopeAndUpdate(boolean isFirstOnLine) {
        if (this.fScopeStack == null || this.fScopeStack.isEmpty()) {
            return;
        }
        CFScope peekScope = this.getPeekScope();
        if (peekScope.addsIndent()) {
            this.decrNextLineIndentLevel(isFirstOnLine);
        }
        this.fScopeStack.pop();
    }

    public void popShouldClose(boolean isFirstOnLine) {
        while (this.hasScopes() && this.getPeekScope().shouldClose()) {
            this.popScopeAndUpdate(isFirstOnLine);
        }
    }

    public void updateOnEndOfBlock(CFToken token, Set<String> exceptions) {
        if (token == null) {
            return;
        }
        boolean isFirstOnLine = token.isFirstNWSTokenOnLine();
        if (!this.hasScopes()) {
            return;
        }
        this.popAndSetShouldClose(isFirstOnLine, exceptions);
        if (this.hasScopes() && this.getPeekScope().isShortScope() && this.getPeekScope().addsIndent() && !this.fFormatPreferences.isBeginPrefNewLineAndIndent()) {
            this.decrCurrLineIndentLevel(isFirstOnLine);
        }
    }

    public void popAndSetShouldClose(boolean isFirstOnLine, Set<String> exceptions) {
        this.popScopeAndUpdate(isFirstOnLine);
        this.setShouldCloseShortScopeAndRecurseUntilMultiConstructOrExceptions(exceptions);
    }

    public void setShouldCloseShortScopeAndRecurseUntilMultiConstructOrExceptions(Set<String> exceptions) {
        if (!this.hasScopes()) {
            return;
        }
        CFScope peekScope = this.getPeekScope();
        if (peekScope.isShortScope()) {
            peekScope.setShouldClose();
        } else if (peekScope.isMultiConstructScope()) {
            return;
        }
        Iterator<CFScope> sIt = this.fScopeStack.iterator();
        sIt.next();
        while (sIt.hasNext()) {
            CFScope scope = sIt.next();
            String scopeName = scope.getScopeName();
            if (scope.isMultiConstructScope() || exceptions != null && exceptions.contains(scopeName)) break;
            scope.setShouldClose();
        }
    }

    public void updateOnParenOpen(CFToken token) {
        if (token == null) {
            return;
        }
        this.fModel.incrNofOpenParens();
        this.hookOnParenOpen4ParameterPrefs(token);
        CFScope peekScope = this.getPeekScope();
        if (peekScope == null) {
            this.pushScope(token, "(", CFScope.BLOCK_SCOPE, CFScope.INDENT);
            return;
        }
        if (this.isAssignmentOperator(peekScope.getToken())) {
            int indentKind = CFScope.NO_INDENT;
            indentKind = peekScope.addsIndent() && peekScope.getLineNo() == token.getLineNo() ? CFScope.GLUE_INDENT : CFScope.INDENT;
            int lineNo = token.getLineNo();
            CFLineInfo lineInfo = this.fModel.getLineInfo(lineNo);
            if (lineInfo == null) {
                return;
            }
            if (this.fFormatPreferences.isLineWrapEnabled()) {
                boolean exceedsLineWrap = this.exceedsLineWrap(token.getEndOffsetInLineAfterWS(), lineInfo);
                int lineBreakOffsetAdjustment = lineInfo.getLineBreakOffsetAdjustment();
                if (exceedsLineWrap || lineBreakOffsetAdjustment != 0 && lineBreakOffsetAdjustment < token.getStartOffsetInLine()) {
                    indentKind = CFScope.INDENT;
                }
            }
            this.pushScope(token, "(", CFScope.BLOCK_SCOPE, indentKind);
            return;
        }
        if ("constraint".equals(peekScope.getScopeName())) {
            this.pushScope(token, "(", CFScope.BLOCK_SCOPE, CFScope.GLUE_INDENT);
            return;
        }
        this.pushScope(token, "(", CFScope.BLOCK_SCOPE, CFScope.INDENT);
    }

    protected void handleMorePerLineIfLessThan() {
    }

    public void hookOnParenOpen4ParameterPrefs(CFToken token) {
    }

    public void updateOnParenClose(CFToken token) {
        if (token == null) {
            return;
        }
        this.fModel.decrNofOpenParens();
        this.handleMorePerLineIfLessThan();
        this.popScopeAndUpdate(token.isFirstNWSTokenOnLine());
        this.hookOnParenClose4ParameterPrefs(token);
    }

    protected void hookOnParenClose4ParameterPrefs(CFToken token) {
    }

    public void updateOnBracketOpen(CFToken token) {
        this.fModel.incrNofOpenBracks();
        this.pushScope(token, "[", CFScope.BLOCK_SCOPE, CFScope.INDENT);
    }

    public void updateOnBracketClose(CFToken token) {
        this.fModel.decrNofOpenBracks();
        this.popScopeAndUpdate(token.isFirstNWSTokenOnLine());
    }

    public void updateOnComma(CFToken token) {
        if (token == null) {
            return;
        }
        this.hookOnSeparator4ParameterPrefs(token);
        CFScope peekScope = this.getPeekScope();
        if (peekScope == null) {
            return;
        }
        if (this.isAssignmentOperator(peekScope.getToken())) {
            this.popScopeAndUpdate(token.isFirstNWSTokenOnLine());
        }
    }

    protected void hookOnSeparator4ParameterPrefs(CFToken token) {
    }

    public boolean isOnTheSameLineWithCurrentScope(CFToken token) {
        CFScope peekScope = this.getPeekScope();
        if (peekScope == null || token == null) {
            return false;
        }
        return peekScope.getLineNo() == token.getLineNo();
    }

    public boolean exceedsLineWrap(int endOffsetInLineAfterWS, CFLineInfo lineInfo) {
        return false;
    }
}

