/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.formatter.scanner;

import java.util.HashMap;
import java.util.Map;
import ro.amiq.dvt.ui.editor.formatter.model.CFChunk;
import ro.amiq.dvt.ui.editor.formatter.model.CFLineInfo;

public class CFToken {
    public static final int CHARS_TOKEN = 1;
    public static final int WORD_TOKEN = 2;
    public static final int WHITESPACE_TOKEN = 3;
    public static final int SINGLE_CHAR_TOKEN = 4;
    public static final int LITERAL_TOKEN = 10;
    public static final int ESCAPED_ID_TOKEN = 20;
    public static final int SL_COMMENT_TOKEN = 30;
    public static final int ML_COMMENT_TOKEN = 40;
    private final CFChunk fEnclosingChunk;
    private final int fTokenType;
    private final String fValue;
    private final int fStartOffsetInChunk;
    private final boolean fIsFirstNWSTokenOnLineExtended;
    private final boolean fIsOnSensibleLine;
    private boolean fIsFirstNWSTokenOnLine;
    private Map<String, Object> fMeta;

    public CFToken(CFChunk enclosingChunk, int tokenType, String value, int startOffsetInChunk, boolean isFirstNWSTokenOnLine) {
        this.fEnclosingChunk = enclosingChunk;
        this.fTokenType = tokenType;
        this.fValue = value;
        this.fStartOffsetInChunk = startOffsetInChunk;
        this.fIsFirstNWSTokenOnLine = isFirstNWSTokenOnLine;
        if (enclosingChunk != null) {
            CFLineInfo lineInfo = enclosingChunk.getEnclosingLineInfo();
            if (lineInfo != null) {
                CFChunk firstChunk = lineInfo.getFirstChunk();
                if (firstChunk != null && firstChunk.hasInfo("codeMarkerInExpansion")) {
                    this.fIsOnSensibleLine = true;
                    this.fIsFirstNWSTokenOnLineExtended = lineInfo.areAllPrevChunksWSExtended(enclosingChunk) ? (!this.fValue.trim().isEmpty() ? enclosingChunk.getValue().substring(0, startOffsetInChunk).trim().isEmpty() : false) : false;
                } else {
                    this.fIsOnSensibleLine = false;
                    this.fIsFirstNWSTokenOnLineExtended = false;
                }
            } else {
                this.fIsOnSensibleLine = false;
                this.fIsFirstNWSTokenOnLineExtended = false;
            }
        } else {
            this.fIsOnSensibleLine = false;
            this.fIsFirstNWSTokenOnLineExtended = false;
        }
    }

    public int getTokenType() {
        return this.fTokenType;
    }

    public String getValue() {
        return this.fValue;
    }

    public boolean isFirstNWSTokenOnLine() {
        if (this.fEnclosingChunk.hasInfo("codeMarkerInExpansion")) {
            return false;
        }
        if (!this.fIsFirstNWSTokenOnLine) {
            return this.fIsFirstNWSTokenOnLineExtended;
        }
        return this.fIsFirstNWSTokenOnLine;
    }

    public void setIsFirstNWSTokenOnLine(boolean isFirstNWSTokenOnLine) {
        this.fIsFirstNWSTokenOnLine = isFirstNWSTokenOnLine;
    }

    public boolean isOnSensibleLine() {
        return this.fIsOnSensibleLine;
    }

    public CFChunk getEnclosingChunk() {
        return this.fEnclosingChunk;
    }

    public int getLineNo() {
        return this.fEnclosingChunk.getLineNo();
    }

    public int getStartOffsetInChunk() {
        return this.fStartOffsetInChunk;
    }

    public int getEndOffsetInChunk() {
        return this.fStartOffsetInChunk + this.fValue.length();
    }

    public int getStartOffsetInLine() {
        return this.fStartOffsetInChunk + this.fEnclosingChunk.getStartOffsetInLine();
    }

    public int getEndOffsetInLine() {
        return this.getStartOffsetInLine() + this.fValue.length();
    }

    public int getStartOffsetInLineAfterWS() {
        return this.fStartOffsetInChunk + this.fEnclosingChunk.getStartOffsetInLineAfterWS();
    }

    public int getEndOffsetInLineAfterWS() {
        return this.getStartOffsetInLineAfterWS() + this.fValue.length();
    }

    public char getCharAt(int charIndexInToken) {
        return this.fValue.charAt(charIndexInToken);
    }

    public String toString() {
        return this.fValue;
    }

    public String dbgGetTokenTypeAsString() {
        switch (this.fTokenType) {
            case 4: {
                return "SINGLE_CHAR";
            }
            case 1: {
                return "CHARS";
            }
            case 2: {
                return "WORD";
            }
            case 3: {
                return "WHITESPACE";
            }
        }
        return "UNKNOWN";
    }

    public void putMeta(String key, Object value) {
        if (this.fMeta == null) {
            this.fMeta = new HashMap<String, Object>();
        }
        this.fMeta.put(key, value);
    }

    public Object getMeta(String key) {
        if (this.fMeta == null) {
            return null;
        }
        return this.fMeta.get(key);
    }
}

