/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.formatter.scanner.indent;

import ro.amiq.dvt.ui.editor.formatter.model.CFAction;
import ro.amiq.dvt.ui.editor.formatter.model.CFChunk;
import ro.amiq.dvt.ui.editor.formatter.model.CFLineInfo;
import ro.amiq.dvt.ui.editor.formatter.model.CFModel;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFToken;
import ro.amiq.dvt.ui.editor.formatter.scanner.indent.CFIndentScanner;
import ro.amiq.dvt.ui.editor.formatter.scanner.indent.ICFBeginIndentScannerImpl;
import ro.amiq.dvt.ui.editor.formatter.scanner.indent.ICFIndentScannerImpl;
import ro.amiq.dvt.ui.editor.formatter.util.CFSyso;

public class CFBeginIndentScanner
extends CFIndentScanner {
    protected ICFBeginIndentScannerImpl fICFBeginIndentScannerImpl;

    public CFBeginIndentScanner(CFModel model, ICFIndentScannerImpl indentScannerImpl) {
        super(model, indentScannerImpl);
        this.fICFBeginIndentScannerImpl = (ICFBeginIndentScannerImpl)indentScannerImpl;
    }

    public boolean tryBeginPrefsDefaultImpl(CFToken token) {
        int keywordType;
        if ((this.fFormatPreferences.isBeginPrefNewLine() || this.fFormatPreferences.isBeginPrefNewLineAndIndent()) && !token.isFirstNWSTokenOnLine() && token.getTokenType() == 2 && (keywordType = this.fStrategy.getKeywordType(token.getValue())) == 4) {
            return this.tryBeginOnNewLine(token);
        }
        if (this.fFormatPreferences.isBeginPrefSameLine() && token.isFirstNWSTokenOnLine() && token.getTokenType() == 2 && (keywordType = this.fStrategy.getKeywordType(token.getValue())) == 4) {
            return this.tryBeginOnSameLine(token);
        }
        return false;
    }

    public boolean tryBeginOnNewLine(CFToken token) {
        if (token == null) {
            return false;
        }
        if (!this.allowLineBreak(token)) {
            return false;
        }
        if (token.isFirstNWSTokenOnLine()) {
            return false;
        }
        CFSyso.println("INDENT", "CFIndentScanner.tryBeginOnNewLine(): " + token.getLineNo());
        CFChunk chunk = token.getEnclosingChunk();
        if (chunk == null) {
            return false;
        }
        this.createActionsForLineBreakBeforeToken(token, Math.max(this.fLineIndent + (this.fNextLineIndentLevel - 1) * this.fTabWidth, 0), "begin new line");
        return true;
    }

    public boolean tryBeginOnSameLine(CFToken token) {
        if (token == null) {
            return false;
        }
        if (token.isOnSensibleLine()) {
            return false;
        }
        CFSyso.println("INDENT", "CFIndentScanner.tryBeginOnSameLine(): " + token.getLineNo());
        int lineNo = token.getLineNo();
        if (lineNo == 1) {
            return false;
        }
        CFChunk chunk = token.getEnclosingChunk();
        if (chunk == null) {
            return false;
        }
        CFLineInfo lineInfo = chunk.getEnclosingLineInfo();
        if (lineInfo == null) {
            return false;
        }
        CFLineInfo prevLineInfo = this.fModel.getPrevNonWhitespaceLine(lineNo);
        if (prevLineInfo == null) {
            return false;
        }
        if (!this.allowBeginOnSameLine(token)) {
            return false;
        }
        CFChunk prevLineLastChunk = prevLineInfo.getLastChunk();
        if (prevLineLastChunk == null) {
            return false;
        }
        return this.tryBeginOnSameLine(prevLineInfo, token, "begin same line");
    }

    private boolean tryBeginOnSameLine(CFLineInfo appendToLineInfo, CFToken token, String causedBy) {
        if (appendToLineInfo == null) {
            return false;
        }
        if (!appendToLineInfo.isFormatterOn()) {
            return false;
        }
        if (token == null) {
            return false;
        }
        if (token.isOnSensibleLine()) {
            return false;
        }
        CFChunk chunk = token.getEnclosingChunk();
        if (chunk == null) {
            return false;
        }
        CFLineInfo lineInfo = chunk.getEnclosingLineInfo();
        if (lineInfo == null) {
            return false;
        }
        if (!lineInfo.isFormatterOn()) {
            return false;
        }
        if (!token.isFirstNWSTokenOnLine()) {
            return false;
        }
        if (token.getTokenType() == 3) {
            return false;
        }
        int lineNo = token.getLineNo();
        if (lineNo == 1) {
            return false;
        }
        if (chunk.getType() == 3 || chunk.getType() == 4) {
            return false;
        }
        if (lineInfo.startsWithLiteralFragment()) {
            return false;
        }
        if (appendToLineInfo.containsPreproc()) {
            return false;
        }
        if (token.getTokenType() == 2 && this.fStrategy.getPreprocType(token.getValue()) != 0) {
            return false;
        }
        CFSyso.println("INDENT", "CFUIndentScanner.moveBeginOnPrevLine():" + token.getValue());
        int lineMergeOffsetAdjustmentForNextLine = appendToLineInfo.getNLOffsetInLineAfterWS() + appendToLineInfo.getLineMergeOffsetAdjustment() - appendToLineInfo.getLineBreakOffsetAdjustment();
        int prevLineCurrWrapIndent = appendToLineInfo.getCurrMergeIndent();
        int nofTailWSChars = appendToLineInfo.getNofTailWSChars();
        int whitespaceAdjustment = 1 - nofTailWSChars;
        this.createActionsToMoveBegin(token, appendToLineInfo, causedBy);
        lineInfo.updateOnLineMerge(lineMergeOffsetAdjustmentForNextLine + whitespaceAdjustment, prevLineCurrWrapIndent);
        return true;
    }

    private void createActionsToMoveBegin(CFToken token, CFLineInfo appendToLineInfo, String causedBy) {
        int prevLineNo = token.getLineNo() - 1;
        CFLineInfo prevLineInfo = null;
        while (prevLineNo > 0) {
            prevLineInfo = this.fModel.getLineInfo(prevLineNo);
            if (prevLineInfo != null) {
                CFChunk prevLastChunk = prevLineInfo.getLastChunk();
                while (prevLastChunk != null) {
                    if (this.isComment(prevLastChunk)) {
                        prevLastChunk = prevLineInfo.getChunkBefore(prevLastChunk);
                        continue;
                    }
                    if (prevLastChunk.endsWithNL() && prevLineInfo.isPrecededByMLComment(prevLastChunk)) {
                        prevLastChunk = prevLineInfo.getChunkBefore(prevLastChunk);
                        continue;
                    }
                    if (prevLastChunk.endsWithNL()) {
                        prevLastChunk.addAction(new CFAction(prevLastChunk.getNLOffset(), prevLastChunk.getNLLength(), "", causedBy));
                    }
                    prevLastChunk = prevLineInfo.getChunkBefore(prevLastChunk);
                }
                if (prevLineInfo.hasCode()) {
                    prevLineInfo.createActionsToDeleteTailWS();
                    break;
                }
            }
            --prevLineNo;
        }
        CFChunk chunk = token.getEnclosingChunk();
        if (chunk == null) {
            return;
        }
        CFLineInfo lineInfo = chunk.getEnclosingLineInfo();
        if (lineInfo == null) {
            return;
        }
        CFChunk prevLineLastChunk = appendToLineInfo.getLastNonEmptyChunk();
        if (this.isComment(prevLineLastChunk)) {
            this.createActionsToMoveBeginBeforeComment(token, chunk, prevLineInfo, causedBy);
        } else {
            this.createActionsToMoveBeginAtTheEndOfPrevLine(lineInfo, chunk, token, causedBy);
        }
    }

    private void createActionsToMoveBeginBeforeComment(CFToken token, CFChunk chunk, CFLineInfo prevLineInfo, String causedBy) {
        if (this.fICFIndentScannerImpl == null) {
            return;
        }
        chunk.addAction(new CFAction(0, this.computeDeleteOffsetForBegin(chunk), "", causedBy));
        if (prevLineInfo == null) {
            return;
        }
        CFChunk prevChunk = prevLineInfo.getLastNonEmptyNotCommentChunk();
        if (prevChunk == null) {
            return;
        }
        this.deleteTailWS(prevChunk);
        prevChunk.addAction(new CFAction(prevChunk.getLength(), 0, this.computeProcessedBegin(prevChunk, token), causedBy));
    }

    private int computeDeleteOffsetForBegin(CFChunk chunk) {
        if (this.isCurrTokenLabeled()) {
            CFToken secondNWSTokenInChunkAfterCurrToken = this.fICFIndentScannerImpl.getSecondNWSTokenInChunkAfterCurrToken();
            CFToken thirdNWSTokenInChunkAfterCurrToken = this.fICFIndentScannerImpl.getThirdNWSTokenInChunkAfterCurrToken();
            if (thirdNWSTokenInChunkAfterCurrToken == null) {
                return chunk.getLength();
            }
            return secondNWSTokenInChunkAfterCurrToken.getEndOffsetInChunk();
        }
        CFToken firstNWSTokenInChunkAfterCurrToken = this.fICFIndentScannerImpl.getFirstNWSTokenInChunkAfterCurrToken();
        return firstNWSTokenInChunkAfterCurrToken == null ? chunk.getLength() : firstNWSTokenInChunkAfterCurrToken.getStartOffsetInChunk();
    }

    private String computeProcessedBegin(CFChunk prevChunk, CFToken token) {
        StringBuilder processedBegin = new StringBuilder(" " + token.getValue());
        if (this.isCurrTokenLabeled()) {
            CFToken firstNWSTokenInChunkAfterCurrToken = this.fICFIndentScannerImpl.getFirstNWSTokenInChunkAfterCurrToken();
            CFToken secondNWSTokenInChunkAfterCurrToken = this.fICFIndentScannerImpl.getSecondNWSTokenInChunkAfterCurrToken();
            processedBegin.append(" " + firstNWSTokenInChunkAfterCurrToken + " " + secondNWSTokenInChunkAfterCurrToken);
        }
        if (prevChunk.endsWithNL()) {
            processedBegin.append(this.fStrategy.getSourceViewerConfiguration().getLineDelimiter());
        } else {
            processedBegin.append(" ");
        }
        return processedBegin.toString();
    }

    private void createActionsToMoveBeginAtTheEndOfPrevLine(CFLineInfo lineInfo, CFChunk chunk, CFToken token, String causedBy) {
        if (this.fICFIndentScannerImpl == null) {
            return;
        }
        if (lineInfo == null) {
            return;
        }
        CFChunk indentableChunk = lineInfo.getIndentableChunk();
        int nofCharsToDelete = lineInfo.getLineStartWSLength();
        if (nofCharsToDelete != 1) {
            indentableChunk.addAction(new CFAction(0, nofCharsToDelete, " ", causedBy));
        }
        if (this.isCurrTokenLabeled()) {
            this.createActionToMoveBeginAndLabelAtTheEndOfPrevLine(chunk, causedBy);
        } else {
            this.createActionsToMoveBeginAtTheEndOfPrevLine(chunk, token, causedBy);
        }
    }

    private void createActionToMoveBeginAndLabelAtTheEndOfPrevLine(CFChunk chunk, String causedBy) {
        CFToken thirdNWSTokenInChunkAfterCurrToken = this.fICFIndentScannerImpl.getThirdNWSTokenInChunkAfterCurrToken();
        if (thirdNWSTokenInChunkAfterCurrToken == null) {
            return;
        }
        CFToken secondNWSTokenInChunkAfterCurrToken = this.fICFIndentScannerImpl.getSecondNWSTokenInChunkAfterCurrToken();
        if (secondNWSTokenInChunkAfterCurrToken == null) {
            return;
        }
        chunk.addAction(new CFAction(1, secondNWSTokenInChunkAfterCurrToken.getEndOffsetInChunk(), 0, this.fStrategy.getSourceViewerConfiguration().getLineDelimiter(), causedBy));
    }

    private void createActionsToMoveBeginAtTheEndOfPrevLine(CFChunk chunk, CFToken token, String causedBy) {
        CFToken firstNWSTokenInChunkAfterCurrToken = this.fICFIndentScannerImpl.getFirstNWSTokenInChunkAfterCurrToken();
        if (firstNWSTokenInChunkAfterCurrToken == null) {
            return;
        }
        chunk.addAction(new CFAction(1, token.getEndOffsetInChunk(), 0, this.fStrategy.getSourceViewerConfiguration().getLineDelimiter(), causedBy));
    }

    private boolean isCurrTokenLabeled() {
        CFToken firstNWSTokenInChunkAfterCurrToken = this.fICFIndentScannerImpl.getFirstNWSTokenInChunkAfterCurrToken();
        if (firstNWSTokenInChunkAfterCurrToken == null) {
            return false;
        }
        if (!":".equals(firstNWSTokenInChunkAfterCurrToken.getValue())) {
            return false;
        }
        CFToken secondNWSTokenInChunkAfterCurrToken = this.fICFIndentScannerImpl.getSecondNWSTokenInChunkAfterCurrToken();
        return secondNWSTokenInChunkAfterCurrToken != null;
    }

    private boolean isComment(CFChunk chunk) {
        if (chunk == null) {
            return false;
        }
        return chunk.getType() == 3 || chunk.getType() == 4;
    }

    private void deleteTailWS(CFChunk prevLastChunk) {
        int nofCharsToDelete = 0;
        String prevLastChunkValue = prevLastChunk.getValue();
        int offsetInChunk = prevLastChunk.getLength() - prevLastChunk.getNLLength() - 1;
        while (offsetInChunk >= 0) {
            if (' ' != prevLastChunkValue.charAt(offsetInChunk)) break;
            ++nofCharsToDelete;
            --offsetInChunk;
        }
        if (nofCharsToDelete != 0) {
            prevLastChunk.addAction(new CFAction(offsetInChunk + 1, nofCharsToDelete, "", "begin same line"));
        }
    }

    private boolean allowBeginOnSameLine(CFToken token) {
        return this.fICFBeginIndentScannerImpl.allowBeginOnSameLine(token);
    }
}

